------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2004 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-reference_finalization.adb,v 1.5 2004/06/28 04:57:05 vagul Exp $

with Ada.Unchecked_Deallocation;

package body OCI.Reference_Finalization is

   procedure Free is new Ada.Unchecked_Deallocation (Counter, Access_Count);

   ------------
   -- Adjust --
   ------------

   procedure Adjust (Object : in out Controlled_Reference) is
   begin
      Object.Refer.Inc;
   end Adjust;

   -------------
   -- Counter --
   -------------

   protected body Counter is

      ---------
      -- Dec --
      ---------

      procedure Dec (Zero : out Boolean) is
      begin
         Data := Data - 1;
         Zero := Data = 0;
      end Dec;

      ---------
      -- Inc --
      ---------

      procedure Inc is
      begin
         Data := Data + 1;
      end Inc;

   end Counter;

   --------------
   -- Finalize --
   --------------

   procedure Finalize (Object : in out Controlled_Reference) is
      Zero : Boolean;
   begin
      Object.Refer.Dec (Zero);

      if Zero then
         Destroy (Controlled_Reference'Class (Object));
         Free (Object.Refer);
      end if;
   end Finalize;

   ----------------
   -- Initialize --
   ----------------

   procedure Initialize (Object : in out Controlled_Reference) is
   begin
      Object.Refer := new Counter;
   end Initialize;

end OCI.Reference_Finalization;
