------------------------------------------------------------------------------
--  Ada95 Interface to Oracle RDBMS                                         --
--  Copyright (C) 2000-2004 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-reference_finalization.ads,v 1.4 2004/06/28 04:57:05 vagul Exp $

with System, Ada.Finalization;

package OCI.Reference_Finalization is

   package AF renames Ada.Finalization;

   type Controlled_Reference is abstract new AF.Controlled with private;

   procedure Destroy (Object : in out Controlled_Reference) is abstract;

private

   type Ref_Count is mod System.Max_Binary_Modulus;

   protected type Counter is
      procedure Dec (Zero : out Boolean);
      procedure Inc;
   private
      Data : Ref_Count := 1;
   end Counter;

   type Access_Count is access all Counter;

   type Controlled_Reference is abstract new AF.Controlled with record
      Refer : Access_Count;
   end record;

   procedure Initialize (Object : in out Controlled_Reference);
   procedure Adjust    (Object : in out Controlled_Reference);
   procedure Finalize  (Object : in out Controlled_Reference);

end OCI.Reference_Finalization;
