------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2004 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-servers.ads,v 1.5 2004/06/28 04:57:05 vagul Exp $

with OCI.Environments;

package OCI.Thick.Servers is

   type Server is new Handle_Reference with private;

   function Attach (Name : String) return Server;

   procedure Set_Blocking (Item : in out Server; Mode : in Boolean);

   function Server_Version (Item : in Server) return String;

   procedure Break (It : Server);
   procedure Reset (It : Server);

private

   type Server is new Handle_Reference with record
      Environment : OCI.Environments.Thread_Environment;
   end record;

   procedure Destroy (It : in out Server);

end OCI.Thick.Servers;
