#include <gtk/gtkstyle.h>

#include "animation.h"
#include "murrine_types.h"

typedef struct _MurrineStyle MurrineStyle;
typedef struct _MurrineStyleClass MurrineStyleClass;

G_GNUC_INTERNAL extern GType murrine_type_style;

#define MURRINE_TYPE_STYLE              murrine_type_style
#define MURRINE_STYLE(object)           (G_TYPE_CHECK_INSTANCE_CAST ((object), MURRINE_TYPE_STYLE, MurrineStyle))
#define MURRINE_STYLE_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), MURRINE_TYPE_STYLE, MurrineStyleClass))
#define MURRINE_IS_STYLE(object)        (G_TYPE_CHECK_INSTANCE_TYPE ((object), MURRINE_TYPE_STYLE))
#define MURRINE_IS_STYLE_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), MURRINE_TYPE_STYLE))
#define MURRINE_STYLE_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), MURRINE_TYPE_STYLE, MurrineStyleClass))

struct _MurrineStyle
{
	GtkStyle parent_instance;

	MurrineColors colors;
	
	double	 hilight_ratio;

	guint8   glazestyle;
	guint8   roundness;
	guint8   progressbarstyle;
	guint8   menubarstyle;
	guint8   menubaritemstyle;
	guint8   menustyle;
	guint8   menuitemstyle;
	guint8   listviewheaderstyle;
	guint8   listviewstyle;
  	guint8 	 scrollbarstyle;
	GdkColor scrollbar_color;
	gboolean has_scrollbar_color;
	gboolean animation;
	gboolean gradients;
};

struct _MurrineStyleClass
{
  GtkStyleClass parent_class;
};

G_GNUC_INTERNAL void murrine_style_register_type (GTypeModule *module);
