#!/bin/sh -e

# Author: Olivier Tilloy <olivier.tilloy@canonical.com>

# This script sets the background image of GDM using xsetbg.
# Since the screen resolution may be larger than the dimensions of the image
# file, the image may need to be stretched. Unfortunately xsetbg doesn’t
# support stretching (see https://bugs.launchpad.net/hedley/+bug/667535),
# but it allows to zoom the image on both axis by factors that we need to
# compute, dependent on the screen resolution and image size.

# Dependencies:
# - x11-utils (xdpyinfo)
# - coreutils (cut)
# - gconf2 (gconftool-2)
# - imagemagick (identify)
# - bc (bc)
# - xloadimage (xsetbg)

# Get the resolution of the screen
if [ -z $1 ]; then
XRES=`xdpyinfo | grep dimensions | cut -f7 -d" " | cut -f1 -dx`
else
XRES=$1
fi

if [ -z $2 ]; then
YRES=`xdpyinfo | grep dimensions | cut -f7 -d" " | cut -f2 -dx`
else
YRES=$2
fi

if [ -z $3 ]; then
XC=0
else
XC=$3
fi

if [ -z $4 ]; then
YC=0
else
YC=$4
fi

# Image file
IMG=`gconftool-2 --get /apps/hedley_launcher/background_path 2> /dev/null`
if [ "x$IMG" = x ]
then
  # Default image, if not defined in GConf
  IMG="/usr/share/backgrounds/hedley.png"
fi

# Get the dimensions of the image file
WIDTH=`identify -format "%w" $IMG`
HEIGHT=`identify -format "%h" $IMG`

# Compute the zoom factors along the X and Y axis
XZOOM=`echo "$XRES * 101 / $WIDTH" | bc`
YZOOM=`echo "$YRES * 101 / $HEIGHT" | bc`

# Set the background, stretched
xsetbg -xzoom $XZOOM -yzoom $YZOOM -at $XC,$YC $IMG

exit 0
