import Qt 4.7

/* Tabulated item that holds any number of so called pages and allows to switch
   between them.

   Each page is a Page item. The list of pages is exactly the children of the
   tabulated item.

   The 'currentPage' property holds the index of the page being shown.
*/
FocusScope {
    property int currentPage: 0

    onCurrentPageChanged: updateChildren()
    Component.onCompleted: updateChildren()

    function updateChildren() {
        for (var i=0; i < children.length; i++) {
            if(i == currentPage)
                children[i].enter()
            else if(children[i].active)
                children[i].exit()
        }
    }
}
