import Qt 4.7

/*
   DOCME
*/
Item {
    property alias icon: icon.source
    property alias label: label.text

    signal clicked

    MouseArea {
        id: mouse

        /* FIXME: workaround double click bug
                  http://bugreports.qt.nokia.com/browse/QTBUG-12250 */
        property bool double_clicked: false

        hoverEnabled: true
        anchors.fill: parent
        onClicked: {
            if(double_clicked)
                double_clicked = false
            else
                parent.clicked()
        }
        onDoubleClicked: {
            double_clicked = true
        }
    }

    Keys.onPressed: {
        if (event.key == Qt.Key_Return || event.key == Qt.Key_Enter) {
            clicked()
            event.accepted = true;
        }
    }

    BorderImage {
        id: background

        opacity: mouse.containsMouse ? 1.0 : 0.0
        border.bottom: 3
        border.top: 3
        border.right: 3
        border.left: 3
        anchors.fill: parent
        source: "artwork/applications_item_border.png"
        smooth: false
        horizontalTileMode: BorderImage.Repeat
        verticalTileMode: BorderImage.Repeat

        Behavior on opacity {NumberAnimation {duration: 100}}
    }

    Image {
        id: icon

        width: 64
        height: 64
        anchors.horizontalCenter: background.horizontalCenter
        anchors.top: parent.top
        anchors.topMargin: 10
        fillMode: Image.PreserveAspectFit
        sourceSize.width: width
        sourceSize.height: height

        asynchronous: true
        opacity: status == Image.Ready ? 1 : 0
        Behavior on opacity {NumberAnimation {duration: 200; easing.type: Easing.InOutQuad}}
    }

    Rectangle {
        id: label_background

        anchors.top: label.top
        anchors.horizontalCenter: label.horizontalCenter
        height: label.paintedHeight + 2
        width: background.width - 4
        opacity: 0.3
        color: "black"
        radius: 5
    }

    TextCustom {
        id: label

        font.pointSize: 10
        wrapMode: Text.WordWrap
        horizontalAlignment: Text.AlignHCenter
        anchors.top: icon.bottom
        anchors.bottom: parent.bottom
        anchors.right: parent.right
        anchors.left: parent.left
        anchors.topMargin: 7
        anchors.bottomMargin: 7
        anchors.leftMargin: 7
        anchors.rightMargin: 7
        font.underline: parent.activeFocus
    }
}
