#ifndef __HRN_STATE_MANAGER_H__
#define __HRN_STATE_MANAGER_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define HRN_TYPE_STATE_MANAGER                                          \
   (hrn_state_manager_get_type())
#define HRN_STATE_MANAGER(obj)                                          \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                HRN_TYPE_STATE_MANAGER,                 \
                                HrnStateManager))
#define HRN_STATE_MANAGER_CLASS(klass)                                  \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             HRN_TYPE_STATE_MANAGER,                    \
                             HrnStateManagerClass))
#define IS_HRN_STATE_MANAGER(obj)                                       \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                HRN_TYPE_STATE_MANAGER))
#define IS_HRN_STATE_MANAGER_CLASS(klass)                               \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             HRN_TYPE_STATE_MANAGER))
#define HRN_STATE_MANAGER_GET_CLASS(obj)                                \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               HRN_TYPE_STATE_MANAGER,                  \
                               HrnStateManagerClass))

typedef struct _HrnStateManagerPrivate HrnStateManagerPrivate;
typedef struct _HrnStateManager      HrnStateManager;
typedef struct _HrnStateManagerClass HrnStateManagerClass;

struct _HrnStateManager
{
    GObject parent;

    HrnStateManagerPrivate *priv;
};

struct _HrnStateManagerClass
{
    GObjectClass parent_class;
};

GType hrn_state_manager_get_type (void) G_GNUC_CONST;
void hrn_state_manager_set_uri (HrnStateManager *state,
                                const char      *uri);
const char *hrn_state_manager_get_uri (HrnStateManager *state);
gboolean hrn_state_manager_get_force_visual_mode (HrnStateManager *state);
gboolean hrn_state_manager_get_playing (HrnStateManager *state);

void hrn_state_manager_ready (HrnStateManager *state);

void hrn_state_manager_set_can_show_visual (HrnStateManager *state,
                                            gboolean         can_show);
double hrn_state_manager_get_progress (HrnStateManager *state);


G_END_DECLS

#endif /* __HRN_STATE_MANAGER_H__ */
