#ifndef __HRN_IFACE_PLAYER_H__
#define __HRN_IFACE_PLAYER_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define HRN_TYPE_IFACE_PLAYER    (hrn_iface_player_get_type ())
#define HRN_IFACE_PLAYER(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                                                                        HRN_TYPE_IFACE_PLAYER,\
                                                                        HrnIfacePlayer))
#define HRN_IFACE_PLAYER_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_INTERFACE ((obj), \
                                                                           HRN_TYPE_IFACE_PLAYER,\
                                                                           HrnIfacePlayerClass))

typedef struct _HrnIfacePlayer HrnIfacePlayer;
typedef struct _HrnIfacePlayerClass HrnIfacePlayerClass;

struct _HrnIfacePlayerClass
{
  GTypeInterface base_iface;

  void (*set_playing)  (HrnIfacePlayer *player,
                        gboolean        playing);
  void (*set_uri)      (HrnIfacePlayer *player,
                        const char     *uri);
  void (*set_position) (HrnIfacePlayer *player,
                        double          position);
};

GType hrn_iface_player_get_type (void);
void  hrn_iface_player_emit_position_changed (HrnIfacePlayer *player,
                                              double          position);
void  hrn_iface_player_emit_eos              (HrnIfacePlayer *player);
void  hrn_iface_player_set_uri               (HrnIfacePlayer *player,
                                              const char     *uri);
void  hrn_iface_player_set_playing           (HrnIfacePlayer *player,
                                              gboolean        playing);
void  hrn_iface_player_set_position          (HrnIfacePlayer *player,
                                              double          position);

G_END_DECLS

#endif
