/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _HRN_SEARCH_BAR_H
#define _HRN_SEARCH_BAR_H

#include <clutter/clutter.h>

G_BEGIN_DECLS

#define HRN_TYPE_SEARCH_BAR    hrn_search_bar_get_type ()

#define HRN_SEARCH_BAR(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), HRN_TYPE_SEARCH_BAR, HrnSearchBar))

#define HRN_SEARCH_BAR_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), HRN_TYPE_SEARCH_BAR, HrnSearchBarClass))

#define HRN_IS_SEARCH_BAR(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HRN_TYPE_SEARCH_BAR))

#define HRN_IS_SEARCH_BAR_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), HRN_TYPE_SEARCH_BAR))

#define HRN_SEARCH_BAR_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), HRN_TYPE_SEARCH_BAR, HrnSearchBarClass))

typedef struct _HrnSearchBar HrnSearchBar;
typedef struct _HrnSearchBarClass HrnSearchBarClass;
typedef struct _HrnSearchBarPrivate HrnSearchBarPrivate;

struct _HrnSearchBar
{
  NbtkEntry            parent_instance;
  HrnSearchBarPrivate *priv;
};

struct _HrnSearchBarClass
{
  /*< private >*/
  NbtkEntryClass parent_class;
};

GType hrn_search_bar_get_type   (void) G_GNUC_CONST;
void  hrn_search_bar_unpin      (HrnSearchBar *searchbar);
void  hrn_search_bar_set_pinned (HrnSearchBar *searchbar);

G_END_DECLS

#endif
