#include "hrn-queue-header.h"

enum {
    PROP_0,
    PROP_PRIMARY,
    PROP_SECONDARY,
    PROP_THUMBNAIL
};

enum {
    EXPAND,
    PROGRESS,
    LAST_SIGNAL,
};

struct _HrnQueueHeaderPrivate {
    NbtkWidget *layout;
    ClutterActor *thumb_holder;
    ClutterActor *thumbnail;
    NbtkWidget *primary;
    NbtkWidget *secondary;
    NbtkWidget *expand;
    gboolean expanded;

    NbtkAdjustment *progress;
    guint32 progress_id;
    NbtkWidget *timebar;

    gboolean playback_set_progress;
};

#define GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), HRN_TYPE_QUEUE_HEADER, HrnQueueHeaderPrivate))
G_DEFINE_TYPE (HrnQueueHeader, hrn_queue_header, NBTK_TYPE_BIN);
static guint32 signals[LAST_SIGNAL] = {0,};

#define QUEUE_WIDTH 170
static void
hrn_queue_header_finalize (GObject *object)
{
    G_OBJECT_CLASS (hrn_queue_header_parent_class)->finalize (object);
}

static void
hrn_queue_header_dispose (GObject *object)
{
    G_OBJECT_CLASS (hrn_queue_header_parent_class)->dispose (object);
}

static void
hrn_queue_header_set_property (GObject      *object,
                               guint         prop_id,
                               const GValue *value,
                               GParamSpec   *pspec)
{
    HrnQueueHeader *self = (HrnQueueHeader *) object;
    HrnQueueHeaderPrivate *priv = self->priv;

    switch (prop_id) {
    case PROP_PRIMARY:
        nbtk_label_set_text ((NbtkLabel *) priv->primary,
                             g_value_get_string (value));
        break;

    case PROP_SECONDARY:
        nbtk_label_set_text ((NbtkLabel *) priv->secondary,
                             g_value_get_string (value));
        break;

    case PROP_THUMBNAIL:
        if (priv->thumbnail) {
            clutter_container_remove_actor ((ClutterContainer *) priv->thumb_holder,
                                            priv->thumbnail);
            priv->thumbnail = NULL;
        }

        priv->thumbnail = g_value_get_object (value);
        if (priv->thumbnail) {
            gfloat           w, h;
            gdouble          scale;

            clutter_actor_get_size (priv->thumbnail, &w, &h);
            if (w == 0 && h == 0) {
                w = h = 36;
                clutter_actor_set_size (priv->thumbnail, 36, 36);
            }
            scale = 36.0 / w;
            clutter_container_add_actor ((ClutterContainer *) priv->thumb_holder,
                                         priv->thumbnail);
            clutter_actor_set_scale (priv->thumbnail, scale, scale);
            clutter_actor_set_position (priv->thumbnail,
                                        0, 0);
        }
        break;

    default:
        break;
    }
}

static void
hrn_queue_header_get_property (GObject    *object,
                               guint       prop_id,
                               GValue     *value,
                               GParamSpec *pspec)
{
    switch (prop_id) {

    default:
        break;
    }
}

static void
hrn_queue_header_allocate (ClutterActor          *actor,
                           const ClutterActorBox *box,
                           ClutterAllocationFlags flags)
{
    HrnQueueHeader *header = (HrnQueueHeader *) actor;
    HrnQueueHeaderPrivate *priv = header->priv;
    NbtkPadding padding = { 0, };
    ClutterActorBox child_box;

    CLUTTER_ACTOR_CLASS (hrn_queue_header_parent_class)->allocate (actor, box,
                                                                   flags);

    nbtk_widget_get_padding ((NbtkWidget *) actor, &padding);
    child_box.x1 = box->x1 + padding.left;
    child_box.x2 = (box->x2 - box->x1) - (padding.left + padding.right);
    child_box.y1 = box->y1 + padding.top;
    child_box.y2 = (box->y2 - box->y1) - (padding.top + padding.bottom);

    clutter_actor_allocate ((ClutterActor *) priv->layout, &child_box, flags);
}

static void
hrn_queue_header_class_init (HrnQueueHeaderClass *klass)
{
    GObjectClass *o_class = (GObjectClass *) klass;
    ClutterActorClass *a_class = (ClutterActorClass *) klass;

    o_class->dispose = hrn_queue_header_dispose;
    o_class->finalize = hrn_queue_header_finalize;
    o_class->set_property = hrn_queue_header_set_property;
    o_class->get_property = hrn_queue_header_get_property;
    a_class->allocate = hrn_queue_header_allocate;

    g_type_class_add_private (klass, sizeof (HrnQueueHeaderPrivate));

    g_object_class_install_property (o_class, PROP_PRIMARY,
                                     g_param_spec_string ("primary", "", "", "",
                                                          G_PARAM_WRITABLE |
                                                          G_PARAM_STATIC_STRINGS));
    g_object_class_install_property (o_class, PROP_SECONDARY,
                                     g_param_spec_string ("secondary",
                                                          "", "", "",
                                                          G_PARAM_WRITABLE |
                                                          G_PARAM_STATIC_STRINGS));
    g_object_class_install_property (o_class, PROP_THUMBNAIL,
                                     g_param_spec_object ("thumbnail", "", "",
                                                          CLUTTER_TYPE_ACTOR,
                                                          G_PARAM_WRITABLE |
                                                          G_PARAM_STATIC_STRINGS));
    signals[EXPAND] = g_signal_new ("expand",
                                    G_TYPE_FROM_CLASS (o_class),
                                    G_SIGNAL_RUN_FIRST |
                                    G_SIGNAL_NO_RECURSE, 0, NULL, NULL,
                                    g_cclosure_marshal_VOID__BOOLEAN,
                                    G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
    signals[PROGRESS] = g_signal_new ("progress",
                                      G_TYPE_FROM_CLASS (o_class),
                                      G_SIGNAL_RUN_FIRST |
                                      G_SIGNAL_NO_RECURSE, 0, NULL, NULL,
                                      g_cclosure_marshal_VOID__DOUBLE,
                                      G_TYPE_NONE, 1, G_TYPE_DOUBLE);
}

static void
expand_clicked_cb (NbtkButton     *expand,
                   HrnQueueHeader *header)
{
    hrn_queue_header_expand (header, !header->priv->expanded);
}

static void
progress_notify (GObject        *object,
                 GParamSpec     *pspec,
                 HrnQueueHeader *header)
{
    HrnQueueHeaderPrivate *priv = GET_PRIVATE (header);
    double value = nbtk_adjustment_get_value ((NbtkAdjustment *) object);

    if (!priv->playback_set_progress)
      g_signal_emit (header, signals[PROGRESS], 0, value);

    priv->playback_set_progress = FALSE;
}

static void
hrn_queue_header_init (HrnQueueHeader *self)
{
    HrnQueueHeaderPrivate *priv = GET_PRIVATE (self);
    NbtkWidget *hbox, *label_box;

    self->priv = priv;

    nbtk_widget_set_style_class_name ((NbtkWidget *) self, "HrnQueueHeader");

    priv->layout = nbtk_box_layout_new ();
    nbtk_box_layout_set_vertical ((NbtkBoxLayout *) priv->layout, TRUE);
    nbtk_box_layout_set_spacing ((NbtkBoxLayout *) priv->layout, 10);
    clutter_container_add_actor ((ClutterContainer *) self,
                                 (ClutterActor *) priv->layout);

    hbox = nbtk_box_layout_new ();
    nbtk_box_layout_set_spacing ((NbtkBoxLayout *) hbox, 5);
    clutter_container_add_actor ((ClutterContainer *) priv->layout,
                                 (ClutterActor *) hbox);

    priv->thumb_holder = clutter_group_new ();
    clutter_actor_set_size (priv->thumb_holder, 36, 36);
    clutter_container_add_actor ((ClutterContainer *) hbox, priv->thumb_holder);

    label_box = nbtk_box_layout_new ();
    nbtk_box_layout_set_vertical ((NbtkBoxLayout *) label_box, TRUE);
    nbtk_box_layout_set_spacing ((NbtkBoxLayout *) label_box, 2);
    clutter_container_add_actor ((ClutterContainer *) hbox,
                                 (ClutterActor *) label_box);

    priv->primary = nbtk_label_new ("");
    clutter_actor_set_width ((ClutterActor *) priv->primary, 110);
    clutter_actor_set_name (CLUTTER_ACTOR (priv->primary),
                            "hrn-queue-header-label");
    clutter_container_add_actor ((ClutterContainer *) label_box,
                                 (ClutterActor *) priv->primary);

    priv->secondary = nbtk_label_new ("");
    clutter_actor_set_width ((ClutterActor *) priv->secondary, 110);
    clutter_actor_set_name (CLUTTER_ACTOR (priv->secondary),
                            "hrn-queue-header-meta-label");
    clutter_container_add_actor ((ClutterContainer *) label_box,
                                 (ClutterActor *) priv->secondary);

    priv->expand = nbtk_button_new ();
    priv->expanded = FALSE;
    nbtk_widget_set_style_class_name (priv->expand, "HrnQueueExpandedUp");
    clutter_container_add_actor ((ClutterContainer *) hbox,
                                 (ClutterActor *) priv->expand);
    g_signal_connect (priv->expand, "clicked",
                      G_CALLBACK (expand_clicked_cb), self);

    priv->progress = nbtk_adjustment_new (0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
    priv->progress_id = g_signal_connect (priv->progress, "notify::value",
                                          G_CALLBACK (progress_notify), self);

    priv->timebar = nbtk_scroll_bar_new (priv->progress);
    nbtk_widget_set_style_class_name (priv->timebar, "HrnProgressBar");
    clutter_container_add_actor ((ClutterContainer *) priv->layout,
                                 (ClutterActor *) priv->timebar);
    clutter_actor_set_size (CLUTTER_ACTOR (priv->timebar), 220, 14);
}

void
hrn_queue_header_show_progress (HrnQueueHeader *header,
                                gboolean        show)
{
    HrnQueueHeaderPrivate *priv = header->priv;

    if (show) {
        clutter_actor_show ((ClutterActor *) priv->timebar);
        clutter_actor_animate ((ClutterActor *) priv->timebar,
                               CLUTTER_EASE_IN_OUT_CUBIC, 250,
                               "opacity", 0xff,
                               NULL);
    } else {
        clutter_actor_animate ((ClutterActor *) priv->timebar,
                               CLUTTER_EASE_IN_OUT_CUBIC, 250,
                               "opacity", 0x00,
                               "signal-swapped::completed", clutter_actor_hide, priv->timebar,
                               NULL);
    }
}

void
hrn_queue_header_set_progress (HrnQueueHeader *header,
                               double          progress)
{
    HrnQueueHeaderPrivate *priv = header->priv;

    priv->playback_set_progress = TRUE;
    nbtk_adjustment_set_value (priv->progress, progress);
}

void
hrn_queue_header_expand (HrnQueueHeader *header,
                         gboolean        expand)
{
    HrnQueueHeaderPrivate *priv = header->priv;

    priv->expanded = expand;
    if (expand)
        nbtk_widget_set_style_class_name (priv->expand, "HrnQueueExpandedDown");
    else
        nbtk_widget_set_style_class_name (priv->expand, "HrnQueueExpandedUp");
    /* clear the pseudo class of the button so we don't end up with :hover
     * at the end of the animation */
    nbtk_widget_set_style_pseudo_class (priv->expand, NULL);
    g_signal_emit (header, signals[EXPAND], 0, expand);
}
