#ifndef _SP_GET_EVENT_H
#define _SP_GET_EVENT_H

#include <glib.h>

/*event source device name*/
#define SP_KEY_INPUT_NODE	"/dev/input/event1"

/*press left/right key,if press another key in 300ms, then program will think it as the middle key pressed*/
#define SP_KEY_TYPE_TIMER_INTERVAL 	300  /*ms*/
/*press left/right key,if released after 1s, then program will think it as long pressed,otherwise, it is short pressed*/
#define SP_KEY_PRESS_TIMER_INTERVAL 	700  /*ms*/

/*key event source based on the evdev standard, below is the event parameter*/
#define SP_EVDEV_KEY_TYPE	0x01
#define SP_EVDEV_LEFT_KEY_CODE	273	
#define SP_EVDEV_RIGHT_KEY_CODE	272	


/*use iochannel to get key event if needed*/
typedef struct _sp_iochannel
{
    GIOChannel *io_channel;
    guint source_id;
}sp_iochannel;

/*there are only two keys on the devices, but you left and right key simotanously pressed . it means middle key*/
typedef enum
{
	SP_KEY_LEFT,
	SP_KEY_RIGHT,
	SP_KEY_BOTH,
	SP_KEY_MAX
}SP_KEY_TYPE;

/*keys have two statics, pressed and released*/
typedef enum
{
	SP_KEY_RELEASE,
	SP_KEY_PRESS,
	SP_KEY_NOTHING
}SP_KEY_ACTION_TYPE;

/*start to monitor the event by iochannel,if some event come, then program will execute some actions(send emulator key event to app).*/
void sp_init_event_monitor(sp_iochannel *app);

#endif
