#ifndef __SP_ERROR_H__
#define __SP_ERROR_H__

#include <stdio.h>

#ifndef _MAX_PATH
#define _MAX_PATH 256
#endif

#define SP_TRUE	    1
#define SP_FALSE	0

//#define SP_SUCCESS		0
//#define SP_FAILED		-1

#define SP_RET_SUCCESS  0
#define SP_RET_FAILED   -1

#define SP_ERR_PARAMETER	-2
#define SP_ERR_TIMEOUT	-3

#define SP_ERR_FILE_OPEN	-100
#define SP_ERR_FILE_READ	-101
#define SP_ERR_FILE_WRITE	-102
#define SP_ERR_FILE_LOCK	-103

#define SP_ERR_ARRAY_FULL	-200
#define SP_ERR_NOT_FOUND	-201

#define SP_ERR_FLIGHT_MODE      -300
#define SP_ERR_APP_NAME_DIFFER  -301
#define SP_ERR_SCENE_NOTEXIST  -302

#define SP_DBUS_SET_VALUE_ERROR	-400

#define SP_FUNCTION_NOT_SUPPORT     -500 
enum{
	SP_TRACE_LEVEL_CRITICAL,		/* 0 */
	SP_TRACE_LEVEL_ERROR,			/* 1 */
	SP_TRACE_LEVEL_WARNING,		    /* 2 */
	SP_TRACE_LEVEL_INFO,			/* 3 */
	SP_TRACE_LEVEL_DEBUG,			/* 4 */
	SP_TRACE_LEVEL_DEBUG_LOW			/* 5 */
};

typedef struct sp_trace{
	FILE	*pFPTrace;
	int		iTraceLevel;
	int		iTrace2Console;
	char	cTraceFileName[_MAX_PATH];
	int		iTraceSize;
}sp_trace_t;

extern sp_trace_t g_sTrace;

#define SP_TRACE_FILENAME				"/tmp/_SP_TRACE"
#define SP_TRACE_SIZE					1000				/* 1MB */
#define SP_ENV_TRACE_LEVEL			"SP_TRACE_LEVEL"		/* 0 - 4*/
#define SP_ENV_TRACE2CONSOLE			"SP_TRACE2CONSOLE"	/* yes or no*/
#define SP_ENV_TRACE_FILENAME		"SP_TRACE_FILENAME"
#define SP_ENV_TRACE_YES				"yes"
#define	SP_ENV_TRACE_SIZE				"SP_TRACE_SIZE"

#define SP_FREE(p){\
	if(p != NULL){\
		free(p);\
		p = NULL;\
	}\
}

#ifndef SP_TEST
void sp_trace_init(int openflag, char *plusname);
#else
void sp_trace_init_test(int trace_level, char *trace_file_name);
#endif
void sp_trace_destroy();
void SP_PRINTF_FUNC( int level, const char *file,const int line,const char *func, char *format, ... );

#define SP_TRACE_FILE_OPEN(i_pFileName, i_pFP)\
{\
	char process_path[_MAX_PATH];\
	memset(process_path, 0x00, sizeof(process_path));\
	strcat(process_path, i_pFileName);\
	if(i_pFP == NULL){\
		if((i_pFP = fopen(process_path, "a+")) == NULL){\
			fprintf(stderr, "SP_PRINTF_FUNC: Can't open file(%s)!\n", process_path);\
		}\
	}\
}

#define SP_TRACE_FILE_CLOSE(i_pFP)\
{\
	if(i_pFP != NULL)\
	{\
		fflush(i_pFP);\
		fclose(i_pFP);\
		i_pFP = NULL;\
	}\
}

#define SP_TRACE(level, format,...){\
	if(level <= g_sTrace.iTraceLevel){\
		SP_PRINTF_FUNC(level, __FILE__, __LINE__, __FUNCTION__, format,__VA_ARGS__);\
	}\
}

#define SP_SIMPLE_TRACE(level, format,...){\
	if(level <= g_sTrace.iTraceLevel){\
		printf(format,__VA_ARGS__);\
	}\
}

#define   DEBUG_PRINT_MODE      				1	/*if you want to print some debug message,put it to 1*/

#if DEBUG_PRINT_MODE
#define   FRANKEY_print   printf
#else
#define   FRANKEY_print(...)
#endif



#endif

