/*
Copyright 2012 Canonical Ltd.

Authors:
    Renato Araujo Oliveira Filho <renato@canonical.com>

This program is free software: you can redistribute it and/or modify it 
under the terms of the GNU General Public License version 3, as published 
by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranties of 
MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along 
with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __ANDROID_ACCOUNT_SYNC_H__
#define __ANDROID_ACCOUNT_SYNC_H__

#include <glib-object.h>

/*
 * Type macros.
 */
#define ANDROID_ACCOUNT_SYNC_TYPE                  (android_account_sync_get_type ())
#define ANDROID_ACCOUNT_SYNC(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), ANDROID_ACCOUNT_SYNC_TYPE, AndroidAccountSync))
#define IS_ANDROID_ACCOUNT_SYNC(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ANDROID_ACCOUNT_SYNC_TYPE))
#define ANDROID_ACCOUNT_SYNC_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), ANDROID_ACCOUNT_SYNC_TYPE, AndroidAccountSyncClass))
#define IS_ANDROID_ACCOUNT_SYNC_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), ANDROID_ACCOUNT_SYNC_TYPE))
#define ANDROID_ACCOUNT_SYNC_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), ANDROID_ACCOUNT_SYNC_TYPE, AndroidAccountSyncClass))

typedef struct _AndroidAccountSync        AndroidAccountSync;
typedef struct _AndroidAccountSyncClass   AndroidAccountSyncClass;

struct _AndroidAccountSync
{
  GObject parent_instance;
};

struct _AndroidAccountSyncClass
{
  GObjectClass parent_class;
};

GType                   android_account_sync_get_type (void);
AndroidAccountSync*     android_account_sync_new (void);
void                    android_account_sync_start (AndroidAccountSync *self);
void                    android_account_sync_stop (AndroidAccountSync *self);

#endif /* __ANDROID_ACCOUNT_SYNC_H__ */
