/*
 * indicator-network
 * Copyright 2010-2012 Canonical Ltd.
 *
 * Authors:
 * Antti Kaijanmäki <antti.kaijanmaki@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "android-service-network.h"

typedef struct _AndroidServiceNetworkPrivate AndroidServiceNetworkPrivate;

struct _AndroidServiceNetworkPrivate
{
  gint strength;
  AndroidNetworkState state;
};

enum {
  PROP_0,

  
};

enum {
  SIG_0,

  SIG_STRENGTH_CHANGED,
  SIG_STATE_CHANGED,
  SIG_PASSPHRASE_NEEDED,

  SIG_LAST
};
static int signals[SIG_LAST];

#define GET_PRIVATE(o)                                         \
  (G_TYPE_INSTANCE_GET_PRIVATE ((o),                           \
                                ANDROID_SERVICE_NETWORK_TYPE,  \
                                AndroidServiceNetworkPrivate))

static void android_service_network_dispose (GObject *object);
static void android_service_network_finalize(GObject *object);

G_DEFINE_TYPE(AndroidServiceNetwork, android_service_network, G_TYPE_OBJECT);

static void
android_service_network_class_init(AndroidServiceNetworkClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS(klass);
  GParamSpec *spec;

  g_type_class_add_private(klass, sizeof(AndroidServiceNetworkPrivate));

  gobject_class->dispose      = android_service_network_dispose;
  gobject_class->finalize     = android_service_network_finalize;

  signals[SIG_STRENGTH_CHANGED] = 
    g_signal_new("strength-changed",
		 G_TYPE_FROM_CLASS(gobject_class),
		 G_SIGNAL_RUN_FIRST,
		 0,
		 NULL,
		 NULL,
		 g_cclosure_marshal_VOID__INT,
		 G_TYPE_NONE,
		 1,
		 G_TYPE_INT);

  signals[SIG_STATE_CHANGED] = 
    g_signal_new("state-changed",
		 G_TYPE_FROM_CLASS(gobject_class),
		 G_SIGNAL_RUN_FIRST,
		 0,
		 NULL,
		 NULL,
		 g_cclosure_marshal_VOID__INT,
		 G_TYPE_NONE,
		 1,
		 G_TYPE_INT);

  signals[SIG_PASSPHRASE_NEEDED] = 
    g_signal_new("passphrase-needed",
		 G_TYPE_FROM_CLASS(gobject_class),
		 G_SIGNAL_RUN_FIRST,
		 0,
		 NULL,
		 NULL,
		  g_cclosure_marshal_VOID__VOID,
		 G_TYPE_NONE,
		 0);
}

static void
android_service_network_init(AndroidServiceNetwork *self)
{
  AndroidServiceNetworkPrivate *priv = GET_PRIVATE(self);
}

AndroidServiceNetwork *
android_service_network_new(const char *identifier,
			    const gchar *ssid,
			    AndroidNetworkSecurity security,
			    const gchar *capabilities,
			    gint strength,
			    AndroidNetworkType type)
{
  AndroidServiceNetwork *self;
  AndroidServiceNetworkPrivate *priv;
  self = g_object_new(ANDROID_SERVICE_NETWORK_TYPE, NULL);

  if (self == NULL)
    return NULL;

  g_debug("%s called for - %s", __func__, identifier);

  priv = GET_PRIVATE(self);

  self->identifier   = g_strdup(identifier);
  self->ssid         = g_strdup(ssid);
  self->security     = security;
  self->capabilities = g_strdup(capabilities);
  self->type         = type;
  self->passphrase   = NULL;

  priv->strength = strength;
  priv->state    = ANDROID_NETWORK_STATE_DISCONNECTED;

  return self;
}

static void
android_service_network_dispose(GObject *object)
{
  AndroidServiceNetwork *self        = ANDROID_SERVICE_NETWORK(object);
  AndroidServiceNetworkPrivate *priv = GET_PRIVATE(self);

  g_debug("%s called for - %s", __func__, self->identifier);

  G_OBJECT_CLASS(android_service_network_parent_class)->dispose(object);
}

static void
android_service_network_finalize(GObject *object)
{
  AndroidServiceNetwork        *self = ANDROID_SERVICE_NETWORK(object);
  AndroidServiceNetworkPrivate *priv = GET_PRIVATE(self);

  g_free(self->identifier);
  g_free(self->ssid);
  g_free(self->capabilities);
  g_free(self->passphrase);

  G_OBJECT_CLASS(android_service_network_parent_class)->finalize(object);
}

gint
android_service_network_get_strength(AndroidServiceNetwork *self)
{
  AndroidServiceNetworkPrivate *priv = GET_PRIVATE(self);

  return priv->strength;
}

void
android_service_network_set_strength(AndroidServiceNetwork *self,
				     gint strength)
{
  AndroidServiceNetworkPrivate *priv = GET_PRIVATE(self);

  if (priv->strength == strength)
    return;

  priv->strength = strength;
  g_signal_emit(self,
		signals[SIG_STRENGTH_CHANGED],
		0,
		priv->strength,
		-1);
}

AndroidNetworkState
android_service_network_get_state(AndroidServiceNetwork *self)
{
  AndroidServiceNetworkPrivate *priv = GET_PRIVATE(self);

  return priv->state;
}

void
android_service_network_set_state(AndroidServiceNetwork *self,
				  AndroidNetworkState state)
{
  AndroidServiceNetworkPrivate *priv = GET_PRIVATE(self);

  if (priv->state == state)
    return;

  priv->state = state;
  g_signal_emit(self,
		signals[SIG_STATE_CHANGED],
		0,
		priv->state,
		-1);
}

