/*      
 *      
 * (c) Copyright 1991 OPEN SOFTWARE FOUNDATION, INC. 
 * (c) Copyright 1991 HEWLETT-PACKARD COMPANY
 * (c) Copyright 1991 DIGITAL EQUIPMENT CORPORATION
 * To anyone who acknowledges that this file is provided "AS IS"
 * without any express or implied warranty:
 *                 permission to use, copy, modify, and distribute this
 * file for any purpose is hereby granted without fee, provided that
 * the above copyright notices and this notice appears in all source
 * code copies, and that none of the names of Open Software
 * Foundation, Inc., Hewlett-Packard Company, or Digital Equipment
 * Corporation be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.  Neither Open Software Foundation, Inc., Hewlett-
 * Packard Company, nor Digital Equipment Corporation makes any
 * representations about the suitability of this software for any
 * purpose.
 *
 */
/*
 */
#ifndef _SEC_ID_PICKLE_H
#define _SEC_ID_PICKLE_H  1
/*
**
**  NAME
**      
**      sec_id_pickle.h
**
**  FACILITY:
**
**      Remote Procedure Call (RPC)
**  
**  ABSTRACT:
**
**      Types and routines for PAC management.
*/
#include <commonp.h>
#include <com.h>
#include <comp.h>  
 
#include <dce/id_base.h>
#include <dce/sec_authn.h>

typedef struct pickle_handle_s * pickle_handle_t;

/*
 * Functions
 */

/* s e c _ p i c k l e _ c r e a t e
 *
 * Create a pickling context.  This must be called to obtain a pickling
 * context before any pickling calls can be performed.
 */
pickle_handle_t sec_pickle_create _DCE_PROTOTYPE_ (( void ));


/* s e c _ p i c k l e _ r e l e a s e
 *
 * Terminate a pickling context.  This function will release any storage
 * associated with the pickling context.
 */
void sec_pickle_release _DCE_PROTOTYPE_ (( pickle_handle_t * /*p*/));


/* s e c _ i d _ p a c _ f r e e
 * 
 * Release dynamic storage associated with a PAC.
 */

void sec_id_pac_free _DCE_PROTOTYPE_ (( sec_id_pac_t *)) ;

/* s e c _ i d _ p a c _ p i c k l e
 *
 * Pickle a pac.
 */
extern void     sec_id_pac_pickle _DCE_PROTOTYPE_ ((
        /* [in] */      pickle_handle_t          /*pickle_handle*/,
        /* [in] */      sec_id_pac_t            *  /*pac*/,
        /* [out] */     sec_id_pickled_pac_t    **  /*pickled_pac*/
  ));

/* s e c _ i d _ p a c _ u n p i c k l e
 *
 * unpickle a pac 
 */

extern void     sec_id_pac_unpickle _DCE_PROTOTYPE_ ((
        /* [in] */      sec_id_pickled_pac_t    *  /*pickled_pac*/,
        /* [out] */     sec_id_pac_t            *  /*pac*/
  ));
#endif
