/*
 * Freescale DIGCTL Register Definitions
 *
 * Copyright 2008 Embedded Alley Solutions, Inc All Rights Reserved.
 * Copyright 2008-2010 Freescale Semiconductor, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * This file is created by xml file. Don't Edit it.
 *
 * Xml Revision: 1.0
 * Template revision: 26195
 */

#ifndef __ARCH_ARM___DIGCTL_H
#define __ARCH_ARM___DIGCTL_H


#define HW_DIGCTL_CTRL	(0x00000000)
#define HW_DIGCTL_CTRL_SET	(0x00000004)
#define HW_DIGCTL_CTRL_CLR	(0x00000008)
#define HW_DIGCTL_CTRL_TOG	(0x0000000c)

#define BM_DIGCTL_CTRL_RSVD3	0x80000000
#define BM_DIGCTL_CTRL_XTAL24M_GATE	0x40000000
#define BM_DIGCTL_CTRL_TRAP_IRQ	0x20000000
#define BP_DIGCTL_CTRL_RSVD2	27
#define BM_DIGCTL_CTRL_RSVD2	0x18000000
#define BF_DIGCTL_CTRL_RSVD2(v)  \
		(((v) << 27) & BM_DIGCTL_CTRL_RSVD2)
#define BM_DIGCTL_CTRL_CACHE_BIST_TMODE	0x04000000
#define BM_DIGCTL_CTRL_LCD_BIST_CLKEN	0x02000000
#define BM_DIGCTL_CTRL_LCD_BIST_START	0x01000000
#define BM_DIGCTL_CTRL_DCP_BIST_CLKEN	0x00800000
#define BM_DIGCTL_CTRL_DCP_BIST_START	0x00400000
#define BM_DIGCTL_CTRL_ARM_BIST_CLKEN	0x00200000
#define BM_DIGCTL_CTRL_USB_TESTMODE	0x00100000
#define BM_DIGCTL_CTRL_ANALOG_TESTMODE	0x00080000
#define BM_DIGCTL_CTRL_DIGITAL_TESTMODE	0x00040000
#define BM_DIGCTL_CTRL_ARM_BIST_START	0x00020000
#define BM_DIGCTL_CTRL_UART_LOOPBACK	0x00010000
#define BV_DIGCTL_CTRL_UART_LOOPBACK__NORMAL 0x0
#define BV_DIGCTL_CTRL_UART_LOOPBACK__LOOPIT 0x1
#define BM_DIGCTL_CTRL_SAIF_LOOPBACK	0x00008000
#define BV_DIGCTL_CTRL_SAIF_LOOPBACK__NORMAL 0x0
#define BV_DIGCTL_CTRL_SAIF_LOOPBACK__LOOPIT 0x1
#define BP_DIGCTL_CTRL_SAIF_CLKMUX_SEL	13
#define BM_DIGCTL_CTRL_SAIF_CLKMUX_SEL	0x00006000
#define BF_DIGCTL_CTRL_SAIF_CLKMUX_SEL(v)  \
		(((v) << 13) & BM_DIGCTL_CTRL_SAIF_CLKMUX_SEL)
#define BV_DIGCTL_CTRL_SAIF_CLKMUX_SEL__MBL_CLK_OUT         0x0
#define BV_DIGCTL_CTRL_SAIF_CLKMUX_SEL__BL_CLK_OUT          0x1
#define BV_DIGCTL_CTRL_SAIF_CLKMUX_SEL__M_CLK_OUT_BL_CLK_IN 0x2
#define BV_DIGCTL_CTRL_SAIF_CLKMUX_SEL__BL_CLK_IN           0x3
#define BM_DIGCTL_CTRL_SAIF_CLKMST_SEL	0x00001000
#define BV_DIGCTL_CTRL_SAIF_CLKMST_SEL__SAIF1_MST 0x0
#define BV_DIGCTL_CTRL_SAIF_CLKMST_SEL__SAIF2_MST 0x1
#define BM_DIGCTL_CTRL_SAIF_ALT_BITCLK_SEL	0x00000800
#define BM_DIGCTL_CTRL_RSVD1	0x00000400
#define BM_DIGCTL_CTRL_SY_ENDIAN	0x00000200
#define BM_DIGCTL_CTRL_SY_SFTRST	0x00000100
#define BM_DIGCTL_CTRL_SY_CLKGATE	0x00000080
#define BM_DIGCTL_CTRL_USE_SERIAL_JTAG	0x00000040
#define BV_DIGCTL_CTRL_USE_SERIAL_JTAG__OLD_JTAG    0x0
#define BV_DIGCTL_CTRL_USE_SERIAL_JTAG__SERIAL_JTAG 0x1
#define BM_DIGCTL_CTRL_TRAP_IN_RANGE	0x00000020
#define BM_DIGCTL_CTRL_TRAP_ENABLE	0x00000010
#define BM_DIGCTL_CTRL_DEBUG_DISABLE	0x00000008
#define BM_DIGCTL_CTRL_USB_CLKGATE	0x00000004
#define BV_DIGCTL_CTRL_USB_CLKGATE__RUN     0x0
#define BV_DIGCTL_CTRL_USB_CLKGATE__NO_CLKS 0x1
#define BM_DIGCTL_CTRL_JTAG_SHIELD	0x00000002
#define BV_DIGCTL_CTRL_JTAG_SHIELD__NORMAL     0x0
#define BV_DIGCTL_CTRL_JTAG_SHIELD__SHIELDS_UP 0x1
#define BM_DIGCTL_CTRL_LATCH_ENTROPY	0x00000001

#define HW_DIGCTL_STATUS	(0x00000010)
#define HW_DIGCTL_STATUS_SET	(0x00000014)
#define HW_DIGCTL_STATUS_CLR	(0x00000018)
#define HW_DIGCTL_STATUS_TOG	(0x0000001c)

#define BM_DIGCTL_STATUS_USB_HS_PRESENT	0x80000000
#define BM_DIGCTL_STATUS_USB_OTG_PRESENT	0x40000000
#define BM_DIGCTL_STATUS_USB_HOST_PRESENT	0x20000000
#define BM_DIGCTL_STATUS_USB_DEVICE_PRESENT	0x10000000
#define BP_DIGCTL_STATUS_RSVD2	11
#define BM_DIGCTL_STATUS_RSVD2	0x0FFFF800
#define BF_DIGCTL_STATUS_RSVD2(v)  \
		(((v) << 11) & BM_DIGCTL_STATUS_RSVD2)
#define BM_DIGCTL_STATUS_DCP_BIST_FAIL	0x00000400
#define BM_DIGCTL_STATUS_DCP_BIST_PASS	0x00000200
#define BM_DIGCTL_STATUS_DCP_BIST_DONE	0x00000100
#define BM_DIGCTL_STATUS_LCD_BIST_FAIL	0x00000080
#define BM_DIGCTL_STATUS_LCD_BIST_PASS	0x00000040
#define BM_DIGCTL_STATUS_LCD_BIST_DONE	0x00000020
#define BM_DIGCTL_STATUS_JTAG_IN_USE	0x00000010
#define BP_DIGCTL_STATUS_PACKAGE_TYPE	1
#define BM_DIGCTL_STATUS_PACKAGE_TYPE	0x0000000E
#define BF_DIGCTL_STATUS_PACKAGE_TYPE(v)  \
		(((v) << 1) & BM_DIGCTL_STATUS_PACKAGE_TYPE)
#define BM_DIGCTL_STATUS_WRITTEN	0x00000001

#define HW_DIGCTL_HCLKCOUNT	(0x00000020)
#define HW_DIGCTL_HCLKCOUNT_SET	(0x00000024)
#define HW_DIGCTL_HCLKCOUNT_CLR	(0x00000028)
#define HW_DIGCTL_HCLKCOUNT_TOG	(0x0000002c)

#define BP_DIGCTL_HCLKCOUNT_COUNT	0
#define BM_DIGCTL_HCLKCOUNT_COUNT	0xFFFFFFFF
#define BF_DIGCTL_HCLKCOUNT_COUNT(v)	(v)

#define HW_DIGCTL_RAMCTRL	(0x00000030)
#define HW_DIGCTL_RAMCTRL_SET	(0x00000034)
#define HW_DIGCTL_RAMCTRL_CLR	(0x00000038)
#define HW_DIGCTL_RAMCTRL_TOG	(0x0000003c)

#define BP_DIGCTL_RAMCTRL_RSVD1	12
#define BM_DIGCTL_RAMCTRL_RSVD1	0xFFFFF000
#define BF_DIGCTL_RAMCTRL_RSVD1(v) \
		(((v) << 12) & BM_DIGCTL_RAMCTRL_RSVD1)
#define BP_DIGCTL_RAMCTRL_SPEED_SELECT	8
#define BM_DIGCTL_RAMCTRL_SPEED_SELECT	0x00000F00
#define BF_DIGCTL_RAMCTRL_SPEED_SELECT(v)  \
		(((v) << 8) & BM_DIGCTL_RAMCTRL_SPEED_SELECT)
#define BP_DIGCTL_RAMCTRL_RSVD0	1
#define BM_DIGCTL_RAMCTRL_RSVD0	0x000000FE
#define BF_DIGCTL_RAMCTRL_RSVD0(v)  \
		(((v) << 1) & BM_DIGCTL_RAMCTRL_RSVD0)
#define BM_DIGCTL_RAMCTRL_RAM_REPAIR_EN	0x00000001

#define HW_DIGCTL_RAMREPAIR	(0x00000040)
#define HW_DIGCTL_RAMREPAIR_SET	(0x00000044)
#define HW_DIGCTL_RAMREPAIR_CLR	(0x00000048)
#define HW_DIGCTL_RAMREPAIR_TOG	(0x0000004c)

#define BP_DIGCTL_RAMREPAIR_RSVD1	16
#define BM_DIGCTL_RAMREPAIR_RSVD1	0xFFFF0000
#define BF_DIGCTL_RAMREPAIR_RSVD1(v) \
		(((v) << 16) & BM_DIGCTL_RAMREPAIR_RSVD1)
#define BP_DIGCTL_RAMREPAIR_ADDR	0
#define BM_DIGCTL_RAMREPAIR_ADDR	0x0000FFFF
#define BF_DIGCTL_RAMREPAIR_ADDR(v)  \
		(((v) << 0) & BM_DIGCTL_RAMREPAIR_ADDR)

#define HW_DIGCTL_ROMCTRL	(0x00000050)
#define HW_DIGCTL_ROMCTRL_SET	(0x00000054)
#define HW_DIGCTL_ROMCTRL_CLR	(0x00000058)
#define HW_DIGCTL_ROMCTRL_TOG	(0x0000005c)

#define BP_DIGCTL_ROMCTRL_RSVD0	4
#define BM_DIGCTL_ROMCTRL_RSVD0	0xFFFFFFF0
#define BF_DIGCTL_ROMCTRL_RSVD0(v) \
		(((v) << 4) & BM_DIGCTL_ROMCTRL_RSVD0)
#define BP_DIGCTL_ROMCTRL_RD_MARGIN	0
#define BM_DIGCTL_ROMCTRL_RD_MARGIN	0x0000000F
#define BF_DIGCTL_ROMCTRL_RD_MARGIN(v)  \
		(((v) << 0) & BM_DIGCTL_ROMCTRL_RD_MARGIN)

#define HW_DIGCTL_WRITEONCE	(0x00000060)

#define BP_DIGCTL_WRITEONCE_BITS	0
#define BM_DIGCTL_WRITEONCE_BITS	0xFFFFFFFF
#define BF_DIGCTL_WRITEONCE_BITS(v)	(v)

#define HW_DIGCTL_ENTROPY	(0x00000090)

#define BP_DIGCTL_ENTROPY_VALUE	0
#define BM_DIGCTL_ENTROPY_VALUE	0xFFFFFFFF
#define BF_DIGCTL_ENTROPY_VALUE(v)	(v)

#define HW_DIGCTL_ENTROPY_LATCHED	(0x000000a0)

#define BP_DIGCTL_ENTROPY_LATCHED_VALUE	0
#define BM_DIGCTL_ENTROPY_LATCHED_VALUE	0xFFFFFFFF
#define BF_DIGCTL_ENTROPY_LATCHED_VALUE(v)	(v)

#define HW_DIGCTL_SJTAGDBG	(0x000000b0)
#define HW_DIGCTL_SJTAGDBG_SET	(0x000000b4)
#define HW_DIGCTL_SJTAGDBG_CLR	(0x000000b8)
#define HW_DIGCTL_SJTAGDBG_TOG	(0x000000bc)

#define BP_DIGCTL_SJTAGDBG_RSVD2	27
#define BM_DIGCTL_SJTAGDBG_RSVD2	0xF8000000
#define BF_DIGCTL_SJTAGDBG_RSVD2(v) \
		(((v) << 27) & BM_DIGCTL_SJTAGDBG_RSVD2)
#define BP_DIGCTL_SJTAGDBG_SJTAG_STATE	16
#define BM_DIGCTL_SJTAGDBG_SJTAG_STATE	0x07FF0000
#define BF_DIGCTL_SJTAGDBG_SJTAG_STATE(v)  \
		(((v) << 16) & BM_DIGCTL_SJTAGDBG_SJTAG_STATE)
#define BP_DIGCTL_SJTAGDBG_RSVD1	11
#define BM_DIGCTL_SJTAGDBG_RSVD1	0x0000F800
#define BF_DIGCTL_SJTAGDBG_RSVD1(v)  \
		(((v) << 11) & BM_DIGCTL_SJTAGDBG_RSVD1)
#define BM_DIGCTL_SJTAGDBG_SJTAG_TDO	0x00000400
#define BM_DIGCTL_SJTAGDBG_SJTAG_TDI	0x00000200
#define BM_DIGCTL_SJTAGDBG_SJTAG_MODE	0x00000100
#define BP_DIGCTL_SJTAGDBG_DELAYED_ACTIVE	4
#define BM_DIGCTL_SJTAGDBG_DELAYED_ACTIVE	0x000000F0
#define BF_DIGCTL_SJTAGDBG_DELAYED_ACTIVE(v)  \
		(((v) << 4) & BM_DIGCTL_SJTAGDBG_DELAYED_ACTIVE)
#define BM_DIGCTL_SJTAGDBG_ACTIVE	0x00000008
#define BM_DIGCTL_SJTAGDBG_SJTAG_PIN_STATE	0x00000004
#define BM_DIGCTL_SJTAGDBG_SJTAG_DEBUG_DATA	0x00000002
#define BM_DIGCTL_SJTAGDBG_SJTAG_DEBUG_OE	0x00000001

#define HW_DIGCTL_MICROSECONDS	(0x000000c0)
#define HW_DIGCTL_MICROSECONDS_SET	(0x000000c4)
#define HW_DIGCTL_MICROSECONDS_CLR	(0x000000c8)
#define HW_DIGCTL_MICROSECONDS_TOG	(0x000000cc)

#define BP_DIGCTL_MICROSECONDS_VALUE	0
#define BM_DIGCTL_MICROSECONDS_VALUE	0xFFFFFFFF
#define BF_DIGCTL_MICROSECONDS_VALUE(v)	(v)

#define HW_DIGCTL_DBGRD	(0x000000d0)

#define BP_DIGCTL_DBGRD_COMPLEMENT	0
#define BM_DIGCTL_DBGRD_COMPLEMENT	0xFFFFFFFF
#define BF_DIGCTL_DBGRD_COMPLEMENT(v)	(v)

#define HW_DIGCTL_DBG	(0x000000e0)

#define BP_DIGCTL_DBG_VALUE	0
#define BM_DIGCTL_DBG_VALUE	0xFFFFFFFF
#define BF_DIGCTL_DBG_VALUE(v)	(v)

#define HW_DIGCTL_OCRAM_BIST_CSR	(0x000000f0)
#define HW_DIGCTL_OCRAM_BIST_CSR_SET	(0x000000f4)
#define HW_DIGCTL_OCRAM_BIST_CSR_CLR	(0x000000f8)
#define HW_DIGCTL_OCRAM_BIST_CSR_TOG	(0x000000fc)

#define BP_DIGCTL_OCRAM_BIST_CSR_RSVD1	11
#define BM_DIGCTL_OCRAM_BIST_CSR_RSVD1	0xFFFFF800
#define BF_DIGCTL_OCRAM_BIST_CSR_RSVD1(v) \
		(((v) << 11) & BM_DIGCTL_OCRAM_BIST_CSR_RSVD1)
#define BM_DIGCTL_OCRAM_BIST_CSR_BIST_DEBUG_MODE	0x00000400
#define BM_DIGCTL_OCRAM_BIST_CSR_BIST_DATA_CHANGE	0x00000200
#define BM_DIGCTL_OCRAM_BIST_CSR_BIST_CLKEN	0x00000100
#define BP_DIGCTL_OCRAM_BIST_CSR_RSVD0	4
#define BM_DIGCTL_OCRAM_BIST_CSR_RSVD0	0x000000F0
#define BF_DIGCTL_OCRAM_BIST_CSR_RSVD0(v)  \
		(((v) << 4) & BM_DIGCTL_OCRAM_BIST_CSR_RSVD0)
#define BM_DIGCTL_OCRAM_BIST_CSR_FAIL	0x00000008
#define BM_DIGCTL_OCRAM_BIST_CSR_PASS	0x00000004
#define BM_DIGCTL_OCRAM_BIST_CSR_DONE	0x00000002
#define BM_DIGCTL_OCRAM_BIST_CSR_START	0x00000001

#define HW_DIGCTL_OCRAM_STATUS0	(0x00000110)
#define HW_DIGCTL_OCRAM_STATUS0_SET	(0x00000114)
#define HW_DIGCTL_OCRAM_STATUS0_CLR	(0x00000118)
#define HW_DIGCTL_OCRAM_STATUS0_TOG	(0x0000011c)

#define BP_DIGCTL_OCRAM_STATUS0_FAILDATA00	0
#define BM_DIGCTL_OCRAM_STATUS0_FAILDATA00	0xFFFFFFFF
#define BF_DIGCTL_OCRAM_STATUS0_FAILDATA00(v)	(v)

#define HW_DIGCTL_OCRAM_STATUS1	(0x00000120)
#define HW_DIGCTL_OCRAM_STATUS1_SET	(0x00000124)
#define HW_DIGCTL_OCRAM_STATUS1_CLR	(0x00000128)
#define HW_DIGCTL_OCRAM_STATUS1_TOG	(0x0000012c)

#define BP_DIGCTL_OCRAM_STATUS1_FAILDATA01	0
#define BM_DIGCTL_OCRAM_STATUS1_FAILDATA01	0xFFFFFFFF
#define BF_DIGCTL_OCRAM_STATUS1_FAILDATA01(v)	(v)

#define HW_DIGCTL_OCRAM_STATUS2	(0x00000130)
#define HW_DIGCTL_OCRAM_STATUS2_SET	(0x00000134)
#define HW_DIGCTL_OCRAM_STATUS2_CLR	(0x00000138)
#define HW_DIGCTL_OCRAM_STATUS2_TOG	(0x0000013c)

#define BP_DIGCTL_OCRAM_STATUS2_FAILDATA10	0
#define BM_DIGCTL_OCRAM_STATUS2_FAILDATA10	0xFFFFFFFF
#define BF_DIGCTL_OCRAM_STATUS2_FAILDATA10(v)	(v)

#define HW_DIGCTL_OCRAM_STATUS3	(0x00000140)
#define HW_DIGCTL_OCRAM_STATUS3_SET	(0x00000144)
#define HW_DIGCTL_OCRAM_STATUS3_CLR	(0x00000148)
#define HW_DIGCTL_OCRAM_STATUS3_TOG	(0x0000014c)

#define BP_DIGCTL_OCRAM_STATUS3_FAILDATA11	0
#define BM_DIGCTL_OCRAM_STATUS3_FAILDATA11	0xFFFFFFFF
#define BF_DIGCTL_OCRAM_STATUS3_FAILDATA11(v)	(v)

#define HW_DIGCTL_OCRAM_STATUS4	(0x00000150)
#define HW_DIGCTL_OCRAM_STATUS4_SET	(0x00000154)
#define HW_DIGCTL_OCRAM_STATUS4_CLR	(0x00000158)
#define HW_DIGCTL_OCRAM_STATUS4_TOG	(0x0000015c)

#define BP_DIGCTL_OCRAM_STATUS4_FAILDATA20	0
#define BM_DIGCTL_OCRAM_STATUS4_FAILDATA20	0xFFFFFFFF
#define BF_DIGCTL_OCRAM_STATUS4_FAILDATA20(v)	(v)

#define HW_DIGCTL_OCRAM_STATUS5	(0x00000160)
#define HW_DIGCTL_OCRAM_STATUS5_SET	(0x00000164)
#define HW_DIGCTL_OCRAM_STATUS5_CLR	(0x00000168)
#define HW_DIGCTL_OCRAM_STATUS5_TOG	(0x0000016c)

#define BP_DIGCTL_OCRAM_STATUS5_FAILDATA21	0
#define BM_DIGCTL_OCRAM_STATUS5_FAILDATA21	0xFFFFFFFF
#define BF_DIGCTL_OCRAM_STATUS5_FAILDATA21(v)	(v)

#define HW_DIGCTL_OCRAM_STATUS6	(0x00000170)
#define HW_DIGCTL_OCRAM_STATUS6_SET	(0x00000174)
#define HW_DIGCTL_OCRAM_STATUS6_CLR	(0x00000178)
#define HW_DIGCTL_OCRAM_STATUS6_TOG	(0x0000017c)

#define BP_DIGCTL_OCRAM_STATUS6_FAILDATA30	0
#define BM_DIGCTL_OCRAM_STATUS6_FAILDATA30	0xFFFFFFFF
#define BF_DIGCTL_OCRAM_STATUS6_FAILDATA30(v)	(v)

#define HW_DIGCTL_OCRAM_STATUS7	(0x00000180)
#define HW_DIGCTL_OCRAM_STATUS7_SET	(0x00000184)
#define HW_DIGCTL_OCRAM_STATUS7_CLR	(0x00000188)
#define HW_DIGCTL_OCRAM_STATUS7_TOG	(0x0000018c)

#define BP_DIGCTL_OCRAM_STATUS7_FAILDATA31	0
#define BM_DIGCTL_OCRAM_STATUS7_FAILDATA31	0xFFFFFFFF
#define BF_DIGCTL_OCRAM_STATUS7_FAILDATA31(v)	(v)

#define HW_DIGCTL_OCRAM_STATUS8	(0x00000190)
#define HW_DIGCTL_OCRAM_STATUS8_SET	(0x00000194)
#define HW_DIGCTL_OCRAM_STATUS8_CLR	(0x00000198)
#define HW_DIGCTL_OCRAM_STATUS8_TOG	(0x0000019c)

#define BP_DIGCTL_OCRAM_STATUS8_RSVD3	29
#define BM_DIGCTL_OCRAM_STATUS8_RSVD3	0xE0000000
#define BF_DIGCTL_OCRAM_STATUS8_RSVD3(v) \
		(((v) << 29) & BM_DIGCTL_OCRAM_STATUS8_RSVD3)
#define BP_DIGCTL_OCRAM_STATUS8_FAILADDR01	16
#define BM_DIGCTL_OCRAM_STATUS8_FAILADDR01	0x1FFF0000
#define BF_DIGCTL_OCRAM_STATUS8_FAILADDR01(v)  \
		(((v) << 16) & BM_DIGCTL_OCRAM_STATUS8_FAILADDR01)
#define BP_DIGCTL_OCRAM_STATUS8_RSVD2	13
#define BM_DIGCTL_OCRAM_STATUS8_RSVD2	0x0000E000
#define BF_DIGCTL_OCRAM_STATUS8_RSVD2(v)  \
		(((v) << 13) & BM_DIGCTL_OCRAM_STATUS8_RSVD2)
#define BP_DIGCTL_OCRAM_STATUS8_FAILADDR00	0
#define BM_DIGCTL_OCRAM_STATUS8_FAILADDR00	0x00001FFF
#define BF_DIGCTL_OCRAM_STATUS8_FAILADDR00(v)  \
		(((v) << 0) & BM_DIGCTL_OCRAM_STATUS8_FAILADDR00)

#define HW_DIGCTL_OCRAM_STATUS9	(0x000001a0)
#define HW_DIGCTL_OCRAM_STATUS9_SET	(0x000001a4)
#define HW_DIGCTL_OCRAM_STATUS9_CLR	(0x000001a8)
#define HW_DIGCTL_OCRAM_STATUS9_TOG	(0x000001ac)

#define BP_DIGCTL_OCRAM_STATUS9_RSVD3	29
#define BM_DIGCTL_OCRAM_STATUS9_RSVD3	0xE0000000
#define BF_DIGCTL_OCRAM_STATUS9_RSVD3(v) \
		(((v) << 29) & BM_DIGCTL_OCRAM_STATUS9_RSVD3)
#define BP_DIGCTL_OCRAM_STATUS9_FAILADDR11	16
#define BM_DIGCTL_OCRAM_STATUS9_FAILADDR11	0x1FFF0000
#define BF_DIGCTL_OCRAM_STATUS9_FAILADDR11(v)  \
		(((v) << 16) & BM_DIGCTL_OCRAM_STATUS9_FAILADDR11)
#define BP_DIGCTL_OCRAM_STATUS9_RSVD2	13
#define BM_DIGCTL_OCRAM_STATUS9_RSVD2	0x0000E000
#define BF_DIGCTL_OCRAM_STATUS9_RSVD2(v)  \
		(((v) << 13) & BM_DIGCTL_OCRAM_STATUS9_RSVD2)
#define BP_DIGCTL_OCRAM_STATUS9_FAILADDR10	0
#define BM_DIGCTL_OCRAM_STATUS9_FAILADDR10	0x00001FFF
#define BF_DIGCTL_OCRAM_STATUS9_FAILADDR10(v)  \
		(((v) << 0) & BM_DIGCTL_OCRAM_STATUS9_FAILADDR10)

#define HW_DIGCTL_OCRAM_STATUS10	(0x000001b0)
#define HW_DIGCTL_OCRAM_STATUS10_SET	(0x000001b4)
#define HW_DIGCTL_OCRAM_STATUS10_CLR	(0x000001b8)
#define HW_DIGCTL_OCRAM_STATUS10_TOG	(0x000001bc)

#define BP_DIGCTL_OCRAM_STATUS10_RSVD3	29
#define BM_DIGCTL_OCRAM_STATUS10_RSVD3	0xE0000000
#define BF_DIGCTL_OCRAM_STATUS10_RSVD3(v) \
		(((v) << 29) & BM_DIGCTL_OCRAM_STATUS10_RSVD3)
#define BP_DIGCTL_OCRAM_STATUS10_FAILADDR21	16
#define BM_DIGCTL_OCRAM_STATUS10_FAILADDR21	0x1FFF0000
#define BF_DIGCTL_OCRAM_STATUS10_FAILADDR21(v)  \
		(((v) << 16) & BM_DIGCTL_OCRAM_STATUS10_FAILADDR21)
#define BP_DIGCTL_OCRAM_STATUS10_RSVD2	13
#define BM_DIGCTL_OCRAM_STATUS10_RSVD2	0x0000E000
#define BF_DIGCTL_OCRAM_STATUS10_RSVD2(v)  \
		(((v) << 13) & BM_DIGCTL_OCRAM_STATUS10_RSVD2)
#define BP_DIGCTL_OCRAM_STATUS10_FAILADDR20	0
#define BM_DIGCTL_OCRAM_STATUS10_FAILADDR20	0x00001FFF
#define BF_DIGCTL_OCRAM_STATUS10_FAILADDR20(v)  \
		(((v) << 0) & BM_DIGCTL_OCRAM_STATUS10_FAILADDR20)

#define HW_DIGCTL_OCRAM_STATUS11	(0x000001c0)
#define HW_DIGCTL_OCRAM_STATUS11_SET	(0x000001c4)
#define HW_DIGCTL_OCRAM_STATUS11_CLR	(0x000001c8)
#define HW_DIGCTL_OCRAM_STATUS11_TOG	(0x000001cc)

#define BP_DIGCTL_OCRAM_STATUS11_RSVD3	29
#define BM_DIGCTL_OCRAM_STATUS11_RSVD3	0xE0000000
#define BF_DIGCTL_OCRAM_STATUS11_RSVD3(v) \
		(((v) << 29) & BM_DIGCTL_OCRAM_STATUS11_RSVD3)
#define BP_DIGCTL_OCRAM_STATUS11_FAILADDR31	16
#define BM_DIGCTL_OCRAM_STATUS11_FAILADDR31	0x1FFF0000
#define BF_DIGCTL_OCRAM_STATUS11_FAILADDR31(v)  \
		(((v) << 16) & BM_DIGCTL_OCRAM_STATUS11_FAILADDR31)
#define BP_DIGCTL_OCRAM_STATUS11_RSVD2	13
#define BM_DIGCTL_OCRAM_STATUS11_RSVD2	0x0000E000
#define BF_DIGCTL_OCRAM_STATUS11_RSVD2(v)  \
		(((v) << 13) & BM_DIGCTL_OCRAM_STATUS11_RSVD2)
#define BP_DIGCTL_OCRAM_STATUS11_FAILADDR30	0
#define BM_DIGCTL_OCRAM_STATUS11_FAILADDR30	0x00001FFF
#define BF_DIGCTL_OCRAM_STATUS11_FAILADDR30(v)  \
		(((v) << 0) & BM_DIGCTL_OCRAM_STATUS11_FAILADDR30)

#define HW_DIGCTL_OCRAM_STATUS12	(0x000001d0)
#define HW_DIGCTL_OCRAM_STATUS12_SET	(0x000001d4)
#define HW_DIGCTL_OCRAM_STATUS12_CLR	(0x000001d8)
#define HW_DIGCTL_OCRAM_STATUS12_TOG	(0x000001dc)

#define BP_DIGCTL_OCRAM_STATUS12_RSVD3	28
#define BM_DIGCTL_OCRAM_STATUS12_RSVD3	0xF0000000
#define BF_DIGCTL_OCRAM_STATUS12_RSVD3(v) \
		(((v) << 28) & BM_DIGCTL_OCRAM_STATUS12_RSVD3)
#define BP_DIGCTL_OCRAM_STATUS12_FAILSTATE11	24
#define BM_DIGCTL_OCRAM_STATUS12_FAILSTATE11	0x0F000000
#define BF_DIGCTL_OCRAM_STATUS12_FAILSTATE11(v)  \
		(((v) << 24) & BM_DIGCTL_OCRAM_STATUS12_FAILSTATE11)
#define BP_DIGCTL_OCRAM_STATUS12_RSVD2	20
#define BM_DIGCTL_OCRAM_STATUS12_RSVD2	0x00F00000
#define BF_DIGCTL_OCRAM_STATUS12_RSVD2(v)  \
		(((v) << 20) & BM_DIGCTL_OCRAM_STATUS12_RSVD2)
#define BP_DIGCTL_OCRAM_STATUS12_FAILSTATE10	16
#define BM_DIGCTL_OCRAM_STATUS12_FAILSTATE10	0x000F0000
#define BF_DIGCTL_OCRAM_STATUS12_FAILSTATE10(v)  \
		(((v) << 16) & BM_DIGCTL_OCRAM_STATUS12_FAILSTATE10)
#define BP_DIGCTL_OCRAM_STATUS12_RSVD1	12
#define BM_DIGCTL_OCRAM_STATUS12_RSVD1	0x0000F000
#define BF_DIGCTL_OCRAM_STATUS12_RSVD1(v)  \
		(((v) << 12) & BM_DIGCTL_OCRAM_STATUS12_RSVD1)
#define BP_DIGCTL_OCRAM_STATUS12_FAILSTATE01	8
#define BM_DIGCTL_OCRAM_STATUS12_FAILSTATE01	0x00000F00
#define BF_DIGCTL_OCRAM_STATUS12_FAILSTATE01(v)  \
		(((v) << 8) & BM_DIGCTL_OCRAM_STATUS12_FAILSTATE01)
#define BP_DIGCTL_OCRAM_STATUS12_RSVD0	4
#define BM_DIGCTL_OCRAM_STATUS12_RSVD0	0x000000F0
#define BF_DIGCTL_OCRAM_STATUS12_RSVD0(v)  \
		(((v) << 4) & BM_DIGCTL_OCRAM_STATUS12_RSVD0)
#define BP_DIGCTL_OCRAM_STATUS12_FAILSTATE00	0
#define BM_DIGCTL_OCRAM_STATUS12_FAILSTATE00	0x0000000F
#define BF_DIGCTL_OCRAM_STATUS12_FAILSTATE00(v)  \
		(((v) << 0) & BM_DIGCTL_OCRAM_STATUS12_FAILSTATE00)

#define HW_DIGCTL_OCRAM_STATUS13	(0x000001e0)
#define HW_DIGCTL_OCRAM_STATUS13_SET	(0x000001e4)
#define HW_DIGCTL_OCRAM_STATUS13_CLR	(0x000001e8)
#define HW_DIGCTL_OCRAM_STATUS13_TOG	(0x000001ec)

#define BP_DIGCTL_OCRAM_STATUS13_RSVD3	28
#define BM_DIGCTL_OCRAM_STATUS13_RSVD3	0xF0000000
#define BF_DIGCTL_OCRAM_STATUS13_RSVD3(v) \
		(((v) << 28) & BM_DIGCTL_OCRAM_STATUS13_RSVD3)
#define BP_DIGCTL_OCRAM_STATUS13_FAILSTATE31	24
#define BM_DIGCTL_OCRAM_STATUS13_FAILSTATE31	0x0F000000
#define BF_DIGCTL_OCRAM_STATUS13_FAILSTATE31(v)  \
		(((v) << 24) & BM_DIGCTL_OCRAM_STATUS13_FAILSTATE31)
#define BP_DIGCTL_OCRAM_STATUS13_RSVD2	20
#define BM_DIGCTL_OCRAM_STATUS13_RSVD2	0x00F00000
#define BF_DIGCTL_OCRAM_STATUS13_RSVD2(v)  \
		(((v) << 20) & BM_DIGCTL_OCRAM_STATUS13_RSVD2)
#define BP_DIGCTL_OCRAM_STATUS13_FAILSTATE30	16
#define BM_DIGCTL_OCRAM_STATUS13_FAILSTATE30	0x000F0000
#define BF_DIGCTL_OCRAM_STATUS13_FAILSTATE30(v)  \
		(((v) << 16) & BM_DIGCTL_OCRAM_STATUS13_FAILSTATE30)
#define BP_DIGCTL_OCRAM_STATUS13_RSVD1	12
#define BM_DIGCTL_OCRAM_STATUS13_RSVD1	0x0000F000
#define BF_DIGCTL_OCRAM_STATUS13_RSVD1(v)  \
		(((v) << 12) & BM_DIGCTL_OCRAM_STATUS13_RSVD1)
#define BP_DIGCTL_OCRAM_STATUS13_FAILSTATE21	8
#define BM_DIGCTL_OCRAM_STATUS13_FAILSTATE21	0x00000F00
#define BF_DIGCTL_OCRAM_STATUS13_FAILSTATE21(v)  \
		(((v) << 8) & BM_DIGCTL_OCRAM_STATUS13_FAILSTATE21)
#define BP_DIGCTL_OCRAM_STATUS13_RSVD0	4
#define BM_DIGCTL_OCRAM_STATUS13_RSVD0	0x000000F0
#define BF_DIGCTL_OCRAM_STATUS13_RSVD0(v)  \
		(((v) << 4) & BM_DIGCTL_OCRAM_STATUS13_RSVD0)
#define BP_DIGCTL_OCRAM_STATUS13_FAILSTATE20	0
#define BM_DIGCTL_OCRAM_STATUS13_FAILSTATE20	0x0000000F
#define BF_DIGCTL_OCRAM_STATUS13_FAILSTATE20(v)  \
		(((v) << 0) & BM_DIGCTL_OCRAM_STATUS13_FAILSTATE20)

#define HW_DIGCTL_SCRATCH0	(0x00000290)

#define BP_DIGCTL_SCRATCH0_PTR	0
#define BM_DIGCTL_SCRATCH0_PTR	0xFFFFFFFF
#define BF_DIGCTL_SCRATCH0_PTR(v)	(v)

#define HW_DIGCTL_SCRATCH1	(0x000002a0)

#define BP_DIGCTL_SCRATCH1_PTR	0
#define BM_DIGCTL_SCRATCH1_PTR	0xFFFFFFFF
#define BF_DIGCTL_SCRATCH1_PTR(v)	(v)

#define HW_DIGCTL_ARMCACHE	(0x000002b0)

#define BP_DIGCTL_ARMCACHE_RSVD4	18
#define BM_DIGCTL_ARMCACHE_RSVD4	0xFFFC0000
#define BF_DIGCTL_ARMCACHE_RSVD4(v) \
		(((v) << 18) & BM_DIGCTL_ARMCACHE_RSVD4)
#define BP_DIGCTL_ARMCACHE_VALID_SS	16
#define BM_DIGCTL_ARMCACHE_VALID_SS	0x00030000
#define BF_DIGCTL_ARMCACHE_VALID_SS(v)  \
		(((v) << 16) & BM_DIGCTL_ARMCACHE_VALID_SS)
#define BP_DIGCTL_ARMCACHE_RSVD3	14
#define BM_DIGCTL_ARMCACHE_RSVD3	0x0000C000
#define BF_DIGCTL_ARMCACHE_RSVD3(v)  \
		(((v) << 14) & BM_DIGCTL_ARMCACHE_RSVD3)
#define BP_DIGCTL_ARMCACHE_DRTY_SS	12
#define BM_DIGCTL_ARMCACHE_DRTY_SS	0x00003000
#define BF_DIGCTL_ARMCACHE_DRTY_SS(v)  \
		(((v) << 12) & BM_DIGCTL_ARMCACHE_DRTY_SS)
#define BP_DIGCTL_ARMCACHE_RSVD2	10
#define BM_DIGCTL_ARMCACHE_RSVD2	0x00000C00
#define BF_DIGCTL_ARMCACHE_RSVD2(v)  \
		(((v) << 10) & BM_DIGCTL_ARMCACHE_RSVD2)
#define BP_DIGCTL_ARMCACHE_CACHE_SS	8
#define BM_DIGCTL_ARMCACHE_CACHE_SS	0x00000300
#define BF_DIGCTL_ARMCACHE_CACHE_SS(v)  \
		(((v) << 8) & BM_DIGCTL_ARMCACHE_CACHE_SS)
#define BP_DIGCTL_ARMCACHE_RSVD1	6
#define BM_DIGCTL_ARMCACHE_RSVD1	0x000000C0
#define BF_DIGCTL_ARMCACHE_RSVD1(v)  \
		(((v) << 6) & BM_DIGCTL_ARMCACHE_RSVD1)
#define BP_DIGCTL_ARMCACHE_DTAG_SS	4
#define BM_DIGCTL_ARMCACHE_DTAG_SS	0x00000030
#define BF_DIGCTL_ARMCACHE_DTAG_SS(v)  \
		(((v) << 4) & BM_DIGCTL_ARMCACHE_DTAG_SS)
#define BP_DIGCTL_ARMCACHE_RSVD0	2
#define BM_DIGCTL_ARMCACHE_RSVD0	0x0000000C
#define BF_DIGCTL_ARMCACHE_RSVD0(v)  \
		(((v) << 2) & BM_DIGCTL_ARMCACHE_RSVD0)
#define BP_DIGCTL_ARMCACHE_ITAG_SS	0
#define BM_DIGCTL_ARMCACHE_ITAG_SS	0x00000003
#define BF_DIGCTL_ARMCACHE_ITAG_SS(v)  \
		(((v) << 0) & BM_DIGCTL_ARMCACHE_ITAG_SS)

#define HW_DIGCTL_DEBUG_TRAP_ADDR_LOW	(0x000002c0)

#define BP_DIGCTL_DEBUG_TRAP_ADDR_LOW_ADDR	0
#define BM_DIGCTL_DEBUG_TRAP_ADDR_LOW_ADDR	0xFFFFFFFF
#define BF_DIGCTL_DEBUG_TRAP_ADDR_LOW_ADDR(v)	(v)

#define HW_DIGCTL_DEBUG_TRAP_ADDR_HIGH	(0x000002d0)

#define BP_DIGCTL_DEBUG_TRAP_ADDR_HIGH_ADDR	0
#define BM_DIGCTL_DEBUG_TRAP_ADDR_HIGH_ADDR	0xFFFFFFFF
#define BF_DIGCTL_DEBUG_TRAP_ADDR_HIGH_ADDR(v)	(v)

#define HW_DIGCTL_SGTL	(0x00000300)

#define BP_DIGCTL_SGTL_COPYRIGHT	0
#define BM_DIGCTL_SGTL_COPYRIGHT	0xFFFFFFFF
#define BF_DIGCTL_SGTL_COPYRIGHT(v)	(v)

#define HW_DIGCTL_CHIPID	(0x00000310)

#define BP_DIGCTL_CHIPID_PRODUCT_CODE	16
#define BM_DIGCTL_CHIPID_PRODUCT_CODE	0xFFFF0000
#define BF_DIGCTL_CHIPID_PRODUCT_CODE(v) \
		(((v) << 16) & BM_DIGCTL_CHIPID_PRODUCT_CODE)
#define BP_DIGCTL_CHIPID_RSVD0	8
#define BM_DIGCTL_CHIPID_RSVD0	0x0000FF00
#define BF_DIGCTL_CHIPID_RSVD0(v)  \
		(((v) << 8) & BM_DIGCTL_CHIPID_RSVD0)
#define BP_DIGCTL_CHIPID_REVISION	0
#define BM_DIGCTL_CHIPID_REVISION	0x000000FF
#define BF_DIGCTL_CHIPID_REVISION(v)  \
		(((v) << 0) & BM_DIGCTL_CHIPID_REVISION)

#define HW_DIGCTL_AHB_STATS_SELECT	(0x00000330)

#define BP_DIGCTL_AHB_STATS_SELECT_RSVD3	28
#define BM_DIGCTL_AHB_STATS_SELECT_RSVD3	0xF0000000
#define BF_DIGCTL_AHB_STATS_SELECT_RSVD3(v) \
		(((v) << 28) & BM_DIGCTL_AHB_STATS_SELECT_RSVD3)
#define BP_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT	24
#define BM_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT	0x0F000000
#define BF_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT(v)  \
		(((v) << 24) & BM_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT)
#define BV_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT__APBH 0x1
#define BV_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT__APBX 0x2
#define BV_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT__USB  0x4
#define BP_DIGCTL_AHB_STATS_SELECT_RSVD2	20
#define BM_DIGCTL_AHB_STATS_SELECT_RSVD2	0x00F00000
#define BF_DIGCTL_AHB_STATS_SELECT_RSVD2(v)  \
		(((v) << 20) & BM_DIGCTL_AHB_STATS_SELECT_RSVD2)
#define BP_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT	16
#define BM_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT	0x000F0000
#define BF_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT(v)  \
		(((v) << 16) & BM_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT)
#define BV_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT__ARM_D 0x1
#define BP_DIGCTL_AHB_STATS_SELECT_RSVD1	12
#define BM_DIGCTL_AHB_STATS_SELECT_RSVD1	0x0000F000
#define BF_DIGCTL_AHB_STATS_SELECT_RSVD1(v)  \
		(((v) << 12) & BM_DIGCTL_AHB_STATS_SELECT_RSVD1)
#define BP_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT	8
#define BM_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT	0x00000F00
#define BF_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT(v)  \
		(((v) << 8) & BM_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT)
#define BV_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT__ARM_I 0x1
#define BP_DIGCTL_AHB_STATS_SELECT_RSVD0	4
#define BM_DIGCTL_AHB_STATS_SELECT_RSVD0	0x000000F0
#define BF_DIGCTL_AHB_STATS_SELECT_RSVD0(v)  \
		(((v) << 4) & BM_DIGCTL_AHB_STATS_SELECT_RSVD0)
#define BP_DIGCTL_AHB_STATS_SELECT_L0_MASTER_SELECT	0
#define BM_DIGCTL_AHB_STATS_SELECT_L0_MASTER_SELECT	0x0000000F
#define BF_DIGCTL_AHB_STATS_SELECT_L0_MASTER_SELECT(v)  \
		(((v) << 0) & BM_DIGCTL_AHB_STATS_SELECT_L0_MASTER_SELECT)
#define BV_DIGCTL_AHB_STATS_SELECT_L0_MASTER_SELECT__ECC8   0x1
#define BV_DIGCTL_AHB_STATS_SELECT_L0_MASTER_SELECT__CRYPTO 0x2

#define HW_DIGCTL_L0_AHB_ACTIVE_CYCLES	(0x00000340)

#define BP_DIGCTL_L0_AHB_ACTIVE_CYCLES_COUNT	0
#define BM_DIGCTL_L0_AHB_ACTIVE_CYCLES_COUNT	0xFFFFFFFF
#define BF_DIGCTL_L0_AHB_ACTIVE_CYCLES_COUNT(v)	(v)

#define HW_DIGCTL_L0_AHB_DATA_STALLED	(0x00000350)

#define BP_DIGCTL_L0_AHB_DATA_STALLED_COUNT	0
#define BM_DIGCTL_L0_AHB_DATA_STALLED_COUNT	0xFFFFFFFF
#define BF_DIGCTL_L0_AHB_DATA_STALLED_COUNT(v)	(v)

#define HW_DIGCTL_L0_AHB_DATA_CYCLES	(0x00000360)

#define BP_DIGCTL_L0_AHB_DATA_CYCLES_COUNT	0
#define BM_DIGCTL_L0_AHB_DATA_CYCLES_COUNT	0xFFFFFFFF
#define BF_DIGCTL_L0_AHB_DATA_CYCLES_COUNT(v)	(v)

#define HW_DIGCTL_L1_AHB_ACTIVE_CYCLES	(0x00000370)

#define BP_DIGCTL_L1_AHB_ACTIVE_CYCLES_COUNT	0
#define BM_DIGCTL_L1_AHB_ACTIVE_CYCLES_COUNT	0xFFFFFFFF
#define BF_DIGCTL_L1_AHB_ACTIVE_CYCLES_COUNT(v)	(v)

#define HW_DIGCTL_L1_AHB_DATA_STALLED	(0x00000380)

#define BP_DIGCTL_L1_AHB_DATA_STALLED_COUNT	0
#define BM_DIGCTL_L1_AHB_DATA_STALLED_COUNT	0xFFFFFFFF
#define BF_DIGCTL_L1_AHB_DATA_STALLED_COUNT(v)	(v)

#define HW_DIGCTL_L1_AHB_DATA_CYCLES	(0x00000390)

#define BP_DIGCTL_L1_AHB_DATA_CYCLES_COUNT	0
#define BM_DIGCTL_L1_AHB_DATA_CYCLES_COUNT	0xFFFFFFFF
#define BF_DIGCTL_L1_AHB_DATA_CYCLES_COUNT(v)	(v)

#define HW_DIGCTL_L2_AHB_ACTIVE_CYCLES	(0x000003a0)

#define BP_DIGCTL_L2_AHB_ACTIVE_CYCLES_COUNT	0
#define BM_DIGCTL_L2_AHB_ACTIVE_CYCLES_COUNT	0xFFFFFFFF
#define BF_DIGCTL_L2_AHB_ACTIVE_CYCLES_COUNT(v)	(v)

#define HW_DIGCTL_L2_AHB_DATA_STALLED	(0x000003b0)

#define BP_DIGCTL_L2_AHB_DATA_STALLED_COUNT	0
#define BM_DIGCTL_L2_AHB_DATA_STALLED_COUNT	0xFFFFFFFF
#define BF_DIGCTL_L2_AHB_DATA_STALLED_COUNT(v)	(v)

#define HW_DIGCTL_L2_AHB_DATA_CYCLES	(0x000003c0)

#define BP_DIGCTL_L2_AHB_DATA_CYCLES_COUNT	0
#define BM_DIGCTL_L2_AHB_DATA_CYCLES_COUNT	0xFFFFFFFF
#define BF_DIGCTL_L2_AHB_DATA_CYCLES_COUNT(v)	(v)

#define HW_DIGCTL_L3_AHB_ACTIVE_CYCLES	(0x000003d0)

#define BP_DIGCTL_L3_AHB_ACTIVE_CYCLES_COUNT	0
#define BM_DIGCTL_L3_AHB_ACTIVE_CYCLES_COUNT	0xFFFFFFFF
#define BF_DIGCTL_L3_AHB_ACTIVE_CYCLES_COUNT(v)	(v)

#define HW_DIGCTL_L3_AHB_DATA_STALLED	(0x000003e0)

#define BP_DIGCTL_L3_AHB_DATA_STALLED_COUNT	0
#define BM_DIGCTL_L3_AHB_DATA_STALLED_COUNT	0xFFFFFFFF
#define BF_DIGCTL_L3_AHB_DATA_STALLED_COUNT(v)	(v)

#define HW_DIGCTL_L3_AHB_DATA_CYCLES	(0x000003f0)

#define BP_DIGCTL_L3_AHB_DATA_CYCLES_COUNT	0
#define BM_DIGCTL_L3_AHB_DATA_CYCLES_COUNT	0xFFFFFFFF
#define BF_DIGCTL_L3_AHB_DATA_CYCLES_COUNT(v)	(v)

/*
 *  multi-register-define name HW_DIGCTL_MPTEn_LOC
 *              base 0x00000400
 *              count 16
 *              offset 0x10
 */
#define HW_DIGCTL_MPTEn_LOC(n)	(0x00000400 + (n) * 0x10)
#define BP_DIGCTL_MPTEn_LOC_RSVD0	12
#define BM_DIGCTL_MPTEn_LOC_RSVD0	0xFFFFF000
#define BF_DIGCTL_MPTEn_LOC_RSVD0(v) \
		(((v) << 12) & BM_DIGCTL_MPTEn_LOC_RSVD0)
#define BP_DIGCTL_MPTEn_LOC_LOC	0
#define BM_DIGCTL_MPTEn_LOC_LOC	0x00000FFF
#define BF_DIGCTL_MPTEn_LOC_LOC(v)  \
		(((v) << 0) & BM_DIGCTL_MPTEn_LOC_LOC)

#define HW_DIGCTL_EMICLK_DELAY	(0x00000500)

#define BP_DIGCTL_EMICLK_DELAY_RSVD0	5
#define BM_DIGCTL_EMICLK_DELAY_RSVD0	0xFFFFFFE0
#define BF_DIGCTL_EMICLK_DELAY_RSVD0(v) \
		(((v) << 5) & BM_DIGCTL_EMICLK_DELAY_RSVD0)
#define BP_DIGCTL_EMICLK_DELAY_NUM_TAPS	0
#define BM_DIGCTL_EMICLK_DELAY_NUM_TAPS	0x0000001F
#define BF_DIGCTL_EMICLK_DELAY_NUM_TAPS(v)  \
		(((v) << 0) & BM_DIGCTL_EMICLK_DELAY_NUM_TAPS)
#endif /* __ARCH_ARM___DIGCTL_H */
