/*
 * Copyright (C) 2009-2010 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __ASM_ARCH_PINS_H
#define __ASM_ARCH_PINS_H

#include <mach/pinctrl.h>

/*
 * Define MX28 pins, the pin name corresponds to MX28 hardware
 * interface this pin belongs to.
 */

/* Bank 0 */
#define PINID_GPMI_D00		MXS_PIN_ENCODE(0, 0)
#define PINID_GPMI_D01		MXS_PIN_ENCODE(0, 1)
#define PINID_GPMI_D02		MXS_PIN_ENCODE(0, 2)
#define PINID_GPMI_D03		MXS_PIN_ENCODE(0, 3)
#define PINID_GPMI_D04		MXS_PIN_ENCODE(0, 4)
#define PINID_GPMI_D05		MXS_PIN_ENCODE(0, 5)
#define PINID_GPMI_D06		MXS_PIN_ENCODE(0, 6)
#define PINID_GPMI_D07		MXS_PIN_ENCODE(0, 7)
#define PINID_GPMI_CE0N		MXS_PIN_ENCODE(0, 16)
#define PINID_GPMI_CE1N		MXS_PIN_ENCODE(0, 17)
#define PINID_GPMI_CE2N		MXS_PIN_ENCODE(0, 18)
#define PINID_GPMI_CE3N		MXS_PIN_ENCODE(0, 19)
#define PINID_GPMI_RDY0		MXS_PIN_ENCODE(0, 20)
#define PINID_GPMI_RDY1		MXS_PIN_ENCODE(0, 21)
#define PINID_GPMI_RDY2		MXS_PIN_ENCODE(0, 22)
#define PINID_GPMI_RDY3		MXS_PIN_ENCODE(0, 23)
#define PINID_GPMI_RDN		MXS_PIN_ENCODE(0, 24)
#define PINID_GPMI_WRN		MXS_PIN_ENCODE(0, 25)
#define PINID_GPMI_ALE		MXS_PIN_ENCODE(0, 26)
#define PINID_GPMI_CLE		MXS_PIN_ENCODE(0, 27)
#define PINID_GPMI_RESETN	MXS_PIN_ENCODE(0, 28)

/* Bank 1 */
#define PINID_LCD_D00		MXS_PIN_ENCODE(1, 0)
#define PINID_LCD_D01		MXS_PIN_ENCODE(1, 1)
#define PINID_LCD_D02		MXS_PIN_ENCODE(1, 2)
#define PINID_LCD_D03		MXS_PIN_ENCODE(1, 3)
#define PINID_LCD_D04		MXS_PIN_ENCODE(1, 4)
#define PINID_LCD_D05		MXS_PIN_ENCODE(1, 5)
#define PINID_LCD_D06		MXS_PIN_ENCODE(1, 6)
#define PINID_LCD_D07		MXS_PIN_ENCODE(1, 7)
#define PINID_LCD_D08		MXS_PIN_ENCODE(1, 8)
#define PINID_LCD_D09		MXS_PIN_ENCODE(1, 9)
#define PINID_LCD_D10		MXS_PIN_ENCODE(1, 10)
#define PINID_LCD_D11		MXS_PIN_ENCODE(1, 11)
#define PINID_LCD_D12		MXS_PIN_ENCODE(1, 12)
#define PINID_LCD_D13		MXS_PIN_ENCODE(1, 13)
#define PINID_LCD_D14		MXS_PIN_ENCODE(1, 14)
#define PINID_LCD_D15		MXS_PIN_ENCODE(1, 15)
#define PINID_LCD_D16		MXS_PIN_ENCODE(1, 16)
#define PINID_LCD_D17		MXS_PIN_ENCODE(1, 17)
#define PINID_LCD_D18		MXS_PIN_ENCODE(1, 18)
#define PINID_LCD_D19		MXS_PIN_ENCODE(1, 19)
#define PINID_LCD_D20		MXS_PIN_ENCODE(1, 20)
#define PINID_LCD_D21		MXS_PIN_ENCODE(1, 21)
#define PINID_LCD_D22		MXS_PIN_ENCODE(1, 22)
#define PINID_LCD_D23		MXS_PIN_ENCODE(1, 23)
#define PINID_LCD_RD_E		MXS_PIN_ENCODE(1, 24)
#define PINID_LCD_WR_RWN	MXS_PIN_ENCODE(1, 25)
#define PINID_LCD_RS		MXS_PIN_ENCODE(1, 26)
#define PINID_LCD_CS		MXS_PIN_ENCODE(1, 27)
#define PINID_LCD_VSYNC		MXS_PIN_ENCODE(1, 28)
#define PINID_LCD_HSYNC		MXS_PIN_ENCODE(1, 29)
#define PINID_LCD_DOTCK		MXS_PIN_ENCODE(1, 30)
#define PINID_LCD_ENABLE	MXS_PIN_ENCODE(1, 31)

/* Bank 2 */
#define PINID_SSP0_DATA0	MXS_PIN_ENCODE(2, 0)
#define PINID_SSP0_DATA1	MXS_PIN_ENCODE(2, 1)
#define PINID_SSP0_DATA2	MXS_PIN_ENCODE(2, 2)
#define PINID_SSP0_DATA3	MXS_PIN_ENCODE(2, 3)
#define PINID_SSP0_DATA4	MXS_PIN_ENCODE(2, 4)
#define PINID_SSP0_DATA5	MXS_PIN_ENCODE(2, 5)
#define PINID_SSP0_DATA6	MXS_PIN_ENCODE(2, 6)
#define PINID_SSP0_DATA7	MXS_PIN_ENCODE(2, 7)
#define PINID_SSP0_CMD		MXS_PIN_ENCODE(2, 8)
#define PINID_SSP0_DETECT	MXS_PIN_ENCODE(2, 9)
#define PINID_SSP0_SCK		MXS_PIN_ENCODE(2, 10)
#define PINID_SSP1_SCK		MXS_PIN_ENCODE(2, 12)
#define PINID_SSP1_CMD		MXS_PIN_ENCODE(2, 13)
#define PINID_SSP1_DATA0	MXS_PIN_ENCODE(2, 14)
#define PINID_SSP1_DATA3	MXS_PIN_ENCODE(2, 15)
#define PINID_SSP2_SCK		MXS_PIN_ENCODE(2, 16)
#define PINID_SSP2_MOSI		MXS_PIN_ENCODE(2, 17)
#define PINID_SSP2_MISO		MXS_PIN_ENCODE(2, 18)
#define PINID_SSP2_SS0		MXS_PIN_ENCODE(2, 19)
#define PINID_SSP2_SS1		MXS_PIN_ENCODE(2, 20)
#define PINID_SSP2_SS2		MXS_PIN_ENCODE(2, 21)
#define PINID_SSP3_SCK		MXS_PIN_ENCODE(2, 24)
#define PINID_SSP3_MOSI		MXS_PIN_ENCODE(2, 25)
#define PINID_SSP3_MISO		MXS_PIN_ENCODE(2, 26)
#define PINID_SSP3_SS0		MXS_PIN_ENCODE(2, 27)

/* Bank 3 */
#define PINID_AUART0_RX		MXS_PIN_ENCODE(3, 0)
#define PINID_AUART0_TX		MXS_PIN_ENCODE(3, 1)
#define PINID_AUART0_CTS	MXS_PIN_ENCODE(3, 2)
#define PINID_AUART0_RTS	MXS_PIN_ENCODE(3, 3)
#define PINID_AUART1_RX		MXS_PIN_ENCODE(3, 4)
#define PINID_AUART1_TX		MXS_PIN_ENCODE(3, 5)
#define PINID_AUART1_CTS	MXS_PIN_ENCODE(3, 6)
#define PINID_AUART1_RTS	MXS_PIN_ENCODE(3, 7)
#define PINID_AUART2_RX		MXS_PIN_ENCODE(3, 8)
#define PINID_AUART2_TX		MXS_PIN_ENCODE(3, 9)
#define PINID_AUART2_CTS	MXS_PIN_ENCODE(3, 10)
#define PINID_AUART2_RTS	MXS_PIN_ENCODE(3, 11)
#define PINID_AUART3_RX		MXS_PIN_ENCODE(3, 12)
#define PINID_AUART3_TX		MXS_PIN_ENCODE(3, 13)
#define PINID_AUART3_CTS	MXS_PIN_ENCODE(3, 14)
#define PINID_AUART3_RTS	MXS_PIN_ENCODE(3, 15)
#define PINID_PWM0		MXS_PIN_ENCODE(3, 16)
#define PINID_PWM1		MXS_PIN_ENCODE(3, 17)
#define PINID_PWM2		MXS_PIN_ENCODE(3, 18)
#define PINID_SAIF0_MCLK	MXS_PIN_ENCODE(3, 20)
#define PINID_SAIF0_LRCLK	MXS_PIN_ENCODE(3, 21)
#define PINID_SAIF0_BITCLK	MXS_PIN_ENCODE(3, 22)
#define PINID_SAIF0_SDATA0	MXS_PIN_ENCODE(3, 23)
#define PINID_I2C0_SCL		MXS_PIN_ENCODE(3, 24)
#define PINID_I2C0_SDA		MXS_PIN_ENCODE(3, 25)
#define PINID_SAIF1_SDATA0	MXS_PIN_ENCODE(3, 26)
#define PINID_SPDIF		MXS_PIN_ENCODE(3, 27)
#define PINID_PWM3		MXS_PIN_ENCODE(3, 28)
#define PINID_PWM4		MXS_PIN_ENCODE(3, 29)
#define PINID_LCD_RESET		MXS_PIN_ENCODE(3, 30)

/* Bank 4 */
#define PINID_ENET0_MDC		MXS_PIN_ENCODE(4, 0)
#define PINID_ENET0_MDIO	MXS_PIN_ENCODE(4, 1)
#define PINID_ENET0_RX_EN	MXS_PIN_ENCODE(4, 2)
#define PINID_ENET0_RXD0	MXS_PIN_ENCODE(4, 3)
#define PINID_ENET0_RXD1	MXS_PIN_ENCODE(4, 4)
#define PINID_ENET0_TX_CLK	MXS_PIN_ENCODE(4, 5)
#define PINID_ENET0_TX_EN	MXS_PIN_ENCODE(4, 6)
#define PINID_ENET0_TXD0	MXS_PIN_ENCODE(4, 7)
#define PINID_ENET0_TXD1	MXS_PIN_ENCODE(4, 8)
#define PINID_ENET0_RXD2	MXS_PIN_ENCODE(4, 9)
#define PINID_ENET0_RXD3	MXS_PIN_ENCODE(4, 10)
#define PINID_ENET0_TXD2	MXS_PIN_ENCODE(4, 11)
#define PINID_ENET0_TXD3	MXS_PIN_ENCODE(4, 12)
#define PINID_ENET0_RX_CLK	MXS_PIN_ENCODE(4, 13)
#define PINID_ENET0_COL		MXS_PIN_ENCODE(4, 14)
#define PINID_ENET0_CRS		MXS_PIN_ENCODE(4, 15)
#define PINID_ENET_CLK		MXS_PIN_ENCODE(4, 16)
#define PINID_JTAG_RTCK		MXS_PIN_ENCODE(4, 20)
#endif /* __ASM_ARCH_PINS_H */
