/*
 * STMP DRI Register Definitions
 *
 * Copyright 2008-2009 Freescale Semiconductor
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef __ARCH_ARM___DRI_H
#define __ARCH_ARM___DRI_H  1

#include <mach/stmp3xxx_regs.h>

#define REGS_DRI_BASE (REGS_BASE + 0x74000)
#define REGS_DRI_BASE_PHYS (0x80074000)
#define REGS_DRI_SIZE 0x00002000
HW_REGISTER(HW_DRI_CTRL, REGS_DRI_BASE, 0x00000000)
#define HW_DRI_CTRL_ADDR (REGS_DRI_BASE + 0x00000000)
#define BM_DRI_CTRL_SFTRST 0x80000000
#define BV_DRI_CTRL_SFTRST__RUN   0x0
#define BV_DRI_CTRL_SFTRST__RESET 0x1
#define BM_DRI_CTRL_CLKGATE 0x40000000
#define BV_DRI_CTRL_CLKGATE__RUN     0x0
#define BV_DRI_CTRL_CLKGATE__NO_CLKS 0x1
#define BM_DRI_CTRL_ENABLE_INPUTS 0x20000000
#define BV_DRI_CTRL_ENABLE_INPUTS__ANALOG_LINE_IN 0x0
#define BV_DRI_CTRL_ENABLE_INPUTS__DRI_DIGITAL_IN 0x1
#define BM_DRI_CTRL_STOP_ON_OFLOW_ERROR 0x04000000
#define BV_DRI_CTRL_STOP_ON_OFLOW_ERROR__IGNORE 0x0
#define BV_DRI_CTRL_STOP_ON_OFLOW_ERROR__STOP   0x1
#define BM_DRI_CTRL_STOP_ON_PILOT_ERROR 0x02000000
#define BV_DRI_CTRL_STOP_ON_PILOT_ERROR__IGNORE 0x0
#define BV_DRI_CTRL_STOP_ON_PILOT_ERROR__STOP   0x1
#define BP_DRI_CTRL_DMA_DELAY_COUNT      16
#define BM_DRI_CTRL_DMA_DELAY_COUNT 0x001F0000
#define BF_DRI_CTRL_DMA_DELAY_COUNT(v)  \
	(((v) << 16) & BM_DRI_CTRL_DMA_DELAY_COUNT)
#define BM_DRI_CTRL_REACQUIRE_PHASE 0x00008000
#define BV_DRI_CTRL_REACQUIRE_PHASE__NORMAL    0x0
#define BV_DRI_CTRL_REACQUIRE_PHASE__NEW_PHASE 0x1
#define BM_DRI_CTRL_OVERFLOW_IRQ_EN 0x00000800
#define BV_DRI_CTRL_OVERFLOW_IRQ_EN__DISABLED 0x0
#define BV_DRI_CTRL_OVERFLOW_IRQ_EN__ENABLED  0x1
#define BM_DRI_CTRL_PILOT_SYNC_LOSS_IRQ_EN 0x00000400
#define BV_DRI_CTRL_PILOT_SYNC_LOSS_IRQ_EN__DISABLED 0x0
#define BV_DRI_CTRL_PILOT_SYNC_LOSS_IRQ_EN__ENABLED  0x1
#define BM_DRI_CTRL_ATTENTION_IRQ_EN 0x00000200
#define BV_DRI_CTRL_ATTENTION_IRQ_EN__DISABLED 0x0
#define BV_DRI_CTRL_ATTENTION_IRQ_EN__ENABLED  0x1
#define BM_DRI_CTRL_OVERFLOW_IRQ 0x00000008
#define BV_DRI_CTRL_OVERFLOW_IRQ__NO_REQUEST 0x0
#define BV_DRI_CTRL_OVERFLOW_IRQ__REQUEST    0x1
#define BM_DRI_CTRL_PILOT_SYNC_LOSS_IRQ 0x00000004
#define BV_DRI_CTRL_PILOT_SYNC_LOSS_IRQ__NO_REQUEST 0x0
#define BV_DRI_CTRL_PILOT_SYNC_LOSS_IRQ__REQUEST    0x1
#define BM_DRI_CTRL_ATTENTION_IRQ 0x00000002
#define BV_DRI_CTRL_ATTENTION_IRQ__NO_REQUEST 0x0
#define BV_DRI_CTRL_ATTENTION_IRQ__REQUEST    0x1
#define BM_DRI_CTRL_RUN 0x00000001
#define BV_DRI_CTRL_RUN__HALT 0x0
#define BV_DRI_CTRL_RUN__RUN  0x1
HW_REGISTER_0(HW_DRI_TIMING, REGS_DRI_BASE, 0x00000010)
#define HW_DRI_TIMING_ADDR (REGS_DRI_BASE + 0x00000010)
#define BP_DRI_TIMING_PILOT_REP_RATE      16
#define BM_DRI_TIMING_PILOT_REP_RATE 0x000F0000
#define BF_DRI_TIMING_PILOT_REP_RATE(v)  \
	(((v) << 16) & BM_DRI_TIMING_PILOT_REP_RATE)
#define BP_DRI_TIMING_GAP_DETECTION_INTERVAL      0
#define BM_DRI_TIMING_GAP_DETECTION_INTERVAL 0x000000FF
#define BF_DRI_TIMING_GAP_DETECTION_INTERVAL(v)  \
	(((v) << 0) & BM_DRI_TIMING_GAP_DETECTION_INTERVAL)
HW_REGISTER_0(HW_DRI_STAT, REGS_DRI_BASE, 0x00000020)
#define HW_DRI_STAT_ADDR (REGS_DRI_BASE + 0x00000020)
#define BM_DRI_STAT_DRI_PRESENT 0x80000000
#define BV_DRI_STAT_DRI_PRESENT__UNAVAILABLE 0x0
#define BV_DRI_STAT_DRI_PRESENT__AVAILABLE   0x1
#define BP_DRI_STAT_PILOT_PHASE      16
#define BM_DRI_STAT_PILOT_PHASE 0x000F0000
#define BF_DRI_STAT_PILOT_PHASE(v)  \
	(((v) << 16) & BM_DRI_STAT_PILOT_PHASE)
#define BM_DRI_STAT_OVERFLOW_IRQ_SUMMARY 0x00000008
#define BV_DRI_STAT_OVERFLOW_IRQ_SUMMARY__NO_REQUEST 0x0
#define BV_DRI_STAT_OVERFLOW_IRQ_SUMMARY__REQUEST    0x1
#define BM_DRI_STAT_PILOT_SYNC_LOSS_IRQ_SUMMARY 0x00000004
#define BV_DRI_STAT_PILOT_SYNC_LOSS_IRQ_SUMMARY__NO_REQUEST 0x0
#define BV_DRI_STAT_PILOT_SYNC_LOSS_IRQ_SUMMARY__REQUEST    0x1
#define BM_DRI_STAT_ATTENTION_IRQ_SUMMARY 0x00000002
#define BV_DRI_STAT_ATTENTION_IRQ_SUMMARY__NO_REQUEST 0x0
#define BV_DRI_STAT_ATTENTION_IRQ_SUMMARY__REQUEST    0x1
HW_REGISTER_0(HW_DRI_DATA, REGS_DRI_BASE, 0x00000030)
#define HW_DRI_DATA_ADDR (REGS_DRI_BASE + 0x00000030)
#define BP_DRI_DATA_DATA      0
#define BM_DRI_DATA_DATA 0xFFFFFFFF
#define BF_DRI_DATA_DATA(v)   (v)
HW_REGISTER(HW_DRI_DEBUG0, REGS_DRI_BASE, 0x00000040)
#define HW_DRI_DEBUG0_ADDR (REGS_DRI_BASE + 0x00000040)
#define BM_DRI_DEBUG0_DMAREQ 0x80000000
#define BM_DRI_DEBUG0_DMACMDKICK 0x40000000
#define BM_DRI_DEBUG0_DRI_CLK_INPUT 0x20000000
#define BM_DRI_DEBUG0_DRI_DATA_INPUT 0x10000000
#define BM_DRI_DEBUG0_TEST_MODE 0x08000000
#define BM_DRI_DEBUG0_PILOT_REP_RATE 0x04000000
#define BV_DRI_DEBUG0_PILOT_REP_RATE__8_AT_4MHZ  0x0
#define BV_DRI_DEBUG0_PILOT_REP_RATE__12_AT_6MHZ 0x1
#define BP_DRI_DEBUG0_SPARE      18
#define BM_DRI_DEBUG0_SPARE 0x03FC0000
#define BF_DRI_DEBUG0_SPARE(v)  \
	(((v) << 18) & BM_DRI_DEBUG0_SPARE)
#define BP_DRI_DEBUG0_FRAME      0
#define BM_DRI_DEBUG0_FRAME 0x0003FFFF
#define BF_DRI_DEBUG0_FRAME(v)  \
	(((v) << 0) & BM_DRI_DEBUG0_FRAME)
HW_REGISTER(HW_DRI_DEBUG1, REGS_DRI_BASE, 0x00000050)
#define HW_DRI_DEBUG1_ADDR (REGS_DRI_BASE + 0x00000050)
#define BM_DRI_DEBUG1_INVERT_PILOT 0x80000000
#define BV_DRI_DEBUG1_INVERT_PILOT__NORMAL   0x0
#define BV_DRI_DEBUG1_INVERT_PILOT__INVERTED 0x1
#define BM_DRI_DEBUG1_INVERT_ATTENTION 0x40000000
#define BV_DRI_DEBUG1_INVERT_ATTENTION__NORMAL   0x0
#define BV_DRI_DEBUG1_INVERT_ATTENTION__INVERTED 0x1
#define BM_DRI_DEBUG1_INVERT_DRI_DATA 0x20000000
#define BV_DRI_DEBUG1_INVERT_DRI_DATA__NORMAL   0x0
#define BV_DRI_DEBUG1_INVERT_DRI_DATA__INVERTED 0x1
#define BM_DRI_DEBUG1_INVERT_DRI_CLOCK 0x10000000
#define BV_DRI_DEBUG1_INVERT_DRI_CLOCK__NORMAL   0x0
#define BV_DRI_DEBUG1_INVERT_DRI_CLOCK__INVERTED 0x1
#define BM_DRI_DEBUG1_REVERSE_FRAME 0x08000000
#define BV_DRI_DEBUG1_REVERSE_FRAME__NORMAL   0x0
#define BV_DRI_DEBUG1_REVERSE_FRAME__REVERSED 0x1
#define BP_DRI_DEBUG1_SWIZZLED_FRAME      0
#define BM_DRI_DEBUG1_SWIZZLED_FRAME 0x0003FFFF
#define BF_DRI_DEBUG1_SWIZZLED_FRAME(v)  \
	(((v) << 0) & BM_DRI_DEBUG1_SWIZZLED_FRAME)
HW_REGISTER_0(HW_DRI_VERSION, REGS_DRI_BASE, 0x00000060)
#define HW_DRI_VERSION_ADDR (REGS_DRI_BASE + 0x00000060)
#define BP_DRI_VERSION_MAJOR      24
#define BM_DRI_VERSION_MAJOR 0xFF000000
#define BF_DRI_VERSION_MAJOR(v) \
	(((v) << 24) & BM_DRI_VERSION_MAJOR)
#define BP_DRI_VERSION_MINOR      16
#define BM_DRI_VERSION_MINOR 0x00FF0000
#define BF_DRI_VERSION_MINOR(v)  \
	(((v) << 16) & BM_DRI_VERSION_MINOR)
#define BP_DRI_VERSION_STEP      0
#define BM_DRI_VERSION_STEP 0x0000FFFF
#define BF_DRI_VERSION_STEP(v)  \
	(((v) << 0) & BM_DRI_VERSION_STEP)
#endif /* __ARCH_ARM___DRI_H */
