/*
 * STMP ICOLL Register Definitions
 *
 * Copyright 2008-2009 Freescale Semiconductor
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef __ARCH_ARM___ICOLL_H
#define __ARCH_ARM___ICOLL_H  1

#include <mach/stmp3xxx_regs.h>

#define REGS_ICOLL_BASE (REGS_BASE + 0x0)
#define REGS_ICOLL_BASE_PHYS (0x80000000)
#define REGS_ICOLL_SIZE 0x00002000
HW_REGISTER(HW_ICOLL_VECTOR, REGS_ICOLL_BASE, 0x00000000)
#define HW_ICOLL_VECTOR_ADDR (REGS_ICOLL_BASE + 0x00000000)
#define BP_ICOLL_VECTOR_IRQVECTOR      2
#define BM_ICOLL_VECTOR_IRQVECTOR 0xFFFFFFFC
#define BF_ICOLL_VECTOR_IRQVECTOR(v) \
	(((v) << 2) & BM_ICOLL_VECTOR_IRQVECTOR)
HW_REGISTER_0(HW_ICOLL_LEVELACK, REGS_ICOLL_BASE, 0x00000010)
#define HW_ICOLL_LEVELACK_ADDR (REGS_ICOLL_BASE + 0x00000010)
#define BP_ICOLL_LEVELACK_IRQLEVELACK      0
#define BM_ICOLL_LEVELACK_IRQLEVELACK 0x0000000F
#define BF_ICOLL_LEVELACK_IRQLEVELACK(v)  \
	(((v) << 0) & BM_ICOLL_LEVELACK_IRQLEVELACK)
#define BV_ICOLL_LEVELACK_IRQLEVELACK__LEVEL0 0x1
#define BV_ICOLL_LEVELACK_IRQLEVELACK__LEVEL1 0x2
#define BV_ICOLL_LEVELACK_IRQLEVELACK__LEVEL2 0x4
#define BV_ICOLL_LEVELACK_IRQLEVELACK__LEVEL3 0x8
HW_REGISTER(HW_ICOLL_CTRL, REGS_ICOLL_BASE, 0x00000020)
#define HW_ICOLL_CTRL_ADDR (REGS_ICOLL_BASE + 0x00000020)
#define BM_ICOLL_CTRL_SFTRST 0x80000000
#define BV_ICOLL_CTRL_SFTRST__RUN      0x0
#define BV_ICOLL_CTRL_SFTRST__IN_RESET 0x1
#define BM_ICOLL_CTRL_CLKGATE 0x40000000
#define BV_ICOLL_CTRL_CLKGATE__RUN       0x0
#define BV_ICOLL_CTRL_CLKGATE__NO_CLOCKS 0x1
#define BP_ICOLL_CTRL_VECTOR_PITCH      21
#define BM_ICOLL_CTRL_VECTOR_PITCH 0x00E00000
#define BF_ICOLL_CTRL_VECTOR_PITCH(v)  \
	(((v) << 21) & BM_ICOLL_CTRL_VECTOR_PITCH)
#define BV_ICOLL_CTRL_VECTOR_PITCH__DEFAULT_BY4 0x0
#define BV_ICOLL_CTRL_VECTOR_PITCH__BY4	 0x1
#define BV_ICOLL_CTRL_VECTOR_PITCH__BY8	 0x2
#define BV_ICOLL_CTRL_VECTOR_PITCH__BY12	0x3
#define BV_ICOLL_CTRL_VECTOR_PITCH__BY16	0x4
#define BV_ICOLL_CTRL_VECTOR_PITCH__BY20	0x5
#define BV_ICOLL_CTRL_VECTOR_PITCH__BY24	0x6
#define BV_ICOLL_CTRL_VECTOR_PITCH__BY28	0x7
#define BM_ICOLL_CTRL_BYPASS_FSM 0x00100000
#define BV_ICOLL_CTRL_BYPASS_FSM__NORMAL 0x0
#define BV_ICOLL_CTRL_BYPASS_FSM__BYPASS 0x1
#define BM_ICOLL_CTRL_NO_NESTING 0x00080000
#define BV_ICOLL_CTRL_NO_NESTING__NORMAL  0x0
#define BV_ICOLL_CTRL_NO_NESTING__NO_NEST 0x1
#define BM_ICOLL_CTRL_ARM_RSE_MODE 0x00040000
#define BM_ICOLL_CTRL_FIQ_FINAL_ENABLE 0x00020000
#define BV_ICOLL_CTRL_FIQ_FINAL_ENABLE__DISABLE 0x0
#define BV_ICOLL_CTRL_FIQ_FINAL_ENABLE__ENABLE  0x1
#define BM_ICOLL_CTRL_IRQ_FINAL_ENABLE 0x00010000
#define BV_ICOLL_CTRL_IRQ_FINAL_ENABLE__DISABLE 0x0
#define BV_ICOLL_CTRL_IRQ_FINAL_ENABLE__ENABLE  0x1
HW_REGISTER(HW_ICOLL_VBASE, REGS_ICOLL_BASE, 0x00000040)
#define HW_ICOLL_VBASE_ADDR (REGS_ICOLL_BASE + 0x00000040)
#define BP_ICOLL_VBASE_TABLE_ADDRESS      2
#define BM_ICOLL_VBASE_TABLE_ADDRESS 0xFFFFFFFC
#define BF_ICOLL_VBASE_TABLE_ADDRESS(v) \
	(((v) << 2) & BM_ICOLL_VBASE_TABLE_ADDRESS)
HW_REGISTER_0(HW_ICOLL_STAT, REGS_ICOLL_BASE, 0x00000070)
#define HW_ICOLL_STAT_ADDR (REGS_ICOLL_BASE + 0x00000070)
#define BP_ICOLL_STAT_VECTOR_NUMBER      0
#define BM_ICOLL_STAT_VECTOR_NUMBER 0x0000007F
#define BF_ICOLL_STAT_VECTOR_NUMBER(v)  \
	(((v) << 0) & BM_ICOLL_STAT_VECTOR_NUMBER)
/*
 *  multi-register-define name HW_ICOLL_RAWn
 *	      base 0x000000A0
 *	      count 4
 *	      offset 0x10
 */
HW_REGISTER_0_INDEXED(HW_ICOLL_RAWn, REGS_ICOLL_BASE, 0x000000a0, 0x10)
#define BP_ICOLL_RAWn_RAW_IRQS      0
#define BM_ICOLL_RAWn_RAW_IRQS 0xFFFFFFFF
#define BF_ICOLL_RAWn_RAW_IRQS(v)   (v)
/*
 *  multi-register-define name HW_ICOLL_INTERRUPTn
 *	      base 0x00000120
 *	      count 128
 *	      offset 0x10
 */
HW_REGISTER_INDEXED(HW_ICOLL_INTERRUPTn, REGS_ICOLL_BASE, 0x00000120, 0x10)
#define BM_ICOLL_INTERRUPTn_ENFIQ 0x00000010
#define BV_ICOLL_INTERRUPTn_ENFIQ__DISABLE 0x0
#define BV_ICOLL_INTERRUPTn_ENFIQ__ENABLE  0x1
#define BM_ICOLL_INTERRUPTn_SOFTIRQ 0x00000008
#define BV_ICOLL_INTERRUPTn_SOFTIRQ__NO_INTERRUPT    0x0
#define BV_ICOLL_INTERRUPTn_SOFTIRQ__FORCE_INTERRUPT 0x1
#define BM_ICOLL_INTERRUPTn_ENABLE 0x00000004
#define BV_ICOLL_INTERRUPTn_ENABLE__DISABLE 0x0
#define BV_ICOLL_INTERRUPTn_ENABLE__ENABLE  0x1
#define BP_ICOLL_INTERRUPTn_PRIORITY      0
#define BM_ICOLL_INTERRUPTn_PRIORITY 0x00000003
#define BF_ICOLL_INTERRUPTn_PRIORITY(v)  \
	(((v) << 0) & BM_ICOLL_INTERRUPTn_PRIORITY)
#define BV_ICOLL_INTERRUPTn_PRIORITY__LEVEL0 0x0
#define BV_ICOLL_INTERRUPTn_PRIORITY__LEVEL1 0x1
#define BV_ICOLL_INTERRUPTn_PRIORITY__LEVEL2 0x2
#define BV_ICOLL_INTERRUPTn_PRIORITY__LEVEL3 0x3
HW_REGISTER(HW_ICOLL_DEBUG, REGS_ICOLL_BASE, 0x00001120)
#define HW_ICOLL_DEBUG_ADDR (REGS_ICOLL_BASE + 0x00001120)
#define BP_ICOLL_DEBUG_INSERVICE      28
#define BM_ICOLL_DEBUG_INSERVICE 0xF0000000
#define BF_ICOLL_DEBUG_INSERVICE(v) \
	(((v) << 28) & BM_ICOLL_DEBUG_INSERVICE)
#define BV_ICOLL_DEBUG_INSERVICE__LEVEL0 0x1
#define BV_ICOLL_DEBUG_INSERVICE__LEVEL1 0x2
#define BV_ICOLL_DEBUG_INSERVICE__LEVEL2 0x4
#define BV_ICOLL_DEBUG_INSERVICE__LEVEL3 0x8
#define BP_ICOLL_DEBUG_LEVEL_REQUESTS      24
#define BM_ICOLL_DEBUG_LEVEL_REQUESTS 0x0F000000
#define BF_ICOLL_DEBUG_LEVEL_REQUESTS(v)  \
	(((v) << 24) & BM_ICOLL_DEBUG_LEVEL_REQUESTS)
#define BV_ICOLL_DEBUG_LEVEL_REQUESTS__LEVEL0 0x1
#define BV_ICOLL_DEBUG_LEVEL_REQUESTS__LEVEL1 0x2
#define BV_ICOLL_DEBUG_LEVEL_REQUESTS__LEVEL2 0x4
#define BV_ICOLL_DEBUG_LEVEL_REQUESTS__LEVEL3 0x8
#define BP_ICOLL_DEBUG_REQUESTS_BY_LEVEL      20
#define BM_ICOLL_DEBUG_REQUESTS_BY_LEVEL 0x00F00000
#define BF_ICOLL_DEBUG_REQUESTS_BY_LEVEL(v)  \
	(((v) << 20) & BM_ICOLL_DEBUG_REQUESTS_BY_LEVEL)
#define BV_ICOLL_DEBUG_REQUESTS_BY_LEVEL__LEVEL0 0x1
#define BV_ICOLL_DEBUG_REQUESTS_BY_LEVEL__LEVEL1 0x2
#define BV_ICOLL_DEBUG_REQUESTS_BY_LEVEL__LEVEL2 0x4
#define BV_ICOLL_DEBUG_REQUESTS_BY_LEVEL__LEVEL3 0x8
#define BM_ICOLL_DEBUG_FIQ 0x00020000
#define BV_ICOLL_DEBUG_FIQ__NO_FIQ_REQUESTED 0x0
#define BV_ICOLL_DEBUG_FIQ__FIQ_REQUESTED    0x1
#define BM_ICOLL_DEBUG_IRQ 0x00010000
#define BV_ICOLL_DEBUG_IRQ__NO_IRQ_REQUESTED 0x0
#define BV_ICOLL_DEBUG_IRQ__IRQ_REQUESTED    0x1
#define BP_ICOLL_DEBUG_VECTOR_FSM      0
#define BM_ICOLL_DEBUG_VECTOR_FSM 0x000003FF
#define BF_ICOLL_DEBUG_VECTOR_FSM(v)  \
	(((v) << 0) & BM_ICOLL_DEBUG_VECTOR_FSM)
#define BV_ICOLL_DEBUG_VECTOR_FSM__FSM_IDLE	 0x000
#define BV_ICOLL_DEBUG_VECTOR_FSM__FSM_MULTICYCLE1  0x001
#define BV_ICOLL_DEBUG_VECTOR_FSM__FSM_MULTICYCLE2  0x002
#define BV_ICOLL_DEBUG_VECTOR_FSM__FSM_PENDING      0x004
#define BV_ICOLL_DEBUG_VECTOR_FSM__FSM_MULTICYCLE3  0x008
#define BV_ICOLL_DEBUG_VECTOR_FSM__FSM_MULTICYCLE4  0x010
#define BV_ICOLL_DEBUG_VECTOR_FSM__FSM_ISR_RUNNING1 0x020
#define BV_ICOLL_DEBUG_VECTOR_FSM__FSM_ISR_RUNNING2 0x040
#define BV_ICOLL_DEBUG_VECTOR_FSM__FSM_ISR_RUNNING3 0x080
#define BV_ICOLL_DEBUG_VECTOR_FSM__FSM_MULTICYCLE5  0x100
#define BV_ICOLL_DEBUG_VECTOR_FSM__FSM_MULTICYCLE6  0x200
HW_REGISTER(HW_ICOLL_DBGREAD0, REGS_ICOLL_BASE, 0x00001130)
#define HW_ICOLL_DBGREAD0_ADDR (REGS_ICOLL_BASE + 0x00001130)
#define BP_ICOLL_DBGREAD0_VALUE      0
#define BM_ICOLL_DBGREAD0_VALUE 0xFFFFFFFF
#define BF_ICOLL_DBGREAD0_VALUE(v)   (v)
HW_REGISTER(HW_ICOLL_DBGREAD1, REGS_ICOLL_BASE, 0x00001140)
#define HW_ICOLL_DBGREAD1_ADDR (REGS_ICOLL_BASE + 0x00001140)
#define BP_ICOLL_DBGREAD1_VALUE      0
#define BM_ICOLL_DBGREAD1_VALUE 0xFFFFFFFF
#define BF_ICOLL_DBGREAD1_VALUE(v)   (v)
HW_REGISTER(HW_ICOLL_DBGFLAG, REGS_ICOLL_BASE, 0x00001150)
#define HW_ICOLL_DBGFLAG_ADDR (REGS_ICOLL_BASE + 0x00001150)
#define BP_ICOLL_DBGFLAG_FLAG      0
#define BM_ICOLL_DBGFLAG_FLAG 0x0000FFFF
#define BF_ICOLL_DBGFLAG_FLAG(v)  \
	(((v) << 0) & BM_ICOLL_DBGFLAG_FLAG)
/*
 *  multi-register-define name HW_ICOLL_DBGREQUESTn
 *	      base 0x00001160
 *	      count 4
 *	      offset 0x10
 */
HW_REGISTER_0_INDEXED(HW_ICOLL_DBGREQUESTn, REGS_ICOLL_BASE, 0x00001160,
		       0x10)
#define BP_ICOLL_DBGREQUESTn_BITS      0
#define BM_ICOLL_DBGREQUESTn_BITS 0xFFFFFFFF
#define BF_ICOLL_DBGREQUESTn_BITS(v)   (v)
HW_REGISTER_0(HW_ICOLL_VERSION, REGS_ICOLL_BASE, 0x000011e0)
#define HW_ICOLL_VERSION_ADDR (REGS_ICOLL_BASE + 0x000011e0)
#define BP_ICOLL_VERSION_MAJOR      24
#define BM_ICOLL_VERSION_MAJOR 0xFF000000
#define BF_ICOLL_VERSION_MAJOR(v) \
	(((v) << 24) & BM_ICOLL_VERSION_MAJOR)
#define BP_ICOLL_VERSION_MINOR      16
#define BM_ICOLL_VERSION_MINOR 0x00FF0000
#define BF_ICOLL_VERSION_MINOR(v)  \
	(((v) << 16) & BM_ICOLL_VERSION_MINOR)
#define BP_ICOLL_VERSION_STEP      0
#define BM_ICOLL_VERSION_STEP 0x0000FFFF
#define BF_ICOLL_VERSION_STEP(v)  \
	(((v) << 0) & BM_ICOLL_VERSION_STEP)
#endif /* __ARCH_ARM___ICOLL_H */
