/*
 * Copyright 2007-2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */

/*---------------------------------------------------------------------------
 * Pegatron Modify History
 *---------------------------------------------------------------------------
 * 2009/10/22  Kevin Wei  - 1. modify / add GPIO setting
 *---------------------------------------------------------------------------
 * 2009/10/22  Huimin Lin - 1. modify / add GPIO setting
 *---------------------------------------------------------------------------
 * 2009/11/05  Eric Chou  - 1. modify / add GPIO setting
 *                          2. fine-tune
 *---------------------------------------------------------------------------
 * 2009/12/18  Huimin Lin - 1. add - to support HW USB power control design
 *---------------------------------------------------------------------------
 * 2010/02/08  Huimin Linto sync the DVFS control interface from Spider1 codebase 
 *---------------------------------------------------------------------------
 * 2010/04/21 : support GPIO_EVENT_CYCLE.
 *               gpio_event_register(), gpio_event_unregister() add.
 *               gpio_event_announce() add, change 20ms timer alway -> POLL_FINISH times.
 *---------------------------------------------------------------------------
 * 2010/05/01 : fixed IOMUX setting.
 *               EIM_D16-18/28-31, EIM_A17-A25, EIM_EB2-3, EIM_CS2-5
 *               EIM_CRE, EIM_DTACK, GPIO1_2, GPIO1_4, DI1_D0_CS, 
 *               DISP1_DAT6, DISP1_DAT7-23, DISP2_DAT7-9
 *               AUD3_BB_TXD, AUD3_BB_RXD, AUD3_BB_CK, AUD3_BB_FS, 
 *               NANDF_ALE, NANDF_RB2-3, NANDF_CS7, NANDF_RDY_INT,
 *               CSPI1_SS0, CSI2_HSYNC, CSI2_PIXCLK,
 *---------------------------------------------------------------------------
 * 2010/05/10 : add gpio_usb_power().
 *---------------------------------------------------------------------------
 */

#include <linux/errno.h>
#include <linux/module.h>
#include <linux/platform_device.h>
#include <linux/delay.h>
#include <mach/hardware.h>
#include <mach/gpio.h>
#include <linux/fsl_devices.h>

#include "iomux.h"

#define GPIO_EVENT_CYCLE   (20)		/* GPIO ON/OFF EVENT CHECK CYCLE(ms) */

/*!
 * @file mach-mx51/mx51_babbage_gpio.c
 *
 * @brief This file contains all the GPIO setup functions for the board.
 *
 * @ingroup GPIO
 */

//Modify by pega Huimin 2009.12.18 to support HW USB power control design
#define DEVICE_USB_HW_DESIGN	1

#define DEBUG_TRACE        0
#if ( DEBUG_TRACE )
#define DEBUG_PRINTK(x)    printk x
#else
#define DEBUG_PRINTK(x)
#endif

#define DEVICE_SYSTEM      1  // baggage - 26M_OSC_EN
#define DEVICE_I2C1        0  // baggage - I2C1
#define DEVICE_I2C2        1  // baggage - I2C2
#define DEVICE_SPI1        1  // spider1 - SPI1
#define DEVICE_UART1       1  // baggage - UART1
#define DEVICE_SD1         1  // baggage - SD1
#define DEVICE_WIFI        1  // baggage - SD2 ( ? spider1 SD2 pin all set PAD_CTL_DRV_VOT_LOW )
#define DEVICE_BLUETOOTH   1  // spider1 - UART3 ( baggage ) , babbage - AUD6 use AUD3 setting
#define DEVICE_LCD         1  // spider1 - LCD
#define DEVICE_AUDIO       1  // baggage - AUD3 , babbage - AMP ( spider1 ) , spider1 - headphone
#define DEVICE_SPI_NOR     1  // baggage - SPI Nor-Flash
#define DEVICE_JOYSTICK    1  // spider1 - Optical Joystick
#define DEVICE_VIBRATOR    1  //
#define DEVICE_HOLD        1  //
#define DEVICE_PMIC        1  // baggage - PMIC
#define DEVICE_USB         1  // baggage - USB
#define DEVICE_PATA        1  // 3stack  - PATA
#define DEVICE_MINIPCI     1  // spider2 - miniPCI

#define ATA_PAD_CONFIG     ( PAD_CTL_DRV_HIGH | PAD_CTL_DRV_VOT_HIGH )
#define FORCE_PAD_ALL0     ( PAD_CTL_HYS_NONE | PAD_CTL_PKE_NONE  | PAD_CTL_SRE_FAST )


// mxc_request_iomux(<pin>, <mux_mode>);
// mxc_iomux_set_input(<in_select>, <in_mode>);
// mxc_iomux_set_pad(<pin>, <pad_cfg>);

static struct mxc_iomux_pin_cfg __initdata mxc_iomux_pins[] =
{
   //----------------------------------------
   // PAD_CTL_SRE ( SLOW / FAST )               - slew rate control
   // PAD_CTL_DRV ( LOW / MEDIUM / HIGH / MAX ) - drive strength control
   // PAD_CTL_ODE_OPENDRAIN ( NONE / ENABLE )   - open drain control
   // PAD_CTL_100K_PD / PAD_CTL_47K_PU / PAD_CTL_100K_PU / PAD_CTL_22K_PU
   // PAD_CTL_PUE ( KEEPER / PULL )             - pull or keeper select
   // PAD_CTL_PKE ( NONE / ENABLE  )            - enable pull or keeper
   // PAD_CTL_HYS ( NONE / ENABLE  )            - hysteresis control
   // PAD_CTL_DDR_INPUT ( CMOS / DDR )          - ddr input control
   // PAD_CTL_DRV_VOT ( LOW / HIGH )            -
   //----------------------------------------
   // System
   //----------------------------------------
   #if ( DEVICE_SYSTEM )
   {  // EIM_A27 = GPIO (in) <-- SYS_ON_OFF_REQ = power key , wakeup the CPU when suspend / suspend the system when power on
      // $ the same
      .pin        = MX51_PIN_EIM_A27,
//    .mux_mode   = IOMUX_CONFIG_ALT1,
      .mux_mode   = IOMUX_CONFIG_GPIO,
      .pad_cfg    = ( PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_NONE ),
   },
   {  // DI1_PIN12 = GPIO (out) --> 26M_OSC_EN ( normal high ) = enable 26MHz clock for USB / Audio
      // $ the same
      .pin        = MX51_PIN_DI1_PIN12,
//    .mux_mode   = IOMUX_CONFIG_ALT4,
      .mux_mode   = IOMUX_CONFIG_GPIO,
      .pad_cfg    = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_PKE_ENABLE ),
      .in_select  = MUX_IN_GPIO3_IPP_IND_G_IN_1_SELECT_INPUT,
      .in_mode    = INPUT_CTL_PATH1,
   },
   {  // GPIO1_6 = GPIO (out) --> VCC_BP_3V3EN ( normal high ) = enable VDD_3V3 - EVT2
      // $$ SD2 - SD_MMC_CD_B
      .pin        = MX51_PIN_GPIO1_6,
//    .mux_mode   = IOMUX_CONFIG_ALT0,
      .mux_mode   = IOMUX_CONFIG_GPIO,
      .pad_cfg    = ( PAD_CTL_100K_PU ),
   },
   {  // GPIO1_7 = GPIO (out) --> VCC_BP_5V2EN ( normal high ) = enable VDD_5V2 - EVT2
      // $$ USB - RST_USB_HUB_B
      .pin        = MX51_PIN_GPIO1_7,
//    .mux_mode   = IOMUX_CONFIG_ALT0,
      .mux_mode   = IOMUX_CONFIG_GPIO,
      .pad_cfg    = ( PAD_CTL_100K_PU ),
   },
   #endif

   //----------------------------------------
   // I2C
   //----------------------------------------
   #if ( DEVICE_I2C1 )
   {  // EIM_D16 = I2C1_SDA
      // $ the same
      .pin        = MX51_PIN_EIM_D16,
      .mux_mode   = IOMUX_CONFIG_ALT4  | IOMUX_CONFIG_SION,
      .pad_cfg    = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_HYS_ENABLE |
                      PAD_CTL_100K_PU  | PAD_CTL_ODE_OPENDRAIN_ENABLE ),
      .in_select  = MUX_IN_I2C1_IPP_SDA_IN_SELECT_INPUT,
      .in_mode    = INPUT_CTL_PATH0,
   },
   {  // EIM_D19 = I2C1_SCL
      // $ the same , pega remove to USB_CLK_ENn = enable USB 26MHz clock
      .pin        = MX51_PIN_EIM_D19,
      .mux_mode   = IOMUX_CONFIG_ALT4  | IOMUX_CONFIG_SION,
      .pad_cfg    = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_HYS_ENABLE |
                      PAD_CTL_100K_PU  | PAD_CTL_ODE_OPENDRAIN_ENABLE ),
      .in_select  = MUX_IN_I2C1_IPP_SCL_IN_SELECT_INPUT,
      .in_mode    = INPUT_CTL_PATH0,
   },
   #endif

   #if ( DEVICE_I2C2 )
   {  // KEY_COL5 = I2C2_SDA
      // $ the same
      .pin        = MX51_PIN_KEY_COL5,
      .mux_mode   = IOMUX_CONFIG_ALT3  | IOMUX_CONFIG_SION,
      .pad_cfg    = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_HYS_ENABLE |
                      PAD_CTL_100K_PU  | PAD_CTL_ODE_OPENDRAIN_ENABLE ),
      .in_select  = MUX_IN_I2C2_IPP_SDA_IN_SELECT_INPUT,
      .in_mode    = INPUT_CTL_PATH1,
   },
   {  // KEY_COL4 = I2C2_SCL
      // $ the same
      .pin        = MX51_PIN_KEY_COL4,
      .mux_mode   = IOMUX_CONFIG_ALT3  | IOMUX_CONFIG_SION,
      .pad_cfg    = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_HYS_ENABLE |
                      PAD_CTL_100K_PU  | PAD_CTL_ODE_OPENDRAIN_ENABLE ),
      .in_select  = MUX_IN_I2C2_IPP_SCL_IN_SELECT_INPUT,
      .in_mode    = INPUT_CTL_PATH1,
   },
   #endif

   //----------------------------------------
   // SPI
   //----------------------------------------
   #if ( DEVICE_SPI1 )
   {  // CSPI1_MOSI = CSPI1_MOSI -- SPI1_MOSI
      // $ no
      .pin          = MX51_PIN_CSPI1_MOSI,
      .mux_mode     = IOMUX_CONFIG_ALT0,
      .pad_cfg      = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_ENABLE |
                        PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_100K_PU ),
   },
   {  // CSPI1_MISO = CSPI1_MISO -- SPI1_MISO
      // $ no
      .pin          = MX51_PIN_CSPI1_MISO,
      .mux_mode     = IOMUX_CONFIG_ALT0,
      .pad_cfg      = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_ENABLE |
                        PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_100K_PD ),
   },
   {  // CSPI1_SCLK = CSPI1_SCLK -- SPI1_SCLK
      // $ no
      .pin          = MX51_PIN_CSPI1_SCLK,
      .mux_mode     = IOMUX_CONFIG_ALT0,
      .pad_cfg      = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_ENABLE |
                        PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_100K_PD ),
   },
   #endif

   //----------------------------------------
   // UARRT1
   //----------------------------------------
   #if ( DEVICE_UART1 )
   {  // UART1_RXD = UART1_RXD <-- UART1_RX
      // $ the same
      .pin         = MX51_PIN_UART1_RXD,
      .mux_mode    = IOMUX_CONFIG_ALT0,
      .pad_cfg     = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH | PAD_CTL_HYS_ENABLE |
                       PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL ),
      .in_select   = MUX_IN_UART1_IPP_UART_RXD_MUX_SELECT_INPUT,
      .in_mode     = INPUT_CTL_PATH0,
   },
   {  // UART1_TXD = UART1_TXD --> UART1_TX
      // $ the same
      .pin         = MX51_PIN_UART1_TXD,
      .mux_mode    = IOMUX_CONFIG_ALT0,
      .pad_cfg     = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH | PAD_CTL_HYS_ENABLE |
                       PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL ),
   },
   {  // UART1_RTS = UART1_RTS <-- UART1_RTS
      // $ the same
      .pin         = MX51_PIN_UART1_RTS,
      .mux_mode    = IOMUX_CONFIG_ALT0,
      .pad_cfg     = ( PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_ENABLE |
                       PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL ),
      .in_select   = MUX_IN_UART1_IPP_UART_RTS_B_SELECT_INPUT,
      .in_mode     = INPUT_CTL_PATH0,
   },
   {  // UART1_CTS = UART1_CTS --> UART1_CTS
      // $ the same
      .pin         = MX51_PIN_UART1_CTS,
      .mux_mode    = IOMUX_CONFIG_ALT0,
      .pad_cfg     = ( PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_ENABLE |
                       PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL ),
   },
   #endif

   //----------------------------------------
   // SD1
   //----------------------------------------
   #if ( DEVICE_SD1 )
   {  // GPIO1_0 = GPIO (in) <-- SD_CDn ( normal high ) = detect SD insert
      // $ the same
      // ? ALT0 = SD_CD
      .pin       = MX51_PIN_GPIO1_0,
      .mux_mode  = IOMUX_CONFIG_GPIO | IOMUX_CONFIG_SION,
      .pad_cfg   = ( PAD_CTL_HYS_ENABLE | PAD_CTL_100K_PU ),
   },
   {  // SD1_CMD = SD1_CMD -- SD_SDIO1_CMD
      // $ the same
      .pin       = MX51_PIN_SD1_CMD,
      .mux_mode  = IOMUX_CONFIG_ALT0 | IOMUX_CONFIG_SION,
        .pad_cfg   = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   |
                       PAD_CTL_PKE_NONE ),

   },
   {  // SD1_CLK = SD1_CLK -- SD_SDIO1_CLK
      // $ the same
      .pin       = MX51_PIN_SD1_CLK,
      .mux_mode  = IOMUX_CONFIG_ALT0 | IOMUX_CONFIG_SION,
      .pad_cfg   = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   |
                     PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_47K_PU ),
   },
   {  // SD1_DATA0 = SD1_DATA0 -- SD_SDIO1_DAT0
      // $ the same
      .pin         = MX51_PIN_SD1_DATA0,
      .mux_mode    = IOMUX_CONFIG_ALT0,
      .pad_cfg     = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   |
                       PAD_CTL_PKE_NONE ),
   },
   {  // SD1_DATA1 = SD1_DATA1 -- SD_SDIO1_DAT1
      // $ the same
      .pin         = MX51_PIN_SD1_DATA1,
      .mux_mode    = IOMUX_CONFIG_ALT0,
      .pad_cfg     = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   |
                       PAD_CTL_PKE_NONE ),
   },
   {  // SD1_DATA2 = SD1_DATA2 -- SD_SDIO1_DAT2
      // $ the same
      .pin         = MX51_PIN_SD1_DATA2,
      .mux_mode    = IOMUX_CONFIG_ALT0,
      .pad_cfg     = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   |
                       PAD_CTL_PKE_NONE ),
   },
   {  // SD1_DATA3 = SD1_DATA3 -- SD_SDIO1_DAT3
      // $ the same
      .pin         = MX51_PIN_SD1_DATA3,
      .mux_mode    = IOMUX_CONFIG_ALT0,
      .pad_cfg     = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   |
                       PAD_CTL_PKE_NONE ),
   },
   #endif

   //----------------------------------------
   // WiFi
   //----------------------------------------
   // ? spider1 SD2 pin all set PAD_CTL_DRV_VOT_LOW
   //----------------------------------------
   #if ( DEVICE_WIFI )
   {  // EIM_D23 = GPIO (out) --> WL_RSTn ( normal high )
      // $$ camera - reset - gpio out
      .pin       = MX51_PIN_EIM_D23,
//    .mux_mode  = IOMUX_CONFIG_ALT1,
      .mux_mode  = IOMUX_CONFIG_GPIO,
      .pad_cfg   = ( PAD_CTL_100K_PU ),
   },
   {  // EIM_A26 = GPIO (in) <-- WL_WAKEUP ( normal ?? - PD 1.33K )
      // $ no
      // ?? driver not support this function
      .pin       = MX51_PIN_EIM_A26,
//    .mux_mode  = IOMUX_CONFIG_ALT1,
      .mux_mode  = IOMUX_CONFIG_GPIO,
      .pad_cfg   = ( PAD_CTL_100K_PU ),
   },
   {  // SD2_CMD = SD2_CMD -- WL_SD_CMD ,
      // $ the same
      .pin       = MX51_PIN_SD2_CMD,
      .mux_mode  = IOMUX_CONFIG_ALT0 | IOMUX_CONFIG_SION,
      .pad_cfg   = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_MAX | PAD_CTL_22K_PU ),
   },
   {  // SD2_CLK = SD2_CLK -- WL_SD_CLK
      // $ the same
      .pin       = MX51_PIN_SD2_CLK,
      .mux_mode  = IOMUX_CONFIG_ALT0 | IOMUX_CONFIG_SION,
      .pad_cfg   = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_MAX | PAD_CTL_22K_PU ),
   },
   {  // SD2_DATA0 = SD2_DATA0 -- WL_SD_DAT[0]
      // $ the same
      .pin         = MX51_PIN_SD2_DATA0,
      .mux_mode    = IOMUX_CONFIG_ALT0,
      .pad_cfg     = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_MAX | PAD_CTL_22K_PU ),
   },
   {  // SD2_DATA1 = SD2_DATA1 -- WL_SD_DAT[1]
      // $ the same
      .pin         = MX51_PIN_SD2_DATA1,
      .mux_mode    = IOMUX_CONFIG_ALT0,
      .pad_cfg     = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_MAX | PAD_CTL_22K_PU ),
   },
   {  // SD2_DATA2 = SD2_DATA2 -- WL_SD_DAT[2]
      // $ the same
      .pin         = MX51_PIN_SD2_DATA2,
      .mux_mode    = IOMUX_CONFIG_ALT0,
      .pad_cfg     = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_MAX | PAD_CTL_22K_PU ),
   },
   {  // SD2_DATA3 = SD2_DATA3 -- WL_SD_DAT[3]
      // $ the same
      .pin         = MX51_PIN_SD2_DATA3,
      .mux_mode    = IOMUX_CONFIG_ALT0,
      .pad_cfg     = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_MAX | PAD_CTL_22K_PU ),
   },
   #endif

   //----------------------------------------
   // Bluetooth
   //----------------------------------------
   #if ( DEVICE_BLUETOOTH )
   {  // GPIO1_5 = GPIO (out) --> BT_EN ( normal high ) = enable Bluetooth power
      // $$ SD2 - SD_MMC_WP = SD2 write protection - GPIO in
      .pin       = MX51_PIN_GPIO1_5,
//    .mux_mode  = IOMUX_CONFIG_ALT0,
      .mux_mode  = IOMUX_CONFIG_GPIO,
      .pad_cfg   = ( PAD_CTL_100K_PU ),
   },
   {  // EIM_A16 = GPIO (out) --> BT_RSTn ( normal high )
      // $$ CARD_RST_OUT - gpio
      .pin       = MX51_PIN_EIM_A16,
//    .mux_mode  = IOMUX_CONFIG_ALT1,
      .mux_mode  = IOMUX_CONFIG_GPIO,
      .pad_cfg   = ( PAD_CTL_100K_PU ),
   },
   {  // EIM_D22 = GPIO (in) <-- BT_WAKE ( normal ?? )
      // $ no
      .pin       = MX51_PIN_EIM_D22,
//    .mux_mode  = IOMUX_CONFIG_ALT1,
      .mux_mode  = IOMUX_CONFIG_GPIO,
      .pad_cfg   = ( PAD_CTL_100K_PU ),
   },
   {  // EIM_D24 = UART3 CTS (out) --> BT_UART3_RTS
      // $ no
      .pin       = MX51_PIN_EIM_D24,
      .mux_mode  = IOMUX_CONFIG_ALT3,
      .pad_cfg   = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_NONE |
                     PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_100K_PU  |
                     PAD_CTL_ODE_OPENDRAIN_NONE ),
//    .pad_cfg   = ( PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_ENABLE |
//                   PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL ), // babbage UART1
   },
   {  // EIM_D25 = UART3 RXD (in) <-- BT_UART3_TX
      // $ no
      .pin       = MX51_PIN_EIM_D25,
      .mux_mode  = IOMUX_CONFIG_ALT3,
      .pad_cfg   = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_NONE |
                     PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_100K_PU  |
                     PAD_CTL_ODE_OPENDRAIN_NONE ),
//    .pad_cfg   = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH | PAD_CTL_HYS_ENABLE |
//                   PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL ), // babbage UART1
      .in_select = MUX_IN_UART3_IPP_UART_RXD_MUX_SELECT_INPUT,
      .in_mode   = INPUT_CTL_PATH0,
   },
   {  // EIM_D26 = UART3 TXD (out) --> BT_UART3_RX
      // $ no
      .pin       = MX51_PIN_EIM_D26,
      .mux_mode  = IOMUX_CONFIG_ALT3,
      .pad_cfg   = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_NONE |
                     PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_100K_PU  |
                     PAD_CTL_ODE_OPENDRAIN_NONE ),
//    .pad_cfg   = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH | PAD_CTL_HYS_ENABLE |
//                   PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL ), // babbage UART1
   },
   {  // EIM_D27 = UART3 RTS (in) <-- BT_UART3_CTS
      // $ no
      .pin       = MX51_PIN_EIM_D27,
      .mux_mode  = IOMUX_CONFIG_ALT3,
      .pad_cfg   = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_NONE |
                     PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_100K_PU  |
                     PAD_CTL_ODE_OPENDRAIN_NONE ),
//    .pad_cfg   = ( PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_ENABLE |
//                   PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL ), // babbage UART1
      .in_select = MUX_IN_UART3_IPP_UART_RTS_B_SELECT_INPUT,
      .in_mode   = INPUT_CTL_PATH3,
//    .in_mode   = INPUT_CTL_PATH0,
   },
   {  // EIM_D28 = AUD6_TXD (out) --> BT_PCM_IN - I2S_IN
      // $ no
      .pin       = MX51_PIN_EIM_D28,
      .mux_mode  = IOMUX_CONFIG_ALT5,
      .pad_cfg   = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_ODE_OPENDRAIN_NONE |
                     PAD_CTL_100K_PU  | PAD_CTL_HYS_NONE ),
   },
   {  // EIM_D29 = AUD6_RXD (in) <-- BT_PCM_OUT - I2S_OUT
      // $ no
      .pin       = MX51_PIN_EIM_D29,
      .mux_mode  = IOMUX_CONFIG_ALT5,
      .pad_cfg   = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_ODE_OPENDRAIN_NONE |
                     PAD_CTL_100K_PU  | PAD_CTL_HYS_NONE ),
   },
   {  // EIM_D30 = AUD6_TXC -- BT_PCM_CLK - I2S_SCK
      // $ no
      .pin       = MX51_PIN_EIM_D30,
      .mux_mode  = IOMUX_CONFIG_ALT5,
      .pad_cfg   = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_ODE_OPENDRAIN_NONE |
                     PAD_CTL_100K_PU  | PAD_CTL_HYS_NONE ),
   },
   {  // EIM_D31 = AUD6_TXFS -- BT_PCM_SYNC - I2S_WS
      // $ no
      .pin       = MX51_PIN_EIM_D31,
      .mux_mode  = IOMUX_CONFIG_ALT5,
      .pad_cfg   = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_ODE_OPENDRAIN_NONE |
                     PAD_CTL_100K_PU  | PAD_CTL_HYS_NONE ),
   },
   #endif

   //----------------------------------------
   // Sharp - LCD / Backlight
   //----------------------------------------
   // DI1_DISP_CLK = only one function , not need setting , -- DISP_CLK
   // DI1_PIN15    = only one function , not need setting , -- DISP_DRDY
   //----------------------------------------
   #if ( DEVICE_LCD )
   {  // DISP2_DAT6 = GPIO (out) --> LCDBL_ON ( normal high ) = enable LCD Backlight 5.2V
      // $$ the same babbage / spider1 CSI2_D13 = LCD_5V_ON
      .pin          = MX51_PIN_DISP2_DAT6,
//    .mux_mode     = IOMUX_CONFIG_ALT5,
      .mux_mode     = IOMUX_CONFIG_GPIO,
      .pad_cfg      = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_HYS_NONE   | PAD_CTL_PKE_ENABLE  ), // spider1
//    .pad_cfg      = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER ),  // babbage ( with defasult = spider1 )
   },
   {  // CSI2_D19 = GPIO (out) --> BL_EN ( normal high ) = enable LCD Backlight
      // $$ camera - low power - gpio out
      // $$ the same babbage / spider1 CSI2_D13 = LCD_5V_ON
      .pin        = MX51_PIN_CSI2_D19,
//    .mux_mode   = IOMUX_CONFIG_ALT3,
      .mux_mode   = IOMUX_CONFIG_GPIO,
      .pad_cfg      = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_HYS_NONE   | PAD_CTL_PKE_ENABLE  ), // spider1
//    .pad_cfg      = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER ),  // babbage ( with defasult = spider1 )
   },
   {  // GPIO1_2 = PWM (out) --> LCD_PWM ( PU 10K ) = Backlight PWM to control brightness
      // $ the smae , LCD use the PWM
      .pin       = MX51_PIN_GPIO1_2,
      .mux_mode  = IOMUX_CONFIG_ALT1,
      .pad_cfg   = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH |
                     PAD_CTL_HYS_NONE | PAD_CTL_PKE_NONE ),
   },
   {  // GPIO1_3 = GPIO (out) --> LCDVDD_3V3_ON ( normal high ) = enable LCD 3.3V
      // $$ CLKO2  - ALT2
      // $$ but the same babbage / spider1 CSI2_D12 = LCD_3V3_ON
      .pin       = MX51_PIN_GPIO1_3,
//    .mux_mode  = IOMUX_CONFIG_ALT0,
      .mux_mode  = IOMUX_CONFIG_GPIO,
      .pad_cfg   = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_HYS_NONE   | PAD_CTL_PKE_ENABLE ), // spider1
//    .pad_cfg   = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER ), // babbage ( with defasult = spider1 )
   },
   {  // DI1_D0_CS = GPIO (out) --> LVDS_PWR_DWNn ( normal high ) = power down LVDS THC63LVDM63A-G
      // $ the same ,
      .pin         = MX51_PIN_DI1_D0_CS,
//    .mux_mode    = IOMUX_CONFIG_ALT4,
      .mux_mode    = IOMUX_CONFIG_GPIO,
      .pad_cfg     = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER ),
      .in_select   = MUX_IN_GPIO3_IPP_IND_G_IN_3_SELECT_INPUT,
      .in_mode     = INPUT_CTL_PATH1,
   },
   {  // DI1_PIN2 = DI1_PIN2 -- DISP_HSYNC
      // $ no
      .pin        = MX51_PIN_DI1_PIN2,
      .mux_mode   = IOMUX_CONFIG_ALT0,
   },
   {  // DI1_PIN3 = DI1_PIN3 -- DISP_VSYNC
      // $ no
      .pin        = MX51_PIN_DI1_PIN3,
      .mux_mode   = IOMUX_CONFIG_ALT0,
   },
   {  // DISP1_DAT0 = DISP1_DAT0 -- DISP_DAT0
      // $ no
      .pin          = MX51_PIN_DISP1_DAT0,
      .mux_mode     = IOMUX_CONFIG_ALT0,
   },
   {  // DISP1_DAT1 = DISP1_DAT1 -- DISP_DAT1
      // $ no
      .pin          = MX51_PIN_DISP1_DAT1,
      .mux_mode     = IOMUX_CONFIG_ALT0,
   },
   {  // DISP1_DAT2 = DISP1_DAT2 -- DISP_DAT2
      // $ no
      .pin          = MX51_PIN_DISP1_DAT2,
      .mux_mode     = IOMUX_CONFIG_ALT0,
   },
   {  // DISP1_DAT3 = DISP1_DAT3 -- DISP_DAT3
      // $ no
      .pin          = MX51_PIN_DISP1_DAT3,
      .mux_mode     = IOMUX_CONFIG_ALT0,
   },
   {  // DISP1_DAT4 = DISP1_DAT4 -- DISP_DAT4
      // $ no
      .pin          = MX51_PIN_DISP1_DAT4,
      .mux_mode     = IOMUX_CONFIG_ALT0,
   },
   {  // DISP1_DAT5 = DISP1_DAT5 -- DISP_DAT5
      // $ no
      .pin          = MX51_PIN_DISP1_DAT5,
      .mux_mode     = IOMUX_CONFIG_ALT0,
   },
   {  // DISP1_DAT6 = DISP1_DAT6 -- DISP_DAT6
      // $ no
      .pin          = MX51_PIN_DISP1_DAT6,
      .mux_mode     = IOMUX_CONFIG_ALT0,
      .pad_cfg      = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH |
                        PAD_CTL_PKE_NONE | PAD_CTL_HYS_NONE ),
   },
   {  // DISP1_DAT7 = DISP1_DAT7 -- DISP_DAT7
      // $ no
      .pin          = MX51_PIN_DISP1_DAT7,
      .mux_mode     = IOMUX_CONFIG_ALT0,
      .pad_cfg      = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH |
                        PAD_CTL_PKE_NONE | PAD_CTL_HYS_NONE ),
   },
   {  // DISP1_DAT8 = DISP1_DAT8 -- DISP_DAT8
      // $ no
      .pin          = MX51_PIN_DISP1_DAT8,
      .mux_mode     = IOMUX_CONFIG_ALT0,
      .pad_cfg      = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH |
                        PAD_CTL_PKE_NONE | PAD_CTL_HYS_NONE ),
   },
   {  // DISP1_DAT9 = DISP1_DAT9 -- DISP_DAT9
      // $ no
      .pin          = MX51_PIN_DISP1_DAT9,
      .mux_mode     = IOMUX_CONFIG_ALT0,
      .pad_cfg      = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH |
                        PAD_CTL_PKE_NONE | PAD_CTL_HYS_NONE ),
   },
   {  // DISP1_DAT10 = DISP1_DAT10 -- DISP_DAT10
      // $ no
      .pin           = MX51_PIN_DISP1_DAT10,
      .mux_mode      = IOMUX_CONFIG_ALT0,
      .pad_cfg      = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH |
                        PAD_CTL_PKE_NONE | PAD_CTL_HYS_NONE ),
   },
   {  // DISP1_DAT11 = DISP1_DAT11 -- DISP_DAT11
      // $ no
      .pin           = MX51_PIN_DISP1_DAT11,
      .mux_mode      = IOMUX_CONFIG_ALT0,
      .pad_cfg      = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH |
                        PAD_CTL_PKE_NONE | PAD_CTL_HYS_NONE ),
   },
   {  // DISP1_DAT12 = DISP1_DAT12 -- DISP_DAT12
      // $ no
      .pin           = MX51_PIN_DISP1_DAT12,
      .mux_mode      = IOMUX_CONFIG_ALT0,
      .pad_cfg      = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH |
                        PAD_CTL_PKE_NONE | PAD_CTL_HYS_NONE ),
   },
   {  // DISP1_DAT13 = DISP1_DAT13 -- DISP_DAT13
      // $ no
      .pin           = MX51_PIN_DISP1_DAT13,
      .mux_mode      = IOMUX_CONFIG_ALT0,
      .pad_cfg      = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH |
                        PAD_CTL_PKE_NONE | PAD_CTL_HYS_NONE ),
   },
   {  // DISP1_DAT14 = DISP1_DAT14 -- DISP_DAT14
      // $ no
      .pin           = MX51_PIN_DISP1_DAT14,
      .mux_mode      = IOMUX_CONFIG_ALT0,
      .pad_cfg      = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH |
                        PAD_CTL_PKE_NONE | PAD_CTL_HYS_NONE ),
   },
   {  // DISP1_DAT15 = DISP1_DAT15 -- DISP_DAT15
      // $ no
      .pin           = MX51_PIN_DISP1_DAT15,
      .mux_mode      = IOMUX_CONFIG_ALT0,
      .pad_cfg      = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH |
                        PAD_CTL_PKE_NONE | PAD_CTL_HYS_NONE ),
   },
   {  // DISP1_DAT16 = DISP1_DAT16 -- DISP_DAT16
      // $ no
      .pin           = MX51_PIN_DISP1_DAT16,
      .mux_mode      = IOMUX_CONFIG_ALT0,
      .pad_cfg      = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH |
                        PAD_CTL_PKE_NONE | PAD_CTL_HYS_NONE ),
   },
   {  // DISP1_DAT17 = DISP1_DAT17 -- DISP_DAT17
      // $ no
      .pin           = MX51_PIN_DISP1_DAT17,
      .mux_mode      = IOMUX_CONFIG_ALT0,
      .pad_cfg      = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH |
                        PAD_CTL_PKE_NONE | PAD_CTL_HYS_NONE ),
   },
   {  // DISP1_DAT18 = DISP1_DAT18 -- DISP_DAT18
      // $ no
      .pin           = MX51_PIN_DISP1_DAT18,
      .mux_mode      = IOMUX_CONFIG_ALT0,
      .pad_cfg      = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH |
                        PAD_CTL_PKE_NONE | PAD_CTL_HYS_NONE ),
   },
   {  // DISP1_DAT19 = DISP1_DAT19 -- DISP_DAT19
      // $ no
      .pin           = MX51_PIN_DISP1_DAT19,
      .mux_mode      = IOMUX_CONFIG_ALT0,
      .pad_cfg      = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH |
                        PAD_CTL_PKE_NONE | PAD_CTL_HYS_NONE ),
   },
   {  // DISP1_DAT20 = DISP1_DAT20 -- DISP_DAT20
      // $ no
      .pin           = MX51_PIN_DISP1_DAT20,
      .mux_mode      = IOMUX_CONFIG_ALT0,
      .pad_cfg      = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH |
                        PAD_CTL_PKE_NONE | PAD_CTL_HYS_NONE ),
   },
   {  // DISP1_DAT21 = DISP1_DAT21 -- DISP_DAT21
      // $ no
      .pin           = MX51_PIN_DISP1_DAT21,
      .mux_mode      = IOMUX_CONFIG_ALT0,
      .pad_cfg      = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH |
                        PAD_CTL_PKE_NONE | PAD_CTL_HYS_NONE ),
   },
   {  // DISP1_DAT22 = DISP1_DAT22 -- DISP_DAT22
      // $ no
      .pin           = MX51_PIN_DISP1_DAT22,
      .mux_mode      = IOMUX_CONFIG_ALT0,
      .pad_cfg      = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH |
                        PAD_CTL_PKE_NONE | PAD_CTL_HYS_NONE ),
   },
   {  // DISP1_DAT23 = DISP1_DAT23 -- DISP_DAT23
      // $ no
      .pin           = MX51_PIN_DISP1_DAT23,
      .mux_mode      = IOMUX_CONFIG_ALT0,
      .pad_cfg      = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH |
                        PAD_CTL_PKE_NONE | PAD_CTL_HYS_NONE ),
   },
   #endif

   //----------------------------------------
   // Audio
   //----------------------------------------
   #if ( DEVICE_AUDIO )
   {  // EIM_A23 = GPIO (out) --> AUDAMP_STBYn ( normal low - PU 10K ?? ) = control AMP power down
      // $ the same , but add PAD_CTL_100K_PD
      .pin       = MX51_PIN_EIM_A23,
//    .mux_mode  = IOMUX_CONFIG_ALT1,
      .mux_mode  = IOMUX_CONFIG_GPIO,
      .pad_cfg   = FORCE_PAD_ALL0,
   },
   {  // EIM_D17 = GPIO (in) <-- HPHONE_DETn ( normal high - PU 68K ) = detect headphone insert
      // $$ USB - USB_CLK_EN_B - GPIO out
      // $$ but the same babbage / spider1 NANDF_D14 = hphone_det_b
      .pin       = MX51_PIN_EIM_D17,
//    .mux_mode  = IOMUX_CONFIG_ALT1,
      .mux_mode  = IOMUX_CONFIG_GPIO,
      .pad_cfg   = ( PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_NONE ),
   },
   {  // CSPI1_RDY = GPIO (out) --> AUDIO_CLK_ENn ( normal low ) = enable Audio 26MHz clock
      // $ the same
      .pin       = MX51_PIN_CSPI1_RDY,
//    .mux_mode  = IOMUX_CONFIG_ALT3,
      .mux_mode  = IOMUX_CONFIG_GPIO,
      .pad_cfg   = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_NONE |
                     PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_100K_PU  |
                     PAD_CTL_ODE_OPENDRAIN_NONE ),
   },
   {  // AUD3_BB_TXD = AUD3_TXD (out) --> I2S_DIN
      // $ the same
      .pin           = MX51_PIN_AUD3_BB_TXD,
      .mux_mode      = IOMUX_CONFIG_ALT0,
      .pad_cfg       = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_ODE_OPENDRAIN_NONE|
                         PAD_CTL_100K_PU  | PAD_CTL_HYS_NONE ),
   },
   {  // AUD3_BB_RXD = AUD3_RXD (in) <-- I2S_DOUT
      // $ the same
      .pin           = MX51_PIN_AUD3_BB_RXD,
      .mux_mode      = IOMUX_CONFIG_ALT0,
      .pad_cfg   = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_ODE_OPENDRAIN_NONE|
                     PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_HYS_NONE ),
   },
   {  // AUD3_BB_CK = AUD3_TXC -- I2S_SCLK
      // $ the same
      .pin          = MX51_PIN_AUD3_BB_CK,
      .mux_mode     = IOMUX_CONFIG_ALT0,
      .pad_cfg   = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_ODE_OPENDRAIN_NONE|
                     PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_HYS_NONE ),
   },
   {  // AUD3_BB_FS = AUD3_TXFS -- I2S_LRCLK
      // $ the same
      .pin          = MX51_PIN_AUD3_BB_FS,
      .mux_mode     = IOMUX_CONFIG_ALT0,
      .pad_cfg   = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_ODE_OPENDRAIN_NONE|
                     PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_HYS_NONE ),
   },
   #endif

   //----------------------------------------
   // SPI Nor-Flash
   //----------------------------------------
   #if ( DEVICE_SPI_NOR )
   {  // CSPI1_SS1 = CSPI1_SS1 --> SPI1_SS1_NORFLASHn = Nor-Flash SPI chip select
      // $ the same
      .pin         = MX51_PIN_CSPI1_SS1,
      .mux_mode    = IOMUX_CONFIG_ALT0,
      .pad_cfg     = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE ),
   },
   #endif

   //----------------------------------------
   // Optical Joystick
   //----------------------------------------
   #if ( DEVICE_JOYSTICK )
   {  // DI1_PIN11 = SPI SS2 --> SPI1_SS2_OJn = Optical Joystick SPI chip select
      // $ no
      .pin         = MX51_PIN_DI1_PIN11,
      .mux_mode    = IOMUX_CONFIG_ALT7,
      .pad_cfg     = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH | PAD_CTL_HYS_ENABLE |
                       PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL ),
   },
   {  // CSI2_D12 = GPIO (out) --> OJ_SHUTDOWN ( normal low ) = Optical Joystick shutdown
      // $$ LCD_3V3_ON - GPIO out
      // add PAD_CTL_100K_PD
      .pin        = MX51_PIN_CSI2_D12,
//    .mux_mode   = IOMUX_CONFIG_ALT3,
      .mux_mode   = IOMUX_CONFIG_GPIO,
      .pad_cfg    = ( PAD_CTL_100K_PD ),
   },
   {  // CSI2_D13 = GPIO (in) <-- OJ_MOTION ( normal high ) = joystick interrupt to CPU
      // $$ LCD_5V_ON - GPIO out
      .pin        = MX51_PIN_CSI2_D13,
//    .mux_mode   = IOMUX_CONFIG_ALT3,
      .mux_mode   = IOMUX_CONFIG_GPIO,
//    .pad_cfg    = ( PAD_CTL_100K_PU ),
   },
   {  // CSI2_D18 = GPIO (in) <-- OJ_ENTERn ( normal high - PU 4.7K ) = left click interrupt
      // $ no
      .pin        = MX51_PIN_CSI2_D18,
//    .mux_mode   = IOMUX_CONFIG_ALT3,
      .mux_mode   = IOMUX_CONFIG_GPIO,
      .pad_cfg    = ( PAD_CTL_HYS_ENABLE ),
   },
   {  // EIM_D20 = GPIO (in) <-- MOUSE_MBn ( normal high - PU 10K ) = right click interrupt
      // $ no
      .pin        = MX51_PIN_EIM_D20,
//    .mux_mode   = IOMUX_CONFIG_ALT1,
      .mux_mode   = IOMUX_CONFIG_GPIO,
      .pad_cfg    = ( PAD_CTL_HYS_ENABLE ),
   },
   #endif

   #if ( DEVICE_VIBRATOR )
   {  // GPIO1_1 = GPIO (out) --> MOTOR_EN = vibrator motor
      // $$ SD - SD_MMC_WP = SD1 write protection - GPIO in
      // add PAD_CTL_100K_PD
      .pin       = MX51_PIN_GPIO1_1,
//    .mux_mode  = IOMUX_CONFIG_ALT1,
      .mux_mode  = IOMUX_CONFIG_GPIO,
      .pad_cfg   = ( PAD_CTL_100K_PD ),
   },
   #endif

   #if ( DEVICE_HOLD )
   {  // EIM_A25 = GPIO (in) <-- HOLDn ( normal high )
      // $ no
      .pin       = MX51_PIN_EIM_A25,
//    .mux_mode  = IOMUX_CONFIG_ALT1,
      .mux_mode  = IOMUX_CONFIG_GPIO,
      .pad_cfg   = ( PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL | PAD_CTL_HYS_ENABLE ),
   },
   #endif

   #if ( DEVICE_PMIC )
   // RESET_IN_B    - ALT0 not need setting , button reset CPU
   // POR_B         - ALT0 not need setting , PMIC reset CPU , when power on / off
   // CKIL          - ALT0 not need setting , PMIC send 32.768K to CPU RTC
   // ID            -      not need setting , USB ID pin connect with CPU / PMIC
   // PMIC_ON_REQ   - ALT0 not need setting , CPU send to PMIC - PWRON2 when power off
   // PMIC_STBY_REQ - ALT0 not need setting , CPU send to PMIC - STANDBY when standby
   //
   {  // CSPI1_SS0 = CSPI1_SS0 --> SPI1_SS0_PMICn = PMIC - CS = PMIC SPI chip select
      // $ the same
      .pin         = MX51_PIN_CSPI1_SS0,
      .mux_mode    = IOMUX_CONFIG_ALT0,
      .pad_cfg     = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_NONE ),
   },
   // WDOG_B keep bootloader setting
   {  // GPIO1_8 = GPIO (in) <-- INT_FROM_PMIC interrupt = PMIC - INT
      // $ the same ?? GPIO
      // ?? PAD_CTL_100K_PD
      .pin       = MX51_PIN_GPIO1_8,
//    .mux_mode  = IOMUX_CONFIG_ALT0 | IOMUX_CONFIG_SION,
      .mux_mode  = IOMUX_CONFIG_GPIO | IOMUX_CONFIG_SION,
      .pad_cfg   = ( PAD_CTL_SRE_SLOW | PAD_CTL_DRV_MEDIUM | PAD_CTL_HYS_ENABLE |
                     PAD_CTL_100K_PU  | PAD_CTL_DRV_VOT_HIGH ),
   },
   {  // UART3_TXD = GPIO (out) --> SYS_ON_OFF_CTL_CPU = CPU to control VEN - 5.2V 3.3V , not used
      // $ the same ??? GPIO
      .pin         = MX51_PIN_UART3_TXD,
//    .mux_mode    = IOMUX_CONFIG_ALT3,
      .mux_mode    = IOMUX_CONFIG_GPIO,
      .pad_cfg     = ( PAD_CTL_100K_PU ),
   },
   #endif

   //----------------------------------------
   // USB
   //----------------------------------------
   // DN / DP / ID - not need setting
   //----------------------------------------
   #if ( DEVICE_USB )
   {  // EIM_D19 = GPIO (out) --> USB_CLK_ENn ( normal low ) = enable USB 26MHz clock
      // $$ I2C1_SCL , but the same babbage / spider1 EIM_D17 = USB_CLK_EN_B
      // add PAD_CTL_100K_PD
      .pin        = MX51_PIN_EIM_D19,
      .mux_mode   = IOMUX_CONFIG_ALT1,
      .pad_cfg    = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_PKE_ENABLE | PAD_CTL_100K_PD ),
   },
   {  // EIM_D21 = GPIO (out) --> RESET_USB_PHYn ( normal high ) = reset USB Phy
      // $ the same
      .pin       = MX51_PIN_EIM_D21,
//    .mux_mode  = IOMUX_CONFIG_ALT1,
      .mux_mode  = IOMUX_CONFIG_GPIO,
      .pad_cfg   = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_NONE |
                     PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_100K_PU  |
                     PAD_CTL_ODE_OPENDRAIN_NONE ),
   },
   {  // USBH1_STP = USBH1_STP -- USB_STP
      // $ the same
      .pin         = MX51_PIN_USBH1_STP,
      .mux_mode    = IOMUX_CONFIG_ALT0,
      .pad_cfg     = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_ENABLE |
                       PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER ),
   },
   {  // USBH1_CLK = USBH1_CLK -- USB_CLK
      // $ the same
      .pin         = MX51_PIN_USBH1_CLK,
      .mux_mode    = IOMUX_CONFIG_ALT0,
      .pad_cfg     = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_ENABLE |
                       PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_DDR_INPUT_CMOS ),
   },
   {  // USBH1_DIR = USBH1_DIR -- USB_DIR
      // $ the same
      .pin         = MX51_PIN_USBH1_DIR,
      .mux_mode    = IOMUX_CONFIG_ALT0,
      .pad_cfg     = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_ENABLE |
                       PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_DDR_INPUT_CMOS ),
   },
   {  // USBH1_NXT = USBH1_NXT -- USB_NXT
      // $ the same
      .pin         = MX51_PIN_USBH1_NXT,
      .mux_mode    = IOMUX_CONFIG_ALT0,
      .pad_cfg     = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_ENABLE |
                       PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_DDR_INPUT_CMOS ),
   },
   {  // USBH1_DATA0 = USBH1_DATA0 -- USB_DATA0
      // $ the same
      .pin           = MX51_PIN_USBH1_DATA0,
      .mux_mode      = IOMUX_CONFIG_ALT0,
      .pad_cfg       = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_ENABLE |
                         PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_100K_PU ),
   },
   {  // USBH1_DATA1 = USBH1_DATA1 -- USB_DATA1
      // $ the same
      .pin           = MX51_PIN_USBH1_DATA1,
      .mux_mode      = IOMUX_CONFIG_ALT0,
      .pad_cfg       = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_ENABLE |
                         PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_100K_PU ),
   },
   {  // USBH1_DATA2 = USBH1_DATA2 -- USB_DATA2
      // $ the same
      .pin           = MX51_PIN_USBH1_DATA2,
      .mux_mode      = IOMUX_CONFIG_ALT0,
      .pad_cfg       = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_ENABLE |
                         PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_100K_PU ),
   },
   {  // USBH1_DATA3 = USBH1_DATA3 --USB_DATA3
      // $ the same
      .pin           = MX51_PIN_USBH1_DATA3,
      .mux_mode      = IOMUX_CONFIG_ALT0,
      .pad_cfg       = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_ENABLE |
                         PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_100K_PU ),
   },
   {  // USBH1_DATA4 = USBH1_DATA4 -- USB_DATA4
      // $ the same
      .pin           = MX51_PIN_USBH1_DATA4,
      .mux_mode      = IOMUX_CONFIG_ALT0,
      .pad_cfg       = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_ENABLE |
                         PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_100K_PU ),
   },
   {  // USBH1_DATA5 = USBH1_DATA5 -- USB_DATA5
      // $ the same
      .pin           = MX51_PIN_USBH1_DATA5,
      .mux_mode      = IOMUX_CONFIG_ALT0,
      .pad_cfg       = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_ENABLE |
                         PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_100K_PU ),
   },
   {  // USBH1_DATA6 = USBH1_DATA6 -- USB_DATA6
      // $ the same
      .pin           = MX51_PIN_USBH1_DATA6,
      .mux_mode      = IOMUX_CONFIG_ALT0,
      .pad_cfg       = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_ENABLE |
                         PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_100K_PU ),
   },
   {  // USBH1_DATA7 = USBH1_DATA7 -- USB_DATA7
      // $ the same
      .pin           = MX51_PIN_USBH1_DATA7,
      .mux_mode      = IOMUX_CONFIG_ALT0,
      .pad_cfg       = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_ENABLE |
                         PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_100K_PU ),
   },
   
//Modify by pega Huimin 2009.12.18 to support HW USB power control design
#if ( DEVICE_USB_HW_DESIGN ) 
   {  // GPIO2_0 = GPIO (out) --> OTG_EN ( normal high ) = OTG_EN switch
      //$ EIM_D16 = I2C1_SDA
      .pin       = MX51_PIN_EIM_D16,
      .mux_mode  = IOMUX_CONFIG_GPIO,
      .pad_cfg   = ( PAD_CTL_ODE_OPENDRAIN_ENABLE ),
   },
#endif
   #endif
   {  // GPIO1_31 = GPIO (out) RESET USB HUB (don't connect)
      //$ DISP2_DAT9
      .pin       = MX51_PIN_DISP2_DAT9,
      .mux_mode  = IOMUX_CONFIG_GPIO,
      .pad_cfg   = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   |
                     PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER ),
   },
   {  // GPIO1_29 = GPIO (out) VBUS EN (don't connect)
      //$ DISP2_DAT7
      .pin       = MX51_PIN_DISP2_DAT7,
      .mux_mode  = IOMUX_CONFIG_GPIO,
      .pad_cfg   = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH   |
                     PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER ),
   },

   #if ( DEVICE_PATA )
   #if ( 0 )
   {  // NANDF_ALE = not use
      // $$ NANDF_ALE = ALT0
      .pin         = MX51_PIN_NANDF_ALE,
      .mux_mode    = IOMUX_CONFIG_ALT1,
      .pad_cfg     = ATA_PAD_CONFIG,
   },
   #endif
   {  // NANDF_CLE = PATA_RESET_B -- PATA_RESETn
      // $$ NANDF_CLE = ALT0
      .pin         = MX51_PIN_NANDF_CLE,
      .mux_mode    = IOMUX_CONFIG_ALT1,
      .pad_cfg     = ATA_PAD_CONFIG,
   },
   {  // NANDF_CS2 = CS_0 -- PATA_CS0
      // $$ FEC_TX_ER = ALT2
      .pin         = MX51_PIN_NANDF_CS2,
      .mux_mode    = IOMUX_CONFIG_ALT1,
      .pad_cfg     = ATA_PAD_CONFIG,
   },
   {  // NANDF_CS3 = CS_1 -- PATA_CS1
      // $$ FEC_MDC = ALT2
      .pin         = MX51_PIN_NANDF_CS3,
      .mux_mode    = IOMUX_CONFIG_ALT1,
      .pad_cfg     = ATA_PAD_CONFIG,
   },
   {  // NANDF_CS4 = DA_0 -- PATA_DA0
      // $$ FEC_TDATA1 = ALT2
      .pin         = MX51_PIN_NANDF_CS4,
      .mux_mode    = IOMUX_CONFIG_ALT1,
      .pad_cfg     = ATA_PAD_CONFIG,
   },
   {  // NANDF_CS5 = DA_1 -- PATA_DA1
      // $$ FEC_TDATA2 = ALT2
      .pin         = MX51_PIN_NANDF_CS5,
      .mux_mode    = IOMUX_CONFIG_ALT1,
      .pad_cfg     = ATA_PAD_CONFIG,
   },
   {  // NANDF_CS6 = DA_2 -- PATA_DA2
      // $$ FEC_TDATA3 = ALT2
      .pin         = MX51_PIN_NANDF_CS6,
      .mux_mode    = IOMUX_CONFIG_ALT1,
      .pad_cfg     = ATA_PAD_CONFIG,
   },
   {  // NANDF_RE_B = DIOR -- PATA_DIOR
      // $$ NANDF_RE_B = ALT0
      .pin          = MX51_PIN_NANDF_RE_B,
      .mux_mode     = IOMUX_CONFIG_ALT1,
      .pad_cfg      = ATA_PAD_CONFIG,
   },
   {  // NANDF_WE_B = DIOW -- PATA_DIOW
      // $$ NANDF_WE_B = ALT0
      .pin          = MX51_PIN_NANDF_WE_B,
      .mux_mode     = IOMUX_CONFIG_ALT1,
      .pad_cfg      = ATA_PAD_CONFIG,
   },
   {  // NANDF_WP_B = DMACK -- PATA_DMACK
      // $$ NANDF_WP_B = ALT0
      .pin          = MX51_PIN_NANDF_WP_B,
      .mux_mode     = IOMUX_CONFIG_ALT1,
      .pad_cfg      = ATA_PAD_CONFIG,
   },
   {  // NANDF_RB0 = DMARQ -- PATA_DMARQ
      // $$ NANDF_RB0 = ALT0
      .pin         = MX51_PIN_NANDF_RB0,
      .mux_mode    = IOMUX_CONFIG_ALT1,
      .pad_cfg     = ATA_PAD_CONFIG,
   },
   {  // NANDF_RB1 = IORDY -- PATA_IORDY
      // $$ NANDF_RB1 = ALT0
      .pin         = MX51_PIN_NANDF_RB1,
      .mux_mode    = IOMUX_CONFIG_ALT1,
      .pad_cfg     = ATA_PAD_CONFIG,
   },
   {  // GPIO_NAND = INTRQ -- PATA_INTRQ
      // $$ no
      .pin         = MX51_PIN_GPIO_NAND,
      .mux_mode    = IOMUX_CONFIG_ALT1,
      .pad_cfg     = ATA_PAD_CONFIG,
   },
   {  // NANDF_D0 = PATA_DATA0 -- PATA_D0
      // $$ ? NANDF_D0 = ALT0
      .pin        = MX51_PIN_NANDF_D0,
      .mux_mode   = IOMUX_CONFIG_ALT1,
      .pad_cfg    = ATA_PAD_CONFIG,
   },
   {  // NANDF_D1 = PATA_DATA1 -- PATA_D1
      // $$ ? NANDF_D1 = ALT0
      .pin        = MX51_PIN_NANDF_D1,
      .mux_mode   = IOMUX_CONFIG_ALT1,
      .pad_cfg    = ATA_PAD_CONFIG,
   },
   {  // NANDF_D2 = PATA_DATA2 -- PATA_D2
      // $$ ? NANDF_D2 = ALT0
      .pin        = MX51_PIN_NANDF_D2,
      .mux_mode   = IOMUX_CONFIG_ALT1,
      .pad_cfg    = ATA_PAD_CONFIG,
   },
   {  // NANDF_D3 = PATA_DATA3 -- PATA_D3
      // $$ ? NANDF_D3 = ALT0
      .pin        = MX51_PIN_NANDF_D3,
      .mux_mode   = IOMUX_CONFIG_ALT1,
      .pad_cfg    = ATA_PAD_CONFIG,
   },
   {  // NANDF_D4 = PATA_DATA4 -- PATA_D4
      // $$ ? NANDF_D4 = ALT0
      .pin        = MX51_PIN_NANDF_D4,
      .mux_mode   = IOMUX_CONFIG_ALT1,
      .pad_cfg    = ATA_PAD_CONFIG,
   },
   {  // NANDF_D5 = PATA_DATA5 -- PATA_D5
      // $$ ? NANDF_D5 = ALT0
      .pin        = MX51_PIN_NANDF_D5,
      .mux_mode   = IOMUX_CONFIG_ALT1,
      .pad_cfg    = ATA_PAD_CONFIG,
   },
   {  // NANDF_D6 = PATA_DATA6 -- PATA_D6
      // $$ ? NANDF_D6 = ALT0
      .pin        = MX51_PIN_NANDF_D6,
      .mux_mode   = IOMUX_CONFIG_ALT1,
      .pad_cfg    = ATA_PAD_CONFIG,
   },
   {  // NANDF_D7 = PATA_DATA7 -- PATA_D7
      // $$ ? NANDF_D7 = ALT0
      .pin        = MX51_PIN_NANDF_D7,
      .mux_mode   = IOMUX_CONFIG_ALT1,
      .pad_cfg    = ATA_PAD_CONFIG,
   },
   {  // NANDF_D8 = PATA_DATA8 -- PATA_D8
      // $$ ? FEC_TDATA0
      .pin        = MX51_PIN_NANDF_D8,
      .mux_mode   = IOMUX_CONFIG_ALT1,
      .pad_cfg    = ATA_PAD_CONFIG,
   },
   {  // NANDF_D9 = PATA_DATA9 -- PATA_D9
      // $$ ? FEC_RDATA0
      .pin        = MX51_PIN_NANDF_D9,
      .mux_mode   = IOMUX_CONFIG_ALT1,
      .pad_cfg    = ATA_PAD_CONFIG,
   },
   {  // NANDF_D10 = PATA_DATA10 -- PATA_D10
      // $$ ? GPIO3_30
      .pin         = MX51_PIN_NANDF_D10,
      .mux_mode    = IOMUX_CONFIG_ALT1,
      .pad_cfg     = ATA_PAD_CONFIG,
   },
   {  // NANDF_D11 = PATA_DATA11 -- PATA_D11
      // $$ ? FEC_RX_DV
      .pin         = MX51_PIN_NANDF_D11,
      .mux_mode    = IOMUX_CONFIG_ALT1,
      .pad_cfg     = ATA_PAD_CONFIG,
   },
   {  // NANDF_D12 = PATA_DATA12 -- PATA_D12
      // $$ ? DVI_DET
      .pin         = MX51_PIN_NANDF_D12,
      .mux_mode    = IOMUX_CONFIG_ALT1,
      .pad_cfg     = ATA_PAD_CONFIG,
   },
   {  // NANDF_D13 = PATA_DATA13 -- PATA_D13
      // $$ ? AMB_LIGHT_INT
      .pin         = MX51_PIN_NANDF_D13,
      .mux_mode    = IOMUX_CONFIG_ALT1,
      .pad_cfg     = ATA_PAD_CONFIG,
   },
   {  // NANDF_D14 = PATA_DATA14 -- PATA_D14
      // $$ ? HPHONE_DET_B
      .pin         = MX51_PIN_NANDF_D14,
      .mux_mode    = IOMUX_CONFIG_ALT1,
      .pad_cfg     = ATA_PAD_CONFIG,
   },
   {  // NANDF_D15 = PATA_DATA15 -- PATA_D15
      // $$ ? HEADSET_DET_B
      .pin         = MX51_PIN_NANDF_D15,
      .mux_mode    = IOMUX_CONFIG_ALT1,
      .pad_cfg     = ATA_PAD_CONFIG,
   },
   #endif

   //------------------------------
   // pega used for other function
   //------------------------------
   // remark by pega Eric 2009.11.12
   #if ( 0 )
   {  MX51_PIN_EIM_A16, IOMUX_CONFIG_GPIO, },      // BT_RSTn

   // NANDF_CS2 - FEC_TX_ER
   {  MX51_PIN_NANDF_CS2, IOMUX_CONFIG_ALT2,       // PATA_CS0
      ( PAD_CTL_DRV_VOT_HIGH | PAD_CTL_DRV_HIGH ),
   },
   // NANDF_CS3 - FEC_MDC
   {  MX51_PIN_NANDF_CS3, IOMUX_CONFIG_ALT2,       // PATA_CS1
      ( PAD_CTL_DRV_VOT_HIGH | PAD_CTL_DRV_HIGH ),
   },
   // NANDF_CS4 - FEC_TDATA1                       // PATA_DA0
   {  MX51_PIN_NANDF_CS4, IOMUX_CONFIG_ALT2,
      ( PAD_CTL_DRV_VOT_HIGH | PAD_CTL_DRV_HIGH ),
   },
   // NANDF_CS5 - FEC_TDATA2                       // PATA_DA1
   {  MX51_PIN_NANDF_CS5, IOMUX_CONFIG_ALT2,
      ( PAD_CTL_DRV_VOT_HIGH | PAD_CTL_DRV_HIGH ),
   },
   // NANDF_CS6 - FEC_TDATA3                       // PATA_DA2
   {  MX51_PIN_NANDF_CS6, IOMUX_CONFIG_ALT2,
      ( PAD_CTL_DRV_VOT_HIGH | PAD_CTL_DRV_HIGH ),
   },
   // NANDF_D12 - DVI_DET                          // PATA_D12
   {  MX51_PIN_NANDF_D12, IOMUX_CONFIG_GPIO, 0, },

   // CSI2_D12 - LCD_3V3_ON ( ALT3 = GPIO )        // OJ_SHUTDOWN
   {  MX51_PIN_CSI2_D12, IOMUX_CONFIG_ALT3,
      ( PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_DRV_HIGH | PAD_CTL_SRE_FAST ),
   },
   // CSI2_D13 - LCD_5V_ON ( ALT3 = GPIO )         // OJ_MOTION
   {  MX51_PIN_CSI2_D13, IOMUX_CONFIG_ALT3,
      ( PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_DRV_HIGH | PAD_CTL_SRE_FAST ),
   },
   // GPIO1_1 - SD_MMC_WP = SD1 write protection   // MOTOR_EN
   {  MX51_PIN_GPIO1_1, IOMUX_CONFIG_GPIO | IOMUX_CONFIG_SION,
      ( PAD_CTL_HYS_ENABLE | PAD_CTL_100K_PU ),
   },
   // GPIO1_3 - CLKO2                              // LCDVDD_3V3_ON
   {  MX51_PIN_GPIO1_3, IOMUX_CONFIG_ALT2 | IOMUX_CONFIG_SION,
      ( PAD_CTL_SRE_FAST | PAD_CTL_ODE_OPENDRAIN_ENABLE | PAD_CTL_DRV_HIGH |
        PAD_CTL_100K_PU | PAD_CTL_HYS_ENABLE ),
      MUX_IN_I2C2_IPP_SDA_IN_SELECT_INPUT, INPUT_CTL_PATH3,
   },
   // GPIO1_5 - SD_MMC_WP = SD2 write protection   // BT_EN
   {  MX51_PIN_GPIO1_5, IOMUX_CONFIG_GPIO | IOMUX_CONFIG_SION,
      ( PAD_CTL_HYS_ENABLE | PAD_CTL_100K_PU ),
   },
   // GPIO1_6 - SD_MMC_CD_B = SD2 detect           // VCC_BP_3V3EN
   {  MX51_PIN_GPIO1_6, IOMUX_CONFIG_GPIO | IOMUX_CONFIG_SION,
      ( PAD_CTL_HYS_ENABLE | PAD_CTL_100K_PU ),
   },
   // EIM_D23 - Expansion_GPIO1 = camera on expansion board = camera reset
   {  MX51_PIN_EIM_D23, IOMUX_CONFIG_ALT1,         // WL_RSTn
      ( PAD_CTL_HYS_NONE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER |
        PAD_CTL_DRV_HIGH | PAD_CTL_SRE_FAST ),
   },
   // CSI2_D19 - Expansion_GPIO2 = camera on expansion board = camera low power
   {  MX51_PIN_CSI2_D19, IOMUX_CONFIG_ALT3,        // BL_EN
      ( PAD_CTL_HYS_NONE | PAD_CTL_PKE_ENABLE | PAD_CTL_DRV_LOW | PAD_CTL_SRE_SLOW ),
   },
   // EIM_D18 - 22MHz_EN
   {  MX51_PIN_EIM_D18, IOMUX_CONFIG_GPIO,         // not seting and connect
      ( PAD_CTL_DRV_HIGH | PAD_CTL_PKE_ENABLE |
        PAD_CTL_PUE_KEEPER | PAD_CTL_100K_PU | PAD_CTL_SRE_FAST ),
   },
   #endif

   // EIM_D18 - 22MHz_EN no connect
   {
      .pin      = MX51_PIN_EIM_D18,
      .mux_mode = IOMUX_CONFIG_GPIO,
      .pad_cfg  = ( PAD_CTL_DRV_HIGH   | PAD_CTL_HYS_NONE | PAD_CTL_PKE_ENABLE |
                    PAD_CTL_PUE_KEEPER | PAD_CTL_SRE_FAST ),
   },
   // EIM_DTACK - HPHONE DET not connect
   {
      .pin      = MX51_PIN_EIM_DTACK,
      .mux_mode = IOMUX_CONFIG_GPIO,
      .pad_cfg  = ( PAD_CTL_PKE_NONE | PAD_CTL_DRV_HIGH | PAD_CTL_SRE_SLOW ),
   },
   // EIM_A17 - not connect
   {
      .pin      = MX51_PIN_EIM_A17,
      .mux_mode = IOMUX_CONFIG_ALT0,
      .pad_cfg  = FORCE_PAD_ALL0,
   },
   // EIM_A18 - not connect
   {
      .pin      = MX51_PIN_EIM_A18,
      .mux_mode = IOMUX_CONFIG_ALT0,
      .pad_cfg  = FORCE_PAD_ALL0,
   },
   // EIM_A19 - not connect
   {
      .pin      = MX51_PIN_EIM_A19,
      .mux_mode = IOMUX_CONFIG_ALT0,
      .pad_cfg  = FORCE_PAD_ALL0,
   },
   // EIM_A20 - not connect
   {
      .pin      = MX51_PIN_EIM_A20,
      .mux_mode = IOMUX_CONFIG_ALT0,
      .pad_cfg  = FORCE_PAD_ALL0,
   },
   // EIM_A21 - not connect
   {
      .pin      = MX51_PIN_EIM_A21,
      .mux_mode = IOMUX_CONFIG_ALT0,
      .pad_cfg  = FORCE_PAD_ALL0,
   },
   // EIM_A22 - not connect
   {
      .pin      = MX51_PIN_EIM_A22,
      .mux_mode = IOMUX_CONFIG_ALT0,
      .pad_cfg  = FORCE_PAD_ALL0,
   },
   // EIM_A24 - not connect
   {
      .pin      = MX51_PIN_EIM_A24,
      .mux_mode = IOMUX_CONFIG_GPIO,
      .pad_cfg  = FORCE_PAD_ALL0,
   },
   // EIM_EB2 - not connect
   {
      .pin      = MX51_PIN_EIM_EB2,
      .mux_mode = IOMUX_CONFIG_ALT0,
      .pad_cfg  = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_HYS_NONE |
                    PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_100K_PU ),
   },
   // EIM_EB3 - not connect
   {
      .pin      = MX51_PIN_EIM_EB3,
      .mux_mode = IOMUX_CONFIG_ALT0,
      .pad_cfg  = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_HYS_NONE |
                    PAD_CTL_PKE_ENABLE ),
   },
   // EIM_CS2 - not connect
   {
      .pin      = MX51_PIN_EIM_CS2,
      .mux_mode = IOMUX_CONFIG_ALT0,
      .pad_cfg  = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_HYS_NONE |
                    PAD_CTL_PKE_ENABLE ),
   },
   // EIM_CS3 - not connect
   {
      .pin      = MX51_PIN_EIM_CS3,
      .mux_mode = IOMUX_CONFIG_ALT0,
      .pad_cfg  = ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_HYS_NONE |
                    PAD_CTL_PKE_ENABLE ),
   },
   // EIM_CS4 - not connect
   {
      .pin      = MX51_PIN_EIM_CS4,
      .mux_mode = IOMUX_CONFIG_ALT0,
      .pad_cfg  = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH | PAD_CTL_HYS_NONE |
                    PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER ),
   },
   // EIM_CS5 - not connect
   {
      .pin      = MX51_PIN_EIM_CS5,
      .mux_mode = IOMUX_CONFIG_ALT0,
      .pad_cfg  = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH | PAD_CTL_HYS_NONE |
                    PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER ),
   },
   // NANDF_ALE - not connect
   {
      .pin      = MX51_PIN_NANDF_ALE,
      .mux_mode = IOMUX_CONFIG_ALT1,
      .pad_cfg  = ( PAD_CTL_DRV_HIGH  | PAD_CTL_PKE_NONE | PAD_CTL_DRV_VOT_HIGH),
   },
   // NANDF_RB2 - not connect
   {
      .pin      = MX51_PIN_NANDF_RB2,
      .mux_mode = IOMUX_CONFIG_ALT0,
      .pad_cfg  = ( PAD_CTL_DRV_LOW  | PAD_CTL_HYS_NONE | PAD_CTL_PKE_ENABLE |
                    PAD_CTL_PUE_PULL | PAD_CTL_100K_PU  | PAD_CTL_DRV_VOT_HIGH),
   },
   // NANDF_RB3 - not connect
   {
      .pin      = MX51_PIN_NANDF_RB3,
      .mux_mode = IOMUX_CONFIG_ALT0,
      .pad_cfg  = ( PAD_CTL_DRV_LOW  | PAD_CTL_HYS_NONE | PAD_CTL_PKE_ENABLE |
                    PAD_CTL_PUE_PULL | PAD_CTL_100K_PU  | PAD_CTL_DRV_VOT_HIGH),
   },
   // NANDF_CS7 - not connect
   {
      .pin      = MX51_PIN_NANDF_CS7,
      .mux_mode = IOMUX_CONFIG_ALT0,
      .pad_cfg  = ( PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH | PAD_CTL_HYS_NONE |
                    PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL | PAD_CTL_100K_PU  |
                    PAD_CTL_DRV_VOT_HIGH),
   },
   // NANDF_RDY_INT - not connect
   {
      .pin      = MX51_PIN_NANDF_RDY_INT,
      .mux_mode = IOMUX_CONFIG_ALT0,
      .pad_cfg  = ( PAD_CTL_DRV_LOW  | PAD_CTL_HYS_NONE | PAD_CTL_PKE_ENABLE |
                    PAD_CTL_PUE_PULL | PAD_CTL_100K_PU  | PAD_CTL_DRV_VOT_HIGH),
   },
   //---------------
   // pega not used
   //---------------
   // remark by pega Eric 2009.11.12
   #if ( 0 )
   // EIM_A17 ~ EIM_A22
   {  MX51_PIN_EIM_A17, IOMUX_CONFIG_GPIO, },
   {  MX51_PIN_EIM_A18, IOMUX_CONFIG_GPIO, },
   {  MX51_PIN_EIM_A19, IOMUX_CONFIG_GPIO, },
   {  MX51_PIN_EIM_A20, IOMUX_CONFIG_GPIO, ( PAD_CTL_PKE_ENABLE ), },
   {  MX51_PIN_EIM_A21, IOMUX_CONFIG_GPIO, },
   {  MX51_PIN_EIM_A22, IOMUX_CONFIG_GPIO, },
   // EIM_EB2 - MDIO
   {  MX51_PIN_EIM_EB2, IOMUX_CONFIG_ALT3,
      ( PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_ODE_OPENDRAIN_ENABLE |
        PAD_CTL_22K_PU | PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL ),
   },
   // EIM_EB3 - RDATA[1]
   {  MX51_PIN_EIM_EB3, IOMUX_CONFIG_ALT3,
      ( PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE ),
   },
   // EIM_CS2 - RDATA[2]
   {   MX51_PIN_EIM_CS2, IOMUX_CONFIG_ALT3,
      ( PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE ),
   },
   // EIM_CS3 - RDATA[3]
   {  MX51_PIN_EIM_CS3, IOMUX_CONFIG_ALT3,
      ( PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE ),
   },
   // EIM_CS4 - RX_ER
   {  MX51_PIN_EIM_CS4, IOMUX_CONFIG_ALT3,
      ( PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE ),
   },
   // EIM_CS5 - CRS
   {  MX51_PIN_EIM_CS5, IOMUX_CONFIG_ALT3,
      ( PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE ),
   },
   // EIM_DTACK
   {  MX51_PIN_EIM_DTACK, IOMUX_CONFIG_GPIO,
      ( PAD_CTL_PKE_ENABLE | PAD_CTL_100K_PU ),
   },
   // EIM_LBA
   {  MX51_PIN_EIM_LBA, IOMUX_CONFIG_GPIO, },
   // NANDF_RB2
   {  MX51_PIN_NANDF_RB2, IOMUX_CONFIG_ALT1,
      ( PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE ),
   },
   // NANDF_RB3
   {  MX51_PIN_NANDF_RB3, IOMUX_CONFIG_ALT1,
      ( PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE ),
   },
   // NANDF_RB4
   {  MX51_PIN_NANDF_RB4, IOMUX_CONFIG_ALT1,
      ( PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE ),
   },
   // NANDF_RB6 - RDATA[0]
   {  MX51_PIN_NANDF_RB6, IOMUX_CONFIG_ALT1,
      ( PAD_CTL_DRV_VOT_HIGH | PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE ),
   },
   // NANDF_RB7 - TDATA[0]
   {  MX51_PIN_NANDF_RB7, IOMUX_CONFIG_ALT1,
      ( PAD_CTL_DRV_VOT_HIGH | PAD_CTL_DRV_HIGH ),
   },
   // NANDF_CS0
   {  MX51_PIN_NANDF_CS0, IOMUX_CONFIG_GPIO, PAD_CTL_100K_PU, },
   // NANDF_CS1
   {  MX51_PIN_NANDF_CS1, IOMUX_CONFIG_GPIO, },
   // NANDF_CS7 - TX_EN
   {  MX51_PIN_NANDF_CS7, IOMUX_CONFIG_ALT1,
      ( PAD_CTL_DRV_VOT_HIGH | PAD_CTL_DRV_HIGH ),
   },
   // NANDF_RDY_INT - TX_CLK
   {  MX51_PIN_NANDF_RDY_INT, IOMUX_CONFIG_ALT1,
      ( PAD_CTL_DRV_VOT_HIGH | PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE ),
   },
   // DI_GP4
   {  MX51_PIN_DI_GP4, IOMUX_CONFIG_ALT4, },
   // DISPB2_SER_DIN
   {  MX51_PIN_DISPB2_SER_DIN, IOMUX_CONFIG_GPIO, 0,
      MUX_IN_GPIO3_IPP_IND_G_IN_5_SELECT_INPUT, INPUT_CTL_PATH1,
   },

   #ifdef CONFIG_FB_MXC_CLAA_WVGA_SYNC_PANEL
   // DISP1_DAT22 - DISP2_DAT16
   {  MX51_PIN_DISP1_DAT22, IOMUX_CONFIG_ALT5, },
   // DISP1_DAT23 - DISP2_DAT17
   {  MX51_PIN_DISP1_DAT23, IOMUX_CONFIG_ALT5, },
   // DI1_D1_CS
   {  MX51_PIN_DI1_D1_CS, IOMUX_CONFIG_ALT4,
      ( PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER | PAD_CTL_DRV_HIGH | PAD_CTL_SRE_FAST ),
      MUX_IN_GPIO3_IPP_IND_G_IN_4_SELECT_INPUT, INPUT_CTL_PATH1,
   },
   #endif

   // I2C1_CLK
   {  MX51_PIN_I2C1_CLK, IOMUX_CONFIG_ALT0 | IOMUX_CONFIG_SION, 0x1E4, },
   // I2C1_DAT
   {  MX51_PIN_I2C1_DAT, IOMUX_CONFIG_ALT0 | IOMUX_CONFIG_SION, 0x1E4, },
   // UART3_RXD - to detect BB2.0 or BB2.5
   {  MX51_PIN_UART3_RXD, IOMUX_CONFIG_ALT3,
      ( PAD_CTL_HYS_NONE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER |
        PAD_CTL_DRV_HIGH | PAD_CTL_SRE_FAST ),
   },
   // DI_GP3 - CSI1_DATA_EN ( need to be pulled up )
   {  MX51_PIN_DI_GP3, IOMUX_CONFIG_ALT3,
      ( PAD_CTL_HYS_NONE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL |
        PAD_CTL_DRV_HIGH | PAD_CTL_SRE_FAST ),
      MUX_IN_HSC_MIPI_MIX_IPP_IND_SENS2_DATA_EN_SELECT_INPUT,
      INPUT_CTL_PATH1,
   },
   // CSI1_D10 ~ CSI1_D19
   {  MX51_PIN_CSI1_D10, IOMUX_CONFIG_ALT0, PAD_CTL_HYS_NONE, },
   {  MX51_PIN_CSI1_D11, IOMUX_CONFIG_ALT0, PAD_CTL_HYS_NONE, },
   {  MX51_PIN_CSI1_D12, IOMUX_CONFIG_ALT0, PAD_CTL_HYS_NONE, },
   {  MX51_PIN_CSI1_D13, IOMUX_CONFIG_ALT0, PAD_CTL_HYS_NONE, },
   {  MX51_PIN_CSI1_D14, IOMUX_CONFIG_ALT0, PAD_CTL_HYS_NONE, },
   {  MX51_PIN_CSI1_D15, IOMUX_CONFIG_ALT0, PAD_CTL_HYS_NONE, },
   {  MX51_PIN_CSI1_D16, IOMUX_CONFIG_ALT0, PAD_CTL_HYS_NONE, },
   {  MX51_PIN_CSI1_D17, IOMUX_CONFIG_ALT0, PAD_CTL_HYS_NONE, },
   {  MX51_PIN_CSI1_D18, IOMUX_CONFIG_ALT0, PAD_CTL_HYS_NONE, },
   {  MX51_PIN_CSI1_D19, IOMUX_CONFIG_ALT0, PAD_CTL_HYS_NONE, },
   // CSI1_VSYNC
   {  MX51_PIN_CSI1_VSYNC, IOMUX_CONFIG_ALT0,
      ( PAD_CTL_HYS_NONE | PAD_CTL_SRE_SLOW ),
   },
   // CSI1_HSYNC
   {   MX51_PIN_CSI1_HSYNC, IOMUX_CONFIG_ALT0,
      ( PAD_CTL_HYS_NONE | PAD_CTL_SRE_SLOW ),
   },
   #endif
};

static int __initdata enable_w1 = { 0 };
static int __init w1_setup(char *__unused)
{
   enable_w1 = 1;
   return 1;
}

__setup("w1", w1_setup);

void __init mx51_babbage_io_init(void)
{
   int i, num;
   struct mxc_iomux_pin_cfg *pin_ptr;

   DEBUG_PRINTK(("[%s] \n",  __func__));

   // remark by pega Eric 2009.11.12
   // GPIO1_7 = GPIO (out) --> VCC_BP_5V2EN ( normal high ) = enable VDD_5V2 - EVT2
   #if ( 0 )
   // GPIO1_7 - RST_USB_HUB_B
   // for external USB HUB chip to use default configuration by reseting hub with i2c lines pulled low
   mxc_request_iomux(MX51_PIN_GPIO1_7, IOMUX_CONFIG_GPIO);
   mxc_iomux_set_pad(MX51_PIN_GPIO1_7, PAD_CTL_DRV_HIGH | PAD_CTL_PKE_ENABLE | PAD_CTL_SRE_FAST);
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_GPIO1_7), "gpio1_7");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_GPIO1_7), 0);
   // reset for external USB HUB
   msleep(1);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_GPIO1_7), 0);
   msleep(1);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_GPIO1_7), 1);
   #endif

   for ( i = 0 ; i < ARRAY_SIZE(mxc_iomux_pins) ; i++ )
   {
      mxc_request_iomux(mxc_iomux_pins[i].pin, mxc_iomux_pins[i].mux_mode);

      if ( mxc_iomux_pins[i].pad_cfg )
         mxc_iomux_set_pad(mxc_iomux_pins[i].pin, mxc_iomux_pins[i].pad_cfg);

      if (mxc_iomux_pins[i].in_select)
         mxc_iomux_set_input(mxc_iomux_pins[i].in_select, mxc_iomux_pins[i].in_mode);
   }

   #if ( DEVICE_SYSTEM )
   // EIM_A27 = GPIO (in) <-- SYS_ON_OFF_REQ = power key , wakeup the CPU when suspend / suspend the system when power on
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_EIM_A27), "eim_a27");
   gpio_direction_input(IOMUX_TO_GPIO(MX51_PIN_EIM_A27));

   // DI1_PIN12 = GPIO (out) --> 26M_OSC_EN ( normal high ) = enable 26MHz clock for USB / Audio
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_DI1_PIN12), "di1_pin12");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_DI1_PIN12), 0);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_DI1_PIN12), 1);

   // GPIO1_6 = GPIO (out) --> VCC_BP_3V3EN ( normal high ) = enable VDD_3V3 - EVT2
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_GPIO1_6), "gpio1_6");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_GPIO1_6), 0);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_GPIO1_6), 1);

   // GPIO1_7 = GPIO (out) --> VCC_BP_5V2EN ( normal high ) = enable VDD_5V2 - EVT2
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_GPIO1_7), "gpio1_7");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_GPIO1_7), 0);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_GPIO1_7), 1);
   #endif

   #if ( DEVICE_I2C1 )
   #endif
   #if ( DEVICE_I2C2 )
   #endif
   #if ( DEVICE_SPI1 )
   #endif
   #if ( DEVICE_UART1 )
   #endif

   #if ( DEVICE_SD1 )
   // GPIO1_0 = GPIO (in) <-- SD_CDn ( normal high ) = detect SD insert
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_GPIO1_0), "gpio1_0");
   gpio_direction_input(IOMUX_TO_GPIO(MX51_PIN_GPIO1_0));
   #endif

   #if ( DEVICE_WIFI )
   // EIM_D23 = GPIO (out) --> WL_RSTn ( normal high )
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_EIM_D23), "eim_d23");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_EIM_D23), 0);
   msleep(1);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_D23), 0);
   msleep(1);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_D23), 1);

   // EIM_A26 = GPIO (in) <-- WL_WAKEUP ( normal ?? - PD 1.33K )
   // WLAN EN = 1 NORMAL not connect
   mxc_request_iomux(MX51_PIN_EIM_CRE, IOMUX_CONFIG_ALT5);
   mxc_iomux_set_pad(MX51_PIN_EIM_CRE, PAD_CTL_DRV_HIGH | PAD_CTL_HYS_NONE | PAD_CTL_PKE_NONE | PAD_CTL_SRE_FAST );
   mxc_iomux_set_input(MUX_IN_GPIO3_IPP_IND_G_IN_2_SELECT_INPUT, INPUT_CTL_PATH1);
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_EIM_CRE), "eim_cre");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_EIM_CRE), 0);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_CRE), 1);
   #endif

   #if ( DEVICE_BLUETOOTH )
   // GPIO1_5 = GPIO (out) --> BT_EN ( normal high ) = enable Bluetooth power
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_GPIO1_5), "gpio1_5");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_GPIO1_5), 0);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_GPIO1_5), 1);

   // EIM_A16 = GPIO (out) --> BT_RSTn ( normal high )
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_EIM_A16), "eim_a16");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_EIM_A16), 0);
   msleep(1);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A16), 0);
   msleep(1);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A16), 1);

   // EIM_D22 = GPIO (in) <-- BT_WAKE ( normal ?? )
   #endif

   #if ( DEVICE_LCD )
   // DISP2_DAT6 = GPIO (out) --> LCDBL_ON ( normal high ) = enable LCD Backlight 5.2V
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_DISP2_DAT6), "disp2_dat6");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_DISP2_DAT6), 0);

   // CSI2_D19 = GPIO (out) --> BL_EN ( normal high ) = enable LCD Backlight
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_CSI2_D19), "csi2_d19");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_CSI2_D19), 0);

   // GPIO1_3 = GPIO (out) --> LCDVDD_3V3_ON ( normal high ) = enable LCD 3.3V
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_GPIO1_3), "gpio1_3");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_GPIO1_3), 0);

   // DI1_D0_CS = GPIO (out) --> LVDS_PWR_DWNn ( normal high ) = power down LVDS THC63LVDM63A-G
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_DI1_D0_CS), "di1_d0_cs");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_DI1_D0_CS), 0);

   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_DI1_D0_CS), 1);  // enable LCD LVDS           = LVDS_PWR_DWNn = 1
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_GPIO1_3), 1);    // enable LCD 3.3V           = LCDVDD_3V3_ON = 1
   mdelay(180);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_DISP2_DAT6), 1); // enable LCD Backlight 5.2V = LCDBL_ON = 1
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_CSI2_D19), 1);   // enable LCD Backlight      = BL_EN = 1

#if ( 0 )
   //Mask BIT 1~2 DSE Field Drive Strenght Field to 01: Medium Drive Strength
   unsigned int pad_confg;
   pad_confg = mxc_iomux_get_pad(MX51_PIN_DI1_DISP_CLK);
   mxc_iomux_set_pad(MX51_PIN_DI1_DISP_CLK, (pad_confg & 0xFFFFFFFB) );
#endif

   #endif

   #if ( DEVICE_AUDIO )
   // EIM_A23 = GPIO (out) -- AUDAMP_STBYn ( normal low - PU 10K ?? ) = control AMP power down
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_EIM_A23), "eim_a23");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_EIM_A23), 0);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A23), 0);

   // EIM_D17 = GPIO (in) -- HPHONE_DETn ( normal high - PU 68K ) = detect headphone insert
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_EIM_D17), "eim_d17");
   gpio_direction_input(IOMUX_TO_GPIO(MX51_PIN_EIM_D17));

   // CSPI1_RDY = GPIO (out) --> AUDIO_CLK_ENn ( normal low ) = enable Audio 26MHz clock
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_CSPI1_RDY), "cspi1_rdy");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_CSPI1_RDY), 0);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_CSPI1_RDY), 0);
   #endif

   #if ( DEVICE_SPI_NOR )
   // NOR WP = 1 NORMAL
   mxc_request_iomux(MX51_PIN_DISP2_DAT8, IOMUX_CONFIG_ALT5);
   mxc_iomux_set_pad(MX51_PIN_DISP2_DAT8, PAD_CTL_DRV_HIGH | PAD_CTL_HYS_NONE | PAD_CTL_PKE_NONE | PAD_CTL_SRE_FAST );
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_DISP2_DAT8), "disp2_dat8");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_DISP2_DAT8), 0);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_DISP2_DAT8), 1);
   #endif

   #if ( DEVICE_JOYSTICK )
   // CSI2_D12 = GPIO (out) --> OJ_SHUTDOWN ( normal low ) = Optical Joystick shutdown
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_CSI2_D12), "csi2_d12");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_CSI2_D12), 0);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_CSI2_D12), 0);

   // CSI2_D13 = GPIO (in) <-- OJ_MOTION ( normal high ) = joystick interrupt to CPU
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_CSI2_D13), "csi2_d13");
   gpio_direction_input(MX51_PIN_CSI2_D13);

   // CSI2_D18 = GPIO (in) <-- OJ_ENTERn ( normal high - PU 4.7K ) = left click interrupt
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_CSI2_D18), "csi2_d18");
   gpio_direction_input(MX51_PIN_CSI2_D18);

   // EIM_D20 = GPIO (in) <-- MOUSE_MBn ( normal high - PU 4.7K ) = right click interrupt
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_EIM_D20), "eim_d20");
   gpio_direction_input(MX51_PIN_EIM_D20);
   #endif

   #if ( DEVICE_VIBRATOR )
   // GPIO1_1 = GPIO (out) --> MOTOR_EN = vibrator motor
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_GPIO1_1), "gpio1_1");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_GPIO1_1), 0);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_GPIO1_1), 0);
   #endif

   #if ( DEVICE_HOLD )
   // EIM_A25 = GPIO (in) <-- HOLDn ( normal high )
   #endif

   #if ( DEVICE_PMIC )
   // GPIO1_4 = GPIO (out) --? WDOGn = PMIC - WDI

   // GPIO1_8 = GPIO (in) <-- INT_FROM_PMIC interrupt = PMIC - INT
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_GPIO1_8), "gpio1_8");
   gpio_direction_input(IOMUX_TO_GPIO(MX51_PIN_GPIO1_8));

   // UART3_TXD = GPIO (out) --> SYS_ON_OFF_CTL_CPU = CPU to control VEN - 5.2V 3.3V , not used
   #endif

   #if ( DEVICE_USB )
   // EIM_D19 = GPIO (out) --> USB_CLK_ENn ( normal low ) = enable USB 26MHz clock
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_EIM_D19), "eim_d19");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_EIM_D19), 0);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_D19), 0);

   // EIM_D21 = GPIO (out) --> RESET_USB_PHYn ( normal high ) = reset USB Phy
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_EIM_D21), "eim_d21");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_EIM_D21), 0);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_D21), 1);
   
//Modify by pega Huimin 2009.12.18 to support HW USB power control design
#if ( DEVICE_USB_HW_DESIGN )
   // GPIO2_0 = GPIO (out) --> OGT_EN
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_EIM_D16), "eim_d16");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_EIM_D16), 0);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_D16), 1);
#endif

   #endif

   #if ( DEVICE_PATA )
   #endif

   #if ( DEVICE_MINIPCI )
      // CARD_RST_OUT = 1 Reset OFF
      mxc_request_iomux(MX51_PIN_CSI2_HSYNC, IOMUX_CONFIG_ALT3);
      mxc_iomux_set_pad(MX51_PIN_CSI2_HSYNC, PAD_CTL_DRV_LOW | PAD_CTL_PKE_ENABLE | PAD_CTL_SRE_FAST );
      gpio_request(IOMUX_TO_GPIO(MX51_PIN_CSI2_HSYNC), "csi2_hsync");
      gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_CSI2_HSYNC), 0);
      gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_CSI2_HSYNC), 1);
      // CARD_ON_OUT = 1  Use ON
      mxc_request_iomux(MX51_PIN_CSI2_PIXCLK, IOMUX_CONFIG_ALT3);
      mxc_iomux_set_pad(MX51_PIN_CSI2_PIXCLK, PAD_CTL_DRV_LOW | PAD_CTL_PKE_ENABLE | PAD_CTL_SRE_FAST );
      gpio_request(IOMUX_TO_GPIO(MX51_PIN_CSI2_PIXCLK), "csi2_pixclk");
      gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_CSI2_PIXCLK), 0);
      gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_CSI2_PIXCLK), 1);
   #endif

   // not seting and connect
   // remark by pega Eric 2009.11.12
   #if ( 1 )
   // EIM_D18 - 22MHz_EN
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_EIM_D18), "eim_d18");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_EIM_D18), 0);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_D18), 1);
   #endif

   // pega not use this pin
   // remark by pega Eric 2009.11.12
   #if ( 0 )
   // EIM_A20 - reset FEC PHY
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_EIM_A20), "eim_a20");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_EIM_A20), 0);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A20), 0);
   msleep(10);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A20), 1);

   // EIM_A21 - reset FM
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_EIM_A21), "eim_a21");
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A21), 0);
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_EIM_A21), 0);
   msleep(10);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A21), 1);

   // EIM_A19 - deassert VGA reset to free i2c bus
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_EIM_A19), "eim_a19");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_EIM_A19), 0);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A19), 1);

   if ( cpu_is_mx51_rev(CHIP_REV_3_0) > 0 )
   {
      // DVI_I2C_ENB = 0 tristates the DVI I2C level shifter
      mxc_request_iomux(MX51_PIN_CSI2_HSYNC, IOMUX_CONFIG_ALT3);
      mxc_iomux_set_pad(MX51_PIN_CSI2_HSYNC, PAD_CTL_DRV_HIGH | PAD_CTL_PKE_ENABLE | PAD_CTL_SRE_FAST );
      gpio_request(IOMUX_TO_GPIO(MX51_PIN_CSI2_HSYNC), "csi2_hsync");
      gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_CSI2_HSYNC), 0);
      gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_CSI2_HSYNC), 0);

      // TO3 doesn't need pad to drive CSI_DATA_EN[0] high
      mxc_request_iomux(MX51_PIN_DI_GP3, IOMUX_CONFIG_ALT0);
   }

   if ( enable_w1 )
   {
      // OWIRE_LINE - OneWire
      mxc_request_iomux(MX51_PIN_OWIRE_LINE, IOMUX_CONFIG_ALT0);
      mxc_iomux_set_pad(MX51_PIN_OWIRE_LINE, PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH | PAD_CTL_HYS_ENABLE |
                                             PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL | PAD_CTL_100K_PU    |
                                             PAD_CTL_ODE_OPENDRAIN_ENABLE );
   }
   else
   {
      // OWIRE_LINE - SPDIF out
      mxc_request_iomux(MX51_PIN_OWIRE_LINE, IOMUX_CONFIG_ALT6);
      mxc_iomux_set_pad(MX51_PIN_OWIRE_LINE, PAD_CTL_SRE_FAST   | PAD_CTL_DRV_HIGH |
                                             PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL | PAD_CTL_100K_PU );
   }
   #endif

   // pega not use this pin for the function
   #if ( 0 )
   // GPIO1_1 = SD1 WP
   // GPIO1_1 = GPIO (out) --> MOTOR_EN = vibrator motor
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_GPIO1_1), "gpio1_1");
   gpio_direction_input(IOMUX_TO_GPIO(MX51_PIN_GPIO1_1));

   // GPIO1_5 - SD2 WP
   // GPIO1_5 = GPIO (out) --> BT_EN ( normal high ) = enable Bluetooth power
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_GPIO1_5), "gpio1_5");
   gpio_direction_input(IOMUX_TO_GPIO(MX51_PIN_GPIO1_5));

   // GPIO1_6 - SD2 CD
   // GPIO1_6 = GPIO (out) --> VCC_BP_3V3EN ( normal high ) = enable VDD_3V3 - EVT2
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_GPIO1_6), "gpio1_6");
   gpio_direction_input(IOMUX_TO_GPIO(MX51_PIN_GPIO1_6));

   // EIM_D17 = set USB_CLK_EN_B = 0 <-- pega EIM_D19 = USB_CLK_ENn = enable USB 26MHz clock
   // EIM_D17 = GPIO (in) -- HPHONE_DETn ( normal high - PU 68K ) = detect headphone insert
   mxc_request_iomux(MX51_PIN_EIM_D17, IOMUX_CONFIG_ALT1);
   mxc_iomux_set_pad(MX51_PIN_EIM_D17, PAD_CTL_DRV_HIGH | PAD_CTL_PKE_ENABLE | PAD_CTL_SRE_FAST);
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_EIM_D17), "eim_d17");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_EIM_D17), 0);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_D17), 0);

   // NANDF_D14 = HPHONE_DET_B
   // NANDF_D14 = PATA_DATA14 -- PATA_D14
   mxc_request_iomux(MX51_PIN_NANDF_D14, IOMUX_CONFIG_ALT3);
   mxc_iomux_set_pad(MX51_PIN_NANDF_D14, PAD_CTL_100K_PU);
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_NANDF_D14), "nandf_d14");
   gpio_direction_input(IOMUX_TO_GPIO(MX51_PIN_NANDF_D14));

   // LCD
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_DI1_D1_CS), "di1_d1_cs");
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_DI1_D0_CS), "di1_d0_cs");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_DI1_D1_CS), 0);
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_DI1_D0_CS), 0);

   // CSI2_D12 = LCD_3V3_ON <-- pega GPIO1_3 = LCDVDD_3V3_ON
   // CSI2_D12 = GPIO (out) --> OJ_SHUTDOWN ( normal low ) = Optical Joystick shutdown
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_CSI2_D12), "csi2_d12");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_CSI2_D12), 0);

   // CSI2_D13 =  LCD_5V_ON <-- pega CSI2_D19 = BL_EN
   // CSI2_D13 = GPIO (in) <-- OJ_MOTION ( normal high ) = joystick interrupt to CPU
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_CSI2_D13), "csi2_d13");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_CSI2_D13), 0);

   // EIM_D23 - camera reset
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_EIM_D23), "eim_d23");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_EIM_D23), 0);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_D23), 1);

   // CSI2_D19 - camera low power
   gpio_request(IOMUX_TO_GPIO(MX51_PIN_CSI2_D19), "csi2_d19");
   gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_CSI2_D19), 0);
   gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_CSI2_D19), 0);
   #endif
}

// for ecspi chipselect pin may not keep correct level when idle
void mx51_sendai_gpio_spi_chipselect_active(int cspi_mode, int status, int chipselect)
{
   u32 gpio;

   switch ( cspi_mode )
   {
      case 1:
      {
         switch ( chipselect )
         {
            case 0x01:
            {
               mxc_request_iomux(MX51_PIN_CSPI1_SS0, IOMUX_CONFIG_ALT0);
               mxc_iomux_set_pad(MX51_PIN_CSPI1_SS0, PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH |
                                                     PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_NONE );
               break;
            }
            case 0x02:
            {
               gpio = IOMUX_TO_GPIO(MX51_PIN_CSPI1_SS0);
               mxc_request_iomux(MX51_PIN_CSPI1_SS0, IOMUX_CONFIG_GPIO);
               gpio_request(gpio, "cspi1_ss0");
               gpio_direction_output(gpio, 0);
               gpio_set_value(gpio, 1 & (~status));
               break;
            }
            default:
               break;
         }
         break;
      }
      case 2:
         break;
      case 3:
         break;
      default:
         break;
   }
}
EXPORT_SYMBOL(mx51_sendai_gpio_spi_chipselect_active);

void mx51_sendai_gpio_spi_chipselect_inactive(int cspi_mode, int status, int chipselect)
{
   switch ( cspi_mode )
   {
      case 1:
      {
         switch ( chipselect )
         {
            case 0x01:
            {
               mxc_free_iomux(MX51_PIN_CSPI1_SS0, IOMUX_CONFIG_ALT0);
               mxc_request_iomux(MX51_PIN_CSPI1_SS0, IOMUX_CONFIG_GPIO);
               mxc_free_iomux(MX51_PIN_CSPI1_SS0, IOMUX_CONFIG_GPIO);
               break;
            }
            case 0x2:
            {
               mxc_free_iomux(MX51_PIN_CSPI1_SS0, IOMUX_CONFIG_GPIO);
               break;
            }
            default:
               break;
         }
         break;
      }
      case 2:
         break;
      case 3:
         break;
      default:
         break;
   }
}
EXPORT_SYMBOL(mx51_sendai_gpio_spi_chipselect_inactive);



#if ( 1 )

/*
 * all CSPI SSx inactive when reset
 */
void mx51_sendai_gpio_spi_chipselect_all_inactive (void)
{
	mxc_free_iomux(MX51_PIN_CSPI1_SS0, IOMUX_CONFIG_ALT0);
	mxc_request_iomux(MX51_PIN_CSPI1_SS0, IOMUX_CONFIG_GPIO);
	mxc_free_iomux(MX51_PIN_CSPI1_SS0, IOMUX_CONFIG_GPIO);
}

#endif


//------------------------------------------------------------------
// add / modify by pega Eric 2009.12.03
//------------------------------------------------------------------
// DI1_PIN12 = GPIO (out) --> 26M_OSC_EN ( normal high ) = enable 26MHz clock for USB / Audio
// GPIO1_6 = GPIO (out) --> VCC_BP_3V3EN ( normal high ) = enable VDD_3V3 - EVT2
// GPIO1_7 = GPIO (out) --> VCC_BP_5V2EN ( normal high ) = enable VDD_5V2 - EVT2
//------------------------------------------------------------------
#if ( DEVICE_SYSTEM )
void enable_26mhz(int enable)
{
   DEBUG_PRINTK(("[%s] = %d \n",  __func__, enable));

	if ( enable )
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_DI1_PIN12), 1);
	else
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_DI1_PIN12), 0);
}
EXPORT_SYMBOL(enable_26mhz);

void enable_vcc_3v3(int enable)
{
   DEBUG_PRINTK(("[%s] = %d \n",  __func__, enable));

	if ( enable )
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_GPIO1_6), 1);
	else
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_GPIO1_6), 0);
}
EXPORT_SYMBOL(enable_vcc_3v3);

void enable_vcc_5v2(int enable)
{
   DEBUG_PRINTK(("[%s] = %d \n",  __func__, enable));

	if ( enable )
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_GPIO1_7), 1);
	else
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_GPIO1_7), 0);
}
EXPORT_SYMBOL(enable_vcc_5v2);
#endif

//------------------------------------------------------------------
// EIM_D23 = GPIO (out) --> WL_RSTn ( normal high )
//------------------------------------------------------------------
#if ( DEVICE_WIFI )
void enable_wifi_reset(int enable)
{
   DEBUG_PRINTK(("[%s] = %d \n",  __func__, enable));

	if ( enable )
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_D23), 0);
	else
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_D23), 1);
}
EXPORT_SYMBOL(enable_wifi_reset);
#endif

//------------------------------------------------------------------
// EIM_A16 = GPIO (out) --> BT_RSTn ( normal high )
// GPIO1_5 = GPIO (out) --> BT_EN ( normal high ) = enable Bluetooth power
//------------------------------------------------------------------
#if ( DEVICE_BLUETOOTH )
void enable_bt_reset(int enable)
{
   DEBUG_PRINTK(("[%s] = %d \n",  __func__, enable));

	if ( enable )
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A16), 0);
	else
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A16), 1);
}
EXPORT_SYMBOL(enable_bt_reset);

void enable_bt_en(int enable)
{
   DEBUG_PRINTK(("[%s] = %d \n",  __func__, enable));

	if ( enable )
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_GPIO1_5), 1);
	else
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_GPIO1_5), 0);
}
EXPORT_SYMBOL(enable_bt_en);
#endif

//------------------------------------------------------------------
// Sharp LCD - add by pega Kevin 2009.10.22
//------------------------------------------------------------------
// DI1_D0_CS  = GPIO (out) --> LVDS_PWR_DWNn ( normal high ) = power down LVDS THC63LVDM63A-G
// GPIO1_3    = GPIO (out) --> LCDVDD_3V3_ON ( normal high ) = enable LCD 3.3V
// DISP2_DAT6 = GPIO (out) --> LCDBL_ON ( normal high )      = enable LCD Backlight 5.2V
// CSI2_D19   = GPIO (out) --> BL_EN ( normal high )         = enable LCD Backlight
//------------------------------------------------------------------
#if ( DEVICE_LCD )
void enable_lcd_power(int enable)
{
   DEBUG_PRINTK(("[%s] = %d \n",  __func__, enable));

   if ( enable )
   {
      gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_DI1_D0_CS), 1);  // enable LCD LVDS           = LVDS_PWR_DWNn = 1
      gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_GPIO1_3), 1);    // enable LCD 3.3V           = LCDVDD_3V3_ON = 1
      mdelay(180);
      gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_DISP2_DAT6), 1); // enable LCD Backlight 5.2V = LCDBL_ON = 1
      gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_CSI2_D19), 1);   // enable LCD Backlight      = BL_EN = 1
   }
   else
   {
      gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_CSI2_D19), 0);   // disable LCD Backlight      = BL_EN = 0
      gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_DISP2_DAT6), 0); // disable LCD Backlight 5.2V = LCDBL_ON = 0
      mdelay(5);
      gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_GPIO1_3), 0);    // disable LCD 3.3V           = LCDVDD_3V3_ON = 0
      gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_DI1_D0_CS), 0);  // disable LCD LVDS           = LVDS_PWR_DWNn = 0
   }
}
EXPORT_SYMBOL(enable_lcd_power);
#endif

//------------------------------------------------------------------
// EIM_A23   = GPIO (out) --> AUDAMP_STBYn ( normal low - PU 10K ?? ) = control AMP power down
// CSPI1_RDY = GPIO (out) --> AUDIO_CLK_ENn ( normal low )            = enable Audio 26MHz clock
//------------------------------------------------------------------
#if ( DEVICE_AUDIO )
void enable_sound_amp(int enable)
{
   DEBUG_PRINTK(("[%s] = %d \n",  __func__, enable));

	if ( enable )
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A23), 1);
	else
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A23), 0);
}
EXPORT_SYMBOL(enable_sound_amp);

void enable_sound_clock(int enable)
{
   DEBUG_PRINTK(("[%s] = %d \n",  __func__, enable));

	if ( enable )
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_CSPI1_RDY), 0);
	else
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_CSPI1_RDY), 1);
}
EXPORT_SYMBOL(enable_sound_clock);
#endif

//------------------------------------------------------------------
// Optical Joystick - add by pega Kevin 2009.10.23
//------------------------------------------------------------------
// CSI2_D12 = GPIO (out) --> OJ_SHUTDOWN ( normal low ) = Optical Joystick shutdown
//------------------------------------------------------------------
#if ( DEVICE_JOYSTICK )
void enable_oj_shutdown(int enable)
{
   DEBUG_PRINTK(("[%s] = %d \n",  __func__, enable));

   if ( enable )
      gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_CSI2_D12), 1); // spider1 = MX51_PIN_CSI1_VSYNC
   else
      gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_CSI2_D12), 0); // spider1 = MX51_PIN_CSI1_VSYNC
}
EXPORT_SYMBOL(enable_oj_shutdown);
#endif

//------------------------------------------------------------------
// Vibrator Motor - add by pega Kevin 2009.11.02
//------------------------------------------------------------------
// GPIO1_1 = GPIO (out) --> MOTOR_EN = vibrator motor
//------------------------------------------------------------------
#if ( DEVICE_VIBRATOR )
void enable_motor(int enable)
{
   DEBUG_PRINTK(("[%s] = %d \n",  __func__, enable));

	if ( enable )
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_GPIO1_1), 1);
	else
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_GPIO1_1), 0);
}
EXPORT_SYMBOL(enable_motor);
#endif

//------------------------------------------------------------------
// EIM_D19 = GPIO (out) --> USB_CLK_ENn ( normal low ) = enable USB 26MHz clock
//------------------------------------------------------------------
#if ( DEVICE_USB )
void enable_usb_clock(int enable)
{
   DEBUG_PRINTK(("[%s] = %d \n",  __func__, enable));

	if ( enable )
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_D19), 0);
	else
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_D19), 1);
}
EXPORT_SYMBOL(enable_usb_clock);

void gpio_usb_power(struct platform_device *pdev, int on)
{
	extern void fsl_platform_set_vbus_power(struct fsl_usb2_platform_data *pdata, int on);
	struct fsl_usb2_platform_data *pdata;

	if (pdev == 0) {
		return;
	}
	pdata = pdev->dev.platform_data;
	if (strcmp (pdata->name, "Host 1") == 0) {
		/*
		 * check HOST-1
		 */
		;
	} else if (strcmp (pdata->name, (char *)"DR") == 0) {
		/*
		 * DR otg-host
		 */
		extern void dr_udc_suspend (void);
		extern void dr_udc_resume (void);
		if (on) {
			dr_udc_resume ();
		} else {
			dr_udc_suspend ();
		}
		return;
	} else {
		return;
	}
	if (on) {
		/* do resume */
		/* Drive 26M_OSC_EN line high */
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_DI1_PIN12), 1);

		/* Drive USB_CLK_EN_B line low  */
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_D19), 0);

		/* MX51_PIN_EIM_D21 - De-assert USB PHY RESETB */
		mdelay ( 10 );
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_D21), 1);
		mdelay ( 5 );

		/* VBUS enable */
		fsl_platform_set_vbus_power (pdata, 1);
	} else {
		/* do suspend */
		/* MX51_PIN_EIM_D21 - assert USB PHY RESETB */
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_D21), 0);

		/* Drive USB_CLK_EN_B line high */
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_D19), 1);

		/* Drive 26M_OSC_EN line low */
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_DI1_PIN12), 0);
	}
}
EXPORT_SYMBOL(gpio_usb_power);
#endif

#ifdef GPIO_EVENT_CYCLE
#include <linux/io.h>
#define POLL_FINISH  (16)		/* polling finish at IRQ */
/*
 * GPIO EVENT
 */
struct _gpio_event {
    void (*func)(void *arg, int onoff);		/* callback */
    void *arg;					/* argument */
};
struct _gpio_event_stat {
    int               init;					/* initialized mark */
    int               polling;					/* polling counter */
    int               called;					/* called counter */
    unsigned long     status [GPIO_PORT_NUM];			/* old status */
    unsigned long     regist [GPIO_PORT_NUM];			/* regist mark */
    char              transfer [GPIO_PORT_NUM][GPIO_NUM_PIN];	/* transfer drop count */
    struct timer_list timer;					/* cycle timer */
};
static struct _gpio_event_stat gpio_event_stat;
static struct _gpio_event      gpio_event [GPIO_PORT_NUM][GPIO_NUM_PIN];

/*
 * GPIO interrupt, 20ms interval called(POLL_FINISH times) by timer
 */
static void gpio_event_poll (unsigned long dummy)
{
	unsigned long       nval [GPIO_PORT_NUM], chg, mask;
	int                 port, pin;
	struct _gpio_event *p;

	gpio_event_stat.called++;
	/*
	 * current GPIO status
	 */
	nval [0] = __raw_readl (IO_ADDRESS(GPIO1_BASE_ADDR)+0x00);
	nval [1] = __raw_readl (IO_ADDRESS(GPIO2_BASE_ADDR)+0x00);
	nval [2] = __raw_readl (IO_ADDRESS(GPIO3_BASE_ADDR)+0x00);
	nval [3] = __raw_readl (IO_ADDRESS(GPIO4_BASE_ADDR)+0x00);

	/*
	 * check ON/OFF change
	 */
	for ( port = 0 ; port < GPIO_PORT_NUM ; port++ ) {
		if (gpio_event_stat.status [port] == nval [port]) {
			continue;
		}
		p    = &(gpio_event [port][0]);
		chg  = gpio_event_stat.status [port] ^ nval [port];
		mask = 0x00000001;
		if ((chg & gpio_event_stat.regist [port]) != 0) {
			for ( pin = 0 ; pin < GPIO_NUM_PIN ; pin++ , p++ , mask = mask << 1 ) {
				if ((p->func != 0) && ((chg & mask) != 0)) {
					/*
					 * change mark
					 */
					gpio_event_stat.transfer [port][pin] = 0;
				}
			}
		}
		gpio_event_stat.status [port] = nval [port];
	}

	/*
	 * check transfer stable
         *
         *      +--------+     +----+            (input status)
         *   ---+        +-----+    +----------
         *    |  |  |  |  |  |  |  |  |  |  |  | (sample timing)
         *    3  01 2  3  01 2  01 2  01 2  3    (value of transfer)
         *             +--------------------+
         *   ----------+                    +--- (fixed status)
         *             @                    @    (event callback)
	 */
	for ( port = 0 ; port < GPIO_PORT_NUM ; port++ ) {
		p    = &(gpio_event [port][0]);
		mask = 0x00000001;
		if (gpio_event_stat.regist [port] != 0) {
			for ( pin = 0 ; pin < GPIO_NUM_PIN ; pin++ , p++ , mask = mask << 1 ) {
				if (3 <= gpio_event_stat.transfer [port][pin]) {
					continue;
				}
				gpio_event_stat.transfer [port][pin]++;
				if ((p->func != 0) &&
				    (3 <= gpio_event_stat.transfer [port][pin])) {
					if ((nval [port] & mask) == 0) {
						(*p->func)(p->arg, 0);	/* ON -> OFF */
					} else {
						(*p->func)(p->arg, 1);	/* OFF -> ON */
					}
				}
			}
		}
	}

	/*
	 * check need next polling
	 */
	gpio_event_stat.polling++;
	if (gpio_event_stat.polling < POLL_FINISH) {
		mod_timer (&gpio_event_stat.timer, jiffies + GPIO_EVENT_CYCLE * HZ / 1000);
	}
}

/*
 * GPIO INTERRUPT ANNOUNCE
 */
int gpio_event_announce (int irq)
{
	int                 port, pin;
	struct _gpio_event *p;

	/*
	 * check IRQ(GPIO PORT/BIT)
	 */
	if ((irq < MXC_GPIO_INT_BASE) ||
	    ((MXC_GPIO_INT_BASE + GPIO_PORT_NUM * GPIO_NUM_PIN) <= irq)) { 
		return -1;
	}
	/*
	 * check register
	 */
	port = (irq - MXC_GPIO_INT_BASE) / GPIO_NUM_PIN;
	pin  = (irq - MXC_GPIO_INT_BASE) % GPIO_NUM_PIN;
	p    = &(gpio_event [port][pin]);
	if (p->func == 0) {
		return -1;
	}

	/*
	 * polling start at GPIO status change.
	 */
	gpio_event_stat.polling = 0;
	gpio_event_poll ( 0 );

	return 0;
}

/*
 * GPIO ON/OFF EVENT REGISTER
 */
int gpio_event_register (int irq, void (*func)(void *arg, int onoff), void *arg)
{
	int                 port, pin;
	struct _gpio_event *p;

	/*
	 * check IRQ(GPIO PORT/BIT)
	 */
	if ((irq < MXC_GPIO_INT_BASE) ||
	    ((MXC_GPIO_INT_BASE + GPIO_PORT_NUM * GPIO_NUM_PIN) <= irq)) { 
		return -1;
	}
	/*
	 * check already register
	 */
	port = (irq - MXC_GPIO_INT_BASE) / GPIO_NUM_PIN;
	pin  = (irq - MXC_GPIO_INT_BASE) % GPIO_NUM_PIN;
	p    = &(gpio_event [port][pin]);
	if (p->func != 0) {
		return -1;
	}
	/*
	 * event register
	 */
	p->arg  = arg;
	p->func = func;
	gpio_event_stat.regist [port] |= (0x00000001 << pin);

	if (gpio_event_stat.init == 0) {
		gpio_event_stat.init = 1;
		/*
		 * first status
		 */
		for ( port = 0 ; port < GPIO_PORT_NUM ; port++ ) {
			for ( pin = 0 ; pin < GPIO_NUM_PIN ; pin++ ) {
				gpio_event_stat.transfer [port][pin] = 3;
			}
		}
		gpio_event_stat.status[0] = __raw_readl(IO_ADDRESS(GPIO1_BASE_ADDR)+0x00);
		gpio_event_stat.status[1] = __raw_readl(IO_ADDRESS(GPIO2_BASE_ADDR)+0x00);
		gpio_event_stat.status[2] = __raw_readl(IO_ADDRESS(GPIO3_BASE_ADDR)+0x00);
		gpio_event_stat.status[3] = __raw_readl(IO_ADDRESS(GPIO4_BASE_ADDR)+0x00);
		init_timer (&gpio_event_stat.timer);
		gpio_event_stat.timer.function = gpio_event_poll;
	}
	return 0;
}

/*
 * GPIO ON/OFF EVENT UNREGISTER
 */
int gpio_event_unregister (int irq)
{
	int                 port, pin;
	struct _gpio_event *p;

	/*
	 * check IRQ(GPIO PORT/BIT)
	 */
	if ((irq < MXC_GPIO_INT_BASE) ||
	    ((MXC_GPIO_INT_BASE + GPIO_PORT_NUM * GPIO_NUM_PIN) <= irq)) { 
		return -1;
	}
	/*
	 * check register
	 */
	port = (irq - MXC_GPIO_INT_BASE) / GPIO_NUM_PIN;
	pin  = (irq - MXC_GPIO_INT_BASE) % GPIO_NUM_PIN;
	p    = &(gpio_event [port][pin]);
	if (p->func == 0) {
		return -1;
	}
	p->func = 0;
	p->arg  = 0;
	gpio_event_stat.regist [port] &= ~(0x00000001 << pin);
	return 0;
}
#endif /* GPIO_EVENT_CYCLE */
