/*
 * STMP AUDIOIN Register Definitions
 *
 * Copyright 2008-2009 Freescale Semiconductor
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef __ARCH_ARM___AUDIOIN_H
#define __ARCH_ARM___AUDIOIN_H  1

#include <mach/stmp3xxx_regs.h>

#define REGS_AUDIOIN_BASE (REGS_BASE + 0x4c000)
#define REGS_AUDIOIN_BASE_PHYS (0x8004C000)
#define REGS_AUDIOIN_SIZE 0x00002000
HW_REGISTER(HW_AUDIOIN_CTRL, REGS_AUDIOIN_BASE, 0x00000000)
#define HW_AUDIOIN_CTRL_ADDR (REGS_AUDIOIN_BASE + 0x00000000)
#define BM_AUDIOIN_CTRL_SFTRST 0x80000000
#define BM_AUDIOIN_CTRL_CLKGATE 0x40000000
#define BP_AUDIOIN_CTRL_DMAWAIT_COUNT      16
#define BM_AUDIOIN_CTRL_DMAWAIT_COUNT 0x001F0000
#define BF_AUDIOIN_CTRL_DMAWAIT_COUNT(v)  \
	(((v) << 16) & BM_AUDIOIN_CTRL_DMAWAIT_COUNT)
#define BM_AUDIOIN_CTRL_LR_SWAP 0x00000400
#define BM_AUDIOIN_CTRL_EDGE_SYNC 0x00000200
#define BM_AUDIOIN_CTRL_INVERT_1BIT 0x00000100
#define BM_AUDIOIN_CTRL_OFFSET_ENABLE 0x00000080
#define BM_AUDIOIN_CTRL_HPF_ENABLE 0x00000040
#define BM_AUDIOIN_CTRL_WORD_LENGTH 0x00000020
#define BM_AUDIOIN_CTRL_LOOPBACK 0x00000010
#define BM_AUDIOIN_CTRL_FIFO_UNDERFLOW_IRQ 0x00000008
#define BM_AUDIOIN_CTRL_FIFO_OVERFLOW_IRQ 0x00000004
#define BM_AUDIOIN_CTRL_FIFO_ERROR_IRQ_EN 0x00000002
#define BM_AUDIOIN_CTRL_RUN 0x00000001
HW_REGISTER(HW_AUDIOIN_STAT, REGS_AUDIOIN_BASE, 0x00000010)
#define HW_AUDIOIN_STAT_ADDR (REGS_AUDIOIN_BASE + 0x00000010)
#define BM_AUDIOIN_STAT_ADC_PRESENT 0x80000000
HW_REGISTER(HW_AUDIOIN_ADCSRR, REGS_AUDIOIN_BASE, 0x00000020)
#define HW_AUDIOIN_ADCSRR_ADDR (REGS_AUDIOIN_BASE + 0x00000020)
#define BM_AUDIOIN_ADCSRR_OSR 0x80000000
#define BV_AUDIOIN_ADCSRR_OSR__OSR6  0x0
#define BV_AUDIOIN_ADCSRR_OSR__OSR12 0x1
#define BP_AUDIOIN_ADCSRR_BASEMULT      28
#define BM_AUDIOIN_ADCSRR_BASEMULT 0x70000000
#define BF_AUDIOIN_ADCSRR_BASEMULT(v)  \
	(((v) << 28) & BM_AUDIOIN_ADCSRR_BASEMULT)
#define BV_AUDIOIN_ADCSRR_BASEMULT__SINGLE_RATE 0x1
#define BV_AUDIOIN_ADCSRR_BASEMULT__DOUBLE_RATE 0x2
#define BV_AUDIOIN_ADCSRR_BASEMULT__QUAD_RATE   0x4
#define BP_AUDIOIN_ADCSRR_SRC_HOLD      24
#define BM_AUDIOIN_ADCSRR_SRC_HOLD 0x07000000
#define BF_AUDIOIN_ADCSRR_SRC_HOLD(v)  \
	(((v) << 24) & BM_AUDIOIN_ADCSRR_SRC_HOLD)
#define BP_AUDIOIN_ADCSRR_SRC_INT      16
#define BM_AUDIOIN_ADCSRR_SRC_INT 0x001F0000
#define BF_AUDIOIN_ADCSRR_SRC_INT(v)  \
	(((v) << 16) & BM_AUDIOIN_ADCSRR_SRC_INT)
#define BP_AUDIOIN_ADCSRR_SRC_FRAC      0
#define BM_AUDIOIN_ADCSRR_SRC_FRAC 0x00001FFF
#define BF_AUDIOIN_ADCSRR_SRC_FRAC(v)  \
	(((v) << 0) & BM_AUDIOIN_ADCSRR_SRC_FRAC)
HW_REGISTER(HW_AUDIOIN_ADCVOLUME, REGS_AUDIOIN_BASE, 0x00000030)
#define HW_AUDIOIN_ADCVOLUME_ADDR (REGS_AUDIOIN_BASE + 0x00000030)
#define BM_AUDIOIN_ADCVOLUME_VOLUME_UPDATE_LEFT 0x10000000
#define BM_AUDIOIN_ADCVOLUME_EN_ZCD 0x02000000
#define BP_AUDIOIN_ADCVOLUME_VOLUME_LEFT      16
#define BM_AUDIOIN_ADCVOLUME_VOLUME_LEFT 0x00FF0000
#define BF_AUDIOIN_ADCVOLUME_VOLUME_LEFT(v)  \
	(((v) << 16) & BM_AUDIOIN_ADCVOLUME_VOLUME_LEFT)
#define BM_AUDIOIN_ADCVOLUME_VOLUME_UPDATE_RIGHT 0x00001000
#define BP_AUDIOIN_ADCVOLUME_VOLUME_RIGHT      0
#define BM_AUDIOIN_ADCVOLUME_VOLUME_RIGHT 0x000000FF
#define BF_AUDIOIN_ADCVOLUME_VOLUME_RIGHT(v)  \
	(((v) << 0) & BM_AUDIOIN_ADCVOLUME_VOLUME_RIGHT)
HW_REGISTER(HW_AUDIOIN_ADCDEBUG, REGS_AUDIOIN_BASE, 0x00000040)
#define HW_AUDIOIN_ADCDEBUG_ADDR (REGS_AUDIOIN_BASE + 0x00000040)
#define BM_AUDIOIN_ADCDEBUG_ENABLE_ADCDMA 0x80000000
#define BM_AUDIOIN_ADCDEBUG_ADC_DMA_REQ_HAND_SHAKE_CLK_CROSS 0x00000008
#define BM_AUDIOIN_ADCDEBUG_SET_INTERRUPT3_HAND_SHAKE 0x00000004
#define BM_AUDIOIN_ADCDEBUG_DMA_PREQ 0x00000002
#define BM_AUDIOIN_ADCDEBUG_FIFO_STATUS 0x00000001
HW_REGISTER(HW_AUDIOIN_ADCVOL, REGS_AUDIOIN_BASE, 0x00000050)
#define HW_AUDIOIN_ADCVOL_ADDR (REGS_AUDIOIN_BASE + 0x00000050)
#define BM_AUDIOIN_ADCVOL_VOLUME_UPDATE_PENDING 0x10000000
#define BM_AUDIOIN_ADCVOL_EN_ADC_ZCD 0x02000000
#define BM_AUDIOIN_ADCVOL_MUTE 0x01000000
#define BP_AUDIOIN_ADCVOL_SELECT_LEFT      12
#define BM_AUDIOIN_ADCVOL_SELECT_LEFT 0x00003000
#define BF_AUDIOIN_ADCVOL_SELECT_LEFT(v)  \
	(((v) << 12) & BM_AUDIOIN_ADCVOL_SELECT_LEFT)
#define BP_AUDIOIN_ADCVOL_GAIN_LEFT      8
#define BM_AUDIOIN_ADCVOL_GAIN_LEFT 0x00000F00
#define BF_AUDIOIN_ADCVOL_GAIN_LEFT(v)  \
	(((v) << 8) & BM_AUDIOIN_ADCVOL_GAIN_LEFT)
#define BP_AUDIOIN_ADCVOL_SELECT_RIGHT      4
#define BM_AUDIOIN_ADCVOL_SELECT_RIGHT 0x00000030
#define BF_AUDIOIN_ADCVOL_SELECT_RIGHT(v)  \
	(((v) << 4) & BM_AUDIOIN_ADCVOL_SELECT_RIGHT)
#define BP_AUDIOIN_ADCVOL_GAIN_RIGHT      0
#define BM_AUDIOIN_ADCVOL_GAIN_RIGHT 0x0000000F
#define BF_AUDIOIN_ADCVOL_GAIN_RIGHT(v)  \
	(((v) << 0) & BM_AUDIOIN_ADCVOL_GAIN_RIGHT)
HW_REGISTER(HW_AUDIOIN_MICLINE, REGS_AUDIOIN_BASE, 0x00000060)
#define HW_AUDIOIN_MICLINE_ADDR (REGS_AUDIOIN_BASE + 0x00000060)
#define BM_AUDIOIN_MICLINE_DIVIDE_LINE1 0x20000000
#define BM_AUDIOIN_MICLINE_DIVIDE_LINE2 0x10000000
#define BM_AUDIOIN_MICLINE_MIC_SELECT 0x01000000
#define BP_AUDIOIN_MICLINE_MIC_RESISTOR      20
#define BM_AUDIOIN_MICLINE_MIC_RESISTOR 0x00300000
#define BF_AUDIOIN_MICLINE_MIC_RESISTOR(v)  \
	(((v) << 20) & BM_AUDIOIN_MICLINE_MIC_RESISTOR)
#define BP_AUDIOIN_MICLINE_MIC_BIAS      16
#define BM_AUDIOIN_MICLINE_MIC_BIAS 0x00070000
#define BF_AUDIOIN_MICLINE_MIC_BIAS(v)  \
	(((v) << 16) & BM_AUDIOIN_MICLINE_MIC_BIAS)
#define BP_AUDIOIN_MICLINE_MIC_CHOPCLK      4
#define BM_AUDIOIN_MICLINE_MIC_CHOPCLK 0x00000030
#define BF_AUDIOIN_MICLINE_MIC_CHOPCLK(v)  \
	(((v) << 4) & BM_AUDIOIN_MICLINE_MIC_CHOPCLK)
#define BP_AUDIOIN_MICLINE_MIC_GAIN      0
#define BM_AUDIOIN_MICLINE_MIC_GAIN 0x00000003
#define BF_AUDIOIN_MICLINE_MIC_GAIN(v)  \
	(((v) << 0) & BM_AUDIOIN_MICLINE_MIC_GAIN)
HW_REGISTER(HW_AUDIOIN_ANACLKCTRL, REGS_AUDIOIN_BASE, 0x00000070)
#define HW_AUDIOIN_ANACLKCTRL_ADDR (REGS_AUDIOIN_BASE + 0x00000070)
#define BM_AUDIOIN_ANACLKCTRL_CLKGATE 0x80000000
#define BM_AUDIOIN_ANACLKCTRL_DITHER_OFF 0x00000400
#define BM_AUDIOIN_ANACLKCTRL_SLOW_DITHER 0x00000200
#define BM_AUDIOIN_ANACLKCTRL_INVERT_ADCCLK 0x00000100
#define BP_AUDIOIN_ANACLKCTRL_ADCCLK_SHIFT      4
#define BM_AUDIOIN_ANACLKCTRL_ADCCLK_SHIFT 0x00000030
#define BF_AUDIOIN_ANACLKCTRL_ADCCLK_SHIFT(v)  \
	(((v) << 4) & BM_AUDIOIN_ANACLKCTRL_ADCCLK_SHIFT)
#define BP_AUDIOIN_ANACLKCTRL_ADCDIV      0
#define BM_AUDIOIN_ANACLKCTRL_ADCDIV 0x00000007
#define BF_AUDIOIN_ANACLKCTRL_ADCDIV(v)  \
	(((v) << 0) & BM_AUDIOIN_ANACLKCTRL_ADCDIV)
HW_REGISTER(HW_AUDIOIN_DATA, REGS_AUDIOIN_BASE, 0x00000080)
#define HW_AUDIOIN_DATA_ADDR (REGS_AUDIOIN_BASE + 0x00000080)
#define BP_AUDIOIN_DATA_HIGH      16
#define BM_AUDIOIN_DATA_HIGH 0xFFFF0000
#define BF_AUDIOIN_DATA_HIGH(v) \
	(((v) << 16) & BM_AUDIOIN_DATA_HIGH)
#define BP_AUDIOIN_DATA_LOW      0
#define BM_AUDIOIN_DATA_LOW 0x0000FFFF
#define BF_AUDIOIN_DATA_LOW(v)  \
	(((v) << 0) & BM_AUDIOIN_DATA_LOW)
#endif /* __ARCH_ARM___AUDIOIN_H */
