/*
 * STMP TVENC Register Definitions
 *
 * Copyright 2008-2009 Freescale Semiconductor
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef __ARCH_ARM___TVENC_H
#define __ARCH_ARM___TVENC_H  1

#include <mach/stmp3xxx_regs.h>

#define REGS_TVENC_BASE (REGS_BASE + 0x38000)
#define REGS_TVENC_BASE_PHYS (0x80038000)
#define REGS_TVENC_SIZE 0x00002000
HW_REGISTER(HW_TVENC_CTRL, REGS_TVENC_BASE, 0x00000000)
#define HW_TVENC_CTRL_ADDR (REGS_TVENC_BASE + 0x00000000)
#define BM_TVENC_CTRL_SFTRST 0x80000000
#define BM_TVENC_CTRL_CLKGATE 0x40000000
#define BM_TVENC_CTRL_TVENC_MACROVISION_PRESENT 0x20000000
#define BM_TVENC_CTRL_TVENC_COMPOSITE_PRESENT 0x10000000
#define BM_TVENC_CTRL_TVENC_SVIDEO_PRESENT 0x08000000
#define BM_TVENC_CTRL_TVENC_COMPONENT_PRESENT 0x04000000
#define BM_TVENC_CTRL_DAC_FIFO_NO_WRITE 0x00000020
#define BM_TVENC_CTRL_DAC_FIFO_NO_READ 0x00000010
#define BM_TVENC_CTRL_DAC_DATA_FIFO_RST 0x00000008
#define BM_TVENC_CTRL_DAC_MUX_MODE 0x00000001
HW_REGISTER(HW_TVENC_CONFIG, REGS_TVENC_BASE, 0x00000010)
#define HW_TVENC_CONFIG_ADDR (REGS_TVENC_BASE + 0x00000010)
#define BM_TVENC_CONFIG_DEFAULT_PICFORM 0x08000000
#define BP_TVENC_CONFIG_YDEL_ADJ      24
#define BM_TVENC_CONFIG_YDEL_ADJ 0x07000000
#define BF_TVENC_CONFIG_YDEL_ADJ(v)  \
	(((v) << 24) & BM_TVENC_CONFIG_YDEL_ADJ)
#define BM_TVENC_CONFIG_ADD_YPBPR_PED 0x00200000
#define BM_TVENC_CONFIG_PAL_SHAPE 0x00100000
#define BM_TVENC_CONFIG_NO_PED 0x00080000
#define BM_TVENC_CONFIG_COLOR_BAR_EN 0x00040000
#define BP_TVENC_CONFIG_YGAIN_SEL      16
#define BM_TVENC_CONFIG_YGAIN_SEL 0x00030000
#define BF_TVENC_CONFIG_YGAIN_SEL(v)  \
	(((v) << 16) & BM_TVENC_CONFIG_YGAIN_SEL)
#define BP_TVENC_CONFIG_CGAIN      14
#define BM_TVENC_CONFIG_CGAIN 0x0000C000
#define BF_TVENC_CONFIG_CGAIN(v)  \
	(((v) << 14) & BM_TVENC_CONFIG_CGAIN)
#define BP_TVENC_CONFIG_CLK_PHS      12
#define BM_TVENC_CONFIG_CLK_PHS 0x00003000
#define BF_TVENC_CONFIG_CLK_PHS(v)  \
	(((v) << 12) & BM_TVENC_CONFIG_CLK_PHS)
#define BM_TVENC_CONFIG_FSYNC_ENBL 0x00000400
#define BM_TVENC_CONFIG_FSYNC_PHS 0x00000200
#define BM_TVENC_CONFIG_HSYNC_PHS 0x00000100
#define BM_TVENC_CONFIG_VSYNC_PHS 0x00000080
#define BP_TVENC_CONFIG_SYNC_MODE      4
#define BM_TVENC_CONFIG_SYNC_MODE 0x00000070
#define BF_TVENC_CONFIG_SYNC_MODE(v)  \
	(((v) << 4) & BM_TVENC_CONFIG_SYNC_MODE)
#define BP_TVENC_CONFIG_ENCD_MODE      0
#define BM_TVENC_CONFIG_ENCD_MODE 0x00000007
#define BF_TVENC_CONFIG_ENCD_MODE(v)  \
	(((v) << 0) & BM_TVENC_CONFIG_ENCD_MODE)
HW_REGISTER(HW_TVENC_FILTCTRL, REGS_TVENC_BASE, 0x00000020)
#define HW_TVENC_FILTCTRL_ADDR (REGS_TVENC_BASE + 0x00000020)
#define BM_TVENC_FILTCTRL_YSHARP_BW 0x00080000
#define BM_TVENC_FILTCTRL_YD_OFFSETSEL 0x00040000
#define BM_TVENC_FILTCTRL_SEL_YLPF 0x00020000
#define BM_TVENC_FILTCTRL_SEL_CLPF 0x00010000
#define BM_TVENC_FILTCTRL_SEL_YSHARP 0x00008000
#define BM_TVENC_FILTCTRL_YLPF_COEFSEL 0x00004000
#define BM_TVENC_FILTCTRL_COEFSEL_CLPF 0x00002000
#define BM_TVENC_FILTCTRL_YS_GAINSGN 0x00001000
#define BP_TVENC_FILTCTRL_YS_GAINSEL      10
#define BM_TVENC_FILTCTRL_YS_GAINSEL 0x00000C00
#define BF_TVENC_FILTCTRL_YS_GAINSEL(v)  \
	(((v) << 10) & BM_TVENC_FILTCTRL_YS_GAINSEL)
HW_REGISTER(HW_TVENC_SYNCOFFSET, REGS_TVENC_BASE, 0x00000030)
#define HW_TVENC_SYNCOFFSET_ADDR (REGS_TVENC_BASE + 0x00000030)
#define BP_TVENC_SYNCOFFSET_HSO      20
#define BM_TVENC_SYNCOFFSET_HSO 0x7FF00000
#define BF_TVENC_SYNCOFFSET_HSO(v)  \
	(((v) << 20) & BM_TVENC_SYNCOFFSET_HSO)
#define BP_TVENC_SYNCOFFSET_VSO      10
#define BM_TVENC_SYNCOFFSET_VSO 0x000FFC00
#define BF_TVENC_SYNCOFFSET_VSO(v)  \
	(((v) << 10) & BM_TVENC_SYNCOFFSET_VSO)
#define BP_TVENC_SYNCOFFSET_HLC      0
#define BM_TVENC_SYNCOFFSET_HLC 0x000003FF
#define BF_TVENC_SYNCOFFSET_HLC(v)  \
	(((v) << 0) & BM_TVENC_SYNCOFFSET_HLC)
HW_REGISTER(HW_TVENC_HTIMINGSYNC0, REGS_TVENC_BASE, 0x00000040)
#define HW_TVENC_HTIMINGSYNC0_ADDR (REGS_TVENC_BASE + 0x00000040)
#define BP_TVENC_HTIMINGSYNC0_SYNC_END      16
#define BM_TVENC_HTIMINGSYNC0_SYNC_END 0x03FF0000
#define BF_TVENC_HTIMINGSYNC0_SYNC_END(v)  \
	(((v) << 16) & BM_TVENC_HTIMINGSYNC0_SYNC_END)
#define BP_TVENC_HTIMINGSYNC0_SYNC_STRT      0
#define BM_TVENC_HTIMINGSYNC0_SYNC_STRT 0x000003FF
#define BF_TVENC_HTIMINGSYNC0_SYNC_STRT(v)  \
	(((v) << 0) & BM_TVENC_HTIMINGSYNC0_SYNC_STRT)
HW_REGISTER(HW_TVENC_HTIMINGSYNC1, REGS_TVENC_BASE, 0x00000050)
#define HW_TVENC_HTIMINGSYNC1_ADDR (REGS_TVENC_BASE + 0x00000050)
#define BP_TVENC_HTIMINGSYNC1_SYNC_EQEND      16
#define BM_TVENC_HTIMINGSYNC1_SYNC_EQEND 0x03FF0000
#define BF_TVENC_HTIMINGSYNC1_SYNC_EQEND(v)  \
	(((v) << 16) & BM_TVENC_HTIMINGSYNC1_SYNC_EQEND)
#define BP_TVENC_HTIMINGSYNC1_SYNC_SREND      0
#define BM_TVENC_HTIMINGSYNC1_SYNC_SREND 0x000003FF
#define BF_TVENC_HTIMINGSYNC1_SYNC_SREND(v)  \
	(((v) << 0) & BM_TVENC_HTIMINGSYNC1_SYNC_SREND)
HW_REGISTER(HW_TVENC_HTIMINGACTIVE, REGS_TVENC_BASE, 0x00000060)
#define HW_TVENC_HTIMINGACTIVE_ADDR (REGS_TVENC_BASE + 0x00000060)
#define BP_TVENC_HTIMINGACTIVE_ACTV_END      16
#define BM_TVENC_HTIMINGACTIVE_ACTV_END 0x03FF0000
#define BF_TVENC_HTIMINGACTIVE_ACTV_END(v)  \
	(((v) << 16) & BM_TVENC_HTIMINGACTIVE_ACTV_END)
#define BP_TVENC_HTIMINGACTIVE_ACTV_STRT      0
#define BM_TVENC_HTIMINGACTIVE_ACTV_STRT 0x000003FF
#define BF_TVENC_HTIMINGACTIVE_ACTV_STRT(v)  \
	(((v) << 0) & BM_TVENC_HTIMINGACTIVE_ACTV_STRT)
HW_REGISTER(HW_TVENC_HTIMINGBURST0, REGS_TVENC_BASE, 0x00000070)
#define HW_TVENC_HTIMINGBURST0_ADDR (REGS_TVENC_BASE + 0x00000070)
#define BP_TVENC_HTIMINGBURST0_WBRST_STRT      16
#define BM_TVENC_HTIMINGBURST0_WBRST_STRT 0x03FF0000
#define BF_TVENC_HTIMINGBURST0_WBRST_STRT(v)  \
	(((v) << 16) & BM_TVENC_HTIMINGBURST0_WBRST_STRT)
#define BP_TVENC_HTIMINGBURST0_NBRST_STRT      0
#define BM_TVENC_HTIMINGBURST0_NBRST_STRT 0x000003FF
#define BF_TVENC_HTIMINGBURST0_NBRST_STRT(v)  \
	(((v) << 0) & BM_TVENC_HTIMINGBURST0_NBRST_STRT)
HW_REGISTER(HW_TVENC_HTIMINGBURST1, REGS_TVENC_BASE, 0x00000080)
#define HW_TVENC_HTIMINGBURST1_ADDR (REGS_TVENC_BASE + 0x00000080)
#define BP_TVENC_HTIMINGBURST1_BRST_END      0
#define BM_TVENC_HTIMINGBURST1_BRST_END 0x000003FF
#define BF_TVENC_HTIMINGBURST1_BRST_END(v)  \
	(((v) << 0) & BM_TVENC_HTIMINGBURST1_BRST_END)
HW_REGISTER(HW_TVENC_VTIMING0, REGS_TVENC_BASE, 0x00000090)
#define HW_TVENC_VTIMING0_ADDR (REGS_TVENC_BASE + 0x00000090)
#define BP_TVENC_VTIMING0_VSTRT_PREEQ      16
#define BM_TVENC_VTIMING0_VSTRT_PREEQ 0x03FF0000
#define BF_TVENC_VTIMING0_VSTRT_PREEQ(v)  \
	(((v) << 16) & BM_TVENC_VTIMING0_VSTRT_PREEQ)
#define BP_TVENC_VTIMING0_VSTRT_ACTV      8
#define BM_TVENC_VTIMING0_VSTRT_ACTV 0x00003F00
#define BF_TVENC_VTIMING0_VSTRT_ACTV(v)  \
	(((v) << 8) & BM_TVENC_VTIMING0_VSTRT_ACTV)
#define BP_TVENC_VTIMING0_VSTRT_SUBPH      0
#define BM_TVENC_VTIMING0_VSTRT_SUBPH 0x0000003F
#define BF_TVENC_VTIMING0_VSTRT_SUBPH(v)  \
	(((v) << 0) & BM_TVENC_VTIMING0_VSTRT_SUBPH)
HW_REGISTER(HW_TVENC_VTIMING1, REGS_TVENC_BASE, 0x000000a0)
#define HW_TVENC_VTIMING1_ADDR (REGS_TVENC_BASE + 0x000000a0)
#define BP_TVENC_VTIMING1_VSTRT_POSTEQ      24
#define BM_TVENC_VTIMING1_VSTRT_POSTEQ 0x3F000000
#define BF_TVENC_VTIMING1_VSTRT_POSTEQ(v)  \
	(((v) << 24) & BM_TVENC_VTIMING1_VSTRT_POSTEQ)
#define BP_TVENC_VTIMING1_VSTRT_SERRA      16
#define BM_TVENC_VTIMING1_VSTRT_SERRA 0x003F0000
#define BF_TVENC_VTIMING1_VSTRT_SERRA(v)  \
	(((v) << 16) & BM_TVENC_VTIMING1_VSTRT_SERRA)
#define BP_TVENC_VTIMING1_LAST_FLD_LN      0
#define BM_TVENC_VTIMING1_LAST_FLD_LN 0x000003FF
#define BF_TVENC_VTIMING1_LAST_FLD_LN(v)  \
	(((v) << 0) & BM_TVENC_VTIMING1_LAST_FLD_LN)
HW_REGISTER(HW_TVENC_MISC, REGS_TVENC_BASE, 0x000000b0)
#define HW_TVENC_MISC_ADDR (REGS_TVENC_BASE + 0x000000b0)
#define BP_TVENC_MISC_LPF_RST_OFF      16
#define BM_TVENC_MISC_LPF_RST_OFF 0x01FF0000
#define BF_TVENC_MISC_LPF_RST_OFF(v)  \
	(((v) << 16) & BM_TVENC_MISC_LPF_RST_OFF)
#define BM_TVENC_MISC_NTSC_LN_CNT 0x00000800
#define BM_TVENC_MISC_PAL_FSC_PHASE_ALT 0x00000400
#define BP_TVENC_MISC_FSC_PHASE_RST      8
#define BM_TVENC_MISC_FSC_PHASE_RST 0x00000300
#define BF_TVENC_MISC_FSC_PHASE_RST(v)  \
	(((v) << 8) & BM_TVENC_MISC_FSC_PHASE_RST)
#define BP_TVENC_MISC_BRUCHB      6
#define BM_TVENC_MISC_BRUCHB 0x000000C0
#define BF_TVENC_MISC_BRUCHB(v)  \
	(((v) << 6) & BM_TVENC_MISC_BRUCHB)
#define BP_TVENC_MISC_AGC_LVL_CTRL      4
#define BM_TVENC_MISC_AGC_LVL_CTRL 0x00000030
#define BF_TVENC_MISC_AGC_LVL_CTRL(v)  \
	(((v) << 4) & BM_TVENC_MISC_AGC_LVL_CTRL)
#define BM_TVENC_MISC_CS_INVERT_CTRL 0x00000004
#define BP_TVENC_MISC_Y_BLANK_CTRL      0
#define BM_TVENC_MISC_Y_BLANK_CTRL 0x00000003
#define BF_TVENC_MISC_Y_BLANK_CTRL(v)  \
	(((v) << 0) & BM_TVENC_MISC_Y_BLANK_CTRL)
HW_REGISTER(HW_TVENC_COLORSUB0, REGS_TVENC_BASE, 0x000000c0)
#define HW_TVENC_COLORSUB0_ADDR (REGS_TVENC_BASE + 0x000000c0)
#define BP_TVENC_COLORSUB0_PHASE_INC      0
#define BM_TVENC_COLORSUB0_PHASE_INC 0xFFFFFFFF
#define BF_TVENC_COLORSUB0_PHASE_INC(v)   (v)
HW_REGISTER(HW_TVENC_COLORSUB1, REGS_TVENC_BASE, 0x000000d0)
#define HW_TVENC_COLORSUB1_ADDR (REGS_TVENC_BASE + 0x000000d0)
#define BP_TVENC_COLORSUB1_PHASE_OFFSET      0
#define BM_TVENC_COLORSUB1_PHASE_OFFSET 0xFFFFFFFF
#define BF_TVENC_COLORSUB1_PHASE_OFFSET(v)   (v)
HW_REGISTER(HW_TVENC_COPYPROTECT, REGS_TVENC_BASE, 0x000000e0)
#define HW_TVENC_COPYPROTECT_ADDR (REGS_TVENC_BASE + 0x000000e0)
#define BM_TVENC_COPYPROTECT_WSS_ENBL 0x00008000
#define BM_TVENC_COPYPROTECT_CGMS_ENBL 0x00004000
#define BP_TVENC_COPYPROTECT_WSS_CGMS_DATA      0
#define BM_TVENC_COPYPROTECT_WSS_CGMS_DATA 0x00003FFF
#define BF_TVENC_COPYPROTECT_WSS_CGMS_DATA(v)  \
	(((v) << 0) & BM_TVENC_COPYPROTECT_WSS_CGMS_DATA)
HW_REGISTER(HW_TVENC_CLOSEDCAPTION, REGS_TVENC_BASE, 0x000000f0)
#define HW_TVENC_CLOSEDCAPTION_ADDR (REGS_TVENC_BASE + 0x000000f0)
#define BP_TVENC_CLOSEDCAPTION_CC_ENBL      18
#define BM_TVENC_CLOSEDCAPTION_CC_ENBL 0x000C0000
#define BF_TVENC_CLOSEDCAPTION_CC_ENBL(v)  \
	(((v) << 18) & BM_TVENC_CLOSEDCAPTION_CC_ENBL)
#define BP_TVENC_CLOSEDCAPTION_CC_FILL      16
#define BM_TVENC_CLOSEDCAPTION_CC_FILL 0x00030000
#define BF_TVENC_CLOSEDCAPTION_CC_FILL(v)  \
	(((v) << 16) & BM_TVENC_CLOSEDCAPTION_CC_FILL)
#define BP_TVENC_CLOSEDCAPTION_CC_DATA      0
#define BM_TVENC_CLOSEDCAPTION_CC_DATA 0x0000FFFF
#define BF_TVENC_CLOSEDCAPTION_CC_DATA(v)  \
	(((v) << 0) & BM_TVENC_CLOSEDCAPTION_CC_DATA)
HW_REGISTER(HW_TVENC_COLORBURST, REGS_TVENC_BASE, 0x00000140)
#define HW_TVENC_COLORBURST_ADDR (REGS_TVENC_BASE + 0x00000140)
#define BP_TVENC_COLORBURST_NBA      24
#define BM_TVENC_COLORBURST_NBA 0xFF000000
#define BF_TVENC_COLORBURST_NBA(v) \
	(((v) << 24) & BM_TVENC_COLORBURST_NBA)
#define BP_TVENC_COLORBURST_PBA      16
#define BM_TVENC_COLORBURST_PBA 0x00FF0000
#define BF_TVENC_COLORBURST_PBA(v)  \
	(((v) << 16) & BM_TVENC_COLORBURST_PBA)
HW_REGISTER(HW_TVENC_MACROVISION0, REGS_TVENC_BASE, 0x00000150)
#define HW_TVENC_MACROVISION0_ADDR (REGS_TVENC_BASE + 0x00000150)
#define BP_TVENC_MACROVISION0_DATA      0
#define BM_TVENC_MACROVISION0_DATA 0xFFFFFFFF
#define BF_TVENC_MACROVISION0_DATA(v)   (v)
HW_REGISTER(HW_TVENC_MACROVISION1, REGS_TVENC_BASE, 0x00000160)
#define HW_TVENC_MACROVISION1_ADDR (REGS_TVENC_BASE + 0x00000160)
#define BP_TVENC_MACROVISION1_DATA      0
#define BM_TVENC_MACROVISION1_DATA 0xFFFFFFFF
#define BF_TVENC_MACROVISION1_DATA(v)   (v)
HW_REGISTER(HW_TVENC_MACROVISION2, REGS_TVENC_BASE, 0x00000170)
#define HW_TVENC_MACROVISION2_ADDR (REGS_TVENC_BASE + 0x00000170)
#define BP_TVENC_MACROVISION2_DATA      0
#define BM_TVENC_MACROVISION2_DATA 0xFFFFFFFF
#define BF_TVENC_MACROVISION2_DATA(v)   (v)
HW_REGISTER(HW_TVENC_MACROVISION3, REGS_TVENC_BASE, 0x00000180)
#define HW_TVENC_MACROVISION3_ADDR (REGS_TVENC_BASE + 0x00000180)
#define BP_TVENC_MACROVISION3_DATA      0
#define BM_TVENC_MACROVISION3_DATA 0xFFFFFFFF
#define BF_TVENC_MACROVISION3_DATA(v)   (v)
HW_REGISTER(HW_TVENC_MACROVISION4, REGS_TVENC_BASE, 0x00000190)
#define HW_TVENC_MACROVISION4_ADDR (REGS_TVENC_BASE + 0x00000190)
#define BP_TVENC_MACROVISION4_MACV_TST      16
#define BM_TVENC_MACROVISION4_MACV_TST 0x00FF0000
#define BF_TVENC_MACROVISION4_MACV_TST(v)  \
	(((v) << 16) & BM_TVENC_MACROVISION4_MACV_TST)
#define BP_TVENC_MACROVISION4_DATA      0
#define BM_TVENC_MACROVISION4_DATA 0x000007FF
#define BF_TVENC_MACROVISION4_DATA(v)  \
	(((v) << 0) & BM_TVENC_MACROVISION4_DATA)
HW_REGISTER(HW_TVENC_DACCTRL, REGS_TVENC_BASE, 0x000001a0)
#define HW_TVENC_DACCTRL_ADDR (REGS_TVENC_BASE + 0x000001a0)
#define BM_TVENC_DACCTRL_TEST3 0x80000000
#define BM_TVENC_DACCTRL_JACK1_DIS_DET_EN 0x10000000
#define BM_TVENC_DACCTRL_TEST2 0x08000000
#define BM_TVENC_DACCTRL_JACK1_DET_EN 0x01000000
#define BM_TVENC_DACCTRL_TEST1 0x00800000
#define BM_TVENC_DACCTRL_DISABLE_GND_DETECT 0x00400000
#define BP_TVENC_DACCTRL_JACK_DIS_ADJ      20
#define BM_TVENC_DACCTRL_JACK_DIS_ADJ 0x00300000
#define BF_TVENC_DACCTRL_JACK_DIS_ADJ(v)  \
	(((v) << 20) & BM_TVENC_DACCTRL_JACK_DIS_ADJ)
#define BM_TVENC_DACCTRL_GAINDN 0x00080000
#define BM_TVENC_DACCTRL_GAINUP 0x00040000
#define BM_TVENC_DACCTRL_INVERT_CLK 0x00020000
#define BM_TVENC_DACCTRL_SELECT_CLK 0x00010000
#define BM_TVENC_DACCTRL_BYPASS_ACT_CASCODE 0x00008000
#define BM_TVENC_DACCTRL_PWRUP1 0x00001000
#define BM_TVENC_DACCTRL_WELL_TOVDD 0x00000800
#define BM_TVENC_DACCTRL_DUMP_TOVDD1 0x00000100
#define BM_TVENC_DACCTRL_LOWER_SIGNAL 0x00000080
#define BP_TVENC_DACCTRL_RVAL      4
#define BM_TVENC_DACCTRL_RVAL 0x00000070
#define BF_TVENC_DACCTRL_RVAL(v)  \
	(((v) << 4) & BM_TVENC_DACCTRL_RVAL)
#define BM_TVENC_DACCTRL_NO_INTERNAL_TERM 0x00000008
#define BM_TVENC_DACCTRL_HALF_CURRENT 0x00000004
#define BP_TVENC_DACCTRL_CASC_ADJ      0
#define BM_TVENC_DACCTRL_CASC_ADJ 0x00000003
#define BF_TVENC_DACCTRL_CASC_ADJ(v)  \
	(((v) << 0) & BM_TVENC_DACCTRL_CASC_ADJ)
HW_REGISTER(HW_TVENC_DACSTATUS, REGS_TVENC_BASE, 0x000001b0)
#define HW_TVENC_DACSTATUS_ADDR (REGS_TVENC_BASE + 0x000001b0)
#define BM_TVENC_DACSTATUS_JACK1_DET_STATUS 0x00000400
#define BM_TVENC_DACSTATUS_JACK1_GROUNDED 0x00000080
#define BM_TVENC_DACSTATUS_JACK1_DIS_DET_IRQ 0x00000010
#define BM_TVENC_DACSTATUS_JACK1_DET_IRQ 0x00000002
#define BM_TVENC_DACSTATUS_ENIRQ_JACK 0x00000001
HW_REGISTER(HW_TVENC_VDACTEST, REGS_TVENC_BASE, 0x000001c0)
#define HW_TVENC_VDACTEST_ADDR (REGS_TVENC_BASE + 0x000001c0)
#define BM_TVENC_VDACTEST_ENABLE_PIX_INT_GAIN 0x00002000
#define BM_TVENC_VDACTEST_BYPASS_PIX_INT 0x00001000
#define BM_TVENC_VDACTEST_BYPASS_PIX_INT_DROOP 0x00000800
#define BM_TVENC_VDACTEST_TEST_FIFO_FULL 0x00000400
#define BP_TVENC_VDACTEST_DATA      0
#define BM_TVENC_VDACTEST_DATA 0x000003FF
#define BF_TVENC_VDACTEST_DATA(v)  \
	(((v) << 0) & BM_TVENC_VDACTEST_DATA)
HW_REGISTER_0(HW_TVENC_VERSION, REGS_TVENC_BASE, 0x000001d0)
#define HW_TVENC_VERSION_ADDR (REGS_TVENC_BASE + 0x000001d0)
#define BP_TVENC_VERSION_MAJOR      24
#define BM_TVENC_VERSION_MAJOR 0xFF000000
#define BF_TVENC_VERSION_MAJOR(v) \
	(((v) << 24) & BM_TVENC_VERSION_MAJOR)
#define BP_TVENC_VERSION_MINOR      16
#define BM_TVENC_VERSION_MINOR 0x00FF0000
#define BF_TVENC_VERSION_MINOR(v)  \
	(((v) << 16) & BM_TVENC_VERSION_MINOR)
#define BP_TVENC_VERSION_STEP      0
#define BM_TVENC_VERSION_STEP 0x0000FFFF
#define BF_TVENC_VERSION_STEP(v)  \
	(((v) << 0) & BM_TVENC_VERSION_STEP)
#endif /* __ARCH_ARM___TVENC_H */
