/*
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
/*---------------------------------------------------------------------------
 * Pegatron Modify History
 *---------------------------------------------------------------------------
 * 2009/10/22  Kevin Wei  - 1. modify
 *---------------------------------------------------------------------------
 * 2009/11/12  Eric Chou  - 1. modify
 *                          2. fine-tune
 *---------------------------------------------------------------------------
 * 2009/11/18  Huimin Lin - 1. modify - mxc_spi_nor_partitions[]
                            2. add    - SDIO_UNIFI_FS platform for WiFi
 *---------------------------------------------------------------------------
 * 2009/12/25  Huimin Lin  - 1. add 	- to support POWER key behaviors
 *                                     - 2. add 	- to support HOLD key behaviors   
 *                                     - 3. modify - to support NOR write access protection mechasim
 *                                     - 4. add 	- to disable touch wakeup
 *---------------------------------------------------------------------------
 * 2009/12/28  Huimin Lin  - 1. modify - to sync the audio solution from Spider1 codebase
 *---------------------------------------------------------------------------
 * 2010/01/29  Huimin Lin  - 1. modify - to fix the CPU Hardware info
 *---------------------------------------------------------------------------
 * 2010/02/08  Huimin Lin - 1. modify - to sync the audio solution from Spider1 codebase
 *						mxc_sgtl5000_line_mute() add.
 *              				mxc_sgtl5000_amp_enable() condition add mute.
 *---------------------------------------------------------------------------
 * 2010/04/02 : fixed AMP enable/disable at mxc_sgtl5000_line_mute()
 *---------------------------------------------------------------------------
 * 2010/05/19               1. modify silent sequence change in mxc_sgtl5000_amp_enable().
 *                             AMP-OFF -> dap-disable.
 *                          2. modify add sgtl5000_dap_enable() in mxc_sgtl5000_line_mute.
 *---------------------------------------------------------------------------
 * 2010/05/19               1. modify option USE_DDR_SDCLK_FORCE_MEDIUM add.
 *                              Spider2 alway USE.
 *---------------------------------------------------------------------------
 */


#include <linux/types.h>
#include <linux/sched.h>
#include <linux/delay.h>
#include <linux/pm.h>
#include <linux/interrupt.h>
#include <linux/irq.h>
#include <linux/init.h>
#include <linux/input.h>
#include <linux/nodemask.h>
#include <linux/clk.h>
#include <linux/platform_device.h>
#include <linux/fsl_devices.h>
#include <linux/spi/spi.h>
#include <linux/i2c.h>
#include <linux/ata.h>
#include <linux/mtd/mtd.h>
#include <linux/mtd/map.h>
#include <linux/mtd/partitions.h>
#include <linux/spi/flash.h>
#include <linux/regulator/consumer.h>
#include <linux/pmic_external.h>
#include <linux/pmic_status.h>
#include <linux/ipu.h>
#include <linux/mxcfb.h>
#include <mach/common.h>
#include <mach/hardware.h>
#include <mach/spba.h>
#include <asm/irq.h>
#include <asm/setup.h>
#include <asm/mach-types.h>
#include <asm/mach/arch.h>
#include <asm/mach/time.h>
#include <asm/mach/keypad.h>
#include <mach/memory.h>
#include <mach/gpio.h>
#include <mach/mmc.h>
#include "board-mx51_babbage.h"
#include "iomux.h"
#include "crm_regs.h"
#include <mach/mxc_edid.h>

/*!
 * @file mach-mx51/mx51_babbage.c
 *
 * @brief This file contains the board specific initialization routines.
 *
 * @ingroup MSL_MX51
 */

#define DEBUG_TRACE        1
#if ( DEBUG_TRACE )
#define DEBUG_PRINTK(x)    printk x
#else
#define DEBUG_PRINTK(x)
#endif

//add by pega Huimin 2009.12.28 to sync the audio solution from Spider1 codebase
#define USE_SGTL5000_VOLUME_FIX	1

//add by pega Huimin 2009.12.25 to support POWER key behaviors
#define USE_PWR_SWITCH	1

//add by pega Huimin 2009.12.25 to support HOLD key behaviors
#define USE_HOLD_SWITCH	1

//add by pega Huimin 2009.12.25 to support NOR write access protection mechasim
#define USE_SW_NOR_PROTECTION	1

//add by pega Huimin 2009.12.25 to disable touch wakeup
#define USE_TS_WAKEUP_FIX		1

#define USE_DDR_SDCLK_FORCE_MEDIUM

//add by pega Huimin 2009.12.28 to sync the audio solution from Spider1 codebase
#if ( USE_SGTL5000_VOLUME_FIX )
extern void sgtl5000_dap_enable(int jack, int event);
#endif

extern void __init mx51_babbage_io_init(void);
extern struct cpu_wp *(*get_cpu_wp)(int *wp);
extern void (*set_num_cpu_wp)(int num);
static int num_cpu_wp = 3;

/* working point(wp): 0 - 800MHz; 1 - 166.25MHz; */
static struct cpu_wp cpu_wp_auto[] = {
	{
	 .pll_rate = 1000000000,
	 .cpu_rate = 1000000000,
	 .pdf = 0,
	 .mfi = 10,
	 .mfd = 11,
	 .mfn = 5,
	 .cpu_podf = 0,
	 .cpu_voltage = 1175000,},
	{
	 .pll_rate = 800000000,
	 .cpu_rate = 800000000,
	 .pdf = 0,
	 .mfi = 8,
	 .mfd = 2,
	 .mfn = 1,
	 .cpu_podf = 0,
	 .cpu_voltage = 1100000,},
	{
	 .pll_rate = 800000000,
	 .cpu_rate = 166250000,
	 .pdf = 4,
	 .mfi = 8,
	 .mfd = 2,
	 .mfn = 1,
	 .cpu_podf = 4,
	 .cpu_voltage = 1000000,},
};

static struct fb_videomode video_modes[] = {
	{
	 /* 720p60 TV output */
	 "720P60", 60, 1280, 720, 7418,
	 220, 110,
	 20, 5,
	 40, 5,
	 FB_SYNC_HOR_HIGH_ACT | FB_SYNC_VERT_HIGH_ACT | FB_SYNC_EXT,
	 FB_VMODE_NONINTERLACED,
	 0,},
	{
	 /* MITSUBISHI LVDS panel */
	 "XGA", 60, 1024, 768, 15385,
	 220, 40,
	 21, 7,
	 60, 10,
	 0,
	 FB_VMODE_NONINTERLACED,
	 0,},
};

struct cpu_wp *mx51_babbage_get_cpu_wp(int *wp)
{
	*wp = num_cpu_wp;
	return cpu_wp_auto;
}

void mx51_babbage_set_num_cpu_wp(int num)
{
	num_cpu_wp = num;
	return;
}
static void mxc_nop_release(struct device *dev)
{
	/* Nothing */
}

#if defined(CONFIG_KEYBOARD_MXC) || defined(CONFIG_KEYBOARD_MXC_MODULE)
static u16 keymapping[24] = {
	KEY_1, KEY_2, KEY_3, KEY_F1, KEY_UP, KEY_F2,
	KEY_4, KEY_5, KEY_6, KEY_LEFT, KEY_SELECT, KEY_RIGHT,
	KEY_7, KEY_8, KEY_9, KEY_F3, KEY_DOWN, KEY_F4,
	KEY_0, KEY_OK, KEY_ESC, KEY_ENTER, KEY_MENU, KEY_BACK,
};

static struct resource mxc_kpp_resources[] = {
	[0] = {
	       .start = MXC_INT_KPP,
	       .end = MXC_INT_KPP,
	       .flags = IORESOURCE_IRQ,
	       }
};

static struct keypad_data keypad_plat_data = {
	.rowmax = 4,
	.colmax = 6,
	.irq = MXC_INT_KPP,
	.learning = 0,
	.delay = 2,
	.matrix = keymapping,
};

/* mxc keypad driver */
static struct platform_device mxc_keypad_device = {
	.name = "mxc_keypad",
	.id = 0,
	.num_resources = ARRAY_SIZE(mxc_kpp_resources),
	.resource = mxc_kpp_resources,
	.dev = {
		.release = mxc_nop_release,
		.platform_data = &keypad_plat_data,
		},
};

static void mxc_init_keypad(void)
{
	(void)platform_device_register(&mxc_keypad_device);
}
#else
static inline void mxc_init_keypad(void)
{
}
#endif

#if defined(CONFIG_FB_MXC_SYNC_PANEL) || \
	defined(CONFIG_FB_MXC_SYNC_PANEL_MODULE)
static struct resource mxcfb_resources[] = {
	[0] = {
	       .flags = IORESOURCE_MEM,
	       },
};

static struct mxc_fb_platform_data fb_data[] = {
	{
	 .interface_pix_fmt = IPU_PIX_FMT_RGB24,
	 .mode_str = "1024x768M-16@60",
	 },
	{
	 .interface_pix_fmt = IPU_PIX_FMT_RGB565,
	 .mode_str = "1024x768M-16@60",
	 },
};

static struct platform_device mxc_fb_device[] = {
	{
	 .name = "mxc_sdc_fb",
	 .id = 0,
	 .dev = {
		 .release = mxc_nop_release,
		 .coherent_dma_mask = 0xFFFFFFFF,
		 .platform_data = &fb_data[0],
		 },
	 .num_resources = ARRAY_SIZE(mxcfb_resources),
	 .resource = mxcfb_resources,
	 },
	{
	 .name = "mxc_sdc_fb",
	 .id = 1,
	 .dev = {
		 .release = mxc_nop_release,
		 .coherent_dma_mask = 0xFFFFFFFF,
		 .platform_data = &fb_data[1],
		 },
	 },
	{
	 .name = "mxc_sdc_fb",
	 .id = 2,
	 .dev = {
		 .release = mxc_nop_release,
		 .coherent_dma_mask = 0xFFFFFFFF,
		 },
	 },
};

static int __initdata enable_vga = { 0 };
static int __initdata enable_wvga = { 0 };
static int __initdata enable_tv = { 0 };
static int __initdata enable_mitsubishi_xga = { 0 };

static void wvga_reset(void)
{
	gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_DI1_D1_CS), 1);
}

static struct mxc_lcd_platform_data lcd_wvga_data = {
	.reset = wvga_reset,
};

static struct platform_device lcd_wvga_device = {
	.name = "lcd_claa",
	.dev = {
		.release = mxc_nop_release,
		.platform_data = &lcd_wvga_data,
		},
};

//---------------------------------
// Sharp LCD
//---------------------------------
// add by pega Kevin 2009.10.22
//---------------------------------
static void lcd_reset(void)
{
}

static struct mxc_lcd_platform_data lcd_data = {
	.reset	    = lcd_reset,
};

static struct platform_device mxc_lcd_device = {
	.name = "lcd_sharp",
	.id   = 0,
	.dev  = {
		.release	   = mxc_nop_release,
		.coherent_dma_mask = 0xFFFFFFFF,
		.platform_data	   = &lcd_data,
	},
};

static void __init mxc_init_lcd(void)
{
	if (!enable_vga) {
		platform_device_register(&mxc_lcd_device);
	}
}
//---------------------------------
// end modify - Sharp LCD
//--------------------------------

static int handle_edid(int *pixclk)
{
	int err = 0;
	int dvi = 0;
	int fb0 = 0;
	int fb1 = 1;
	struct fb_var_screeninfo screeninfo;
	struct i2c_adapter *adp;

	DEBUG_PRINTK(("[%s] \n",  __func__));

	memset(&screeninfo, 0, sizeof(screeninfo));

	adp = i2c_get_adapter(1);

	if (cpu_is_mx51_rev(CHIP_REV_3_0) > 0) {
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_CSI2_HSYNC), 1);
		msleep(1);
	}
	err = read_edid(adp, &screeninfo, &dvi);
	if (cpu_is_mx51_rev(CHIP_REV_3_0) > 0)
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_CSI2_HSYNC), 0);

	if (!err) {
		printk(KERN_INFO " EDID read\n");
		if (!dvi) {
			enable_vga = 1;
			fb0 = 1; /* fb0 will be VGA */
			fb1 = 0; /* fb1 will be DVI or TV */
		}

		/* Handle TV modes */
		/* This logic is fairly complex yet still doesn't handle all
		   possibilities.  Once a customer knows the platform
		   configuration, this should be simplified to what is desired.
		 */
		if (screeninfo.xres == 1920 && screeninfo.yres != 1200) {
			/* MX51 can't handle clock speeds for anything larger.*/
			if (!enable_tv)
				enable_tv = 1;
			if (enable_vga || enable_wvga || enable_tv == 2)
				enable_tv = 2;
			fb_data[0].mode = &(video_modes[0]);
			if (!enable_wvga)
				fb_data[1].mode_str = "800x600M-16@60";
		} else if (screeninfo.xres > 1280 && screeninfo.yres > 1024) {
			if (!enable_wvga) {
				fb_data[fb0].mode_str = "1280x1024M-16@60";
				fb_data[fb1].mode_str = NULL;
			} else {
				/* WVGA is preset so the DVI can't be > this. */
				fb_data[0].mode_str = "1024x768M-16@60";
			}
		} else if (screeninfo.xres > 0 && screeninfo.yres > 0) {
			if (!enable_wvga) {
				fb_data[fb0].mode =
					kzalloc(sizeof(struct fb_videomode),
							GFP_KERNEL);
				fb_var_to_videomode(fb_data[fb0].mode,
						    &screeninfo);
				fb_data[fb0].mode_str = NULL;
				if (screeninfo.xres >= 1280 &&
						screeninfo.yres > 720)
					fb_data[fb1].mode_str = NULL;
				else if (screeninfo.xres > 1024 &&
						screeninfo.yres > 768)
					fb_data[fb1].mode_str =
						"800x600M-16@60";
				else if (screeninfo.xres > 800 &&
						screeninfo.yres > 600)
					fb_data[fb1].mode_str =
						"1024x768M-16@60";
			} else {
				/* A WVGA panel was specified and an EDID was
				   read thus there is a DVI monitor attached. */
				if (screeninfo.xres >= 1024)
					fb_data[0].mode_str = "1024x768M-16@60";
				else if (screeninfo.xres >= 800)
					fb_data[0].mode_str = "800x600M-16@60";
				else
					fb_data[0].mode_str = "640x480M-16@60";
			}
		}
	}

	return 0;
}

static int __init mxc_init_fb(void)
{
	int pixclk = 0;

	DEBUG_PRINTK(("[%s] \n",  __func__));

   #if 0 //modify by kevin 20100304
	if (!machine_is_mx51_babbage())
		return 0;
   #endif
	
	if (cpu_is_mx51_rev(CHIP_REV_1_1) == 1) {
		enable_vga = 1;
		fb_data[0].mode_str = NULL;
		fb_data[1].mode_str = NULL;
	}

	if (enable_wvga)
   {
		DEBUG_PRINTK(("[%s] enable_wvga \n",  __func__));

		fb_data[1].interface_pix_fmt = IPU_PIX_FMT_RGB565;
		fb_data[1].mode_str = "800x480M-16@55";
	}

	if (enable_mitsubishi_xga)
   {
		DEBUG_PRINTK(("[%s] enable_mitsubishi_xga \n",  __func__));

		fb_data[0].interface_pix_fmt = IPU_PIX_FMT_LVDS666;
		fb_data[0].mode = &(video_modes[1]);

		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_DI1_D0_CS), 0);
		msleep(1);
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_DI1_D0_CS), 1);

		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_CSI2_D12), 1);
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_CSI2_D13), 1);
	}

	// remark by pega Eric 2009.11.12
	#if ( 0 )
	/* DVI Detect */
	gpio_request(IOMUX_TO_GPIO(MX51_PIN_NANDF_D12), "nandf_d12");
	gpio_direction_input(IOMUX_TO_GPIO(MX51_PIN_NANDF_D12));
	/* DVI Reset - Assert for i2c disabled mode */
	gpio_request(IOMUX_TO_GPIO(MX51_PIN_DISPB2_SER_DIN), "dispb2_ser_din");
	gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_DISPB2_SER_DIN), 0);
	gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_DISPB2_SER_DIN), 0);
	/* DVI Power-down */
	gpio_request(IOMUX_TO_GPIO(MX51_PIN_DISPB2_SER_DIO), "dispb2_ser_di0");
	gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_DISPB2_SER_DIO), 1);
	gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_DISPB2_SER_DIO), 0);
	#endif

	(void)platform_device_register(&lcd_wvga_device);

   #if ( 0 )
	if (cpu_is_mx51_rev(CHIP_REV_1_1) == 2)
		handle_edid(&pixclk);
   #endif

	if (enable_vga)
		printk(KERN_INFO "VGA monitor is primary\n");
	else if (enable_wvga)
		printk(KERN_INFO "WVGA LCD panel is primary\n");
	else if (!enable_tv)
		printk(KERN_INFO "DVI monitor is primary\n");

	if (enable_tv) {
		printk(KERN_INFO "TV is specified as %d\n", enable_tv);
		if (!fb_data[0].mode) {
			fb_data[0].mode = &(video_modes[0]);
			if (!enable_wvga)
				fb_data[1].mode_str = "800x600M-16@60";
		}
	}

	if (enable_tv) {
		struct clk *clk, *di_clk;
		clk = clk_get(NULL, "pll3");
		di_clk = clk_get(NULL, "ipu_di0_clk");
		clk_disable(clk);
		clk_disable(di_clk);
		clk_set_rate(clk, 297000000);
		clk_set_rate(di_clk, 297000000 / 4);
		clk_enable(clk);
		clk_enable(di_clk);
		clk_put(di_clk);
		clk_put(clk);
	}

	/* Once a customer knows the platform configuration,
	   this should be simplified to what is desired.
	 */
	if (enable_vga || enable_wvga || enable_tv == 2) {
		(void)platform_device_register(&mxc_fb_device[1]); /* VGA */
		if (fb_data[0].mode_str || fb_data[0].mode)
			(void)platform_device_register(&mxc_fb_device[0]);
	} else {
		(void)platform_device_register(&mxc_fb_device[0]); /* DVI */
		if (fb_data[1].mode_str || fb_data[1].mode)
			(void)platform_device_register(&mxc_fb_device[1]);
	}

	(void)platform_device_register(&mxc_fb_device[2]);

	return 0;
}
device_initcall(mxc_init_fb);

static int __init vga_setup(char *__unused)
{
	enable_vga = 1;
	return 1;
}

__setup("vga", vga_setup);

static int __init wvga_setup(char *__unused)
{
	enable_wvga = 1;
	return 1;
}

__setup("wvga", wvga_setup);

static int __init mitsubishi_xga_setup(char *__unused)
{
	enable_mitsubishi_xga = 1;
	return 1;
}

__setup("mitsubishi_xga", mitsubishi_xga_setup);

static int __init tv_setup(char *s)
{
	enable_tv = 1;
	if (strcmp(s, "2") == 0 || strcmp(s, "=2") == 0)
		enable_tv = 2;
	return 1;
}

__setup("tv", tv_setup);
#else
static inline void mxc_init_fb(void)
{
}
#endif

static void dvi_reset(void)
{
	DEBUG_PRINTK(("[%s] \n",  __func__));

	gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_DISPB2_SER_DIN), 0);
	gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_DISPB2_SER_DIN), 0);
	msleep(50);

	/* do reset */
	gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_DISPB2_SER_DIN), 1);
	msleep(20);		/* tRES >= 50us */

	gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_DISPB2_SER_DIN), 0);
}

static struct mxc_lcd_platform_data dvi_data = {
	.core_reg = "VGEN1",
	.io_reg = "VGEN3",
	.reset = dvi_reset,
};

static void vga_reset(void)
{
	DEBUG_PRINTK(("[%s] \n",  __func__));

	gpio_request(IOMUX_TO_GPIO(MX51_PIN_EIM_A19), "eim_a19");
	gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_EIM_A19), 0);
	gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A19), 0);
	msleep(50);
	/* do reset */
	gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A19), 1);
	msleep(10);		/* tRES >= 50us */
	gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A19), 0);
}

static struct mxc_lcd_platform_data vga_data = {
	.core_reg = "VCAM",
	.io_reg = "VGEN3",
	.analog_reg = "VAUDIO",
	.reset = vga_reset,
};

static void si4702_reset(void)
{
	DEBUG_PRINTK(("[%s] \n",  __func__));
	return;

	gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A21), 0);
	msleep(100);
	gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A21), 1);
	msleep(100);
}

static void si4702_clock_ctl(int flag)
{
	gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A18), flag);
	msleep(100);
}

static void si4702_gpio_get(void)
{
	gpio_request(IOMUX_TO_GPIO(MX51_PIN_EIM_A18), "eim_a18");
	gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_EIM_A18), 0);
}

static void si4702_gpio_put(void)
{
}

static struct mxc_fm_platform_data si4702_data = {
	.reg_vio = "SW4",
	.reg_vdd = "VIOHI",
	.gpio_get = si4702_gpio_get,
	.gpio_put = si4702_gpio_put,
	.reset = si4702_reset,
	.clock_ctl = si4702_clock_ctl,
};

#if defined(CONFIG_I2C_MXC) || defined(CONFIG_I2C_MXC_MODULE)

#ifdef CONFIG_I2C_MXC_SELECT1
static struct mxc_camera_platform_data camera_data = {
	.io_regulator = "SW4",
	.analog_regulator = "VIOHI",
	.mclk = 24000000,
	.csi = 0,
};

static struct i2c_board_info mxc_i2c0_board_info[] __initdata = {
	{
	.type = "ov3640",
	.addr = 0x3C,
	.platform_data = (void *)&camera_data,
	},
};
#endif
#ifdef CONFIG_I2C_MXC_SELECT2
static struct i2c_board_info mxc_i2c1_board_info[] __initdata = {
	{
	 .type = "sgtl5000-i2c",
	 .addr = 0x0a,
	 },
};
#endif

#if defined(CONFIG_I2C_MXC_HS) || defined(CONFIG_I2C_MXC_HS_MODULE)
static struct i2c_board_info mxc_i2c_hs_board_info[] __initdata = {
	{
	 .type = "sii9022",
	 .addr = 0x39,
	 .platform_data = &dvi_data,
	 },
	{
	 .type = "ch7026",
	 .addr = 0x75,
	 .platform_data = &vga_data,
	 },
	{
	 .type = "si4702",
	 .addr = 0x10,
	 .platform_data = (void *)&si4702_data,
	 },
};
#endif

#endif

#if defined(CONFIG_MTD) || defined(CONFIG_MTD_MODULE)
static struct mtd_partition mxc_spi_nor_partitions[] =
{
	#if ( 1 ) 
#if ( USE_SW_NOR_PROTECTION )

//modify by pega Huimin 2010.3.12, to fulfill the mtd partition planning in Spider2 product
#if ( 1 )
        {       .name   = "mfg_data",
                .offset = 0xC0000,
                .size   = 0x40000,
		.mask_flags = MTD_WRITEABLE,
        },
        {       .name   = "bootloader",
                .offset = 0x0,
                .size   = 0xC0000,
		.mask_flags = MTD_WRITEABLE,
        },
        {       .name   = "info",
                .offset = 0x100000,
                .size   = 0x100000,
        },

#endif

#if ( 0 )
	//modify by pega Huimin 2009.12.25 to use the NOR SW write protection mechanism
	{	.name   = "mfg_data",
	 	.offset = 0xC0000,
		.size   = 0x40000,
		.mask_flags = MTD_WRITEABLE,
	},
   //modify by pega kevin 20100304
   {	.name   = "info",
	 	.offset = MTDPART_OFS_APPEND,
		.size   = 0x100000,
	},
#endif

#else
	// modify by pega Huimin 2009.11.18
	{	.name   = "bootloader",
	 	.offset = 0,
		.size   = 0x00C00000,
	},
	{	.name   = "mfg",
		.offset = MTDPART_OFS_APPEND,
		.size   = 0x00400000,
	},
	{	.name   = "kernel",
		.offset = MTDPART_OFS_APPEND,
		.size   = MTDPART_SIZ_FULL,
	},
#endif	
	#else
	{	.name   = "bootloader",
		.offset = 0,
		.size   = 0x00040000,
	},
	{	.name   = "kernel",
	 	.offset = MTDPART_OFS_APPEND,
	 	.size   = MTDPART_SIZ_FULL,
	},
	#endif
};

static struct mtd_partition mxc_dataflash_partitions[] = {
	{
	 .name = "bootloader",
	 .offset = 0,
	 .size = 0x000100000,},
	{
	 .name = "kernel",
	 .offset = MTDPART_OFS_APPEND,
	 .size = MTDPART_SIZ_FULL,},
};

static struct flash_platform_data mxc_spi_flash_data[] = {
	{
	 .name = "mxc_spi_nor",
	 .parts = mxc_spi_nor_partitions,
	 .nr_parts = ARRAY_SIZE(mxc_spi_nor_partitions),
	 #if ( 1 ) // modify by pega Kevin 2009.10.28 - type = 0 : auto detect
	 .type = 0},
	 #else
	 .type = "sst25vf016b",},
	 #endif
	{
	 .name = "mxc_dataflash",
	 .parts = mxc_dataflash_partitions,
	 .nr_parts = ARRAY_SIZE(mxc_dataflash_partitions),
	 .type = "at45db321d",}
};
#endif

static struct spi_board_info mxc_spi_nor_device[] __initdata = {
#if defined(CONFIG_MTD) || defined(CONFIG_MTD_MODULE)
	{
	 .modalias = "mxc_spi_nor",
	 .max_speed_hz = 25000000,	/* max spi clock (SCK) speed in HZ */
	 .bus_num = 1,
	 .chip_select = 1,
	 .platform_data = &mxc_spi_flash_data[0],},
#endif
};

static struct spi_board_info mxc_dataflash_device[] __initdata = {
#if defined(CONFIG_MTD) || defined(CONFIG_MTD_MODULE)
	{
	 .modalias = "mxc_dataflash",
	 .max_speed_hz = 25000000,	/* max spi clock (SCK) speed in HZ */
	 .bus_num = 1,
	 .chip_select = 1,
	 .platform_data = &mxc_spi_flash_data[1],},
#endif
};

#if defined(CONFIG_FEC) || defined(CONFIG_FEC_MODULE)
unsigned int expio_intr_fec;

EXPORT_SYMBOL(expio_intr_fec);
#endif

#if defined(CONFIG_MMC_IMX_ESDHCI) || defined(CONFIG_MMC_IMX_ESDHCI_MODULE)
static int sdhc_write_protect(struct device *dev)
{
	#if ( 1 )
	return 0; // modify by pega Kevin 2009.10.22
	#else
	unsigned short rc = 0;

	if (to_platform_device(dev)->id == 0)
		rc = gpio_get_value(IOMUX_TO_GPIO(MX51_PIN_GPIO1_1));
	else
		rc = gpio_get_value(IOMUX_TO_GPIO(MX51_PIN_GPIO1_5));

	return rc;
	#endif
}

static unsigned int sdhc_get_card_det_status(struct device *dev)
{
	int ret;

	if (to_platform_device(dev)->id == 0) {
		ret = gpio_get_value(IOMUX_TO_GPIO(MX51_PIN_GPIO1_0));
		return ret;
	} else {		/* config the det pin for SDHC2 */
		#if ( 1 )
		return 0; // modify by pega Kevin 2009.10.22
		#else
		if (board_is_babbage_2_5() == 1)
			/* BB2.5 */
			ret = gpio_get_value(IOMUX_TO_GPIO(MX51_PIN_GPIO1_6));
		else
			/* BB2.0 */
			ret = gpio_get_value(IOMUX_TO_GPIO(MX51_PIN_GPIO1_4));
		return ret;
		#endif
	}
}

static struct mxc_mmc_platform_data mmc1_data = {
	.ocr_mask = MMC_VDD_31_32,
	.caps = MMC_CAP_4_BIT_DATA,
	.min_clk = 400000,
	.max_clk = 52000000,
	.card_inserted_state = 1,
	.status = sdhc_get_card_det_status,
	.wp_status = sdhc_write_protect,
	.clock_mmc = "esdhc_clk",
	.power_mmc = NULL,
};

static struct mxc_mmc_platform_data mmc2_data = {
	.ocr_mask = MMC_VDD_27_28 | MMC_VDD_28_29 | MMC_VDD_29_30 |
	    MMC_VDD_31_32,
	.caps = MMC_CAP_4_BIT_DATA,
	.min_clk = 150000,
	.max_clk = 50000000,
	.card_inserted_state = 0,
	.status = sdhc_get_card_det_status,
	.wp_status = sdhc_write_protect,
	.clock_mmc = "esdhc_clk",
};

/*!
 * Resource definition for the SDHC1
 */
static struct resource mxcsdhc1_resources[] = {
	[0] = {
	       .start = MMC_SDHC1_BASE_ADDR,
	       .end = MMC_SDHC1_BASE_ADDR + SZ_4K - 1,
	       .flags = IORESOURCE_MEM,
	       },
	[1] = {
	       .start = MXC_INT_MMC_SDHC1,
	       .end = MXC_INT_MMC_SDHC1,
	       .flags = IORESOURCE_IRQ,
	       },
	[2] = {
	       .start = IOMUX_TO_IRQ(MX51_PIN_GPIO1_0),
	       .end = IOMUX_TO_IRQ(MX51_PIN_GPIO1_0),
	       .flags = IORESOURCE_IRQ,
	       },
};

/*!
 * Resource definition for the SDHC2
 */
static struct resource mxcsdhc2_resources[] = {
	[0] = {
	       .start = MMC_SDHC2_BASE_ADDR,
	       .end = MMC_SDHC2_BASE_ADDR + SZ_4K - 1,
	       .flags = IORESOURCE_MEM,
	       },
	[1] = {
	       .start = MXC_INT_MMC_SDHC2,
	       .end = MXC_INT_MMC_SDHC2,
	       .flags = IORESOURCE_IRQ,
	       },
	[2] = {
	       .start = 0, // not connect // IOMUX_TO_IRQ(MX51_PIN_GPIO1_4), // modify by pega Eric 2009.11.12
	       .end = 0,   // not connect // IOMUX_TO_IRQ(MX51_PIN_GPIO1_4), // modify by pega Eric 2009.11.12
	       .flags = IORESOURCE_IRQ,
	       },
};

/*! Device Definition for MXC SDHC1 */
static struct platform_device mxcsdhc1_device = {
	.name = "mxsdhci",
	.id = 0,
	.dev = {
		.release = mxc_nop_release,
		.platform_data = &mmc1_data,
		},
	.num_resources = ARRAY_SIZE(mxcsdhc1_resources),
	.resource = mxcsdhc1_resources,
};

/*! Device Definition for MXC SDHC2 */
static struct platform_device mxcsdhc2_device = {
	.name = "mxsdhci",
	.id = 1,
	.dev = {
		.release = mxc_nop_release,
		.platform_data = &mmc2_data,
		},
	.num_resources = ARRAY_SIZE(mxcsdhc2_resources),
	.resource = mxcsdhc2_resources,
};

static inline void mxc_init_mmc(void)
{
	#if ( 0 ) // modify by pega Eric 2009.11.12
	if (board_is_babbage_2_5() == 1) {
		/* BB2.5 */
		mxcsdhc2_resources[2].start =
			IOMUX_TO_IRQ(MX51_PIN_GPIO1_6);	/* SD2 CD */
		mxcsdhc2_resources[2].end =
			IOMUX_TO_IRQ(MX51_PIN_GPIO1_6);	/* SD2 CD */
	}
	#endif

	(void)platform_device_register(&mxcsdhc1_device);
	(void)platform_device_register(&mxcsdhc2_device);
}
#else
static inline void mxc_init_mmc(void)
{
}
#endif

//---------------------------------
// Optical Joystick
//---------------------------------
// add by pega Kevin 2009.10.23
//---------------------------------
#ifdef CONFIG_JOYSTICK_OJ6SH

#include <linux/oj6sh.h>
extern void enable_oj_shutdown(int shutdown);

static struct oj6sh_platform_data oj6sh_data = {
	.left_btn_irq  = IOMUX_TO_IRQ(MX51_PIN_CSI2_D18), // (MX51_PIN_EIM_EB2),
	.right_btn_irq = IOMUX_TO_IRQ(MX51_PIN_EIM_D20),  // (MX51_PIN_EIM_EB3),
	.shutdown      = enable_oj_shutdown,
};

static struct spi_board_info mxc_spi_oj6sh_device __initdata = {
	.modalias      = "oj6sh_spi",
	.max_speed_hz  = 2500000,
	.bus_num       = 1,
	.chip_select   = 2,
	.mode          = SPI_MODE_0,
	.irq           = IOMUX_TO_IRQ(MX51_PIN_CSI2_D13), // (MX51_PIN_CSI1_HSYNC),
	.platform_data = (void *)&oj6sh_data,
};

static void __init mxc_init_oj6sh(void)
{
	spi_register_board_info(&mxc_spi_oj6sh_device,  ARRAY_SIZE(mxc_spi_nor_device)); // (mxc_spi_board_info));
}
#else
static inline void mxc_init_oj6sh(void)
{
}
#endif

//---------------------------------
// Vibrator Motor
//---------------------------------
// add by pega Kevin 2009.11.02
//---------------------------------
#ifdef CONFIG_MXC_VIBRATOR

extern void enable_motor(int enable);

static struct mxc_vibrator_platform_data vibrator_data =
{
	.enable = enable_motor,
	.reg_vdd = "VSD"
};

static struct platform_device mxc_vibrator_device =
{
	.name = "vibrator",
	.dev =
	{
		.release = mxc_nop_release,
		.platform_data = &vibrator_data,
	},
};

static void __init mxc_init_vibrator(void)
{
	platform_device_register(&mxc_vibrator_device);
}
#else
static inline void mxc_init_vibrator(void)
{
}
#endif

//---------------------------------
// Control GPIO
//---------------------------------
// add by pega Eric 2009.12.03
//---------------------------------
#ifdef CONFIG_MXC_CTL_GPIO

extern void enable_26mhz(int enable);          // System
extern void enable_vcc_3v3(int enable);        // System
extern void enable_vcc_5v2(int enable);        // System
extern void enable_wifi_reset(int enable);     // WiFi
extern void enable_bt_reset(int enable);       // BT
extern void enable_bt_en(int enable);          // BT
extern void enable_lcd_power(int enable);      // LCD
extern void enable_sound_amp(int enable);      // Audio
extern void enable_sound_clock(int enable);    // Audio
extern void enable_oj_shutdown(int enable);    // OJ
extern void enable_motor(int enable);          // Vibrator
extern void enable_usb_clock(int enable);      // USB

static struct mxc_ctl_gpio_platform_data ctl_gpio_data =
{
	.enable_clt[0]  = enable_26mhz,
	.enable_clt[1]  = enable_vcc_3v3,
	.enable_clt[2]  = enable_vcc_5v2,
	.enable_clt[3]  = enable_wifi_reset,
	.enable_clt[4]  = enable_bt_reset,
	.enable_clt[5]  = enable_bt_en,
	.enable_clt[6]  = enable_lcd_power,
	.enable_clt[7]  = enable_sound_amp,
	.enable_clt[8]  = enable_sound_clock,
	.enable_clt[9]  = enable_oj_shutdown,
	.enable_clt[10] = enable_motor,
	.enable_clt[11] = enable_usb_clock,
/*
	.enable_26mhz       = enable_26mhz,
   .enable_vcc_3v3     = enable_vcc_3v3,
	.enable_vcc_5v2     = enable_vcc_5v2,
	.enable_wifi_reset  = enable_wifi_reset,
	.enable_bt_reset    = enable_bt_reset,
	.enable_bt_en       = enable_bt_en,
	.enable_lcd_power   = enable_lcd_power,
	.enable_sound_amp   = enable_sound_amp,
	.enable_sound_clock = enable_sound_clock,
	.enable_oj_shutdown = enable_oj_shutdown,
	.enable_motor       = enable_motor,
	.enable_usb_clock   = enable_usb_clock,
*/
};

static struct platform_device mxc_ctl_gpio_device =
{
	.name = "ctl_gpio",
	.dev =
	{
		.release = mxc_nop_release,
		.platform_data = &ctl_gpio_data,
	},
};

static void __init mxc_init_ctl_gpio(void)
{
	platform_device_register(&mxc_ctl_gpio_device);
}
#else
static inline void mxc_init_ctl_gpio(void)
{
}
#endif

//---------------------------------
// PATA driver
//---------------------------------
// add by pega Kevin 2009.10.29
//---------------------------------
#if defined(CONFIG_PATA_FSL) || defined(CONFIG_PATA_FSL_MODULE)
extern void gpio_ata_active(void);
extern void gpio_ata_inactive(void);

static int ata_init(struct platform_device *pdev)
{
	/* Configure the pins */

	gpio_ata_active();
	return 0;
}

static void ata_exit(void)
{
	/* Free the pins */

	gpio_ata_inactive();
}

static struct fsl_ata_platform_data ata_data = {
	.udma_mask = ATA_UDMA3,
	.mwdma_mask = ATA_MWDMA2,
	.pio_mask = ATA_PIO4,
	.fifo_alarm = MXC_IDE_DMA_WATERMARK / 2,
	.max_sg = MXC_IDE_DMA_BD_NR,
	.init = ata_init,
	.exit = ata_exit,
	.core_reg = NULL,
	.io_reg = NULL,
};

static struct resource pata_fsl_resources[] = {
	[0] = {
	       .start = ATA_BASE_ADDR,
	       .end = ATA_BASE_ADDR + 0x000000C8,
	       .flags = IORESOURCE_MEM,},
	[2] = {
	       .start = MXC_INT_ATA,
	       .end = MXC_INT_ATA,
	       .flags = IORESOURCE_IRQ,},
};

static struct platform_device pata_fsl_device = {
	.name = "pata_fsl",
	.id = -1,
	.num_resources = ARRAY_SIZE(pata_fsl_resources),
	.resource = pata_fsl_resources,
	.dev = {
		.platform_data = &ata_data,
		.coherent_dma_mask = ~0,},
};

static void __init mxc_init_pata(void)
{

	(void)platform_device_register(&pata_fsl_device);
}
#else				/* CONFIG_PATA_FSL */
static void __init mxc_init_pata(void)
{
}
#endif				/* CONFIG_PATA_FSL */
//---------------------------------
// end modify - PATA driver
//---------------------------------

// modify by pega Kevin 2009.10.28 - Audio SGTL5000
#if defined(CONFIG_SND_SOC_IMX_3STACK_SGTL5000) || defined(CONFIG_SND_SOC_IMX_3STACK_SGTL5000_MODULE)
static int mxc_sgtl5000_amp_enable(int enable);

// modify by pega Kevin 2009.10.28 - headphone detect pin change to " EIM_D17 - HPHONE_DET "
static int headphone_det_status(void)
{
	#if ( 1 )
	return (gpio_get_value(IOMUX_TO_GPIO(MX51_PIN_EIM_D17)) == 0);
	#else
	if (cpu_is_mx51_rev(CHIP_REV_1_1) == 2)
		return (gpio_get_value(IOMUX_TO_GPIO(MX51_PIN_NANDF_D14)) == 0);

	return gpio_get_value(IOMUX_TO_GPIO(MX51_PIN_NANDF_CS0));
	#endif
}

static struct mxc_audio_platform_data sgtl5000_data = {
	.ssi_num = 1,
	.src_port = 2,
	.ext_port = 3,
	#if ( 1 ) // modify by pega Kevin 2009.10.28 - headphone detect pin set IRQ
	.hp_irq = IOMUX_TO_IRQ(MX51_PIN_EIM_D17),
	#else
	.hp_irq = IOMUX_TO_IRQ(MX51_PIN_NANDF_CS0),
	#endif
	.hp_status = headphone_det_status,
	.vddio_reg = "VVIDEO",
	.vdda_reg = "VDIG",
	.vddd_reg = "VGEN1",
	.amp_enable = mxc_sgtl5000_amp_enable,
	.vddio = 2775000,
	.vdda = 1650000,
	.vddd = 1200000,
	.sysclk = 12288000,
};

static struct platform_device mxc_sgtl5000_device = {
	.name = "imx-3stack-sgtl5000",
	.dev = {
		.release = mxc_nop_release,
		.platform_data = &sgtl5000_data,
		},
};



//add by pega Huimin 2010.02.08, to sync the audio solution from Spider1 codebase
#if ( 1 )
static int line_mute_flag = 1;		/* mute flag */
static int enable_f = 0;		/* amp enable flag */
/*
 * mxc_sgtl5000_line_mute - mute ON/OFF
 */
void mxc_sgtl5000_line_mute (int mute)
{
	if (line_mute_flag != mute) {
		int jack = headphone_det_status();
		if ((jack == 0) && (enable_f == 1) && (mute == 0)) {
#if ( 0 )			
			/*
			 * LINE-ON, AMP-enable, MUTE-OFF
			 */
			mxc_set_gpio_dataout(MX51_PIN_EIM_A23, 1);
			mxc_set_gpio_dataout(MX51_PIN_EIM_A25, 1);
#else
			sgtl5000_dap_enable(jack, 1);
			gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A23), 1);
#endif

		} else {
#if ( 0 )
			mxc_set_gpio_dataout(MX51_PIN_EIM_A23, 0);
			mxc_set_gpio_dataout(MX51_PIN_EIM_A25, 0);
#else
			gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A23), 0);
			sgtl5000_dap_enable(jack, 0);
#endif
		}
		line_mute_flag = mute;
	}
}


static int mxc_sgtl5000_amp_enable(int enable)
{
	int jack;

	if (enable == 0 || enable == 1 || enable == -1){
	} else {
		return -EINVAL;
	}

	if (enable == 0 || enable == 1){
		enable_f = enable;
	}

	jack = headphone_det_status();
	if ((jack == 0) && (enable_f == 1) && (line_mute_flag == 0)) {
		/*
		 * LINE-ON, AMP-enable, MUTE-OFF
		 */
		sgtl5000_dap_enable(jack, 1);
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A23), enable_f ? 1 : 0);
		
	} else {

		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A23),  0);
		sgtl5000_dap_enable(jack, 0);
	}

	return jack;
}

#endif



#if ( 0 )
// modify by pega Kevin 2009.10.28 - amplify power control " EIM_A23 - AUDAMP_STBYn " - source from sharp
static int mxc_sgtl5000_amp_enable(int enable)
{
	#if ( 1 )
	static int enable_f = 0;
	int jack;

	if ( enable == 0 || enable == 1 || enable == -1 ) {}
	else
		return -EINVAL;

	if ( enable == 0 || enable == 1 )
		enable_f = enable;

	jack = headphone_det_status();
	if ( jack == 0 ) // if low - accroding enable to control AMP power
	{
		//add by pega Huimin 2009.12.28 to sync the audio solution from Spider1 codebase
		#if ( USE_SGTL5000_VOLUME_FIX )
		sgtl5000_dap_enable(jack, enable_f ? 1 : 0);
		#endif
		
		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A23), enable_f ? 1 : 0);
	}
	else // if high - headphone insert , close AMP
	{
		//add by pega Huimin 2009.12.28 to sync the audio solution from Spider1 codebase
		#if ( USE_SGTL5000_VOLUME_FIX )	
		sgtl5000_dap_enable(jack, 0);
		#endif
      		gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A23),  0);
	}
	return jack;
	#else
	gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A23), enable ? 1 : 0);
	return 0;
	#endif
}
#endif

static void mxc_init_sgtl5000(void)
{
	if (cpu_is_mx51_rev(CHIP_REV_1_1) == 2) {
		sgtl5000_data.sysclk = 26000000;
		sgtl5000_data.vddd_reg = NULL;
		sgtl5000_data.vddd = 0;
	}

	gpio_request(IOMUX_TO_GPIO(MX51_PIN_EIM_A23), "eim_a23");
	gpio_direction_output(IOMUX_TO_GPIO(MX51_PIN_EIM_A23), 0);

	platform_device_register(&mxc_sgtl5000_device);
}
#else
static inline void mxc_init_sgtl5000(void)
{
}
#endif

#if defined(CONFIG_GPIO_BUTTON_MXC) || \
	defined(CONFIG_GPIO_BUTTON_MXC_MODULE)

#define MXC_BUTTON_GPIO_PIN MX51_PIN_EIM_DTACK

static struct mxc_gpio_button_data gpio_button_data = {
	.name = "Power Button (CM)",
	.gpio = MXC_BUTTON_GPIO_PIN,
	.irq = IOMUX_TO_IRQ(MXC_BUTTON_GPIO_PIN),
	.key = KEY_POWER,
};

static struct platform_device gpio_button_device = {
	.name = "gpio_button",
	.dev = {
		.release = mxc_nop_release,
		.platform_data = &gpio_button_data,
		},
};

static inline void mxc_init_gpio_button(void)
{
	DEBUG_PRINTK(("[%s] \n",  __func__));

	gpio_request(IOMUX_TO_GPIO(MXC_BUTTON_GPIO_PIN), "button");
	gpio_direction_input(IOMUX_TO_GPIO(MXC_BUTTON_GPIO_PIN));
	platform_device_register(&gpio_button_device);
}
#else
static inline void mxc_init_gpio_button(void)
{
}
#endif

//---------------------------------
// SDIO_UNIFI_FS
//---------------------------------
// add by pega Huimin 2009.11.18 - source from mx51_3stack.c
//---------------------------------
#if defined( CONFIG_SDIO_UNIFI_FS )
static void mxc_unifi_hardreset(int pin_level)
{
	/* Comment out this somehow it would bring about the issue*/
	#if ( 0 ) // remark by pega Huimin 2009.11.18 - probe driver will reset failure
	gpio_set_value(IOMUX_TO_GPIO(MX51_PIN_EIM_D23), pin_level & 0x01); // WL_RSTn
	#endif
}

static struct mxc_unifi_platform_data unifi_data =
{
	.hardreset = mxc_unifi_hardreset,
	.reg_vdd_vpa = NULL,
	.reg_1v5_dd = "VGEN1",
	.host_id = 1,
};

struct mxc_unifi_platform_data *get_unifi_plat_data(void)
{
	return &unifi_data;
}

EXPORT_SYMBOL(get_unifi_plat_data);
#endif
//---------------------------------
// end modify - SDIO_UNIFI_FS
//--------------------------------

/*!
 * Board specific fixup function. It is called by \b setup_arch() in
 * setup.c file very early on during kernel starts. It allows the user to
 * statically fill in the proper values for the passed-in parameters. None of
 * the parameters is used currently.
 *
 * @param  desc         pointer to \b struct \b machine_desc
 * @param  tags         pointer to \b struct \b tag
 * @param  cmdline      pointer to the command line
 * @param  mi           pointer to \b struct \b meminfo
 */
static void __init fixup_mxc_board(struct machine_desc *desc, struct tag *tags,
				   char **cmdline, struct meminfo *mi)
{
	char *str;
	int size = SZ_512M - SZ_32M;
	struct tag *t;

	mxc_cpu_init();

	get_cpu_wp = mx51_babbage_get_cpu_wp;
	set_num_cpu_wp = mx51_babbage_set_num_cpu_wp;

	for_each_tag(t, tags) {
		if (t->hdr.tag != ATAG_CMDLINE)
			continue;
		str = t->u.cmdline.cmdline;
		str = strstr(str, "mem=");
		if (str != NULL) {
			str += 4;
			size = memparse(str, &str);
			if (size == 0 || size == SZ_512M)
				return;
		}
	}

	for_each_tag(t, tags) {
		if (t->hdr.tag != ATAG_MEM)
			continue;

		t->u.mem.size = size;
		mxcfb_resources[0].start = t->u.mem.start + size;
		mxcfb_resources[0].end = t->u.mem.start + SZ_512M - 1;
	}
}

#define PWGT1SPIEN (1<<15)
#define PWGT2SPIEN (1<<16)
#define USEROFFSPI (1<<3)

static void mxc_power_off(void)
{
	/* We can do power down one of two ways:
	   Set the power gating
	   Set USEROFFSPI */

	/* Set the power gate bits to power down */
	pmic_write_reg(REG_POWER_MISC, (PWGT1SPIEN|PWGT2SPIEN),
		(PWGT1SPIEN|PWGT2SPIEN));
}

//modify by pega Huimin 2009.12.25 to comment out the previous POWER key code statements
#if ( 0 )
/*!
 * Power Key interrupt handler.
 */
static irqreturn_t power_key_int(int irq, void *dev_id)
{
	pr_info(KERN_INFO "PWR key pressed\n");
	return 0;
}



/*!
 * Power Key initialization.
 */
static int __init mxc_init_power_key(void)
{
	/* Set power key as wakeup resource */
	int irq, ret;
	irq = IOMUX_TO_IRQ(MX51_PIN_EIM_A27);
	set_irq_type(irq, IRQF_TRIGGER_RISING);
	ret = request_irq(irq, power_key_int, 0, "power_key", 0);
	if (ret)
		pr_info("register on-off key interrupt failed\n");
	else
		enable_irq_wake(irq);
	return ret;
}

#endif



//add by pega Huimin 2009.12.25 to support POWER key behaviors
#if ( USE_PWR_SWITCH )

#if ( 1 )
int resume_power_sw_flag;
/*
 * check resume by Power-SW
 *  return 0 - none
 *  return 1 - by Power-SW
 */
int is_resume_power_sw (void)
{
	return resume_power_sw_flag;
}
void resume_power_sw_clean (void)
{
	resume_power_sw_flag = 0;
}
#endif

static int power_key_create_inputdevice(void)
{
	int ret = 0;

	struct input_dev *pwr_inputdev;
	
	pwr_inputdev = input_allocate_device();
	if (!pwr_inputdev) {
		ret = -ENOMEM;
		goto err;
	}

	pwr_inputdev->name = "power_switch";
	input_set_capability(pwr_inputdev, EV_KEY, KEY_POWER);

	ret = input_register_device(pwr_inputdev);
	if (ret) {
		goto err;
	}

err:
	if (ret) {
		input_free_device(pwr_inputdev);
		pwr_inputdev = NULL;
	}

	return ret;
}

/*!
 * Power Key interrupt handler.
 */
static irqreturn_t power_key_int(int irq, void *dev_id)
{
	int state;
	struct input_dev *pwr_inputdev = dev_id;

//Modify by pega Huimin 2010.01.04 to syn the power key solution from Spider1 codebase
#if ( 1 )
	int ignore;
#endif

	state = gpio_get_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A27));
	pr_info(KERN_INFO "PWR key pressed:%d\n", state);

	
//Modify by pega Huimin 2010.01.04 to syn the power key solution from Spider1 codebase
#if ( 1 )
	/*
	 * check for after Power-SW(wakeup by Power-SW)
	 */
	 	ignore = 0;
		extern int is_near_wakeup (void);
		if (is_near_wakeup () == 1) {
			resume_power_sw_flag = 1;
			ignore = 1;	/* near wakeup supress event */
		} else {
			resume_power_sw_flag = 0;
		}
#endif


//Modify by pega Huimin 2010.01.04 to syn the power key solution from Spider1 codebase
#if ( 1 )
	if ( ignore == 0)
		input_report_key(pwr_inputdev, KEY_POWER, state);
#else
		input_report_key(pwr_inputdev, KEY_POWER, state);
#endif

	if (state) 
		set_irq_type(irq, IRQF_TRIGGER_FALLING);
	else
		set_irq_type(irq, IRQF_TRIGGER_RISING);
	
	return 0;
}

/*!
 * Power Key initialization.
 */
static int __init mxc_init_power_key(void)
{
	/* Set power key as wakeup resource */
	int irq, ret;

	struct input_dev *pwr_inputdev;
	
	pwr_inputdev = input_allocate_device();
	if (!pwr_inputdev) {
		ret = -ENOMEM;
		goto err;
	}

	pwr_inputdev->name = "power_switch";
	input_set_capability(pwr_inputdev, EV_KEY, KEY_POWER);

	ret = input_register_device(pwr_inputdev);
	if (ret) {
		goto err;
	}


	irq = IOMUX_TO_IRQ(MX51_PIN_EIM_A27);
	set_irq_type(irq, IRQF_TRIGGER_FALLING);
	ret = request_irq(irq, power_key_int, 0, "power_key", pwr_inputdev);
	if (ret)
		pr_info("register on-off key interrupt failed\n");
	else
		enable_irq_wake(irq);


err:
	if (ret) {
		input_free_device(pwr_inputdev);
		pwr_inputdev = NULL;
	}
	
	
	return ret;
}


late_initcall(mxc_init_power_key);

//Modify by pega Huimin 2010.01.04 to syn the power key solution from Spider1 codebase
#if ( 1 )
EXPORT_SYMBOL(is_resume_power_sw);
EXPORT_SYMBOL(resume_power_sw_clean);
#endif

#endif


//add by pega Huimin 2009.12.25, to disable the touchscreen wakeup
#if ( USE_TS_WAKEUP_FIX )	
int disable_mxc_ts_int(int disable)
{
	int value;

	pmic_read_reg(REG_INT_MASK0, &value, 0xFFFFFF);
	if ( disable )
	 value |= (1 << 2);
	else
	 value &= ~(1 << 2);
	pmic_write_reg(REG_INT_MASK0, value, 0xFFFFFF);

}

EXPORT_SYMBOL(disable_mxc_ts_int);
#endif


//add by pega Huimin 2009.12.25 to support HOLD key behaviors
#if ( USE_HOLD_SWITCH )

int get_hold_key_irq(void)
{
	return IOMUX_TO_IRQ(MX51_PIN_EIM_A25);
}

EXPORT_SYMBOL(get_hold_key_irq);


int get_hold_key_status(void)
{
	return gpio_get_value(IOMUX_TO_GPIO(MX51_PIN_EIM_A25));
}

EXPORT_SYMBOL(get_hold_key_status);


int hold_key_action(int on)
{
//add by pega Huimin 2009.12.25, to disable the touchscreen wakeup
#if ( USE_TS_WAKEUP_FIX )	
	disable_mxc_ts_int(on);
#endif
	return 0;
	
}

EXPORT_SYMBOL(hold_key_action);

#endif




/*!
 * Board specific initialization.
 */
static void __init mxc_board_init(void)
{
	mxc_cpu_common_init();
	mxc_register_gpios();
	mx51_babbage_io_init();			// mx51_babbage_gpio.c
	early_console_setup(saved_command_line);

	mxc_init_devices();				// at ?

	mxc_init_keypad(); 				// pega not use
	mxc_init_lcd();    				// add by pega Kevin 2009.10.22
	mxc_init_mmc();					// pega use
	mxc_init_gpio_button();			// pega not used
	mx51_babbage_init_mc13892();  // mx51_babbage_pmic_mc13892.c

	if (board_is_babbage_2_5() == 1)
		/* BB2.5 */
		spi_register_board_info(mxc_dataflash_device,
					ARRAY_SIZE(mxc_dataflash_device));
	else
		/* BB2.0 */
		spi_register_board_info(mxc_spi_nor_device,
					ARRAY_SIZE(mxc_spi_nor_device));

#if defined(CONFIG_I2C_MXC) || defined(CONFIG_I2C_MXC_MODULE)

#ifdef CONFIG_I2C_MXC_SELECT1
	i2c_register_board_info(0, mxc_i2c0_board_info,
				ARRAY_SIZE(mxc_i2c0_board_info));
#endif
#ifdef CONFIG_I2C_MXC_SELECT2
	i2c_register_board_info(1, mxc_i2c1_board_info,
				ARRAY_SIZE(mxc_i2c1_board_info));
#endif
#if defined(CONFIG_I2C_MXC_HS) || defined(CONFIG_I2C_MXC_HS_MODULE)
	if (cpu_is_mx51_rev(CHIP_REV_2_0) >= 1) {
		vga_data.core_reg = NULL;
		vga_data.io_reg = NULL;
		vga_data.analog_reg = NULL;
	}
	i2c_register_board_info(3, mxc_i2c_hs_board_info,
				ARRAY_SIZE(mxc_i2c_hs_board_info));
#endif

#endif
	pm_power_off = mxc_power_off;
	mxc_init_sgtl5000();
	mxc_init_oj6sh();		// add by pega Kevin 2009.10.23 - Optical Joystick
	mxc_init_pata();		// add by pega Kevin 2009.10.29 - init PATA driver
	mxc_init_vibrator();	// add by pega kevin 2009.11.02 - Vibrator Motor
	mxc_init_ctl_gpio();	// add by pega Eric  2009.12.03 - Control GPIO

#ifdef USE_DDR_SDCLK_FORCE_MEDIUM
   printk("DRAM SDCLK = %08x\n",__raw_readl(IO_ADDRESS(IOMUXC_BASE_ADDR) + 0x04b8)); // DRAM clock driver strength high to medium 0xE7 -> 0xE3
   __raw_writel(0xe3 , (IO_ADDRESS(IOMUXC_BASE_ADDR) + 0x04b8));                     // by pega Kevin 2010.03.12
   printk("DRAM SDCLK = %08x\n",__raw_readl(IO_ADDRESS(IOMUXC_BASE_ADDR) + 0x04b8));
#endif /* USE_DDR_SDCLK_FORCE_MEDIUM */
}

static void __init mx51_babbage_timer_init(void)
{
	mxc_clocks_init(32768, 24000000, 22579200, 24576000);
	mxc_timer_init("gpt_clk.0");
}

static struct sys_timer mxc_timer = {
	.init	= mx51_babbage_timer_init,
};

/*
 * The following uses standard kernel macros define in arch.h in order to
 * initialize __mach_desc_MX51_BABBAGE data structure.
 */
/* *INDENT-OFF* */
//Modify by pega Huimin 2010.01.29, to fix the CPU Hardware info
#if ( 1 )
MACHINE_START(MX51_SENDAI, "SHARP PC-T1")
#else
MACHINE_START(MX51_BABBAGE, "Freescale MX51 Babbage Board")
#endif

	/* Maintainer: Freescale Semiconductor, Inc. */
	.phys_io = AIPS1_BASE_ADDR,
	.io_pg_offst = ((AIPS1_BASE_ADDR_VIRT) >> 18) & 0xfffc,
	.boot_params = PHYS_OFFSET + 0x100,
	.fixup = fixup_mxc_board,
	.map_io = mxc_map_io,
	.init_irq = mxc_init_irq,
	.init_machine = mxc_board_init,
	.timer = &mxc_timer,
MACHINE_END
