/*
 * Copyright (C) 2005 - 2008 ServerEngines
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.  The full GNU General
 * Public License is included in this distribution in the file called COPYING.
 *
 * Contact Information:
 * linux-drivers@serverengines.com
 *
 * ServerEngines
 * 209 N. Fair Oaks Ave
 * Sunnyvale, CA 94085
 */
/*
 * Autogenerated by srcgen version: 0127
 */
#ifndef __fwcmd_common_bmap_h__
#define __fwcmd_common_bmap_h__
#include "fwcmd_types_bmap.h"
#include "fwcmd_hdr_bmap.h"

#if defined(__BIG_ENDIAN)
   /* Physical Address. */
struct PHYS_ADDR {
	union {
		struct {
			u32 lo;	/* DWORD 0 */
			u32 hi;	/* DWORD 1 */
		} __packed;	/* unnamed struct */
		u32 dw[2];	/* dword union */
	};			/* unnamed union */
} __packed ;


#else
   /* Physical Address. */
struct PHYS_ADDR {
	union {
		struct {
			u32 lo;	/* DWORD 0 */
			u32 hi;	/* DWORD 1 */
		} __packed;	/* unnamed struct */
		u32 dw[2];	/* dword union */
	};			/* unnamed union */
} __packed ;

struct BE_LINK_STATUS {
	u8 mac0_duplex;
	u8 mac0_speed;
	u8 mac1_duplex;
	u8 mac1_speed;
	u8 mgmt_mac_duplex;
	u8 mgmt_mac_speed;
	u8 active_port;
	u8 rsvd0;
	u8 mac0_fault;
	u8 mac1_fault;
	u16 rsvd1;
} __packed;
#endif

struct FWCMD_COMMON_ANON_170_REQUEST {
	u32 rsvd0;
} __packed;

union LINK_STATUS_QUERY_PARAMS {
	struct BE_LINK_STATUS response;
	struct FWCMD_COMMON_ANON_170_REQUEST request;
} __packed;

/*
 *  Queries the the link status for all ports.  The valid values below
 *  DO NOT indicate that  a particular duplex or speed is supported by
 *  BladeEngine. These enumerations simply  list all possible duplexes
 *  and speeds for any port. Consult BladeEngine product  documentation
 *  for the supported parameters.
 */
struct FWCMD_COMMON_NTWK_LINK_STATUS_QUERY {
	union FWCMD_HEADER header;
	union LINK_STATUS_QUERY_PARAMS params;
} __packed;

struct FWCMD_COMMON_ANON_171_REQUEST {
	u8 type;
	u8 port;
	u8 mac1;
	u8 permanent;
} __packed;

struct FWCMD_COMMON_ANON_172_RESPONSE {
	struct MAC_ADDRESS_FORMAT mac;
} __packed;

union NTWK_MAC_QUERY_PARAMS {
	struct FWCMD_COMMON_ANON_171_REQUEST request;
	struct FWCMD_COMMON_ANON_172_RESPONSE response;
} __packed;

/* Queries one MAC address.  */
struct FWCMD_COMMON_NTWK_MAC_QUERY {
	union FWCMD_HEADER header;
	union NTWK_MAC_QUERY_PARAMS params;
} __packed;

struct MAC_SET_PARAMS_IN {
	u8 type;
	u8 port;
	u8 mac1;
	u8 invalidate;
	struct MAC_ADDRESS_FORMAT mac;
} __packed;

struct MAC_SET_PARAMS_OUT {
	u32 rsvd0;
} __packed;

union MAC_SET_PARAMS {
	struct MAC_SET_PARAMS_IN request;
	struct MAC_SET_PARAMS_OUT response;
} __packed;

/* Sets a MAC address.  */
struct FWCMD_COMMON_NTWK_MAC_SET {
	union FWCMD_HEADER header;
	union MAC_SET_PARAMS params;
} __packed;

/* MAC address list. */
struct NTWK_MULTICAST_MAC_LIST {
	u8 byte[6];
} __packed;

struct FWCMD_COMMON_NTWK_MULTICAST_SET_REQUEST_PAYLOAD {
	u16 num_mac;
	u8 promiscuous;
	u8 rsvd0;
	struct NTWK_MULTICAST_MAC_LIST mac[32];
} __packed;

struct FWCMD_COMMON_ANON_174_RESPONSE {
	u32 rsvd0;
} __packed;

union FWCMD_COMMON_ANON_173_PARAMS {
	struct FWCMD_COMMON_NTWK_MULTICAST_SET_REQUEST_PAYLOAD request;
	struct FWCMD_COMMON_ANON_174_RESPONSE response;
} __packed;

/*
 *  Sets multicast address hash. The MPU will merge the MAC address lists
 *  from all clients,  including the networking and storage functions.
 *  This command may fail if the final merged  list of MAC addresses exceeds
 *  32 entries.
 */
struct FWCMD_COMMON_NTWK_MULTICAST_SET {
	union FWCMD_HEADER header;
	union FWCMD_COMMON_ANON_173_PARAMS params;
} __packed;

struct FWCMD_COMMON_NTWK_VLAN_CONFIG_REQUEST_PAYLOAD {
	u16 num_vlan;
	u8 promiscuous;
	u8 rsvd0;
	u16 vlan_tag[32];
} __packed;

struct FWCMD_COMMON_ANON_176_RESPONSE {
	u32 rsvd0;
} __packed;

union FWCMD_COMMON_ANON_175_PARAMS {
	struct FWCMD_COMMON_NTWK_VLAN_CONFIG_REQUEST_PAYLOAD request;
	struct FWCMD_COMMON_ANON_176_RESPONSE response;
} __packed;

/*
 *  Sets VLAN tag filter. The MPU will merge the VLAN tag list from all
 *  clients, including  the networking and storage functions. This command
 *  may fail if the final vlan_tag array  (from all functions) is longer
 *  than 32 entries.
 */
struct FWCMD_COMMON_NTWK_VLAN_CONFIG {
	union FWCMD_HEADER header;
	union FWCMD_COMMON_ANON_175_PARAMS params;
} __packed;

struct RING_DESTROY_REQUEST {
	u16 ring_type;
	u16 id;
	u8 bypass_flush;
	u8 rsvd0;
	u16 rsvd1;
} __packed;

struct FWCMD_COMMON_ANON_190_RESPONSE {
	u32 rsvd0;
} __packed;

union FWCMD_COMMON_ANON_189_PARAMS {
	struct RING_DESTROY_REQUEST request;
	struct FWCMD_COMMON_ANON_190_RESPONSE response;
} __packed;
/*
 *  Command for destroying any ring. The connection(s) using the ring should
 *  be quiesced  before destroying the ring.
 */
struct FWCMD_COMMON_RING_DESTROY {
	union FWCMD_HEADER header;
	union FWCMD_COMMON_ANON_189_PARAMS params;
} __packed;

struct FWCMD_COMMON_ANON_192_REQUEST {
	u16 num_pages;
	u16 rsvd0;
	struct CQ_CONTEXT_AMAP context;
	struct PHYS_ADDR pages[4];
} __packed ;

struct FWCMD_COMMON_ANON_193_RESPONSE {
	u16 cq_id;
} __packed ;

union FWCMD_COMMON_ANON_191_PARAMS {
	struct FWCMD_COMMON_ANON_192_REQUEST request;
	struct FWCMD_COMMON_ANON_193_RESPONSE response;
} __packed ;

/*
 *  Command for creating a completion queue. A Completion Queue must span
 *  at least 1 page and  at most 4 pages. Each completion queue entry
 *  is 16 bytes regardless of CQ entry format.  Thus the ring must be
 *  at least 256 entries deep (corresponding to 1 page) and can be at
 *   most 1024 entries deep (corresponding to 4 pages). The number of
 *  pages posted must  contain the CQ ring size as encoded in the context.
 *
 */
struct FWCMD_COMMON_CQ_CREATE {
	union FWCMD_HEADER header;
	union FWCMD_COMMON_ANON_191_PARAMS params;
} __packed ;

struct FWCMD_COMMON_ANON_198_REQUEST {
	u16 num_pages;
	u16 rsvd0;
	struct EQ_CONTEXT_AMAP context;
	struct PHYS_ADDR pages[8];
} __packed ;

struct FWCMD_COMMON_ANON_199_RESPONSE {
	u16 eq_id;
} __packed ;

union FWCMD_COMMON_ANON_197_PARAMS {
	struct FWCMD_COMMON_ANON_198_REQUEST request;
	struct FWCMD_COMMON_ANON_199_RESPONSE response;
} __packed ;

/*
 *  Command for creating a event queue. An Event Queue must span at least
 *  1 page and at most  8 pages. The number of pages posted must contain
 *  the EQ ring. The ring is defined by  the size of the EQ entries (encoded
 *  in the context) and the number of EQ entries (also  encoded in the
 *  context).
 */
struct FWCMD_COMMON_EQ_CREATE {
	union  FWCMD_HEADER header;
	union FWCMD_COMMON_ANON_197_PARAMS params;
} __packed ;

struct FWCMD_COMMON_ANON_201_REQUEST {
	u16 cq_id;
	u16 bcmc_cq_id;
	u16 num_pages;
	u16 rsvd0;
	struct PHYS_ADDR pages[2];
} __packed;

struct FWCMD_COMMON_ANON_202_RESPONSE {
	u16 id;
} __packed;

union FWCMD_COMMON_ANON_200_PARAMS {
	struct FWCMD_COMMON_ANON_201_REQUEST request;
	struct FWCMD_COMMON_ANON_202_RESPONSE response;
} __packed;

/*
 *  Command for creating Ethernet receive ring.  An ERX ring contains ETH_RX_D
 *  entries (8  bytes each). An ERX ring must be 1024 entries deep
 *  (corresponding to 2 pages).
 */
struct FWCMD_COMMON_ETH_RX_CREATE {
	union FWCMD_HEADER header;
	union FWCMD_COMMON_ANON_200_PARAMS params;
} __packed;

struct FWCMD_COMMON_ANON_204_REQUEST {
	u16 num_pages;
	u8 ulp_num;
	u8 type;
	struct ETX_CONTEXT_AMAP context;
	struct PHYS_ADDR pages[8];
} __packed ;

struct FWCMD_COMMON_ANON_205_RESPONSE {
	u16 cid;
	u8 ulp_num;
	u8 rsvd0;
} __packed ;

union FWCMD_COMMON_ANON_203_PARAMS {
	struct FWCMD_COMMON_ANON_204_REQUEST request;
	struct FWCMD_COMMON_ANON_205_RESPONSE response;
} __packed ;

/*
 *  Command for creating an Ethernet transmit ring.  An ETX ring contains
 *  ETH_WRB entries (16  bytes each). An ETX ring must be at least 256
 *  entries deep (corresponding to 1 page)  and at most 2k entries deep
 *  (corresponding to 8 pages).
 */
struct FWCMD_COMMON_ETH_TX_CREATE {
	union FWCMD_HEADER header;
	union FWCMD_COMMON_ANON_203_PARAMS params;
} __packed ;

struct FWCMD_COMMON_ANON_222_REQUEST {
	u16 num_pages;
	u16 rsvd0;
	struct MCC_RING_CONTEXT_AMAP context;
	struct PHYS_ADDR pages[8];
} __packed ;

struct FWCMD_COMMON_ANON_223_RESPONSE {
	u16 id;
} __packed ;

union FWCMD_COMMON_ANON_221_PARAMS {
	struct FWCMD_COMMON_ANON_222_REQUEST request;
	struct FWCMD_COMMON_ANON_223_RESPONSE response;
} __packed ;

/*
 *  Command for creating the MCC ring. An MCC ring must be at least 16
 *  entries deep  (corresponding to 1 page) and at most 128 entries deep
 *  (corresponding to 8 pages).
 */
struct FWCMD_COMMON_MCC_CREATE {
	union FWCMD_HEADER header;
	union FWCMD_COMMON_ANON_221_PARAMS params;
} __packed ;

struct GET_QOS_IN {
	u32 qos_params_rsvd;
} __packed;

struct GET_QOS_OUT {
	u32 max_bits_per_second_NIC;
	u32 max_packets_per_second_NIC;
	u32 max_ios_per_second_iSCSI;
	u32 max_bytes_per_second_iSCSI;
	u16 domain_VLAN_tag;
	u16 fabric_domain_ID;
	u32 qos_params_oem[4];
} __packed;

union GET_QOS_PARAMS {
	struct GET_QOS_IN request;
	struct GET_QOS_OUT response;
} __packed;

/* QOS/Bandwidth settings per domain. Applicable only in VMs.  */
struct FWCMD_COMMON_GET_QOS {
	union FWCMD_HEADER header;
	union GET_QOS_PARAMS params;
} __packed;

struct SET_QOS_IN {
	u32 valid_flags;
	u32 max_bits_per_second_NIC;
	u32 max_packets_per_second_NIC;
	u32 max_ios_per_second_iSCSI;
	u32 max_bytes_per_second_iSCSI;
	u16 domain_VLAN_tag;
	u16 fabric_domain_ID;
	u32 qos_params_oem[4];
} __packed;

struct SET_QOS_OUT {
	u32 qos_params_rsvd;
} __packed;

union SET_QOS_PARAMS {
	struct SET_QOS_IN request;
	struct SET_QOS_OUT response;
} __packed;

/* QOS/Bandwidth settings per domain. Applicable only in VMs.  */
struct FWCMD_COMMON_SET_QOS {
	union FWCMD_HEADER header;
	union SET_QOS_PARAMS params;
} __packed;

struct SET_FRAME_SIZE_IN {
	u32 max_tx_frame_size;
	u32 max_rx_frame_size;
} __packed;

struct SET_FRAME_SIZE_OUT {
	u32 chip_max_tx_frame_size;
	u32 chip_max_rx_frame_size;
} __packed;

union SET_FRAME_SIZE_PARAMS {
	struct SET_FRAME_SIZE_IN request;
	struct SET_FRAME_SIZE_OUT response;
} __packed;

/* Set frame size command. Only host domain may issue this command.  */
struct FWCMD_COMMON_SET_FRAME_SIZE {
	union FWCMD_HEADER header;
	union SET_FRAME_SIZE_PARAMS params;
} __packed;

struct FORCE_FAILOVER_IN {
	u32 move_to_port;
	u32 failover_config;
} __packed;

struct FWCMD_COMMON_ANON_231_RESPONSE {
	u32 rsvd0;
} __packed;

union FWCMD_COMMON_ANON_230_PARAMS {
	struct FORCE_FAILOVER_IN request;
	struct FWCMD_COMMON_ANON_231_RESPONSE response;
} __packed;

/*
 *  Use this command to control failover in BladeEngine. It may be used
 *  to failback to a  restored port or to forcibly move traffic from
 *  one port to another. It may also be used  to enable or disable the
 *  automatic failover feature. This command can only be issued by  domain
 *  0.
 */
struct FWCMD_COMMON_FORCE_FAILOVER {
	union FWCMD_HEADER header;
	union FWCMD_COMMON_ANON_230_PARAMS params;
} __packed;

struct FWCMD_COMMON_ANON_240_REQUEST {
	u64 context;
} __packed;

struct FWCMD_COMMON_ANON_241_RESPONSE {
	u64 context;
} __packed;

union FWCMD_COMMON_ANON_239_PARAMS {
	struct FWCMD_COMMON_ANON_240_REQUEST request;
	struct FWCMD_COMMON_ANON_241_RESPONSE response;
} __packed;

/*
 *  This command can be used by clients as a no-operation request. Typical
 *  uses for drivers  are as a heartbeat mechanism, or deferred processing
 *  catalyst. The ARM will always  complete this command with a good completion.
 *  The 64-bit parameter is not touched by the  ARM processor.
 */
struct FWCMD_COMMON_NOP {
	union FWCMD_HEADER header;
	union FWCMD_COMMON_ANON_239_PARAMS params;
} __packed;

struct NTWK_RX_FILTER_SETTINGS {
	u8 promiscuous;
	u8 ip_cksum;
	u8 tcp_cksum;
	u8 udp_cksum;
	u8 pass_err;
	u8 pass_ckerr;
	u8 strip_crc;
	u8 mcast_en;
	u8 bcast_en;
	u8 mcast_promiscuous_en;
	u8 unicast_en;
	u8 vlan_promiscuous;
} __packed;

union FWCMD_COMMON_ANON_242_PARAMS {
	struct NTWK_RX_FILTER_SETTINGS request;
	struct NTWK_RX_FILTER_SETTINGS response;
} __packed;

/*
 *  This command is used to modify the ethernet receive filter configuration.
 *  Only domain 0  network function drivers may issue this command. The
 *  applied configuration is returned in  the response payload. Note:
 *  Some receive packet filter settings are global on  BladeEngine and
 *  can affect both the storage and network function clients that the
 *   BladeEngine hardware and firmware serve. Additionaly, depending
 *  on the revision of  BladeEngine, some ethernet receive filter settings
 *  are dependent on others. If a  dependency exists between settings
 *  for the BladeEngine revision, and the command request  settings do
 *  not meet the dependency requirement, the invalid settings will not
 *  be  applied despite the comand succeeding. For example: a driver may
 *  request to enable  broadcast packets, but not enable multicast packets.
 *  On early revisions of BladeEngine,  there may be no distinction between
 *  broadcast and multicast filters, so broadcast could  not be enabled
 *  without enabling multicast. In this scenario, the comand would still
 *   succeed, but the response payload would indicate the previously
 *  configured broadcast  and multicast setting.
 */
struct FWCMD_COMMON_NTWK_RX_FILTER {
	union FWCMD_HEADER header;
	union FWCMD_COMMON_ANON_242_PARAMS params;
} __packed;


struct FWCMD_COMMON_ANON_244_REQUEST {
	u32 rsvd0;
} __packed;

struct FWCMD_COMMON_GET_FW_VERSION_RESPONSE_PAYLOAD {
	u8 firmware_version_string[32];
	u8 fw_on_flash_version_string[32];
} __packed;

union FWCMD_COMMON_ANON_243_PARAMS {
	struct FWCMD_COMMON_ANON_244_REQUEST request;
	struct FWCMD_COMMON_GET_FW_VERSION_RESPONSE_PAYLOAD response;
} __packed;

/* This comand retrieves the firmware version.  */
struct FWCMD_COMMON_GET_FW_VERSION {
	union FWCMD_HEADER header;
	union FWCMD_COMMON_ANON_243_PARAMS params;
} __packed;

struct FWCMD_COMMON_ANON_246_REQUEST {
	u16 tx_flow_control;
	u16 rx_flow_control;
} __packed;

struct FWCMD_COMMON_ANON_247_RESPONSE {
	u32 rsvd0;
} __packed;

union FWCMD_COMMON_ANON_245_PARAMS {
	struct FWCMD_COMMON_ANON_246_REQUEST request;
	struct FWCMD_COMMON_ANON_247_RESPONSE response;
} __packed;

/*
 *  This comand is used to program BladeEngine flow control behavior.
 *  Only the host  networking driver is allowed to use this comand.
 */
struct FWCMD_COMMON_SET_FLOW_CONTROL {
	union FWCMD_HEADER header;
	union FWCMD_COMMON_ANON_245_PARAMS params;
} __packed;

struct FWCMD_COMMON_ANON_249_REQUEST {
	u32 rsvd0;
} __packed;

struct FWCMD_COMMON_ANON_250_RESPONSE {
	u16 tx_flow_control;
	u16 rx_flow_control;
} __packed;

union FWCMD_COMMON_ANON_248_PARAMS {
	struct FWCMD_COMMON_ANON_249_REQUEST request;
	struct FWCMD_COMMON_ANON_250_RESPONSE response;
} __packed;

/* This comand is used to read BladeEngine flow control settings.  */
struct FWCMD_COMMON_GET_FLOW_CONTROL {
	union FWCMD_HEADER header;
	union FWCMD_COMMON_ANON_248_PARAMS params;
} __packed;

struct EQ_DELAY_PARAMS {
	u32 eq_id;
	u32 delay_in_microseconds;
} __packed;

struct FWCMD_COMMON_ANON_257_REQUEST {
	u32 num_eq;
	u32 rsvd0;
	struct EQ_DELAY_PARAMS delay[16];
} __packed;

struct FWCMD_COMMON_ANON_258_RESPONSE {
	u32 delay_resolution_in_microseconds;
	u32 delay_max_in_microseconds;
} __packed;

union MODIFY_EQ_DELAY_PARAMS {
	struct FWCMD_COMMON_ANON_257_REQUEST request;
	struct FWCMD_COMMON_ANON_258_RESPONSE response;
} __packed;

/* This comand changes the EQ delay for a given set of EQs.  */
struct FWCMD_COMMON_MODIFY_EQ_DELAY {
	union FWCMD_HEADER header;
	union MODIFY_EQ_DELAY_PARAMS params;
} __packed;

struct FWCMD_COMMON_ANON_260_REQUEST {
	u32 rsvd0;
} __packed;

struct BE_FIRMWARE_CONFIG {
	u16 be_config_number;
	u16 asic_revision;
	u32 nic_ulp_mask;
	u32 tulp_mask;
	u32 iscsi_ulp_mask;
	u32 rdma_ulp_mask;
	u32 rsvd0[4];
	u32 eth_tx_id_start;
	u32 eth_tx_id_count;
	u32 eth_rx_id_start;
	u32 eth_rx_id_count;
	u32 tpm_wrbq_id_start;
	u32 tpm_wrbq_id_count;
	u32 tpm_defq_id_start;
	u32 tpm_defq_id_count;
	u32 iscsi_wrbq_id_start;
	u32 iscsi_wrbq_id_count;
	u32 iscsi_defq_id_start;
	u32 iscsi_defq_id_count;
	u32 rdma_qp_id_start;
	u32 rdma_qp_id_count;
	u32 rsvd1[8];
} __packed;

union FWCMD_COMMON_ANON_259_PARAMS {
	struct FWCMD_COMMON_ANON_260_REQUEST request;
	struct BE_FIRMWARE_CONFIG response;
} __packed;

/*
 *  This comand queries the current firmware configuration parameters.
 *   The static  configuration type is defined by be_config_number. This
 *  differentiates different  BladeEngine builds, such as iSCSI Initiator
 *  versus iSCSI Target.  For a given static  configuration, the Upper
 *  Layer Protocol (ULP) processors may be reconfigured to support  different
 *  protocols. Each ULP processor supports one or more protocols. The
 *  masks  indicate which processors are configured for each protocol.
 *   For a given static  configuration, the number of TCP connections
 *  supported for each protocol may vary. The  *_id_start and *_id_count
 *  variables define a linear range of IDs that are available for  each
 *  supported protocol. The *_id_count may be used by the driver to allocate
 *  the  appropriate number of connection resources. The *_id_start may
 *  be used to map the  arbitrary range of IDs to a zero-based range
 *  of indices.
 */
struct FWCMD_COMMON_FIRMWARE_CONFIG {
	union FWCMD_HEADER header;
	union FWCMD_COMMON_ANON_259_PARAMS params;
} __packed;

struct FWCMD_COMMON_PORT_EQUALIZATION_PARAMS {
	u32 emph_lev_sel_port0;
	u32 emph_lev_sel_port1;
	u8 xaui_vo_sel;
	u8 xaui_state;
	u16 rsvd0;
	u32 xaui_eq_vector;
} __packed;

struct FWCMD_COMMON_ANON_262_REQUEST {
	u32 rsvd0;
} __packed;

union FWCMD_COMMON_ANON_261_PARAMS {
	struct FWCMD_COMMON_ANON_262_REQUEST request;
	struct FWCMD_COMMON_PORT_EQUALIZATION_PARAMS response;
} __packed;

/*
 *  This comand can be used to read XAUI equalization parameters. The
 *  ARM firmware applies  default equalization parameters during initialization.
 *  These parameters may be  customer-specific when derived from the
 *  SEEPROM. See SEEPROM_DATA for equalization  specific fields.
 */
struct FWCMD_COMMON_GET_PORT_EQUALIZATION {
	union FWCMD_HEADER header;
	union FWCMD_COMMON_ANON_261_PARAMS params;
} __packed;

struct FWCMD_COMMON_ANON_264_RESPONSE {
	u32 rsvd0;
} __packed;

union FWCMD_COMMON_ANON_263_PARAMS {
	struct FWCMD_COMMON_PORT_EQUALIZATION_PARAMS request;
	struct FWCMD_COMMON_ANON_264_RESPONSE response;
} __packed;

/*
 *  This comand can be used to set XAUI equalization parameters. The ARM
 *  firmware applies  default equalization parameters during initialization.
 *  These parameters may be  customer-specific when derived from the
 *  SEEPROM. See SEEPROM_DATA for equalization  specific fields.
 */
struct FWCMD_COMMON_SET_PORT_EQUALIZATION {
	union FWCMD_HEADER header;
	union FWCMD_COMMON_ANON_263_PARAMS params;
} __packed;

#endif /* __fwcmd_common_bmap_h__ */
