/* **********************************************************
 * Copyright 1998-2003 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 * **********************************************************/

/*
 *
 * vcpuid.h --
 *
 *    Monitor's VCPU ID.
 */

#ifndef _VCPUID_H_
#define _VCPUID_H_

#define INCLUDE_ALLOW_USERLEVEL
#define INCLUDE_ALLOW_VMMEXT
#define INCLUDE_ALLOW_MODULE
#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMNIXMOD
#define INCLUDE_ALLOW_VMKERNEL
#define INCLUDE_ALLOW_VMK_MODULE
#define INCLUDE_ALLOW_DISTRIBUTE
#define INCLUDE_ALLOW_VMCORE
#include "includeCheck.h"


typedef uint32 Vcpuid;			// VCPU number

#define VCPUID_UP	(0)		// XXX to be phased out
#define VCPUID_PIC	VCPUID_UP	// CPU on which interrupts are routed
#define VCPUID_INVALID	(~0U)

#define BOOT_VCPU_ID		0
#define IS_BOOT_VCPUID(vcpuid)  ((vcpuid) == BOOT_VCPU_ID)
#define IS_BOOT_VCPU()		IS_BOOT_VCPUID(CurVcpuid())

#define MAX_VCPUS	8


#endif // ifndef _VCPUID_H_
