/*
 * Copyright (C) 2005 - 2008 ServerEngines
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.  The full GNU General
 * Public License is included in this distribution in the file called COPYING.
 *
 * Contact Information:
 * linux-drivers@serverengines.com
 *
 * ServerEngines
 * 209 N. Fair Oaks Ave
 * Sunnyvale, CA 94085
 */
/*
 * Autogenerated by srcgen version: 0127
 */
#ifndef __asyncmesg_amap_h__
#define __asyncmesg_amap_h__
#include "fwcmd_common.h"

/* --- ASYNC_EVENT_CODES --- */
#define ASYNC_EVENT_CODE_LINK_STATE     (1)
#define ASYNC_EVENT_CODE_ISCSI          (2)

/* --- ASYNC_LINK_STATES --- */
#define ASYNC_EVENT_LINK_DOWN           (0)	/* Link Down on a port */
#define ASYNC_EVENT_LINK_UP             (1)	/* Link Up on a port */

/*
 * The last 4 bytes of the async events have this common format.  It allows
 * the driver to distinguish [link]MCC_CQ_ENTRY[/link] structs from
 * asynchronous events.  Both arrive on the same completion queue.  This
 * structure also contains the common fields used to decode the async event.
 */
struct BE_ASYNC_EVENT_TRAILER_AMAP {
	u8 rsvd0[8];	/* DWORD 0 */
	u8 event_code[8];	/* DWORD 0 */
	u8 event_type[8];	/* DWORD 0 */
	u8 rsvd1[6];	/* DWORD 0 */
	u8 async_event;	/* DWORD 0 */
	u8 valid;		/* DWORD 0 */
} __packed;
struct ASYNC_EVENT_TRAILER_AMAP {
	u32 dw[1];
};

/*
 * Applicable in Initiator, Target and NIC modes.
 * A link state async event is seen by all device drivers as soon they
 * create an MCC ring. Thereafter, anytime the link status changes the
 * drivers will receive a link state async event. Notifications continue to
 * be sent until a driver destroys its MCC ring. A link down event is
 * reported when either port loses link. A link up event is reported
 * when either port regains link. When BE's failover mechanism is enabled, a
 * link down on the active port causes traffic to be diverted to the standby
 * port by the BE's ARM firmware (assuming the standby port has link). In
 * this case, the standy port assumes the active status. Note: when link is
 * restored on the failed port, traffic continues on the currently active
 * port. The ARM firmware does not attempt to 'fail back' traffic to
 * the restored port.
 */
struct BE_ASYNC_EVENT_LINK_STATE_AMAP {
	u8 port0_link_status[8];
	u8 port1_link_status[8];
	u8 active_port[8];
	u8 rsvd0[8];	/* DWORD 0 */
	u8 port0_duplex[8];
	u8 port0_speed[8];
	u8 port1_duplex[8];
	u8 port1_speed[8];
	u8 port0_fault[8];
	u8 port1_fault[8];
	u8 rsvd1[2][8];	/* DWORD 2 */
	struct BE_ASYNC_EVENT_TRAILER_AMAP trailer;
} __packed;
struct ASYNC_EVENT_LINK_STATE_AMAP {
	u32 dw[4];
};
#endif /* __asyncmesg_amap_h__ */
