# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


import threading
try: from elementtree.ElementTree import fromstring as XMLFromString
except ImportError: 
    # Python 2.5 rename
    from xml.etree.ElementTree import fromstring as XMLFromString

import urllib
from time import time

from web_threading import WebFetchThread
import utils

class LastFmInfo:
    def __init__(self):
        
        self.condition_artist = threading.Condition() 
        self.download_thread_related = WebFetchThread(1024,self.fail_fetch)
        self.download_thread_related.set_mode_queue(True)
        
        self.download_thread_topalbum = WebFetchThread(1024,self.fail_fetch)
        self.download_thread_topalbum.set_mode_queue(True)
        
        self.related_cache = {}
        self.topalbum_cache = {}
        
    def fail_fetch(self):
        print "W:LastFmInfo:Failed retrieve url not catched"
        pass
    
    def get_related(self,artist,callback,*args_cb,**kargs):
        if self.related_cache.has_key(artist):
            callback(self.related_cache[artist][1],*args_cb)
        else:
            url_artist = "http://ws.audioscrobbler.com/1.0/artist/%s/similar.xml"%urllib.quote(utils.filter_info_song(artist).encode("utf-8"))    
            self.download_thread_related.fetch_url(url_artist,self.fetch_related,artist,callback,*args_cb,**kargs)
        
        
    def fetch_related(self,file,artist,callback,*args_cb):
        try:
            root = XMLFromString(file.read())
        except:pass
        else:
            related = []            
            for i,a in enumerate(root.getchildren()):
                if a.tag == 'artist':
                    item = {}
                    for at in a.getchildren():    
                        if at.tag == 'name':
                            item["name"] = at.text
                        if at.tag == 'url':
                            item["url"] = at.text
                        if at.tag == 'match':
                            item["match"] = at.text
                        if at.tag == 'image_small':
                            item["image_small"] = at.text
                        if at.tag == 'image_big':
                            item["image_big"] = at.text
                    related.append(item)
            self.related_cache[artist] = (time(),related)
            callback(self.related_cache[artist][1],*args_cb)
        
    def get_topalbum(self,artist,callback,*args_cb,**kargs):
        if self.topalbum_cache.has_key(artist):
            callback(self.topalbum_cache[artist][1],*args_cb)
        else:
            url_artist = "http://ws.audioscrobbler.com/1.0/artist/%s/topalbums.xml"%urllib.quote(utils.filter_info_song(artist).encode("utf-8"))    
            self.download_thread_topalbum.fetch_url(url_artist,self.fetch_topalbum,artist,callback,*args_cb,**kargs)
        
        
    def fetch_topalbum(self,file,artist,callback,*args_cb):
        try:
            root = XMLFromString(file.read())
        except:pass
        else:
            topalbum = []        
            initial = None
            for i,a in enumerate(root.getchildren()):
                if a.tag == 'album':
                    item = {}
                    for at in a.getchildren():    
                        if at.tag == 'name':
                            item["name"] = at.text
                        if at.tag == 'url':
                            item["url"] = at.text
                        if at.tag == 'reach':
                            if initial==None or initial==0:
                                initial = int(at.text)
                                item["reach"] = at.text
                                item["reach_percent"] = "100"
                            else:
                                item["reach"] = at.text    
                                item["reach_percent"] = "%d"%( int(at.text)*100/initial )
                            
                        if at.tag == 'coverart':
                            for art in at.getchildren():    
                                if art.tag == 'small':
                                   item["image_small"] = art.text
                                if art.tag == 'big':
                                   item["image_big"] = art.text
                                   
                    topalbum.append(item)
                    
            self.topalbum_cache[artist] = (time(),topalbum)
            callback(self.topalbum_cache[artist][1],*args_cb)
                    
lastfm_info = LastFmInfo()
        
        
        
