# -*- coding: utf-8 -*-
# vim: ts=4
###
# written by xsdnyd <xsdnyd@gmail.com>
###

import urllib
import string
from xml.dom.minidom import parse as xmlparse

from plugins.lyrics import LyricsPlugin

class LyricwikiPlugin(LyricsPlugin):
    PLUGIN_NAME = "lyricwiki.org"
    PLUGIN_DESC = "Add support of lyricwiki.org website to provide lyrics"
    PLUGIN_VERSION = "2.0"
    server_name = "lyricwiki.org"
    PLUGIN_AUTHOR = "Ajnasz "
    PLUGIN_WEBSITE = ""
    
    def process_lyrics(self, artist, album, title, song):
        url = "http://lyricwiki.org/api.php?artist=%s&song=%s&fmt=xml"%( 
                urllib.quote(artist.encode('utf-8')), 
                urllib.quote(title.encode('utf-8'))) 
        self.download_data(url,self.fetch_lyrics_lyricwiki,song)

    def fetch_lyrics_lyricwiki(self,html_buffer,song):
        try:
            xml = xmlparse(html_buffer)
        except:
            self.logexception("failed fetch_lyrics_part1 xml")
            self.render(_("Server did not respond."))
        else:
            xmldoc = xml.documentElement
            try: text = xmldoc.getElementsByTagName('lyrics')[0].firstChild.nodeValue
            except :
                self.logexception("failed read xml reponse")
                self.render(_("Can't read the lyrics from the server."))
            else:
                self.render(text.replace("\n","<br />"),song,True)
            xmldoc.unlink()

    """ OLD METHOD """
    def __process_lyrics(self,artist,album,title,song):
        url = "http://www.lyricwiki.org/%s:%s" % ( urllib.quote(string.replace(string.capwords(artist.encode('utf-8')), " ", "_")), 
                                                urllib.quote(string.replace(string.capwords(title.encode('utf-8')), " ", "_")))
        self.download_data(url,self.fetch_lyrics_lyricwiki,song)

    def __fetch_lyrics_lyricwiki(self,html_buffer,song):
        startMarker = "<div id=\"lyric\">"
        endMarker = "</div>"
        lyric = html_buffer.read()
        pos = string.find(lyric, startMarker)
        if pos < 0:
            self.render(_("Unable to find any matches for this song."))
        else:
            pos += len(startMarker)
            if lyric[pos] == "<":
                pos = string.find(lyric, ">", pos) + 1
            lyric = string.replace(lyric[pos:string.find(lyric, endMarker, pos) - len(endMarker)], "<br/>", "<br />")
            self.render(lyric,song,True)
