# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###


import os
import re
import urlparse
from urllib2 import urlopen

# Function discover_http_proxy found at : 
# https://svn.berlios.de/wsvn/solipsis/trunk/main/solipsis/util/httpproxy.py?op=file&rev=0&sc=0
# Solipsis, a peer-to-peer serverless virtual world.
# Copyright (C) 2002-2005 France Telecom R&D
def discover_http_proxy():
    """
    Returns a (host, port) tuple if an HTTP proxy is found in the
    current machine configuration, (None, None) otherwise.
    
    Note: automatic proxy configuration file (*.pac) handling is braindead.
    """

    host_port = None
    host = port = None
    pac_url = None

    # Unix 
    if 'http_proxy' in os.environ:
        parts = urlparse.urlparse(os.environ['http_proxy'])
        if not parts[0] or parts[0] == 'http':
            host_port = parts[1]

    # Gnome
    try:
        import gconf
        client = gconf.client_get_default()
    except:
        pass
    else:
        try: 
            mode = client.get_string('/system/proxy/mode')
        except: 
            pass
        else:
            if mode == 'auto':
                pac_url = client.get_string('/system/proxy/autoconfig_url')
            elif mode == 'manual':
                if client.get_bool('/system/http_proxy/use_http_proxy'):
                    host = client.get_string('/system/http_proxy/host')
                    port = client.get_int('/system/http_proxy/port')

    # Read PAC file if necessary
    # Yes, we could use Twisted, but we don't need asynchronicity here
    if pac_url and not host and not host_port:
        try:
            f = urlopen(pac_url)
        except Exception, e:
            print str(e)
            pass
        else:
            print pac_url
            # A hack until someone embeds a Javascript interpreter in Python...
            regex = re.compile(r'PROXY\s(\d+.\d+.\d+.\d+:\d+)')
            for l in f:
                m = regex.search(l)
                if m is not None:
                    host_port = m.group(1)
                    break

    # Split host and port if necessary
    if host_port and not host:
        t = host_port.split(':')
        host = t[0].strip()
        if host:
            try:
                port = int(t[1])
            except:
                port = 80
    
    if host and port:
        return {"http":"http://%s:%d"%(host,port)}
    else:
        return {}


