/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */


#ifndef _G_GADGET_H_
#define _G_GADGET_H_

#include <glib.h>
#include <glib-object.h>
#include <libgadget/libgadget.h>

G_BEGIN_DECLS

#define G_TYPE_GADGET (g_gadget_get_type ())

#define G_GADGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
        G_TYPE_GADGET, GGadget))

#define G_GADGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
      	G_TYPE_GADGET, GGadgetClass))

#define G_IS_GADGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
        G_TYPE_GADGET))

#define G_GADGET_IS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
        G_TYPE_GADGET))

#define G_GADGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
        G_TYPE_GADGET, GGadgetClass))

typedef struct _GGadget        GGadget;
typedef struct _GGadgetClass   GGadgetClass;
typedef struct _GGadgetPrivate GGadgetPrivate;

struct _GGadget
{
  GadgetCairo parent;

  GGadgetPrivate *priv;
};

struct _GGadgetClass
{
  /*< private >*/
  GadgetCairoClass  parent_class;

  /*< public >*/
  
  /* signals, not vfuncs */
  
  /* vtable */
  
  /*< private >*/
  /* padding */
  void (*_g_gadget_padding1) (void);
  void (*_g_gadget_padding2) (void);
  void (*_g_gadget_padding3) (void);
  void (*_g_gadget_padding4) (void);
  void (*_g_gadget_padding5) (void);
  void (*_g_gadget_padding6) (void);
};

GType g_gadget_get_type (void) G_GNUC_CONST;

G_END_DECLS

#endif /* _G_GADGET_H_ */

