/*
 * Copyright 2005-2008 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * Based on gstavidemux.h by Erik Walthinsen <omega@cse.ogi.edu>
 */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Module Name:    mfw_gst_avidemuxer.h
 *
 * Description:    This Header file contains all the declarations for  
 *                 AVI Demuxer Plugin for GStreamer. 
 *
 * Portability:    This code is written for Linux OS and Gstreamer
 */  
 
/*
 * Changelog: 
 * 
 */

/*===============================================================================
                                INCLUDE FILES
=============================================================================*/

/* None. */
/*=============================================================================
                                 CONSTANTS
=============================================================================*/

#define AVI_DEMUX_VIDEO_BUFFERS         2
#define AVI_DEMUX_AUDIO_BUFFERS         2
#define AVI_DEMUX_INPUT_BUFFERS         2
#define AVI_DEMUX_INPUT_BUFFER_SIZE     1000 * 1024
#define AVI_DEMUX_MAX_STREAMS           2
#define AVI_DEMUX_VIDEO_STREAM          0
#define AVI_DEMUX_AUDIO_STREAM          1


#define AVIIF_KEYFRAME 0x10     //This frame is a key frame 
#define AVIIF_NOTIME   0x100    //this frame doesn't take any time. For drm entries.
/*=============================================================================
								  MACROS
=============================================================================*/

#ifndef _MFW_GST_AVI_DEMUXER_H_
#define _MFW_GST_AVI_DEMUXER_H_

G_BEGIN_DECLS
#define MFW_GST_TYPE_AVI_DEMUXER (mfw_gst_type_avidemuxer_get_type())
#define MFW_GST_AVI_DEMUXER(obj) \
	(G_TYPE_CHECK_INSTANCE_CAST((obj), MFW_GST_TYPE_AVI_DEMUXER, MFW_GST_AVIDEMUX_INFO_T))
#define MFW_GST_AVI_DEMUXER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), MFW_GST_TYPE_AVI_DEMUXER, MFW_GST_AVIDEMUX_INFO_CLASS_T))
#define MFW_GST_IS_AVI_DEMUXER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), MFW_GST_TYPE_AVI_DEMUXER))
#define MFW_GST_IS_AVI_DEMUXER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), MFW_GST_TYPE_AVI_DEMUXER))
/*=============================================================================
                                             ENUMS
=============================================================================*/
    typedef enum {
    MFW_GST_AVI_MEDIA_AUDIO_TRACK = 0,
    MFW_GST_AVI_MEDIA_VIDEO_TRACK
} MFW_GST_AVI_MEDIA_TYPE_T;

/*=============================================================================
                                 STRUCTURES AND OTHER TYPEDEFS
=============================================================================*/

/*  This structure is used by the Gstreamer-Plugin for creating the Audio/Video
    pads. This structure contains the riff data structures for pads creation.
*/
typedef struct _gst_riff_avih {
    guint32 us_frame;		/* microsec per frame */
    guint32 max_bps;		/* byte/s overall */
    guint32 pad_gran;		/* pad_granularity */
    guint32 flags;
    /* flags values */
#define GST_RIFF_AVIH_HASINDEX       0x00000010	/* has idx1 chunk */
#define GST_RIFF_AVIH_MUSTUSEINDEX   0x00000020	/* must use idx1 chunk to determine order */
#define GST_RIFF_AVIH_ISINTERLEAVED  0x00000100	/* AVI file is interleaved */
#define GST_RIFF_AVIH_WASCAPTUREFILE 0x00010000	/* specially allocated used for capturing real time video */
#define GST_RIFF_AVIH_COPYRIGHTED    0x00020000	/* contains copyrighted data */
    guint32 tot_frames;		/* # of frames (all) */
    guint32 init_frames;	/* initial frames (???) */
    guint32 streams;
    guint32 bufsize;		/* suggested buffer size */
    guint32 width;
    guint32 height;
    guint32 scale;
    guint32 rate;
    guint32 start;
    guint32 length;
} gst_riff_avih;

typedef struct {
   /* gint index_nr; */     /* removed to decrease memory */
    gint stream_nr;
    gint size;
    guint32 flags;
    guint32 frames_before;  /* to calculate timestamp (for vbr audio, this is bytes_before) */
   /* guint64 ts, dur; */   /* removed and calculate on time to decrease memory */
    guint32 offset;         /* changed from 64 to 32 bits long to decrease memory */
   /* guint64 bytes_before; */ /* not used and removed to decrease memory */
} gst_avi_index_entry;

typedef struct _avi_stream_context {
    guint num;			/* index of this stream */

    GstPad *src_pad;
    gst_riff_strh strh;

    union {
	gst_riff_strf_vids vids;
	gst_riff_strf_auds auds;
    } strf;

    GstBuffer *strd;
    gchar *name;
    GstBuffer *tmp_av_buffer;	// For Handling the non-complete buffer.

    /* current position (byte, frame, time) */
    guint current_frame;
    guint64 current_byte;
    gint current_entry;

    /* stream length */
    guint64 total_bytes;
    guint32 total_frames;

    guint64 *indexes;

} avi_stream_context;

/*  This structure is used by the parser library to give information to the plug-in.
    This structure contains lot of variables which are similar to the above strcture, 
    but the reason why this is separate is because we wanted to maintain clean interface
    between parser library and the gstreamer plug-in.
*/

typedef struct _avi_parser_info {
    STD_BD_SET_T stOut[AVI_DEMUX_MAX_STREAMS];	// Two outputs needed - audio and video
    STD_BD_T video_output[AVI_DEMUX_VIDEO_BUFFERS];
    STD_BD_T audio_output[AVI_DEMUX_AUDIO_BUFFERS];
    STD_BD_T avi_input[AVI_DEMUX_INPUT_BUFFERS];
    STD_BD_SET_T stIn;		// One input type used - avi
    FSR_AVI_DEMUX_CTRL_T stCtrl;
    FSR_AVI_DEMUX_STAT_T stStat;

} avi_parser_info;

typedef struct _MFWGstAviDemux {
    GstElement element;
    GstPad *sinkpad;
    gboolean init_parser;
    GstState state;
    avi_stream_context avi_stream[AVI_DEMUX_MAX_STREAMS];
    avi_parser_info avi_str_content;

    guint *input_buf;		// Input Buffer Pointer.
    gint input_buf_offset;	// Offset from the beg of the file.
    gboolean is_eos;
    gboolean new_segment[AVI_DEMUX_MAX_STREAMS];
    gint buf_filled;

    guint num_v_streams;	/* actual numbers video format in stream */
    guint num_a_streams;	/* actual numbers audio format in stream */
    guint num_streams;		/* actual numbers audio format in stream */
    guint i_loop;
    gst_riff_avih *avih;
    /* in GST_FORMAT_TIME */
    gint64 segment_start;
    gint64 segment_stop;

    guint32 offset;         /*offset of the 'movi' list, point to fourcc 'LIST'.changed from 64 to 32 bits long to decrease memory */
    //guint64    index_offset;    

    /* seeking */
    gdouble segment_rate;
    GstSeekFlags segment_flags;

    /* index */
    gst_avi_index_entry *index_entries;
    guint index_size;
    guint32 index_offset;         /* base offset of index entries, point to 'movi' list type fourcc 'movi'.changed from 64 to 32 bits long to decrease memory */
    guint current_entry;
    GstEvent *seek_event;
    gchar end_bitstream;
    gint last_index_read;
    gint64 total_duration;
    gboolean isWork;
    gst_avi_index_entry *ptr_to_entry;
    guint64 max_video_time;
    guint64 max_audio_time;
    gboolean video_eos;
    gboolean audio_eos;
    gboolean trick_mode;
    gint     trick_direction;
    guint64  prvBufTime;

    gboolean videosent;

} MFW_GST_AVIDEMUX_INFO_T;

typedef struct _MFWGstAviDemuxClass {
    GstElementClass parent_class;
} MFW_GST_AVIDEMUX_INFO_CLASS_T;



/*=============================================================================
                                 GLOBAL VARIABLE DECLARATIONS
=============================================================================*/

/* None. */

/*=============================================================================
                                     FUNCTION PROTOTYPES
=============================================================================*/

GType mfw_gst_type_avidemuxer_get_type(void);

/*===========================================================================*/

G_END_DECLS
#endif	/*_MFW_GST_AVI_DEMUXER_H*/
