/*
 * Qt wrapper for libindicate
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: LGPL v2.1 or LGPL v3
 */
// Self
#include "servertest.h"

// Qt
#include <QtTest>

// Local
#include <qindicateserver.h>

QTEST_MAIN(ServerTest)

void ServerTest::testShowHide()
{
    const QString type = "message";

    QIndicate::Server server;
    QSignalSpy showSpy(&server, SIGNAL(serverShow(const QString&)));
    QSignalSpy hideSpy(&server, SIGNAL(serverHide(const QString&)));

    server.setType(type);
    server.show();

    QCOMPARE(showSpy.count(), 1);
    QVariantList args = showSpy.takeFirst();
    QCOMPARE(args[0].toString(), type);

    server.hide();

    QCOMPARE(hideSpy.count(), 1);
    args = hideSpy.takeFirst();
    QCOMPARE(args[0].toString(), type);
}

#include "servertest.moc"
