/*
 * Copyright (C) 2009 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 */

#ifndef _LAUNCHER_APPLICATION_H_
#define _LAUNCHER_APPLICATION_H_

#include <glib.h>
#include <glib-object.h>
#include <libwnck/libwnck.h>

G_BEGIN_DECLS

#define LAUNCHER_TYPE_APPLICATION	(launcher_application_get_type ())

typedef struct _LauncherApplication LauncherApplication;

GType             launcher_application_get_type (void) G_GNUC_CONST;

LauncherApplication * launcher_application_new_from_info (const gchar  *name,
                                                  const gchar  *comment,
                                                  const gchar  *icon_name,
                                                  const gchar  *exec_path,
                                                  const gchar  *desktop_file);

LauncherApplication * launcher_application_new_from_wnck_app (WnckApplication *app);

void              launcher_application_free  (LauncherApplication *app);

LauncherApplication * launcher_application_copy  (const LauncherApplication *app);

LauncherApplication * launcher_application_ref   (LauncherApplication *app);

void              launcher_application_unref (LauncherApplication *app);

void              launcher_application_set_wnckapp (LauncherApplication *app,
                                                WnckApplication *wnckapp);

WnckApplication * launcher_application_get_wnckapp (LauncherApplication *app);

const gchar * launcher_application_get_name         (LauncherApplication *app);

const gchar * launcher_application_get_comment      (LauncherApplication *app);

const gchar * launcher_application_get_icon_name    (LauncherApplication *app);

const gchar * launcher_application_get_exec_string  (LauncherApplication *app);

const gchar * launcher_application_get_desktop_file (LauncherApplication *app);

const gchar * launcher_application_get_match_name   (LauncherApplication *app);

void          launcher_application_launch           (LauncherApplication *app,
                                                     GError             **err);


G_END_DECLS

#endif /* _LAUNCHER_APPLICATION_H_ */
