/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.asm.util;

import org.mockito.asm.AnnotationVisitor;
import org.mockito.asm.Type;
import org.mockito.asm.util.CheckMethodAdapter;

public class CheckAnnotationAdapter
implements AnnotationVisitor {
    private final AnnotationVisitor av;
    private final boolean named;
    private boolean end;

    public CheckAnnotationAdapter(AnnotationVisitor annotationVisitor) {
        this(annotationVisitor, true);
    }

    CheckAnnotationAdapter(AnnotationVisitor annotationVisitor, boolean bl) {
        this.av = annotationVisitor;
        this.named = bl;
    }

    @Override
    public void visit(String string, Object object) {
        this.checkEnd();
        this.checkName(string);
        if (!(object instanceof Byte || object instanceof Boolean || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof String || object instanceof Type || object instanceof byte[] || object instanceof boolean[] || object instanceof char[] || object instanceof short[] || object instanceof int[] || object instanceof long[] || object instanceof float[] || object instanceof double[])) {
            throw new IllegalArgumentException("Invalid annotation value");
        }
        if (this.av != null) {
            this.av.visit(string, object);
        }
    }

    @Override
    public void visitEnum(String string, String string2, String string3) {
        this.checkEnd();
        this.checkName(string);
        CheckMethodAdapter.checkDesc(string2, false);
        if (string3 == null) {
            throw new IllegalArgumentException("Invalid enum value");
        }
        if (this.av != null) {
            this.av.visitEnum(string, string2, string3);
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, String string2) {
        this.checkEnd();
        this.checkName(string);
        CheckMethodAdapter.checkDesc(string2, false);
        return new CheckAnnotationAdapter(this.av == null ? null : this.av.visitAnnotation(string, string2));
    }

    @Override
    public AnnotationVisitor visitArray(String string) {
        this.checkEnd();
        this.checkName(string);
        return new CheckAnnotationAdapter(this.av == null ? null : this.av.visitArray(string), false);
    }

    @Override
    public void visitEnd() {
        this.checkEnd();
        this.end = true;
        if (this.av != null) {
            this.av.visitEnd();
        }
    }

    private void checkEnd() {
        if (this.end) {
            throw new IllegalStateException("Cannot call a visit method after visitEnd has been called");
        }
    }

    private void checkName(String string) {
        if (this.named && string == null) {
            throw new IllegalArgumentException("Annotation value name must not be null");
        }
    }
}

