/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.asm.util;

import org.mockito.asm.AnnotationVisitor;
import org.mockito.asm.Attribute;
import org.mockito.asm.FieldVisitor;
import org.mockito.asm.util.CheckAnnotationAdapter;
import org.mockito.asm.util.CheckMethodAdapter;

public class CheckFieldAdapter
implements FieldVisitor {
    private final FieldVisitor fv;
    private boolean end;

    public CheckFieldAdapter(FieldVisitor fieldVisitor) {
        this.fv = fieldVisitor;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        this.checkEnd();
        CheckMethodAdapter.checkDesc(string, false);
        return new CheckAnnotationAdapter(this.fv.visitAnnotation(string, bl));
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.checkEnd();
        if (attribute == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        this.fv.visitAttribute(attribute);
    }

    @Override
    public void visitEnd() {
        this.checkEnd();
        this.end = true;
        this.fv.visitEnd();
    }

    private void checkEnd() {
        if (this.end) {
            throw new IllegalStateException("Cannot call a visit method after visitEnd has been called");
        }
    }
}

