/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.cglib.beans;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.mockito.asm.ClassVisitor;
import org.mockito.asm.Type;
import org.mockito.cglib.core.AbstractClassGenerator;
import org.mockito.cglib.core.ClassEmitter;
import org.mockito.cglib.core.CodeEmitter;
import org.mockito.cglib.core.Constants;
import org.mockito.cglib.core.Converter;
import org.mockito.cglib.core.EmitUtils;
import org.mockito.cglib.core.KeyFactory;
import org.mockito.cglib.core.Local;
import org.mockito.cglib.core.MethodInfo;
import org.mockito.cglib.core.ReflectUtils;
import org.mockito.cglib.core.Signature;
import org.mockito.cglib.core.TypeUtils;

public abstract class BeanCopier {
    private static final BeanCopierKey KEY_FACTORY = (BeanCopierKey)((Object)KeyFactory.create(BeanCopierKey.class));
    private static final Type CONVERTER = TypeUtils.parseType("org.mockito.cglib.core.Converter");
    private static final Type BEAN_COPIER = TypeUtils.parseType("org.mockito.cglib.beans.BeanCopier");
    private static final Signature COPY = new Signature("copy", Type.VOID_TYPE, new Type[]{Constants.TYPE_OBJECT, Constants.TYPE_OBJECT, CONVERTER});
    private static final Signature CONVERT = TypeUtils.parseSignature("Object convert(Object, Class, Object)");

    public static BeanCopier create(Class clazz, Class clazz2, boolean bl) {
        Generator generator = new Generator();
        generator.setSource(clazz);
        generator.setTarget(clazz2);
        generator.setUseConverter(bl);
        return generator.create();
    }

    public abstract void copy(Object var1, Object var2, Converter var3);

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(BeanCopier.class.getName());
        private Class source;
        private Class target;
        private boolean useConverter;

        public Generator() {
            super(SOURCE);
        }

        public void setSource(Class clazz) {
            if (!Modifier.isPublic(clazz.getModifiers())) {
                this.setNamePrefix(clazz.getName());
            }
            this.source = clazz;
        }

        public void setTarget(Class clazz) {
            if (!Modifier.isPublic(clazz.getModifiers())) {
                this.setNamePrefix(clazz.getName());
            }
            this.target = clazz;
        }

        public void setUseConverter(boolean bl) {
            this.useConverter = bl;
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.source.getClassLoader();
        }

        public BeanCopier create() {
            Object object = KEY_FACTORY.newInstance(this.source.getName(), this.target.getName(), this.useConverter);
            return (BeanCopier)super.create(object);
        }

        @Override
        public void generateClass(ClassVisitor classVisitor) {
            Type type = Type.getType(this.source);
            Type type2 = Type.getType(this.target);
            ClassEmitter classEmitter = new ClassEmitter(classVisitor);
            classEmitter.begin_class(46, 1, this.getClassName(), BEAN_COPIER, null, "<generated>");
            EmitUtils.null_constructor(classEmitter);
            CodeEmitter codeEmitter = classEmitter.begin_method(1, COPY, null);
            PropertyDescriptor[] propertyDescriptorArray = ReflectUtils.getBeanGetters(this.source);
            PropertyDescriptor[] propertyDescriptorArray2 = ReflectUtils.getBeanGetters(this.target);
            HashMap<String, PropertyDescriptor> hashMap = new HashMap<String, PropertyDescriptor>();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                hashMap.put(propertyDescriptorArray[i].getName(), propertyDescriptorArray[i]);
            }
            Local local = codeEmitter.make_local();
            Local local2 = codeEmitter.make_local();
            if (this.useConverter) {
                codeEmitter.load_arg(1);
                codeEmitter.checkcast(type2);
                codeEmitter.store_local(local);
                codeEmitter.load_arg(0);
                codeEmitter.checkcast(type);
                codeEmitter.store_local(local2);
            } else {
                codeEmitter.load_arg(1);
                codeEmitter.checkcast(type2);
                codeEmitter.load_arg(0);
                codeEmitter.checkcast(type);
            }
            for (int i = 0; i < propertyDescriptorArray2.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray2[i];
                PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)hashMap.get(propertyDescriptor.getName());
                if (propertyDescriptor2 == null) continue;
                MethodInfo methodInfo = ReflectUtils.getMethodInfo(propertyDescriptor2.getReadMethod());
                MethodInfo methodInfo2 = ReflectUtils.getMethodInfo(propertyDescriptor.getWriteMethod());
                if (this.useConverter) {
                    Type type3 = methodInfo2.getSignature().getArgumentTypes()[0];
                    codeEmitter.load_local(local);
                    codeEmitter.load_arg(2);
                    codeEmitter.load_local(local2);
                    codeEmitter.invoke(methodInfo);
                    codeEmitter.box(methodInfo.getSignature().getReturnType());
                    EmitUtils.load_class(codeEmitter, type3);
                    codeEmitter.push(methodInfo2.getSignature().getName());
                    codeEmitter.invoke_interface(CONVERTER, CONVERT);
                    codeEmitter.unbox_or_zero(type3);
                    codeEmitter.invoke(methodInfo2);
                    continue;
                }
                if (!Generator.compatible(propertyDescriptor2, propertyDescriptor)) continue;
                codeEmitter.dup2();
                codeEmitter.invoke(methodInfo);
                codeEmitter.invoke(methodInfo2);
            }
            codeEmitter.return_value();
            codeEmitter.end_method();
            classEmitter.end_class();
        }

        private static boolean compatible(PropertyDescriptor propertyDescriptor, PropertyDescriptor propertyDescriptor2) {
            return propertyDescriptor2.getPropertyType().isAssignableFrom(propertyDescriptor.getPropertyType());
        }

        @Override
        protected Object firstInstance(Class clazz) {
            return ReflectUtils.newInstance(clazz);
        }

        @Override
        protected Object nextInstance(Object object) {
            return object;
        }
    }

    static interface BeanCopierKey {
        public Object newInstance(String var1, String var2, boolean var3);
    }
}

