/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.cglib.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mockito.asm.ClassVisitor;
import org.mockito.asm.Label;
import org.mockito.asm.Type;
import org.mockito.cglib.core.AbstractClassGenerator;
import org.mockito.cglib.core.ClassEmitter;
import org.mockito.cglib.core.CodeEmitter;
import org.mockito.cglib.core.CodeGenerationException;
import org.mockito.cglib.core.CollectionUtils;
import org.mockito.cglib.core.Constants;
import org.mockito.cglib.core.DuplicatesPredicate;
import org.mockito.cglib.core.EmitUtils;
import org.mockito.cglib.core.KeyFactory;
import org.mockito.cglib.core.Local;
import org.mockito.cglib.core.MethodInfo;
import org.mockito.cglib.core.MethodInfoTransformer;
import org.mockito.cglib.core.MethodWrapper;
import org.mockito.cglib.core.ObjectSwitchCallback;
import org.mockito.cglib.core.ProcessSwitchCallback;
import org.mockito.cglib.core.ReflectUtils;
import org.mockito.cglib.core.RejectModifierPredicate;
import org.mockito.cglib.core.Signature;
import org.mockito.cglib.core.Transformer;
import org.mockito.cglib.core.TypeUtils;
import org.mockito.cglib.core.VisibilityPredicate;
import org.mockito.cglib.proxy.Callback;
import org.mockito.cglib.proxy.CallbackFilter;
import org.mockito.cglib.proxy.CallbackGenerator;
import org.mockito.cglib.proxy.CallbackInfo;
import org.mockito.cglib.proxy.Factory;

public class Enhancer
extends AbstractClassGenerator {
    private static final CallbackFilter ALL_ZERO = new CallbackFilter(){

        @Override
        public int accept(Method method) {
            return 0;
        }
    };
    private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(Enhancer.class.getName());
    private static final EnhancerKey KEY_FACTORY = (EnhancerKey)((Object)KeyFactory.create(EnhancerKey.class));
    private static final String BOUND_FIELD = "CGLIB$BOUND";
    private static final String THREAD_CALLBACKS_FIELD = "CGLIB$THREAD_CALLBACKS";
    private static final String STATIC_CALLBACKS_FIELD = "CGLIB$STATIC_CALLBACKS";
    private static final String SET_THREAD_CALLBACKS_NAME = "CGLIB$SET_THREAD_CALLBACKS";
    private static final String SET_STATIC_CALLBACKS_NAME = "CGLIB$SET_STATIC_CALLBACKS";
    private static final String CONSTRUCTED_FIELD = "CGLIB$CONSTRUCTED";
    private static final Type FACTORY = TypeUtils.parseType("org.mockito.cglib.proxy.Factory");
    private static final Type ILLEGAL_STATE_EXCEPTION = TypeUtils.parseType("IllegalStateException");
    private static final Type ILLEGAL_ARGUMENT_EXCEPTION = TypeUtils.parseType("IllegalArgumentException");
    private static final Type THREAD_LOCAL = TypeUtils.parseType("ThreadLocal");
    private static final Type CALLBACK = TypeUtils.parseType("org.mockito.cglib.proxy.Callback");
    private static final Type CALLBACK_ARRAY = Type.getType(Callback[].class);
    private static final Signature CSTRUCT_NULL = TypeUtils.parseConstructor("");
    private static final Signature SET_THREAD_CALLBACKS = new Signature("CGLIB$SET_THREAD_CALLBACKS", Type.VOID_TYPE, new Type[]{CALLBACK_ARRAY});
    private static final Signature SET_STATIC_CALLBACKS = new Signature("CGLIB$SET_STATIC_CALLBACKS", Type.VOID_TYPE, new Type[]{CALLBACK_ARRAY});
    private static final Signature NEW_INSTANCE = new Signature("newInstance", Constants.TYPE_OBJECT, new Type[]{CALLBACK_ARRAY});
    private static final Signature MULTIARG_NEW_INSTANCE = new Signature("newInstance", Constants.TYPE_OBJECT, new Type[]{Constants.TYPE_CLASS_ARRAY, Constants.TYPE_OBJECT_ARRAY, CALLBACK_ARRAY});
    private static final Signature SINGLE_NEW_INSTANCE = new Signature("newInstance", Constants.TYPE_OBJECT, new Type[]{CALLBACK});
    private static final Signature SET_CALLBACK = new Signature("setCallback", Type.VOID_TYPE, new Type[]{Type.INT_TYPE, CALLBACK});
    private static final Signature GET_CALLBACK = new Signature("getCallback", CALLBACK, new Type[]{Type.INT_TYPE});
    private static final Signature SET_CALLBACKS = new Signature("setCallbacks", Type.VOID_TYPE, new Type[]{CALLBACK_ARRAY});
    private static final Signature GET_CALLBACKS = new Signature("getCallbacks", CALLBACK_ARRAY, new Type[0]);
    private static final Signature THREAD_LOCAL_GET = TypeUtils.parseSignature("Object get()");
    private static final Signature THREAD_LOCAL_SET = TypeUtils.parseSignature("void set(Object)");
    private static final Signature BIND_CALLBACKS = TypeUtils.parseSignature("void CGLIB$BIND_CALLBACKS(Object)");
    private Class[] interfaces;
    private CallbackFilter filter;
    private Callback[] callbacks;
    private Type[] callbackTypes;
    private boolean classOnly;
    private Class superclass;
    private Class[] argumentTypes;
    private Object[] arguments;
    private boolean useFactory = true;
    private Long serialVersionUID;
    private boolean interceptDuringConstruction = true;

    public Enhancer() {
        super(SOURCE);
    }

    public void setSuperclass(Class clazz) {
        if (clazz != null && clazz.isInterface()) {
            this.setInterfaces(new Class[]{clazz});
        } else {
            this.superclass = clazz != null && clazz.equals(Object.class) ? null : clazz;
        }
    }

    public void setInterfaces(Class[] classArray) {
        this.interfaces = classArray;
    }

    public void setCallbackFilter(CallbackFilter callbackFilter) {
        this.filter = callbackFilter;
    }

    public void setCallback(Callback callback) {
        this.setCallbacks(new Callback[]{callback});
    }

    public void setCallbacks(Callback[] callbackArray) {
        if (callbackArray != null && callbackArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty");
        }
        this.callbacks = callbackArray;
    }

    public void setUseFactory(boolean bl) {
        this.useFactory = bl;
    }

    public void setInterceptDuringConstruction(boolean bl) {
        this.interceptDuringConstruction = bl;
    }

    public void setCallbackType(Class clazz) {
        this.setCallbackTypes(new Class[]{clazz});
    }

    public void setCallbackTypes(Class[] classArray) {
        if (classArray != null && classArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty");
        }
        this.callbackTypes = CallbackInfo.determineTypes(classArray);
    }

    public Object create() {
        this.classOnly = false;
        this.argumentTypes = null;
        return this.createHelper();
    }

    public Object create(Class[] classArray, Object[] objectArray) {
        this.classOnly = false;
        if (classArray == null || objectArray == null || classArray.length != objectArray.length) {
            throw new IllegalArgumentException("Arguments must be non-null and of equal length");
        }
        this.argumentTypes = classArray;
        this.arguments = objectArray;
        return this.createHelper();
    }

    public Class createClass() {
        this.classOnly = true;
        return (Class)this.createHelper();
    }

    public void setSerialVersionUID(Long l) {
        this.serialVersionUID = l;
    }

    private void validate() {
        if (this.classOnly ^ this.callbacks == null) {
            if (this.classOnly) {
                throw new IllegalStateException("createClass does not accept callbacks");
            }
            throw new IllegalStateException("Callbacks are required");
        }
        if (this.classOnly && this.callbackTypes == null) {
            throw new IllegalStateException("Callback types are required");
        }
        if (this.callbacks != null && this.callbackTypes != null) {
            if (this.callbacks.length != this.callbackTypes.length) {
                throw new IllegalStateException("Lengths of callback and callback types array must be the same");
            }
            Type[] typeArray = CallbackInfo.determineTypes(this.callbacks);
            for (int i = 0; i < typeArray.length; ++i) {
                if (typeArray[i].equals(this.callbackTypes[i])) continue;
                throw new IllegalStateException("Callback " + typeArray[i] + " is not assignable to " + this.callbackTypes[i]);
            }
        } else if (this.callbacks != null) {
            this.callbackTypes = CallbackInfo.determineTypes(this.callbacks);
        }
        if (this.filter == null) {
            if (this.callbackTypes.length > 1) {
                throw new IllegalStateException("Multiple callback types possible but no filter specified");
            }
            this.filter = ALL_ZERO;
        }
        if (this.interfaces != null) {
            for (int i = 0; i < this.interfaces.length; ++i) {
                if (this.interfaces[i] == null) {
                    throw new IllegalStateException("Interfaces cannot be null");
                }
                if (this.interfaces[i].isInterface()) continue;
                throw new IllegalStateException(this.interfaces[i] + " is not an interface");
            }
        }
    }

    private Object createHelper() {
        this.validate();
        if (this.superclass != null) {
            this.setNamePrefix(this.superclass.getName());
        } else if (this.interfaces != null) {
            this.setNamePrefix(this.interfaces[ReflectUtils.findPackageProtected(this.interfaces)].getName());
        }
        return super.create(KEY_FACTORY.newInstance(this.superclass != null ? this.superclass.getName() : null, ReflectUtils.getNames(this.interfaces), this.filter, this.callbackTypes, this.useFactory, this.interceptDuringConstruction, this.serialVersionUID));
    }

    @Override
    protected ClassLoader getDefaultClassLoader() {
        if (this.superclass != null) {
            return this.superclass.getClassLoader();
        }
        if (this.interfaces != null) {
            return this.interfaces[0].getClassLoader();
        }
        return null;
    }

    private Signature rename(Signature signature, int n) {
        return new Signature("CGLIB$" + signature.getName() + "$" + n, signature.getDescriptor());
    }

    public static void getMethods(Class clazz, Class[] classArray, List list) {
        Enhancer.getMethods(clazz, classArray, list, null, null);
    }

    private static void getMethods(Class clazz, Class[] classArray, List list, List list2, Set set) {
        List list3;
        ReflectUtils.addAllMethods(clazz, list);
        List list4 = list3 = list2 != null ? list2 : list;
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i] == Factory.class) continue;
                ReflectUtils.addAllMethods(classArray[i], list3);
            }
        }
        if (list2 != null) {
            if (set != null) {
                set.addAll(MethodWrapper.createSet(list2));
            }
            list.addAll(list2);
        }
        CollectionUtils.filter(list, new RejectModifierPredicate(8));
        CollectionUtils.filter(list, new VisibilityPredicate(clazz, true));
        CollectionUtils.filter(list, new DuplicatesPredicate());
        CollectionUtils.filter(list, new RejectModifierPredicate(16));
    }

    @Override
    public void generateClass(ClassVisitor classVisitor) throws Exception {
        Class clazz;
        Class clazz2 = clazz = this.superclass == null ? Object.class : this.superclass;
        if (TypeUtils.isFinal(clazz.getModifiers())) {
            throw new IllegalArgumentException("Cannot subclass final class " + clazz);
        }
        ArrayList arrayList = new ArrayList(Arrays.asList(clazz.getDeclaredConstructors()));
        this.filterConstructors(clazz, arrayList);
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        final HashSet hashSet = new HashSet();
        Enhancer.getMethods(clazz, this.interfaces, arrayList2, arrayList3, hashSet);
        List list = CollectionUtils.transform(arrayList2, new Transformer(){

            @Override
            public Object transform(Object object) {
                Method method = (Method)object;
                int n = 0x10 | method.getModifiers() & 0xFFFFFBFF & 0xFFFFFEFF & 0xFFFFFFDF;
                if (hashSet.contains(MethodWrapper.create(method))) {
                    n = n & 0xFFFFFFFB | 1;
                }
                return ReflectUtils.getMethodInfo(method, n);
            }
        });
        ClassEmitter classEmitter = new ClassEmitter(classVisitor);
        classEmitter.begin_class(46, 1, this.getClassName(), Type.getType(clazz), this.useFactory ? TypeUtils.add(TypeUtils.getTypes(this.interfaces), FACTORY) : TypeUtils.getTypes(this.interfaces), "<generated>");
        List list2 = CollectionUtils.transform(arrayList, MethodInfoTransformer.getInstance());
        classEmitter.declare_field(2, BOUND_FIELD, Type.BOOLEAN_TYPE, null);
        if (!this.interceptDuringConstruction) {
            classEmitter.declare_field(2, CONSTRUCTED_FIELD, Type.BOOLEAN_TYPE, null);
        }
        classEmitter.declare_field(26, THREAD_CALLBACKS_FIELD, THREAD_LOCAL, null);
        classEmitter.declare_field(26, STATIC_CALLBACKS_FIELD, CALLBACK_ARRAY, null);
        if (this.serialVersionUID != null) {
            classEmitter.declare_field(26, "serialVersionUID", Type.LONG_TYPE, this.serialVersionUID);
        }
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            classEmitter.declare_field(2, Enhancer.getCallbackField(i), this.callbackTypes[i], null);
        }
        this.emitMethods(classEmitter, list, arrayList2);
        this.emitConstructors(classEmitter, list2);
        this.emitSetThreadCallbacks(classEmitter);
        this.emitSetStaticCallbacks(classEmitter);
        this.emitBindCallbacks(classEmitter);
        if (this.useFactory) {
            int[] nArray = this.getCallbackKeys();
            this.emitNewInstanceCallbacks(classEmitter);
            this.emitNewInstanceCallback(classEmitter);
            this.emitNewInstanceMultiarg(classEmitter, list2);
            this.emitGetCallback(classEmitter, nArray);
            this.emitSetCallback(classEmitter, nArray);
            this.emitGetCallbacks(classEmitter);
            this.emitSetCallbacks(classEmitter);
        }
        classEmitter.end_class();
    }

    protected void filterConstructors(Class clazz, List list) {
        CollectionUtils.filter(list, new VisibilityPredicate(clazz, true));
        if (list.size() == 0) {
            throw new IllegalArgumentException("No visible constructors in " + clazz);
        }
    }

    @Override
    protected Object firstInstance(Class clazz) throws Exception {
        if (this.classOnly) {
            return clazz;
        }
        return this.createUsingReflection(clazz);
    }

    @Override
    protected Object nextInstance(Object object) {
        Class<?> clazz;
        Class<?> clazz2 = clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        if (this.classOnly) {
            return clazz;
        }
        if (object instanceof Factory) {
            if (this.argumentTypes != null) {
                return ((Factory)object).newInstance(this.argumentTypes, this.arguments, this.callbacks);
            }
            return ((Factory)object).newInstance(this.callbacks);
        }
        return this.createUsingReflection(clazz);
    }

    public static void registerCallbacks(Class clazz, Callback[] callbackArray) {
        Enhancer.setThreadCallbacks(clazz, callbackArray);
    }

    public static void registerStaticCallbacks(Class clazz, Callback[] callbackArray) {
        Enhancer.setCallbacksHelper(clazz, callbackArray, SET_STATIC_CALLBACKS_NAME);
    }

    public static boolean isEnhanced(Class clazz) {
        try {
            Enhancer.getCallbacksSetter(clazz, SET_THREAD_CALLBACKS_NAME);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    private static void setThreadCallbacks(Class clazz, Callback[] callbackArray) {
        Enhancer.setCallbacksHelper(clazz, callbackArray, SET_THREAD_CALLBACKS_NAME);
    }

    private static void setCallbacksHelper(Class clazz, Callback[] callbackArray, String string) {
        try {
            Method method = Enhancer.getCallbacksSetter(clazz, string);
            method.invoke(null, new Object[]{callbackArray});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException(clazz + " is not an enhanced class");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CodeGenerationException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CodeGenerationException(invocationTargetException);
        }
    }

    private static Method getCallbacksSetter(Class clazz, String string) throws NoSuchMethodException {
        return clazz.getDeclaredMethod(string, Callback[].class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object createUsingReflection(Class clazz) {
        Enhancer.setThreadCallbacks(clazz, this.callbacks);
        try {
            if (this.argumentTypes != null) {
                Object object = ReflectUtils.newInstance(clazz, this.argumentTypes, this.arguments);
                return object;
            }
            Object object = ReflectUtils.newInstance(clazz);
            return object;
        }
        finally {
            Enhancer.setThreadCallbacks(clazz, null);
        }
    }

    public static Object create(Class clazz, Callback callback) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(clazz);
        enhancer.setCallback(callback);
        return enhancer.create();
    }

    public static Object create(Class clazz, Class[] classArray, Callback callback) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(clazz);
        enhancer.setInterfaces(classArray);
        enhancer.setCallback(callback);
        return enhancer.create();
    }

    public static Object create(Class clazz, Class[] classArray, CallbackFilter callbackFilter, Callback[] callbackArray) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(clazz);
        enhancer.setInterfaces(classArray);
        enhancer.setCallbackFilter(callbackFilter);
        enhancer.setCallbacks(callbackArray);
        return enhancer.create();
    }

    private void emitConstructors(ClassEmitter classEmitter, List list) {
        boolean bl = false;
        for (MethodInfo methodInfo : list) {
            CodeEmitter codeEmitter = EmitUtils.begin_method(classEmitter, methodInfo, 1);
            codeEmitter.load_this();
            codeEmitter.dup();
            codeEmitter.load_args();
            Signature signature = methodInfo.getSignature();
            bl = bl || signature.getDescriptor().equals("()V");
            codeEmitter.super_invoke_constructor(signature);
            codeEmitter.invoke_static_this(BIND_CALLBACKS);
            if (!this.interceptDuringConstruction) {
                codeEmitter.load_this();
                codeEmitter.push(1);
                codeEmitter.putfield(CONSTRUCTED_FIELD);
            }
            codeEmitter.return_value();
            codeEmitter.end_method();
        }
        if (!this.classOnly && !bl && this.arguments == null) {
            throw new IllegalArgumentException("Superclass has no null constructors but no arguments were given");
        }
    }

    private int[] getCallbackKeys() {
        int[] nArray = new int[this.callbackTypes.length];
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    private void emitGetCallback(ClassEmitter classEmitter, int[] nArray) {
        final CodeEmitter codeEmitter = classEmitter.begin_method(1, GET_CALLBACK, null);
        codeEmitter.load_this();
        codeEmitter.invoke_static_this(BIND_CALLBACKS);
        codeEmitter.load_this();
        codeEmitter.load_arg(0);
        codeEmitter.process_switch(nArray, new ProcessSwitchCallback(){

            @Override
            public void processCase(int n, Label label) {
                codeEmitter.getfield(Enhancer.getCallbackField(n));
                codeEmitter.goTo(label);
            }

            @Override
            public void processDefault() {
                codeEmitter.pop();
                codeEmitter.aconst_null();
            }
        });
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    private void emitSetCallback(ClassEmitter classEmitter, int[] nArray) {
        final CodeEmitter codeEmitter = classEmitter.begin_method(1, SET_CALLBACK, null);
        codeEmitter.load_arg(0);
        codeEmitter.process_switch(nArray, new ProcessSwitchCallback(){

            @Override
            public void processCase(int n, Label label) {
                codeEmitter.load_this();
                codeEmitter.load_arg(1);
                codeEmitter.checkcast(Enhancer.this.callbackTypes[n]);
                codeEmitter.putfield(Enhancer.getCallbackField(n));
                codeEmitter.goTo(label);
            }

            @Override
            public void processDefault() {
            }
        });
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    private void emitSetCallbacks(ClassEmitter classEmitter) {
        CodeEmitter codeEmitter = classEmitter.begin_method(1, SET_CALLBACKS, null);
        codeEmitter.load_this();
        codeEmitter.load_arg(0);
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            codeEmitter.dup2();
            codeEmitter.aaload(i);
            codeEmitter.checkcast(this.callbackTypes[i]);
            codeEmitter.putfield(Enhancer.getCallbackField(i));
        }
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    private void emitGetCallbacks(ClassEmitter classEmitter) {
        CodeEmitter codeEmitter = classEmitter.begin_method(1, GET_CALLBACKS, null);
        codeEmitter.load_this();
        codeEmitter.invoke_static_this(BIND_CALLBACKS);
        codeEmitter.load_this();
        codeEmitter.push(this.callbackTypes.length);
        codeEmitter.newarray(CALLBACK);
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            codeEmitter.dup();
            codeEmitter.push(i);
            codeEmitter.load_this();
            codeEmitter.getfield(Enhancer.getCallbackField(i));
            codeEmitter.aastore();
        }
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    private void emitNewInstanceCallbacks(ClassEmitter classEmitter) {
        CodeEmitter codeEmitter = classEmitter.begin_method(1, NEW_INSTANCE, null);
        codeEmitter.load_arg(0);
        codeEmitter.invoke_static_this(SET_THREAD_CALLBACKS);
        this.emitCommonNewInstance(codeEmitter);
    }

    private void emitCommonNewInstance(CodeEmitter codeEmitter) {
        codeEmitter.new_instance_this();
        codeEmitter.dup();
        codeEmitter.invoke_constructor_this();
        codeEmitter.aconst_null();
        codeEmitter.invoke_static_this(SET_THREAD_CALLBACKS);
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    private void emitNewInstanceCallback(ClassEmitter classEmitter) {
        CodeEmitter codeEmitter = classEmitter.begin_method(1, SINGLE_NEW_INSTANCE, null);
        switch (this.callbackTypes.length) {
            case 0: {
                break;
            }
            case 1: {
                codeEmitter.push(1);
                codeEmitter.newarray(CALLBACK);
                codeEmitter.dup();
                codeEmitter.push(0);
                codeEmitter.load_arg(0);
                codeEmitter.aastore();
                codeEmitter.invoke_static_this(SET_THREAD_CALLBACKS);
                break;
            }
            default: {
                codeEmitter.throw_exception(ILLEGAL_STATE_EXCEPTION, "More than one callback object required");
            }
        }
        this.emitCommonNewInstance(codeEmitter);
    }

    private void emitNewInstanceMultiarg(ClassEmitter classEmitter, List list) {
        final CodeEmitter codeEmitter = classEmitter.begin_method(1, MULTIARG_NEW_INSTANCE, null);
        codeEmitter.load_arg(2);
        codeEmitter.invoke_static_this(SET_THREAD_CALLBACKS);
        codeEmitter.new_instance_this();
        codeEmitter.dup();
        codeEmitter.load_arg(0);
        EmitUtils.constructor_switch(codeEmitter, list, new ObjectSwitchCallback(){

            @Override
            public void processCase(Object object, Label label) {
                MethodInfo methodInfo = (MethodInfo)object;
                Type[] typeArray = methodInfo.getSignature().getArgumentTypes();
                for (int i = 0; i < typeArray.length; ++i) {
                    codeEmitter.load_arg(1);
                    codeEmitter.push(i);
                    codeEmitter.aaload();
                    codeEmitter.unbox(typeArray[i]);
                }
                codeEmitter.invoke_constructor_this(methodInfo.getSignature());
                codeEmitter.goTo(label);
            }

            @Override
            public void processDefault() {
                codeEmitter.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Constructor not found");
            }
        });
        codeEmitter.aconst_null();
        codeEmitter.invoke_static_this(SET_THREAD_CALLBACKS);
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    private void emitMethods(ClassEmitter classEmitter, List list, List list2) {
        ArrayList<Object> arrayList;
        Object object;
        Object object2;
        Iterator iterator;
        CallbackGenerator[] callbackGeneratorArray = CallbackInfo.getGenerators(this.callbackTypes);
        HashMap<CallbackGenerator, ArrayList<Object>> hashMap = new HashMap<CallbackGenerator, ArrayList<Object>>();
        final HashMap<Object, Integer> hashMap2 = new HashMap<Object, Integer>();
        final HashMap<Object, Integer> hashMap3 = new HashMap<Object, Integer>();
        final Map map = CollectionUtils.getIndexMap(list);
        Iterator iterator2 = list.iterator();
        Iterator iterator3 = iterator = list2 != null ? list2.iterator() : null;
        while (iterator2.hasNext()) {
            object2 = (MethodInfo)iterator2.next();
            object = iterator != null ? (Method)iterator.next() : null;
            int n = this.filter.accept((Method)object);
            if (n >= this.callbackTypes.length) {
                throw new IllegalArgumentException("Callback filter returned an index that is too large: " + n);
            }
            hashMap3.put(object2, new Integer(object != null ? ((Method)object).getModifiers() : ((MethodInfo)object2).getModifiers()));
            hashMap2.put(object2, new Integer(n));
            arrayList = (List)hashMap.get(callbackGeneratorArray[n]);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>(list.size());
                hashMap.put(callbackGeneratorArray[n], arrayList);
            }
            arrayList.add(object2);
        }
        object2 = new HashSet();
        object = classEmitter.getStaticHook();
        ((CodeEmitter)object).new_instance(THREAD_LOCAL);
        ((CodeEmitter)object).dup();
        ((CodeEmitter)object).invoke_constructor(THREAD_LOCAL, CSTRUCT_NULL);
        ((CodeEmitter)object).putfield(THREAD_CALLBACKS_FIELD);
        Object[] objectArray = new Object[1];
        arrayList = new CallbackGenerator.Context(){

            @Override
            public ClassLoader getClassLoader() {
                return Enhancer.this.getClassLoader();
            }

            @Override
            public int getOriginalModifiers(MethodInfo methodInfo) {
                return (Integer)hashMap3.get(methodInfo);
            }

            @Override
            public int getIndex(MethodInfo methodInfo) {
                return (Integer)hashMap2.get(methodInfo);
            }

            @Override
            public void emitCallback(CodeEmitter codeEmitter, int n) {
                Enhancer.this.emitCurrentCallback(codeEmitter, n);
            }

            @Override
            public Signature getImplSignature(MethodInfo methodInfo) {
                return Enhancer.this.rename(methodInfo.getSignature(), (Integer)map.get(methodInfo));
            }

            @Override
            public CodeEmitter beginMethod(ClassEmitter classEmitter, MethodInfo methodInfo) {
                CodeEmitter codeEmitter = EmitUtils.begin_method(classEmitter, methodInfo);
                if (!Enhancer.this.interceptDuringConstruction && !TypeUtils.isAbstract(methodInfo.getModifiers())) {
                    Label label = codeEmitter.make_label();
                    codeEmitter.load_this();
                    codeEmitter.getfield(Enhancer.CONSTRUCTED_FIELD);
                    codeEmitter.if_jump(154, label);
                    codeEmitter.load_this();
                    codeEmitter.load_args();
                    codeEmitter.super_invoke();
                    codeEmitter.return_value();
                    codeEmitter.mark(label);
                }
                return codeEmitter;
            }
        };
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            CallbackGenerator callbackGenerator = callbackGeneratorArray[i];
            if (object2.contains(callbackGenerator)) continue;
            object2.add(callbackGenerator);
            List list3 = (List)hashMap.get(callbackGenerator);
            if (list3 == null) continue;
            try {
                callbackGenerator.generate(classEmitter, (CallbackGenerator.Context)((Object)arrayList), list3);
                callbackGenerator.generateStatic((CodeEmitter)object, (CallbackGenerator.Context)((Object)arrayList), list3);
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new CodeGenerationException(exception);
            }
        }
        ((CodeEmitter)object).return_value();
        ((CodeEmitter)object).end_method();
    }

    private void emitSetThreadCallbacks(ClassEmitter classEmitter) {
        CodeEmitter codeEmitter = classEmitter.begin_method(9, SET_THREAD_CALLBACKS, null);
        codeEmitter.getfield(THREAD_CALLBACKS_FIELD);
        codeEmitter.load_arg(0);
        codeEmitter.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_SET);
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    private void emitSetStaticCallbacks(ClassEmitter classEmitter) {
        CodeEmitter codeEmitter = classEmitter.begin_method(9, SET_STATIC_CALLBACKS, null);
        codeEmitter.load_arg(0);
        codeEmitter.putfield(STATIC_CALLBACKS_FIELD);
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    private void emitCurrentCallback(CodeEmitter codeEmitter, int n) {
        codeEmitter.load_this();
        codeEmitter.getfield(Enhancer.getCallbackField(n));
        codeEmitter.dup();
        Label label = codeEmitter.make_label();
        codeEmitter.ifnonnull(label);
        codeEmitter.pop();
        codeEmitter.load_this();
        codeEmitter.invoke_static_this(BIND_CALLBACKS);
        codeEmitter.load_this();
        codeEmitter.getfield(Enhancer.getCallbackField(n));
        codeEmitter.mark(label);
    }

    private void emitBindCallbacks(ClassEmitter classEmitter) {
        CodeEmitter codeEmitter = classEmitter.begin_method(26, BIND_CALLBACKS, null);
        Local local = codeEmitter.make_local();
        codeEmitter.load_arg(0);
        codeEmitter.checkcast_this();
        codeEmitter.store_local(local);
        Label label = codeEmitter.make_label();
        codeEmitter.load_local(local);
        codeEmitter.getfield(BOUND_FIELD);
        codeEmitter.if_jump(154, label);
        codeEmitter.load_local(local);
        codeEmitter.push(1);
        codeEmitter.putfield(BOUND_FIELD);
        codeEmitter.getfield(THREAD_CALLBACKS_FIELD);
        codeEmitter.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_GET);
        codeEmitter.dup();
        Label label2 = codeEmitter.make_label();
        codeEmitter.ifnonnull(label2);
        codeEmitter.pop();
        codeEmitter.getfield(STATIC_CALLBACKS_FIELD);
        codeEmitter.dup();
        codeEmitter.ifnonnull(label2);
        codeEmitter.pop();
        codeEmitter.goTo(label);
        codeEmitter.mark(label2);
        codeEmitter.checkcast(CALLBACK_ARRAY);
        codeEmitter.load_local(local);
        codeEmitter.swap();
        for (int i = this.callbackTypes.length - 1; i >= 0; --i) {
            if (i != 0) {
                codeEmitter.dup2();
            }
            codeEmitter.aaload(i);
            codeEmitter.checkcast(this.callbackTypes[i]);
            codeEmitter.putfield(Enhancer.getCallbackField(i));
        }
        codeEmitter.mark(label);
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    private static String getCallbackField(int n) {
        return "CGLIB$CALLBACK_" + n;
    }

    public static interface EnhancerKey {
        public Object newInstance(String var1, String[] var2, CallbackFilter var3, Type[] var4, boolean var5, boolean var6, Long var7);
    }
}

