/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.cglib.transform.impl;

import java.lang.reflect.Method;
import org.mockito.asm.Type;
import org.mockito.cglib.core.CodeEmitter;
import org.mockito.cglib.core.Constants;
import org.mockito.cglib.core.MethodInfo;
import org.mockito.cglib.core.ReflectUtils;
import org.mockito.cglib.core.Signature;
import org.mockito.cglib.transform.ClassEmitterTransformer;

public class AddInitTransformer
extends ClassEmitterTransformer {
    private MethodInfo info;

    public AddInitTransformer(Method method) {
        this.info = ReflectUtils.getMethodInfo(method);
        Type[] typeArray = this.info.getSignature().getArgumentTypes();
        if (typeArray.length != 1 || !typeArray[0].equals(Constants.TYPE_OBJECT) || !this.info.getSignature().getReturnType().equals(Type.VOID_TYPE)) {
            throw new IllegalArgumentException(method + " illegal signature");
        }
    }

    @Override
    public CodeEmitter begin_method(int n, Signature signature, Type[] typeArray) {
        CodeEmitter codeEmitter = super.begin_method(n, signature, typeArray);
        if (signature.getName().equals("<init>")) {
            return new CodeEmitter(codeEmitter){

                @Override
                public void visitInsn(int n) {
                    if (n == 177) {
                        this.load_this();
                        this.invoke(AddInitTransformer.this.info);
                    }
                    super.visitInsn(n);
                }
            };
        }
        return codeEmitter;
    }
}

