/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.defaultanswers;

import java.io.Serializable;
import org.mockito.Mockito;
import org.mockito.internal.MockHandlerInterface;
import org.mockito.internal.stubbing.InvocationContainerImpl;
import org.mockito.internal.stubbing.defaultanswers.ReturnsEmptyValues;
import org.mockito.internal.util.MockCreationValidator;
import org.mockito.internal.util.MockUtil;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class ReturnsDeepStubs
implements Answer<Object>,
Serializable {
    private static final long serialVersionUID = -6926328908792880098L;
    private Answer<Object> delegate = new ReturnsEmptyValues();

    @Override
    public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
        Class<?> clazz = invocationOnMock.getMethod().getReturnType();
        if (!new MockCreationValidator().isTypeMockable(clazz)) {
            return this.delegate.answer(invocationOnMock);
        }
        return this.getMock(invocationOnMock);
    }

    private Object getMock(InvocationOnMock invocationOnMock) {
        Class<?> clazz = invocationOnMock.getMethod().getReturnType();
        final Object obj = Mockito.mock(clazz, this);
        MockHandlerInterface<Object> mockHandlerInterface = new MockUtil().getMockHandler(invocationOnMock.getMock());
        InvocationContainerImpl invocationContainerImpl = (InvocationContainerImpl)mockHandlerInterface.getInvocationContainer();
        invocationContainerImpl.addAnswer(new Answer<Object>(){

            @Override
            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                return obj;
            }
        }, false);
        return obj;
    }
}

