/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.internal.progress.MockingProgress;
import org.mockito.internal.stubbing.answers.CallsRealMethods;
import org.mockito.internal.stubbing.answers.DoesNothing;
import org.mockito.internal.stubbing.answers.Returns;
import org.mockito.internal.stubbing.answers.ThrowsException;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.expectation.ConstructorExpectationSetup;
import org.powermock.api.mockito.expectation.PowerMockitoStubber;
import org.powermock.api.mockito.expectation.WithOrWithoutExpectedArguments;
import org.powermock.api.mockito.internal.PowerMockitoCore;
import org.powermock.api.mockito.internal.expectation.ConstructorAwareExpectationSetup;
import org.powermock.api.mockito.internal.expectation.DefaultConstructorExpectationSetup;
import org.powermock.api.mockito.internal.expectation.DefaultMethodExpectationSetup;
import org.powermock.api.mockito.internal.mockcreation.MockCreator;
import org.powermock.api.mockito.internal.verification.DefaultConstructorArgumentsVerfication;
import org.powermock.api.mockito.internal.verification.DefaultPrivateMethodVerification;
import org.powermock.api.mockito.internal.verification.VerifyNoMoreInteractions;
import org.powermock.api.mockito.verification.ConstructorArgumentsVerification;
import org.powermock.api.mockito.verification.PrivateMethodVerification;
import org.powermock.api.support.membermodification.MemberModifier;
import org.powermock.core.MockRepository;
import org.powermock.core.spi.NewInvocationControl;
import org.powermock.reflect.Whitebox;

public class PowerMockito
extends MemberModifier {
    private static final String NO_OBJECT_CREATION_ERROR_MESSAGE_TEMPLATE = "No instantiation of class %s was recorded during the test. Note that only expected object creations (e.g. those using whenNew(..)) can be verified.";
    private static final PowerMockitoCore POWERMOCKITO_CORE = new PowerMockitoCore();

    public static synchronized void mockStatic(Class<?> clazz) {
        MockCreator.mock(clazz, true, false, null, null, null);
    }

    public static void mockStatic(Class<?> clazz, Answer answer) {
        PowerMockito.mockStatic(clazz, Mockito.withSettings().defaultAnswer(answer));
    }

    public static void mockStatic(Class<?> clazz, MockSettings mockSettings) {
        MockCreator.mock(clazz, true, false, null, mockSettings, null);
    }

    public static synchronized <T> T mock(Class<T> clazz) {
        return MockCreator.mock(clazz, false, false, null, null, null);
    }

    public static <T> T mock(Class<T> clazz, Answer answer) {
        return PowerMockito.mock(clazz, Mockito.withSettings().defaultAnswer(answer));
    }

    public static <T> T mock(Class<T> clazz, MockSettings mockSettings) {
        return MockCreator.mock(clazz, false, false, null, mockSettings, null);
    }

    public static synchronized <T> T spy(T t) {
        return (T)MockCreator.mock(Whitebox.getType(t), false, true, t, null, null);
    }

    public static synchronized <T> void spy(Class<T> clazz) {
        MockCreator.mock(clazz, true, true, clazz, null, null);
    }

    public static synchronized void verifyStatic() {
        PowerMockito.verifyStatic(Mockito.times((int)1));
    }

    public static synchronized void verifyStatic(VerificationMode verificationMode) {
        Whitebox.getInternalState(Mockito.class, MockingProgress.class).verificationStarted((VerificationMode)POWERMOCKITO_CORE.wrapInStaticVerificationMode(verificationMode));
    }

    public static PrivateMethodVerification verifyPrivate(Object object) throws Exception {
        return PowerMockito.verifyPrivate(object, Mockito.times((int)1));
    }

    public static PrivateMethodVerification verifyPrivate(Object object, VerificationMode verificationMode) throws Exception {
        Whitebox.getInternalState(Mockito.class, MockingProgress.class).verificationStarted((VerificationMode)POWERMOCKITO_CORE.wrapInMockitoSpecificVerificationMode(object, verificationMode));
        return new DefaultPrivateMethodVerification(object);
    }

    public static PrivateMethodVerification verifyPrivate(Class<?> clazz) throws Exception {
        return PowerMockito.verifyPrivate(clazz);
    }

    public static PrivateMethodVerification verifyPrivate(Class<?> clazz, VerificationMode verificationMode) throws Exception {
        return PowerMockito.verifyPrivate(clazz, verificationMode);
    }

    public static synchronized <T> ConstructorArgumentsVerification verifyNew(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class to verify cannot be null");
        }
        NewInvocationControl<?> newInvocationControl = MockRepository.getNewInstanceControl(clazz);
        if (newInvocationControl == null) {
            throw new IllegalStateException(String.format(NO_OBJECT_CREATION_ERROR_MESSAGE_TEMPLATE, Whitebox.getType(clazz).getName()));
        }
        newInvocationControl.verify(new Object[0]);
        return new DefaultConstructorArgumentsVerfication(newInvocationControl, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> ConstructorArgumentsVerification verifyNew(Class<?> clazz, VerificationMode verificationMode) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class to verify cannot be null");
        }
        if (verificationMode == null) {
            throw new IllegalArgumentException("Verify mode cannot be null");
        }
        NewInvocationControl<?> newInvocationControl = MockRepository.getNewInstanceControl(clazz);
        MockRepository.putAdditionalState("VerificationMode", POWERMOCKITO_CORE.wrapInMockitoSpecificVerificationMode(clazz, verificationMode));
        if (newInvocationControl == null) {
            throw new IllegalStateException(String.format(NO_OBJECT_CREATION_ERROR_MESSAGE_TEMPLATE, Whitebox.getType(clazz).getName()));
        }
        try {
            newInvocationControl.verify(new Object[0]);
        }
        finally {
            MockRepository.removeAdditionalState("VerificationMode");
        }
        return new DefaultConstructorArgumentsVerfication(newInvocationControl, clazz);
    }

    public static <T> OngoingStubbing<T> when(Object object, String string, Object ... objectArray) throws Exception {
        return Mockito.when(Whitebox.invokeMethod(object, string, objectArray));
    }

    public static <T> WithOrWithoutExpectedArguments<T> when(Object object, Method method) throws Exception {
        return new DefaultMethodExpectationSetup(object, method);
    }

    public static <T> WithOrWithoutExpectedArguments<T> when(Class<?> clazz, Method method) throws Exception {
        return new DefaultMethodExpectationSetup(clazz, method);
    }

    public static <T> OngoingStubbing<T> when(Object object, Object ... objectArray) throws Exception {
        return Mockito.when(Whitebox.invokeMethod(object, objectArray));
    }

    public static <T> OngoingStubbing<T> when(Class<?> clazz, String string, Object ... objectArray) throws Exception {
        return Mockito.when(Whitebox.invokeMethod(clazz, string, objectArray));
    }

    public static <T> OngoingStubbing<T> when(Class<?> clazz, Object ... objectArray) throws Exception {
        return Mockito.when(Whitebox.invokeMethod(clazz, objectArray));
    }

    public static <T> OngoingStubbing<T> when(T t) {
        return Mockito.when(t);
    }

    public static synchronized <T> WithOrWithoutExpectedArguments<T> whenNew(Constructor<T> constructor) {
        return new ConstructorAwareExpectationSetup<T>(constructor);
    }

    public static synchronized <T> ConstructorExpectationSetup<T> whenNew(Class<T> clazz) {
        return new DefaultConstructorExpectationSetup<T>(clazz);
    }

    public static synchronized <T> ConstructorExpectationSetup<T> whenNew(String string) throws Exception {
        Class<?> clazz = Class.forName(string);
        return new DefaultConstructorExpectationSetup(clazz);
    }

    public static void verifyNoMoreInteractions(Object ... objectArray) {
        VerifyNoMoreInteractions.verifyNoMoreInteractions(objectArray);
    }

    public static void verifyZeroInteractions(Object ... objectArray) {
        VerifyNoMoreInteractions.verifyNoMoreInteractions(objectArray);
    }

    public static PowerMockitoStubber doAnswer(Answer<?> answer) {
        return POWERMOCKITO_CORE.doAnswer(answer);
    }

    public static PowerMockitoStubber doThrow(Throwable throwable) {
        return POWERMOCKITO_CORE.doAnswer((Answer)new ThrowsException(throwable));
    }

    public static PowerMockitoStubber doCallRealMethod() {
        return POWERMOCKITO_CORE.doAnswer((Answer)new CallsRealMethods());
    }

    public static PowerMockitoStubber doNothing() {
        return POWERMOCKITO_CORE.doAnswer((Answer)new DoesNothing());
    }

    public static PowerMockitoStubber doReturn(Object object) {
        return POWERMOCKITO_CORE.doAnswer((Answer)new Returns(object));
    }
}

