/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.support.membermodification;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.powermock.reflect.Whitebox;
import org.powermock.reflect.internal.WhiteboxImpl;
import org.powermock.tests.utils.impl.ArrayMergerImpl;

public class MemberMatcher {
    public static Method[] methodsDeclaredIn(Class<?> clazz, Class<?> ... classArray) {
        if (clazz == null) {
            throw new IllegalArgumentException("You need to supply at least one class.");
        }
        HashSet<Method> hashSet = new HashSet<Method>();
        hashSet.addAll(Arrays.asList(WhiteboxImpl.getAllMethods(clazz)));
        for (Class<?> clazz2 : classArray) {
            hashSet.addAll(Arrays.asList(WhiteboxImpl.getAllMethods(clazz2)));
        }
        return hashSet.toArray(new Method[hashSet.size()]);
    }

    public static Method method(Class<?> clazz, String string, Class<?> ... classArray) {
        Method method = WhiteboxImpl.findMethod(clazz, string, classArray);
        WhiteboxImpl.throwExceptionIfMethodWasNotFound(clazz, string, method, classArray);
        return method;
    }

    public static Method method(Class<?> clazz, Class<?> ... classArray) {
        return Whitebox.getMethod(clazz, classArray);
    }

    public static Method[] methods(Class<?> clazz, String string, String ... stringArray) {
        return Whitebox.getMethods(clazz, MemberMatcher.merge(string, stringArray));
    }

    public static Method[] methods(Method method, Method ... methodArray) {
        return MemberMatcher.merge(method, methodArray);
    }

    public static Method[] methods(Class<?> clazz, String[] stringArray) {
        return Whitebox.getMethods(clazz, stringArray);
    }

    public static Field field(Class<?> clazz, String string) {
        return Whitebox.getField(clazz, string);
    }

    public static Field[] fields(Class<?> clazz, String string, String ... stringArray) {
        return Whitebox.getFields(clazz, MemberMatcher.merge(string, stringArray));
    }

    public static Field[] fields(Class<?> clazz) {
        return WhiteboxImpl.getAllFields(clazz);
    }

    public static Field[] fields(Field field, Field ... fieldArray) {
        return MemberMatcher.merge(field, fieldArray);
    }

    public static Field[] fields(Class<?> clazz, String[] stringArray) {
        return Whitebox.getFields(clazz, stringArray);
    }

    public static <T> Constructor<T> constructor(Class<T> clazz, Class<?> ... classArray) {
        return WhiteboxImpl.findUniqueConstructorOrThrowException(clazz, classArray);
    }

    public static <T> Constructor<T> constructor(Class<T> clazz) {
        return WhiteboxImpl.findConstructorOrThrowException(clazz);
    }

    public static <T> Constructor<T> defaultConstructorIn(Class<T> clazz) {
        return WhiteboxImpl.findDefaultConstructorOrThrowException(clazz);
    }

    public static Constructor<?>[] constructorsDeclaredIn(Class<?> clazz, Class<?> ... classArray) {
        if (clazz == null) {
            throw new IllegalArgumentException("You need to supply at least one class.");
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(Arrays.asList(WhiteboxImpl.getAllConstructors(clazz)));
        for (Class<?> clazz2 : classArray) {
            hashSet.addAll(Arrays.asList(WhiteboxImpl.getAllConstructors(clazz2)));
        }
        return hashSet.toArray(new Constructor[hashSet.size()]);
    }

    public static Constructor<?>[] constructors(Constructor<?> constructor, Constructor<?> ... constructorArray) {
        return MemberMatcher.merge(constructor, constructorArray);
    }

    public static AccessibleObject[] everythingDeclaredIn(Class<?> clazz, Class<?> ... classArray) {
        if (clazz == null) {
            throw new IllegalArgumentException("You need to supply at least one class.");
        }
        HashSet<Executable> hashSet = new HashSet<Executable>();
        hashSet.addAll(Collections.unmodifiableCollection(Arrays.asList(MemberMatcher.methodsDeclaredIn(clazz, classArray))));
        hashSet.addAll(Collections.unmodifiableCollection(Arrays.asList(MemberMatcher.constructorsDeclaredIn(clazz, classArray))));
        return hashSet.toArray(new AccessibleObject[hashSet.size()]);
    }

    private static String[] merge(String string, String ... stringArray) {
        return new ArrayMergerImpl().mergeArrays(String.class, {string}, stringArray);
    }

    private static Method[] merge(Method method, Method ... methodArray) {
        return new ArrayMergerImpl().mergeArrays(Method.class, {method}, methodArray);
    }

    private static Field[] merge(Field field, Field ... fieldArray) {
        return new ArrayMergerImpl().mergeArrays(Field.class, {field}, fieldArray);
    }

    private static Constructor<?>[] merge(Constructor<?> constructor, Constructor<?> ... constructorArray) {
        return new ArrayMergerImpl().mergeArrays(Constructor.class, {constructor}, constructorArray);
    }
}

