/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core;

import java.util.concurrent.atomic.AtomicInteger;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.powermock.reflect.internal.TypeUtils;

public class ConcreteClassGenerator {
    private static AtomicInteger counter = new AtomicInteger(0);

    public Class<?> createConcreteSubClass(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        if (!java.lang.reflect.Modifier.isAbstract(clazz.getModifiers())) {
            throw new IllegalArgumentException("clazz must be abstract");
        }
        ClassPool classPool = ClassPool.getDefault();
        String string = clazz.getName();
        CtClass ctClass = null;
        CtClass ctClass2 = classPool.makeClass(this.generateClassName(clazz));
        try {
            ctClass2.setSuperclass(classPool.get(clazz.getName()));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        try {
            CtMethod[] ctMethodArray;
            ctClass = classPool.get(string);
            for (CtMethod ctMethod : ctMethodArray = ctClass.getDeclaredMethods()) {
                if (!Modifier.isAbstract((int)ctMethod.getModifiers())) continue;
                String string2 = this.getReturnCode(ctMethod.getReturnType());
                CtNewMethod.make((CtClass)ctMethod.getReturnType(), (String)ctMethod.getName(), (CtClass[])ctMethod.getParameterTypes(), (CtClass[])ctMethod.getExceptionTypes(), (String)string2, (CtClass)ctClass2);
            }
            if (!this.hasInheritableConstructor(ctClass)) {
                return null;
            }
            return ctClass2.toClass(this.getClass().getClassLoader(), this.getClass().getProtectionDomain());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private boolean hasInheritableConstructor(CtClass ctClass) throws NotFoundException {
        CtConstructor[] ctConstructorArray = ctClass.getDeclaredConstructors();
        if (ctConstructorArray.length == 0) {
            return true;
        }
        for (CtConstructor ctConstructor : ctConstructorArray) {
            int n = ctConstructor.getModifiers();
            if (Modifier.isPackage((int)n) || Modifier.isPrivate((int)n)) continue;
            return true;
        }
        return false;
    }

    private String getReturnCode(CtClass ctClass) {
        if (ctClass.equals(CtClass.voidType)) {
            return "{}";
        }
        return "{return " + TypeUtils.getDefaultValueAsString(ctClass.getName()) + ";}";
    }

    private <T> String generateClassName(Class<T> clazz) {
        return "subclass." + clazz.getName() + "$$PowerMock" + counter.getAndIncrement();
    }
}

