/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.mockpolicies.impl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.powermock.mockpolicies.MockPolicyInterceptionSettings;

public class MockPolicyInterceptionSettingsImpl
implements MockPolicyInterceptionSettings {
    private Set<Field> fieldsToSuppress = new LinkedHashSet<Field>();
    private Set<Method> methodsToSuppress = new LinkedHashSet<Method>();
    private Map<Method, Object> substituteReturnValues = new HashMap<Method, Object>();
    private Set<String> fieldsTypesToSuppress;
    private Map<Method, InvocationHandler> proxies = new HashMap<Method, InvocationHandler>();

    public MockPolicyInterceptionSettingsImpl() {
        this.fieldsTypesToSuppress = new LinkedHashSet<String>();
    }

    @Override
    public void addFieldTypesToSuppress(String string, String ... stringArray) {
        this.fieldsTypesToSuppress.add(string);
        this.addFieldTypesToSuppress(stringArray);
    }

    @Override
    public void addFieldTypesToSuppress(String[] stringArray) {
        for (String string : stringArray) {
            this.fieldsTypesToSuppress.add(string);
        }
    }

    @Override
    public void setFieldTypesToSuppress(String[] stringArray) {
        this.fieldsTypesToSuppress.clear();
        this.addFieldTypesToSuppress(stringArray);
    }

    @Override
    public Field[] getFieldsToSuppress() {
        return this.fieldsToSuppress.toArray(new Field[this.fieldsToSuppress.size()]);
    }

    @Override
    public Method[] getMethodsToSuppress() {
        return this.methodsToSuppress.toArray(new Method[this.methodsToSuppress.size()]);
    }

    @Override
    public Map<Method, Object> getStubbedMethods() {
        return Collections.unmodifiableMap(this.substituteReturnValues);
    }

    @Override
    public void addFieldToSuppress(Field field, Field ... fieldArray) {
        this.fieldsToSuppress.add(field);
        this.addFieldToSuppress(fieldArray);
    }

    @Override
    public void addFieldToSuppress(Field[] fieldArray) {
        for (Field field : fieldArray) {
            this.fieldsToSuppress.add(field);
        }
    }

    @Override
    public void addMethodsToSuppress(Method method, Method ... methodArray) {
        this.methodsToSuppress.add(method);
        this.addMethodsToSuppress(methodArray);
    }

    @Override
    public void addMethodsToSuppress(Method[] methodArray) {
        for (Method method : methodArray) {
            this.methodsToSuppress.add(method);
        }
    }

    @Override
    public void stubMethod(Method method, Object object) {
        this.substituteReturnValues.put(method, object);
    }

    @Override
    public void setFieldsSuppress(Field[] fieldArray) {
        this.fieldsToSuppress.clear();
        this.addFieldToSuppress(fieldArray);
    }

    @Override
    public void setMethodsToSuppress(Method[] methodArray) {
        this.methodsToSuppress.clear();
        this.addMethodsToSuppress(methodArray);
    }

    @Override
    public void setMethodsToStub(Map<Method, Object> map) {
        this.substituteReturnValues = map;
    }

    @Override
    public String[] getFieldTypesToSuppress() {
        return this.fieldsTypesToSuppress.toArray(new String[this.fieldsTypesToSuppress.size()]);
    }

    @Override
    public void addSubtituteReturnValue(Method method, Object object) {
        this.substituteReturnValues.put(method, object);
    }

    @Override
    public void setSubtituteReturnValues(Map<Method, Object> map) {
        this.substituteReturnValues = map;
    }

    @Override
    public Map<Method, Object> getSubstituteReturnValues() {
        return this.getStubbedMethods();
    }

    @Override
    public Map<Method, InvocationHandler> getProxiedMethods() {
        return this.proxies;
    }

    @Override
    public void proxyMethod(Method method, InvocationHandler invocationHandler) {
        this.proxies.put(method, invocationHandler);
    }

    @Override
    public void setMethodsToProxy(Map<Method, InvocationHandler> map) {
        this.proxies = map;
    }
}

