/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.reflect.internal.matcherstrategies;

import java.lang.reflect.Field;
import org.powermock.reflect.exceptions.FieldNotFoundException;
import org.powermock.reflect.internal.matcherstrategies.FieldMatcherStrategy;

public class FieldNameMatcherStrategy
extends FieldMatcherStrategy {
    private final String fieldName;

    public FieldNameMatcherStrategy(String string) {
        if (string == null || string.equals("") || string.startsWith(" ")) {
            throw new IllegalArgumentException("field name cannot be null.");
        }
        this.fieldName = string;
    }

    @Override
    public boolean matches(Field field) {
        return this.fieldName.equals(field.getName());
    }

    @Override
    public void notFound(Class<?> clazz, boolean bl) throws FieldNotFoundException {
        throw new FieldNotFoundException(String.format("No %s field named \"%s\" could be found in the class hierarchy of %s.", bl ? "instance" : "static", this.fieldName, clazz.getName()));
    }

    public String toString() {
        return "fieldName " + this.fieldName;
    }
}

