/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * Authors:
 *  Florian Boucault <florian.boucault@canonical.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; version 3.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef QT_BAMF_INDICATOR_H
#define QT_BAMF_INDICATOR_H

#include <QtCore/QObject>

#include "bamf-view.h"

class OrgAyatanaBamfIndicatorInterface;

class BamfIndicator: public BamfView
{
    Q_OBJECT

    Q_PROPERTY(QString address READ address);
    Q_PROPERTY(QString path READ path);
    Q_PROPERTY(QString dbus_menu_path READ dbus_menu_path);

friend class BamfFactory;

private:
    BamfIndicator(QString path);
    ~BamfIndicator();
    BamfIndicator(BamfIndicator const&);
    void operator=(BamfIndicator const&);

public:
    // getters
    const QString address() const;
    const QString path() const;
    const QString dbus_menu_path() const;

private:
    OrgAyatanaBamfIndicatorInterface *m_indicator_proxy;
};

#endif

