/* unity-io.c generated by valac 0.14.2, the Vala compiler
 * generated from unity-io.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */
/*
 * IMPLEMENTATION NOTE:
 * We want the generatedd C API to be nice and not too Vala-ish. We must
 * anticipate that place daemons consuming libunity will be written in
 * both Vala and C.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "unity.h"
#include <stdlib.h>
#include <string.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _UnityIoReadStreamAsyncData UnityIoReadStreamAsyncData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UnityIoOpenFromDirsData UnityIoOpenFromDirsData;
typedef struct _UnityIoOpenFromDataDirsData UnityIoOpenFromDataDirsData;

struct _UnityIoReadStreamAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GInputStream* input;
	gint io_priority;
	GCancellable* cancellable;
	guint8* data;
	gint data_length1;
	gsize size;
	GMemoryOutputStream* _tmp0_;
	GMemoryOutputStream* output;
	GMemoryOutputStream* _tmp1_;
	GInputStream* _tmp2_;
	gint _tmp3_;
	GCancellable* _tmp4_;
	GMemoryOutputStream* _tmp5_;
	GMemoryOutputStream* _tmp6_;
	guint8* _tmp7_;
	GMemoryOutputStream* _tmp8_;
	gsize _tmp9_;
	GInputStream* _tmp10_;
	GError * _inner_error_;
};

struct _UnityIoOpenFromDirsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* filename;
	gchar** dirs;
	gint dirs_length1;
	GFileInputStream* result;
	gchar* path;
	GFile* datafile;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** dir_collection;
	gint dir_collection_length1;
	gint _dir_collection_size_;
	gint dir_it;
	gchar* _tmp1_;
	gchar* dir;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFileInputStream* _tmp8_;
	GFileInputStream* _tmp9_;
	GError* ee;
	GError* _tmp10_;
	GError* _tmp11_;
	GError* _tmp12_;
	GError * _inner_error_;
};

struct _UnityIoOpenFromDataDirsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* filename;
	GFileInputStream* result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* path;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* f;
	GFile* _tmp5_;
	GFileInputStream* _tmp6_;
	GFileInputStream* _tmp7_;
	GError* e;
	GError* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	gint _tmp11_;
	gchar** _tmp12_;
	gchar** dirs;
	gint dirs_length1;
	gint _dirs_size_;
	const gchar* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	GFileInputStream* _tmp15_;
	GFileInputStream* _tmp16_;
	GError * _inner_error_;
};


extern gchar** unity_io_system_data_dirs;
extern gint unity_io_system_data_dirs_length1;
gchar** unity_io_system_data_dirs = NULL;
gint unity_io_system_data_dirs_length1 = 0;
static gint _unity_io_system_data_dirs_size_ = 0;

static void unity_io_read_stream_async_data_free (gpointer _data);
static gboolean unity_io_read_stream_async_co (UnityIoReadStreamAsyncData* _data_);
static void* _g_realloc_grealloc_func (void* data, gsize size);
static void unity_io_read_stream_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_io_open_from_dirs_data_free (gpointer _data);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gboolean unity_io_open_from_dirs_co (UnityIoOpenFromDirsData* _data_);
static void unity_io_open_from_dirs_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_io_open_from_data_dirs_data_free (gpointer _data);
static gboolean unity_io_open_from_data_dirs_co (UnityIoOpenFromDataDirsData* _data_);
static void unity_io_open_from_data_dirs_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar** _vala_array_dup2 (gchar** self, int length);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void unity_io_read_stream_async_data_free (gpointer _data) {
	UnityIoReadStreamAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->input);
	_g_object_unref0 (_data_->cancellable);
	g_slice_free (UnityIoReadStreamAsyncData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void unity_io_read_stream_async (GInputStream* input, gint io_priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityIoReadStreamAsyncData* _data_;
	GInputStream* _tmp0_;
	GInputStream* _tmp1_;
	gint _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	_data_ = g_slice_new0 (UnityIoReadStreamAsyncData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, unity_io_read_stream_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_io_read_stream_async_data_free);
	_tmp0_ = input;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data_->input = _tmp1_;
	_tmp2_ = io_priority;
	_data_->io_priority = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->cancellable = _tmp4_;
	unity_io_read_stream_async_co (_data_);
}


void unity_io_read_stream_finish (GAsyncResult* _res_, guint8** data, int* data_length1, gsize* size, GError** error) {
	UnityIoReadStreamAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (data) {
		*data = _data_->data;
	} else {
		_data_->data = (g_free (_data_->data), NULL);
	}
	if (data_length1) {
		*data_length1 = _data_->data_length1;
	}
	_data_->data = NULL;
	if (size) {
		*size = _data_->size;
	}
}


/**
   * Asynchronously read a stream into memory. This method will close
   * the input stream when done.
   */
static void* _g_realloc_grealloc_func (void* data, gsize size) {
	void* result;
	result = g_realloc (data, size);
	return result;
}


static void unity_io_read_stream_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityIoReadStreamAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_io_read_stream_async_co (_data_);
}


static gboolean unity_io_read_stream_async_co (UnityIoReadStreamAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = (GMemoryOutputStream*) g_memory_output_stream_new (NULL, 0, _g_realloc_grealloc_func, NULL);
	_data_->output = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->output;
	_data_->_tmp2_ = _data_->input;
	_data_->_tmp3_ = _data_->io_priority;
	_data_->_tmp4_ = _data_->cancellable;
	_data_->_state_ = 1;
	g_output_stream_splice_async ((GOutputStream*) _data_->_tmp1_, _data_->_tmp2_, G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE, _data_->_tmp3_, _data_->_tmp4_, unity_io_read_stream_async_ready, _data_);
	return FALSE;
	_state_1:
	g_output_stream_splice_finish ((GOutputStream*) _data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == G_IO_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->output);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->output);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp5_ = _data_->output;
	g_output_stream_close ((GOutputStream*) _data_->_tmp5_, NULL, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == G_IO_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->output);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->output);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp6_ = _data_->output;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = g_memory_output_stream_steal_data (_data_->_tmp6_);
	_data_->data = (g_free (_data_->data), NULL);
	_data_->data = _data_->_tmp7_;
	_data_->data_length1 = -1;
	_data_->_tmp8_ = _data_->output;
	_data_->_tmp9_ = 0UL;
	_data_->_tmp9_ = g_memory_output_stream_get_data_size (_data_->_tmp8_);
	_data_->size = _data_->_tmp9_;
	_data_->_tmp10_ = _data_->input;
	g_input_stream_close_async (_data_->_tmp10_, G_PRIORITY_LOW, NULL, NULL, NULL);
	_g_object_unref0 (_data_->output);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_io_open_from_dirs_data_free (gpointer _data) {
	UnityIoOpenFromDirsData* _data_;
	_data_ = _data;
	_g_free0 (_data_->filename);
	_data_->dirs = (_vala_array_free (_data_->dirs, _data_->dirs_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->result);
	g_slice_free (UnityIoOpenFromDirsData, _data_);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void unity_io_open_from_dirs (const gchar* filename, gchar** dirs, int dirs_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityIoOpenFromDirsData* _data_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	_data_ = g_slice_new0 (UnityIoOpenFromDirsData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, unity_io_open_from_dirs);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_io_open_from_dirs_data_free);
	_tmp0_ = filename;
	_tmp1_ = g_strdup (_tmp0_);
	_data_->filename = _tmp1_;
	_tmp2_ = dirs;
	_tmp2__length1 = dirs_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup1 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	_data_->dirs = _tmp3_;
	_data_->dirs_length1 = _tmp3__length1;
	unity_io_open_from_dirs_co (_data_);
}


GFileInputStream* unity_io_open_from_dirs_finish (GAsyncResult* _res_, GError** error) {
	GFileInputStream* result;
	UnityIoOpenFromDirsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Asynchronously looks for a file with base name 'filename' in all the
   * directories defined in 'dirs' and returns a file input stream for it.
   *
   * If the file can not be found this method returns null.
   */
static void unity_io_open_from_dirs_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityIoOpenFromDirsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_io_open_from_dirs_co (_data_);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean unity_io_open_from_dirs_co (UnityIoOpenFromDirsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->dirs;
	_data_->_tmp0__length1 = _data_->dirs_length1;
	{
		_data_->dir_collection_length1 = 0;
		_data_->_dir_collection_size_ = 0;
		_data_->dir_collection = _data_->_tmp0_;
		_data_->dir_collection_length1 = _data_->_tmp0__length1;
		_data_->dir_it = 0;
		for (_data_->dir_it = 0; _data_->dir_it < _data_->_tmp0__length1; _data_->dir_it = _data_->dir_it + 1) {
			_data_->_tmp1_ = g_strdup (_data_->dir_collection[_data_->dir_it]);
			_data_->dir = _data_->_tmp1_;
			{
				_data_->_tmp2_ = _data_->dir;
				_data_->_tmp3_ = _data_->filename;
				_data_->_tmp4_ = NULL;
				_data_->_tmp4_ = g_build_filename (_data_->_tmp2_, _data_->_tmp3_, NULL, NULL);
				_g_free0 (_data_->path);
				_data_->path = _data_->_tmp4_;
				_data_->_tmp5_ = _data_->path;
				_data_->_tmp6_ = NULL;
				_data_->_tmp6_ = g_file_new_for_path (_data_->_tmp5_);
				_g_object_unref0 (_data_->datafile);
				_data_->datafile = _data_->_tmp6_;
				{
					_data_->_tmp7_ = _data_->datafile;
					_data_->_state_ = 1;
					g_file_read_async (_data_->_tmp7_, G_PRIORITY_DEFAULT, NULL, unity_io_open_from_dirs_ready, _data_);
					return FALSE;
					_state_1:
					_data_->_tmp8_ = NULL;
					_data_->_tmp8_ = g_file_read_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
					_data_->_tmp9_ = _data_->_tmp8_;
					if (_data_->_inner_error_ != NULL) {
						goto __catch12_g_error;
					}
					_data_->result = _data_->_tmp9_;
					_g_free0 (_data_->dir);
					_g_object_unref0 (_data_->datafile);
					_g_free0 (_data_->path);
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				goto __finally12;
				__catch12_g_error:
				{
					_data_->ee = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_data_->_tmp10_ = _data_->ee;
					if (!g_error_matches (_data_->_tmp10_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
						_data_->_tmp11_ = _data_->ee;
						_data_->_tmp12_ = _g_error_copy0 (_data_->_tmp11_);
						_data_->_inner_error_ = _data_->_tmp12_;
						_g_error_free0 (_data_->ee);
						goto __finally12;
					}
					_g_error_free0 (_data_->ee);
				}
				__finally12:
				if (_data_->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
					g_error_free (_data_->_inner_error_);
					_g_free0 (_data_->dir);
					_g_object_unref0 (_data_->datafile);
					_g_free0 (_data_->path);
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_g_free0 (_data_->dir);
			}
		}
	}
	_data_->result = NULL;
	_g_object_unref0 (_data_->datafile);
	_g_free0 (_data_->path);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->datafile);
	_g_free0 (_data_->path);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_io_open_from_data_dirs_data_free (gpointer _data) {
	UnityIoOpenFromDataDirsData* _data_;
	_data_ = _data;
	_g_free0 (_data_->filename);
	_g_object_unref0 (_data_->result);
	g_slice_free (UnityIoOpenFromDataDirsData, _data_);
}


void unity_io_open_from_data_dirs (const gchar* filename, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityIoOpenFromDataDirsData* _data_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	_data_ = g_slice_new0 (UnityIoOpenFromDataDirsData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, unity_io_open_from_data_dirs);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_io_open_from_data_dirs_data_free);
	_tmp0_ = filename;
	_tmp1_ = g_strdup (_tmp0_);
	_data_->filename = _tmp1_;
	unity_io_open_from_data_dirs_co (_data_);
}


GFileInputStream* unity_io_open_from_data_dirs_finish (GAsyncResult* _res_, GError** error) {
	GFileInputStream* result;
	UnityIoOpenFromDataDirsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Like open_from_dirs() but scans first the user data dir and then
   * the system data dirs as defined by the XDG_DATA_DIRS environment variable.
   */
static void unity_io_open_from_data_dirs_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityIoOpenFromDataDirsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_io_open_from_data_dirs_co (_data_);
}


static gboolean unity_io_open_from_data_dirs_co (UnityIoOpenFromDataDirsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_get_user_data_dir ();
	_data_->_tmp1_ = _data_->filename;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_build_filename (_data_->_tmp0_, _data_->_tmp1_, NULL, NULL);
	_data_->path = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->path;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_file_new_for_path (_data_->_tmp3_);
	_data_->f = _data_->_tmp4_;
	{
		_data_->_tmp5_ = _data_->f;
		_data_->_state_ = 1;
		g_file_read_async (_data_->_tmp5_, G_PRIORITY_DEFAULT, NULL, unity_io_open_from_data_dirs_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = g_file_read_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp7_ = _data_->_tmp6_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
		_data_->result = _data_->_tmp7_;
		_g_object_unref0 (_data_->f);
		_g_free0 (_data_->path);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally13;
	__catch13_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp8_ = _data_->e;
		if (!g_error_matches (_data_->_tmp8_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
			_data_->_tmp9_ = _data_->e;
			_data_->_tmp10_ = _g_error_copy0 (_data_->_tmp9_);
			_data_->_inner_error_ = _data_->_tmp10_;
			_g_error_free0 (_data_->e);
			goto __finally13;
		}
		_g_error_free0 (_data_->e);
	}
	__finally13:
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->f);
		_g_free0 (_data_->path);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = 0;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = unity_io_get_system_data_dirs (&_data_->_tmp11_);
	_data_->dirs = _data_->_tmp12_;
	_data_->dirs_length1 = _data_->_tmp11_;
	_data_->_dirs_size_ = _data_->dirs_length1;
	_data_->_tmp13_ = _data_->filename;
	_data_->_tmp14_ = _data_->dirs;
	_data_->_tmp14__length1 = _data_->dirs_length1;
	_data_->_state_ = 2;
	unity_io_open_from_dirs (_data_->_tmp13_, _data_->_tmp14_, _data_->_tmp14__length1, unity_io_open_from_data_dirs_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = unity_io_open_from_dirs_finish (_data_->_res_, &_data_->_inner_error_);
	_data_->_tmp16_ = _data_->_tmp15_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_data_->dirs = (_vala_array_free (_data_->dirs, _data_->dirs_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_data_->f);
		_g_free0 (_data_->path);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->_tmp16_;
	_data_->dirs = (_vala_array_free (_data_->dirs, _data_->dirs_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->f);
	_g_free0 (_data_->path);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_data_->dirs = (_vala_array_free (_data_->dirs, _data_->dirs_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->f);
	_g_free0 (_data_->path);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


gchar** unity_io_get_system_data_dirs (int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** _tmp10_;
	gint _tmp10__length1;
	_tmp0_ = unity_io_system_data_dirs;
	_tmp0__length1 = unity_io_system_data_dirs_length1;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* dirs;
		const gchar* _tmp3_;
		_tmp1_ = g_getenv ("XDG_DATA_DIRS");
		_tmp2_ = g_strdup (_tmp1_);
		dirs = _tmp2_;
		_tmp3_ = dirs;
		if (_tmp3_ != NULL) {
			const gchar* _tmp4_;
			gchar** _tmp5_;
			gchar** _tmp6_ = NULL;
			_tmp4_ = dirs;
			_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ":", 0);
			unity_io_system_data_dirs = (_vala_array_free (unity_io_system_data_dirs, unity_io_system_data_dirs_length1, (GDestroyNotify) g_free), NULL);
			unity_io_system_data_dirs = _tmp6_;
			unity_io_system_data_dirs_length1 = _vala_array_length (_tmp5_);
			_unity_io_system_data_dirs_size_ = unity_io_system_data_dirs_length1;
		} else {
			gchar** _tmp7_ = NULL;
			_tmp7_ = g_new0 (gchar*, 0 + 1);
			unity_io_system_data_dirs = (_vala_array_free (unity_io_system_data_dirs, unity_io_system_data_dirs_length1, (GDestroyNotify) g_free), NULL);
			unity_io_system_data_dirs = _tmp7_;
			unity_io_system_data_dirs_length1 = 0;
			_unity_io_system_data_dirs_size_ = unity_io_system_data_dirs_length1;
		}
		_g_free0 (dirs);
	}
	_tmp8_ = unity_io_system_data_dirs;
	_tmp8__length1 = unity_io_system_data_dirs_length1;
	_tmp9_ = (_tmp8_ != NULL) ? _vala_array_dup2 (_tmp8_, _tmp8__length1) : ((gpointer) _tmp8_);
	_tmp9__length1 = _tmp8__length1;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp9__length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



