/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

using GLib;
using Dee;

namespace Unity {

/*
 * Forms a response to an activation requesit
 */

public enum HandledType
{
  NOT_HANDLED,
  SHOW_DASH,
  HIDE_DASH,
  GOTO_DASH_URI
}

public class ActivationResponse : InitiallyUnowned
{
  public HandledType handled { get; construct; }
  public string goto_uri { get; construct set; }

  public ActivationResponse (HandledType handled, string goto_uri="")
  {
    Object (handled:handled, goto_uri:goto_uri);
  }

  internal HashTable<string, Variant> get_hints ()
  {
    var hash = new HashTable<string, Variant> (null, null);

    if (goto_uri != "")
      hash.insert ("goto-uri", goto_uri);
    
    return hash;
  }
}

} /* namespace */
