/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by
 *             Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 */

#ifndef _ZEITGEIST_EGGDBUSCONVERSIONS_H_
#define _ZEITGEIST_EGGDBUSCONVERSIONS_H_

#include <glib-object.h>
#include "zeitgeist-data-source.h"
#include "zeitgeist-event.h"
#include "zeitgeist-timerange.h"
#include "eggzeitgeistdatasource.h"
#include "eggzeitgeistevent.h"
#include "eggzeitgeisttimerange.h"
#include "eggzeitgeisteventdataoffset.h"
#include "eggzeitgeistsubjectdataoffset.h"


G_BEGIN_DECLS

ZeitgeistEvent*     _egg_zeitgeist_event_to_zeitgeist_event   (EggZeitgeistEvent *event);

EggZeitgeistEvent*  _zeitgeist_event_to_egg_zeitgeist_event   (ZeitgeistEvent *event);

GPtrArray*          _egg_zeitgeist_events_to_zeitgeist_events (EggDBusArraySeq *events);

EggDBusArraySeq*    _zeitgeist_events_to_egg_zeitgeist_events (GPtrArray *events);

GPtrArray*          _zeitgeist_events_from_valist             (va_list    events);

EggZeitgeistTimeRange* _zeitgeist_time_range_to_egg_zeitgeist_time_range (ZeitgeistTimeRange *time_range);

ZeitgeistTimeRange*    _egg_zeitgeist_time_range_to_zeitgeist_time_range (EggZeitgeistTimeRange *time_range);

ZeitgeistDataSource* _egg_zeitgeist_data_source_to_zeitgeist_data_source (EggZeitgeistDataSource *data_source);

GPtrArray*          _egg_zeitgeist_data_sources_to_zeitgeist_data_sources (EggDBusArraySeq *data_sources);

G_END_DECLS

#endif /* _ZEITGEIST_EGGDBUSCONVERSIONS_H_ */
