<?php
/** Persian (فارسی)
  *
  * @addtogroup Language
  * Maintainer: Hojjat - huji.odp@gmail.com
  */
$skinNames = array(
	'standard' => 'استاندارد',
	'nostalgia' => 'نوستالژی',
	'cologneblue' => 'آبی کلون',
);
$namespaceNames = array(
	NS_MEDIA          => 'مدیا',
	NS_SPECIAL        => 'ویژه',
	NS_MAIN	          => '',
	NS_TALK	          => 'بحث',
	NS_USER           => 'کاربر',
	NS_USER_TALK      => 'بحث_کاربر',
	# NS_PROJECT set by $wgMetaNamespace
	NS_PROJECT_TALK   => 'بحث_$1',
	NS_IMAGE          => 'تصویر',
	NS_IMAGE_TALK     => 'بحث_تصویر',
	NS_MEDIAWIKI      => 'مدیاویکی',
	NS_MEDIAWIKI_TALK	=> 'بحث_مدیاویکی',
	NS_TEMPLATE       => 'الگو',
	NS_TEMPLATE_TALK  => 'بحث_الگو',
	NS_HELP           => 'راهنما',
	NS_HELP_TALK      => 'بحث_راهنما',
	NS_CATEGORY       => 'رده',
	NS_CATEGORY_TALK  => 'بحث_رده'
);

$digitTransformTable = array(
	'0' => '۰', # &#x06f0;
	'1' => '۱', # &#x06f1;
	'2' => '۲', # &#x06f2;
	'3' => '۳', # &#x06f3;
	'4' => '۴', # &#x06f4;
	'5' => '۵', # &#x06f5;
	'6' => '۶', # &#x06f6;
	'7' => '۷', # &#x06f7;
	'8' => '۸', # &#x06f8;
	'9' => '۹', # &#x06f9;
	'%' => '٪', # &#x066a;
	'.' => '٫', # &#x066b; wrong table?
	',' => '٬', # &#x066c;
);

$rtl = true;
$defaultUserOptionOverrides = array(
	# Swap sidebar to right side by default
	'quickbar' => 2,
	# Underlines seriously harm legibility. Force off:
	'underline' => 0,
);


/**
 * A list of date format preference keys which can be selected in user 
 * preferences. New preference keys can be added, provided they are supported
 * by the language class's timeanddate(). Only the 5 keys listed below are 
 * supported by the wikitext converter (DateFormatter.php).
 *
 * The special key "default" is an alias for either dmy or mdy depending on 
 * $wgAmericanDates
 */
$datePreferences = array(
	'default',
	'mdy',
	'dmy',
	'ymd',
	'ISO 8601',
);

/**
 * The date format to use for generated dates in the user interface.
 * This may be one of the above date preferences, or the special value 
 * "dmy or mdy", which uses mdy if $wgAmericanDates is true, and dmy 
 * if $wgAmericanDates is false.
 */
$defaultDateFormat = 'dmy or mdy';

/**
 * Associative array mapping old numeric date formats, which may still be 
 * stored in user preferences, to the new string formats.
 */
$datePreferenceMigrationMap = array(
	'default',
	'mdy',
	'dmy',
	'ymd'
);

/**
 * These are formats for dates generated by MediaWiki (as opposed to the wikitext
 * DateFormatter). Documentation for the format string can be found in 
 * Language.php, search for sprintfDate. 
 *
 * This array is automatically inherited by all subclasses. Individual keys can be
 * overridden.
 */
$dateFormats = array(
	'mdy time' => 'H:i',
	'mdy date' => 'xg j، Y', # Arabic comma
	'mdy both' => 'H:i، xg j، Y', # Arabic comma

	'dmy time' => 'H:i',
	'dmy date' => 'j xg Y',
	'dmy both' => 'H:i، j xg Y', # Arabic comma

	'ymd time' => 'H:i',
	'ymd date' => 'Y xg j',
	'ymd both' => 'H:i، Y xg j', # Arabic comma

	'ISO 8601 time' => 'xnH:xni:xns',
	'ISO 8601 date' => 'xnY-xnm-xnd',
	'ISO 8601 both' => 'xnY-xnm-xnd"T"xnH:xni:xns',
);

$magicWords = array(
       'redirect'            => array( 0, "#تغییرمسیر", "#REDIRECT" ),
       'notoc'               => array( 0, "__بی‌فهرست__", "__NOTOC__" ),
       'forcetoc'            => array( 0, "__بافهرست__", "__FORCETOC__" ),
       'toc'                 => array( 0, "__فهرست__", "__TOC__" ),
       'noeditsection'       => array( 0, "__بی‌بخش__", "__NOEDITSECTION__" ),
       'currentmonth'        => array( 1, "ماه", "ماه‌کنونی", "CURRENTMONTH" ),
       'currentmonthname'    => array( 1, "نام‌ماه", "نام_ماه", "نام‌ماه‌کنونی", "CURRENTMONTHNAME" ),
       'currentday'          => array( 1, "روز", "CURRENTDAY" ),
       'currentday2'         => array( 1, "روز۲", "CURRENTDAY2" ),
       'currentdayname'      => array( 1, "نام‌روز", "CURRENTDAYNAME" ),
       'currentyear'         => array( 1, "سال", "سال‌کنونی", "CURRENTYEAR" ),
       'currenttime'         => array( 1, "زمان", "CURRENTTIME" ),
       'currenthour'         => array( 1, "ساعت", "CURRENTHOUR" ),
       'localmonth'          => array( 1, "ماه‌محلی", "LOCALMONTH" ),
       'localmonthname'      => array( 1, "نام‌ماه‌محلی", "LOCALMONTHNAME" ),
       'localmonthabbrev'    => array( 1, "اختصارماه‌محلی", "LOCALMONTHABBREV" ),
       'localday'            => array( 1, "روزمحلی", "LOCALDAY" ),
       'localday2'           => array( 1, "روزمحلی۲", "LOCALDAY2" ),
       'localdayname'        => array( 1, "نام‌روزمحلی", "LOCALDAYNAME" ),
       'localyear'           => array( 1, "سال‌محلی", "LOCALYEAR" ),
       'localtime'           => array( 1, "زمان‌محلی", "LOCALTIME" ),
       'localhour'           => array( 1, "ساعت‌محلی", "LOCALHOUR" ),
       'numberofpages'       => array( 1, "تعدادصفحه‌ها", "تعداد_صفحه‌ها", "NUMBEROFPAGES" ),
       'numberofarticles'    => array( 1, "تعدادمقاله‌ها", "تعداد_مقاله‌ها", "NUMBEROFARTICLES" ),
       'numberoffiles'       => array( 1, "تعدادپرونده‌ها", "تعداد_پرونده‌ها", "NUMBEROFFILES" ),
       'numberofusers'       => array( 1, "تعدادکاربران", "تعداد_کاربران", "NUMBEROFUSERS" ),
       'pagename'            => array( 1, "نام‌صفحه", "PAGENAME" ),
       'pagenamee'           => array( 1, "عنوان‌صفحه", "PAGENAMEE" ),
       'namespace'           => array( 1, "فضاینام", "فضای_نام", "NAMESPACE" ),
       'namespacee'          => array( 1, "عنوان‌فضای‌نام", "NAMESPACEE" ),
       'talkspace'           => array( 1, "فضای‌بحث", "TALKSPACE" ),
       'talkspacee'          => array( 1, "عنوان‌بحث", "TALKSPACEE" ),
       'fullpagename'        => array( 1, "نام‌کامل‌صفحه", "FULLPAGENAME" ),
       'fullpagenamee'       => array( 1, "عنوان‌کامل‌صفحه", "FULLPAGENAMEE" ),
       'subst'               => array( 0, "جایگزین:", "جا:", "SUBST:" ),
       'img_thumbnail'       => array( 1, "بندانگشتی", "انگشتدان", "thumbnail", "thumb" ),
       'img_manualthumb'     => array( 1, "بندانگشتی=$1", "انگشتدانهای=$1", "thumbnail=$1", "thumb=$1" ),
       'img_right'           => array( 1, "راست", "right" ),
       'img_left'            => array( 1, "چپ", "left" ),
       'img_none'            => array( 1, "هیچ", "none" ),
       'img_center'          => array( 1, "وسط", "center", "centre" ),
       'img_framed'          => array( 1, "قاب", "framed", "enframed", "frame" ),
       'img_page'            => array( 1, "صفحه=$1", "صفحه $1", "page=$1", "page $1" ),
       'int'                 => array( 0, "محتوى:", "INT:" ),
       'sitename'            => array( 1, "نام‌وبگاه", "SITENAME" ),
       'ns'                  => array( 0, "فن:", "NS:" ),
       'localurl'            => array( 0, "نشانی:", "LOCALURL:" ),
       'server'              => array( 0, "کارگزار", "SERVER" ),
       'servername'          => array( 0, "نام‌کارگزار", "SERVERNAME" ),
       'scriptpath'          => array( 0, "مسیر", "SCRIPTPATH" ),
       'currentweek'         => array( 1, "هفته", "CURRENTWEEK" ),
       'currentdow'          => array( 1, "روزهفته", "CURRENTDOW" ),
       'localweek'           => array( 1, "هفته‌محلی", "LOCALWEEK" ),
       'revisionid'          => array( 1, "نسخه", "REVISIONID" ),
       'plural'              => array( 0, "جمع:", "PLURAL:" ),
       'fullurl'             => array( 0, "نشانی‌کامل:", "FULLURL:" ),
       'newsectionlink'      => array( 1, "__بخش‌جدید__", "__NEWSECTIONLINK__" ),
       'language'            => array( 0, "#زبان:", "#LANGUAGE:" ),
       'numberofadmins'      => array( 1, "تعدادمدیران", "تعداد_مدیران", "NUMBEROFADMINS" ),
       'special'             => array( 0, "ویژه", "special" ),
);

$linkTrail = "/^([a-z]+)(.*)\$/sD"; /* This may need to be changed --RP */

$messages = array(
# User preference toggles
'tog-underline'               => 'زیر پیوندها خط کشیده شود',
'tog-highlightbroken'         => 'قالب‌بندی پیوندهای ناقص <a href="" class="new">به این شکل</a> (امکان دیگر: به این شکل<a href="" class="internal">؟</a>).',
'tog-justify'                 => 'تمام‌چین‌کردن بندها',
'tog-hideminor'               => 'نشان ندادن تغییرات جزئی در فهرست تغییرات اخیر',
'tog-extendwatchlist'         => 'گسترش فهرست تعقیبات برای نشان‌دادن همهٔ تغییرات مربوط.',
'tog-usenewrc'                => 'تغییرات اخیر گسترش‌یافته (برای هر مرورگری نیست)',
'tog-numberheadings'          => 'شماره‌گذاری خودکار عناوین',
'tog-showtoolbar'             => 'نمایش نوار ابزار جعبهٔ ویرایش',
'tog-editondblclick'          => 'ویرایش صفحه‌ها با دوکلیک (جاوااسکریپت)',
'tog-editsection'             => 'به کار انداختن ویرایش قسمت‌ها از طریق پیوندهای [ویرایش]',
'tog-editsectiononrightclick' => 'به کار انداختن ویرایش قسمت‌ها با کلیک راست<br />روی عناوین قسمت‌ها (جاوااسکریپت)',
'tog-showtoc'                 => 'نمایش فهرست مندرجات<br />(برای مقالات با بیش از ۳ سرفصل)',
'tog-rememberpassword'        => 'کلمهٔ عبور برای نشست‌های بعدی بماند',
'tog-editwidth'               => 'عرض جعبهٔ ویرایش کامل باشد',
'tog-watchcreations'          => 'افزودن صفحه‌های ایجادشده توسط من به فهرست تعقیباتم.',
'tog-watchdefault'            => 'افزودن صفحه‌هایی که ویرایش می‌کنم به فهرست تعقیبات',
'tog-watchmoves'              => 'افزودن صفحه‌هایی که منتقل می‌کنم به فهرست تعقیبات',
'tog-watchdeletion'           => 'افزودن صفحه‌هایی که حذف می‌کنم به فهرست تعقیبات من',
'tog-minordefault'            => 'پیش‌فرض همهٔ ویرایش‌ها «جزئی» باشد',
'tog-previewontop'            => 'نمایش پیش‌نمایش قبل از جعبهٔ ویرایش و نه پس از آن',
'tog-previewonfirst'          => 'پیش‌نمایش هنگام اولین ویرایش',
'tog-nocache'                 => 'از کار انداختن حافظهٔ نهانی صفحات',
'tog-enotifwatchlistpages'    => 'اگر صفحه‌ای مورد تعقیب من تغییر کرد به من ایمیل بزن.',
'tog-enotifusertalkpages'     => 'هنگامی که در صفحهٔ بحث کاربری‌ام تغییری صورت می‌گیرد به من ایمیل بزن.',
'tog-enotifminoredits'        => 'برای تغییرات جزئی در صفحه‌ها هم به من ایمیل بزن.',
'tog-enotifrevealaddr'        => 'نشانی پست الکترونیک من در نامه‌های اطلاع‌رسانی قید شود',
'tog-shownumberswatching'     => 'نشان‌دادن شمار کاربران تعقیب‌کننده',
'tog-fancysig'                => 'امضای خام (بدون درج خودکار پیوند)',
'tog-externaleditor'          => 'به‌طور پیش‌فرض از ویرایشگر خارجی استفاده شود',
'tog-externaldiff'            => 'استفاده از تفاوت‌گیر (diff) خارجی به‌طور پیش‌فرض.',
'tog-showjumplinks'           => 'نمایش پیوندهای پرشی در فهرست مندرجات',
'tog-uselivepreview'          => 'استفاده از پیش‌نمایش زنده (جاوااسکریپت) (آزمایشی)',
'tog-forceeditsummary'        => 'هنگامی که خلاصهٔ ویرایش ننوشته‌ام به من اطلاع بده',
'tog-watchlisthideown'        => 'مخفی‌کردن ویرایش‌های من در فهرست تعقیبات',
'tog-watchlisthidebots'       => 'مخفی‌کردن ویرایش‌های ربات‌ها در فهرست تعقیبات',
'tog-watchlisthideminor'      => 'نهفتن ویرایش‌های جزئی از فهرست تعقیبات من',
'tog-nolangconversion'        => 'غیرفعال کردن تبدیل زبان‌ها',
'tog-ccmeonemails'            => 'فرستادن رونوشت نامه‌های الکترونیکی که به دیگران ارسال می‌کنم به خودم.',
'tog-diffonly'                => 'محتویات صفحه زیر تفاوت نمایش داده نشود',

'underline-always'  => 'همیشه',
'underline-never'   => 'هرگز',
'underline-default' => 'پیش‌فرض مرورگر',

'skinpreview' => '(پیش‌نمایش)',

# Dates
'sunday'        => 'یک‌شنبه',
'monday'        => 'دوشنبه',
'tuesday'       => 'سه‌شنبه',
'wednesday'     => 'چهارشنبه',
'thursday'      => 'پنجشنبه',
'friday'        => 'جمعه',
'saturday'      => 'شنبه',
'sun'           => 'یکشنبه',
'mon'           => 'دوشنبه',
'tue'           => 'سه‌شنبه',
'wed'           => 'چهارشنبه',
'thu'           => 'پنجشنبه',
'fri'           => 'جمعه',
'sat'           => 'شنبه',
'january'       => 'ژانویه',
'february'      => 'فوریه',
'march'         => 'مارس',
'april'         => 'آوریل',
'may_long'      => 'مه',
'june'          => 'ژوئن',
'july'          => 'ژوئیه',
'august'        => 'اوت',
'september'     => 'سپتامبر',
'october'       => 'اکتبر',
'november'      => 'نوامبر',
'december'      => 'دسامبر',
'january-gen'   => 'ژانویه',
'february-gen'  => 'فوریه',
'march-gen'     => 'مارس',
'april-gen'     => 'آوریل',
'may-gen'       => 'مه',
'june-gen'      => 'ژوئن',
'july-gen'      => 'ژوئیه',
'august-gen'    => 'اوت',
'september-gen' => 'سپتامبر',
'october-gen'   => 'اکتبر',
'november-gen'  => 'نوامبر',
'december-gen'  => 'دسامبر',
'jan'           => 'ژانویه',
'feb'           => 'فوریه',
'mar'           => 'مارس',
'apr'           => 'آوریل',
'may'           => 'مه',
'jun'           => 'ژوئن',
'jul'           => 'ژوئیه',
'aug'           => 'اوت',
'sep'           => 'سپتامبر',
'oct'           => 'اکتبر',
'nov'           => 'نوامبر',
'dec'           => 'دسامبر',

# Bits of text used by many pages
'categories'            => 'رده‌های صفحه',
'pagecategories'        => '{{PLURAL:$1|رده‌های صفحه|رده‌های صفحه}}',
'category_header'       => 'مقاله‌های ردهٔ «$1»',
'subcategories'         => 'زیررده‌ها',
'category-media-header' => 'پرونده‌های ردهٔ «$1»',
'category-empty'        => 'این رده شامل هیچ صفحه یا پرونده‌ای نمی‌شود.',

'mainpagetext'      => 'نرم‌افزار ویکی با موفقیت نصب شد.',
'mainpagedocfooter' => 'از [http://meta.wikimedia.org/wiki/Help:Contents راهنمای کاربران]
برای استفاده از نرم‌افزار ویکی کمک بگیرید.

== آغاز به کار ==

* [http://www.mediawiki.org/wiki/Manual:Configuration_settings تنظیم پیکربندی]
* [http://www.mediawiki.org/wiki/Manual:FAQ MediaWiki پرسش‌های متداول]
* [http://lists.wikimedia.org/mailman/listinfo/mediawiki-announce فهرست رایانامه نسخه‌های مدیاویکی]',

'about'          => 'درباره',
'article'        => 'صفحهٔ محتوا',
'newwindow'      => '(در پنجرهٔ جدید باز می‌شود)',
'cancel'         => 'لغو',
'qbfind'         => 'یافتن',
'qbbrowse'       => 'مرور',
'qbedit'         => 'ویرایش',
'qbpageoptions'  => 'این صفحه',
'qbpageinfo'     => 'بافت',
'qbmyoptions'    => 'صفحات من',
'qbspecialpages' => 'صفحات ویژه',
'moredotdotdot'  => 'بیشتر...',
'mypage'         => 'صفحهٔ من',
'mytalk'         => 'بحث من',
'anontalk'       => 'بحث برای این IP',
'navigation'     => 'گشتن',

# Metadata in edit box
'metadata_help' => 'متاداده:',

'errorpagetitle'    => 'خطا',
'returnto'          => 'بازگشت به $1.',
'tagline'           => 'از {{SITENAME}}، دانشنامهٔ آزاد.',
'help'              => 'راهنما',
'search'            => 'جستجو',
'searchbutton'      => 'جستجو کن',
'go'                => 'برو',
'searcharticle'     => 'برو',
'history'           => 'تاریخچهٔ صفحه',
'history_short'     => 'تاریخچه',
'updatedmarker'     => 'به‌روزشده از پس از آخرین باری که سرزده‌ام.',
'info_short'        => 'اطلاعات',
'printableversion'  => 'نسخهٔ قابل چاپ',
'permalink'         => 'پیوند دائمی',
'print'             => 'چاپ',
'edit'              => 'این صفحه را ویرایش کنید',
'editthispage'      => 'ویرایش این صفحه',
'delete'            => 'حذف',
'deletethispage'    => 'حذف این صفحه',
'undelete_short'    => 'احیای $1 ویرایش',
'protect'           => 'محافظت',
'protect_change'    => 'تغییر وضعیت',
'protectthispage'   => 'محافظت از این صفحه',
'unprotect'         => 'به‌درآوردن از محافظت',
'unprotectthispage' => 'از محافظت در آوردن این صفحه',
'newpage'           => 'صفحهٔ جدید',
'talkpage'          => 'بحث دربارهٔ این صفحه',
'talkpagelinktext'  => 'بحث',
'specialpage'       => 'صفحهٔ ویژه',
'personaltools'     => 'ابزارهای شخصی',
'postcomment'       => 'نوشتن نظر',
'articlepage'       => 'نمایش مقاله',
'talk'              => 'بحث',
'views'             => 'بازدیدها',
'toolbox'           => 'جعبه‌ابزار',
'userpage'          => 'نمایش صفحهٔ کاربر',
'projectpage'       => 'دیدن صفحهٔ پروژه',
'imagepage'         => 'نمایش صفحهٔ تصویر',
'mediawikipage'     => 'نمایش صفحهٔ پیغام',
'templatepage'      => 'نمایش صفحهٔ الگو',
'viewhelppage'      => 'نمایش صفحهٔ راهنما',
'categorypage'      => 'نمایش صفحهٔ رده',
'viewtalkpage'      => 'نمایش مباحثات',
'otherlanguages'    => 'زبان‌های دیگر',
'redirectedfrom'    => '(تغییر مسیر از $1)',
'redirectpagesub'   => 'صفحهٔ تغییر مسیر',
'lastmodifiedat'    => 'این صفحه آخرین بار در $2، $1 تغییر یافته‌است.', # $1 date, $2 time
'viewcount'         => 'این صفحه $1 بار دیده شده است.',
'protectedpage'     => 'صفحهٔ محافظت‌شده',
'jumpto'            => 'پرش به:',
'jumptonavigation'  => 'ناوبری',
'jumptosearch'      => 'جستجو',

# All link text and link target definitions of links into project namespace that get used by other message strings, with the exception of user group pages (see grouppage) and the disambiguation template definition (see disambiguations).
'aboutsite'         => 'دربارهٔ {{SITENAME}}',
'aboutpage'         => '{{ns:project}}:درباره',
'bugreports'        => 'گزارش اشکالات',
'bugreportspage'    => '{{ns:project}}:گزارش اشکالات',
'copyright'         => 'محتویات تحت اجازه‌نامهٔ $1 در دسترس است.',
'copyrightpagename' => 'حق تکثیر {{SITENAME}}',
'copyrightpage'     => '{{ns:project}}:حق_تکثیر',
'currentevents'     => 'وقایع کنونی',
'currentevents-url' => 'وقایع کنونی',
'disclaimers'       => 'تکذیب‌نامه‌ها',
'disclaimerpage'    => '{{ns:project}}:تکذیب‌نامهٔ عمومی',
'edithelp'          => 'راهنمای ویرایش کردن',
'edithelppage'      => '{{ns:project}}:چگونه_صفحات_را_ویرایش_کنیم',
'faq'               => 'سؤالات معمول',
'faqpage'           => '{{ns:project}}:سؤالات معمول',
'helppage'          => '{{ns:project}}:راهنما',
'mainpage'          => 'صفحهٔ اصلی',
'policy-url'        => '{{ns:project}}:سیاست‌ها',
'portal'            => 'ورودی کاربران',
'portal-url'        => '{{ns:project}}:ورودی کاربران',
'privacy'           => 'سیاست حفظ اسرار',
'privacypage'       => 'Project:سیاست_حفظ_اسرار',
'sitesupport'       => 'کمک مالی',
'sitesupport-url'   => '{{ns:project}}:کمک به این سایت',

'badaccess'        => 'خطای دسترسی',
'badaccess-group0' => 'شما اجازهٔ اجرای عمل درخواسته را ندارید.',
'badaccess-group1' => 'عملی که درخواسته‌اید منحصر به کاربران گروه $1 است.',
'badaccess-group2' => 'عملی که درخواسته‌اید منحصر به کاربران یکی از گروههای $1 است.',
'badaccess-groups' => 'عملی که درخواسته‌اید منحصر به کاربران یکی از گروههای $1 است.',

'versionrequired'     => 'نسخهٔ $1 از نرم‌افزار مدیاویکی لازم است',
'versionrequiredtext' => 'برای دیدن این صفحه به نسخهٔ $1 از نرم‌افزار مدیاویکی نیاز دارید. برای اطلاع از نسخهٔ نرم‌افزار نصب شده در این ویکی به [[Special:Version|این صفحه]] مراجعه کنید.',

'ok'                      => 'باشد',
'retrievedfrom'           => 'برگرفته از «$1»',
'youhavenewmessages'      => '$1 دارید ($2).',
'newmessageslink'         => 'پیامهای جدیدی',
'newmessagesdifflink'     => 'تفاوت با نسخهٔ پیش از آخر',
'youhavenewmessagesmulti' => 'پیغامهای جدیدی در $1 دارید.',
'editsection'             => 'ویرایش',
'editold'                 => 'ویرایش',
'editsectionhint'         => 'ویرایش بخش: $1',
'toc'                     => 'فهرست مندرجات',
'showtoc'                 => 'نمایش داده شود',
'hidetoc'                 => 'مخفی شود',
'thisisdeleted'           => 'نمایش یا احیای $1؟',
'viewdeleted'             => 'نمایش $1؟',
'restorelink'             => '$1 ویرایش حذف‌شده',
'feedlinks'               => 'خبرخوان:',
'feed-invalid'            => 'اشکال در آبونمان خبرخوان',

# Short words for each namespace, by default used in the 'article' tab in monobook
'nstab-main'      => 'مقاله',
'nstab-user'      => 'صفحهٔ کاربر',
'nstab-media'     => 'رسانه',
'nstab-special'   => 'ویژه',
'nstab-project'   => 'صفحهٔ پروژه',
'nstab-image'     => 'تصویر',
'nstab-mediawiki' => 'پیغام',
'nstab-template'  => 'الگو',
'nstab-help'      => 'راهنما',
'nstab-category'  => 'رده',

# Main script and global functions
'nosuchaction'      => 'چنین عملی وجود ندارد',
'nosuchactiontext'  => 'ویکی عمل مشخص شده در URL را نمی‌شناسد',
'nosuchspecialpage' => 'چنین صفحهٔ ویژه‌ای وجود ندارد',
'nospecialpagetext' => 'شما صفحهٔ ویژه‌ای را درخواست کرده‌اید که ویکی نمی‌شناسد.',

# General errors
'error'                => 'خطا',
'databaseerror'        => 'خطای پایگاه داده',
'dberrortext'          => 'اشکالی در دستور فرستاده شده به پایگاه داده رخ داد.
علت این مساله می‌توانید ایرادی در نرم‌افزار مدیاویکی باشد.
آخرین دستوری که برای پایگاه داده فرستاد شد این بود:
<div dir="ltr"><blockquote><tt>$1</tt></blockquote></div>
این دستور از درون عملگر <span dir=ltr><tt>$2</tt></span> فرستاده شد
پایگاه داده این خطا را باز گرداند:
<div dir="ltr"><tt>$3: $4</tt></div>',
'dberrortextcl'        => 'اشکالی در دستور فرستاده شده به پایگاه داده رخ داد.
علت این مساله می‌توانید ایرادی در نرم‌افزار مدیاویکی باشد.
آخرین دستوری که برای پایگاه داده فرستاد شد این بود:
<div dir="ltr">$1</div>
این دستور از درون عملگر <span dir=ltr>$2</span> فرستاده شد
پایگاه داده این خطا را باز گرداند:
<div dir="ltr">$3: $4</div>',
'noconnect'            => 'شرمنده! ویکی مشکلات فنی دارد، و نمی‌تواند با کارگزار پایگاه داده تماس بگیرد.<br /> $1',
'nodb'                 => 'نمی‌توان پایگاه دادهٔ $1 را انتخاب کرد',
'cachederror'          => 'در زیر یک نسخهٔ بایگانی‌شدهٔ صفحهٔ درخواستی می‌آید، و ممکن است به‌روز نباشد.',
'laggedslavemode'      => 'هشدار: صفحه ممکن است به‌روزرسانی‌های اخیر را شامل نگردد.',
'readonly'             => 'پایگاه داده قفل شد',
'enterlockreason'      => 'دلیلی برای قفل کردن ذکر کنید، و تقریبی از زمانی که قفل برداشته خواهد شد در آن بیاورید',
'readonlytext'         => 'پایگاه داده در حال حاضر در برابر تغییرات و ایجاد مداخل قفل شده است. احتمالاً علت آن بهینه‌سازی و رسیدگی‌های معمول است که بعد از انجام آن وضع به حالت عادی باز خواهد گشت. توضیح مدیری که آن را قفل کرده است بدین شرح است: 
<p>$1',
'missingarticle'       => 'پایگاه داده متن صفحه‌ای به نام «$1» را که باید می‌یافت، نیافت.

<p>این مشکل معمولاً بر اثر ادامه دادن پیوندهای تاریخ‌گذشتهٔ تفاوت یا تاریخچهٔ صفحاتی رخ می‌دهد که حذف شده‌اند.

<p>اگر مورد شما این نیست، ممکن است اشکالی در نرم‌افزار پیدا کرده باشید.
لطفاً این مسئله را، با ذکر URL، به یکی از مدیران گزارش کنید.',
'readonly_lag'         => 'پایگاه داده به طور خودکار قفل شده‌است تا نسخه‌های پشتیبان با نسخهٔ اصلی هماهنگ شوند.',
'internalerror'        => 'خطای داخلی',
'internalerror_info'   => 'خطای داخلی: $1',
'filecopyerror'        => 'نتوانستم از پروندهٔ «$1» روی «$2» نسخه‌برداری کنم.',
'filerenameerror'      => 'نتوانستم پروندهٔ «$1» را به «$2» تغییر نام دهم.',
'filedeleteerror'      => 'نتوانستم پروندهٔ «$1» را حذف کنم',
'directorycreateerror' => 'امکان ایجاد پوشه $1 وجود ندارد.',
'filenotfound'         => 'پروندهٔ «$1» یافت نشد.',
'fileexistserror'      => 'امکان نوشتن روی پرونده $1 وجود ندارد: پرونده از قبل وجود دارد.',
'unexpected'           => 'مقدار غیرمنتظره: «$1»=«$2».',
'formerror'            => 'خطا: نمی‌توان فرم را فرستاد',
'badarticleerror'      => 'نمی‌توان این عمل را بر این صفحه انجام داد.',
'cannotdelete'         => 'نشد صفحه یا تصویر مشخص‌شده را حذف کرد. (ممکن است قبلاً کس دیگری آن را حذف کرده باشد.)',
'badtitle'             => 'عنوان بد',
'badtitletext'         => 'عنوان درخواستی نامعتبر، خالی، یا عنوانی بین زبانی یا بین‌ویکی‌ای با پیوند نادرست بود.',
'perfdisabled'         => 'شرمنده! این امکان موفقتاً برداشته شده چون پایگاه داده را چنان کند می‌کند
که هیچ کس نمی‌تواند از ویکی استفاده کند.',
'perfcached'           => 'داده‌های زیر از حافظهٔ موقت فراخوانی شده‌اند و ممکن است کاملاً به‌روز نباشند:',
'perfcachedts'         => 'داده‌های زیر از حافظهٔ موقت فراخوانی شده‌اند و آخرین به‌روزرسانی $1 است',
'querypage-no-updates' => 'امکان به روز رسانی این صفحه فعلاً غیرفعال شده‌است.',
'wrong_wfQuery_params' => 'پارامترهای wfQuery() نادرست است<br />
تابع: $1<br />
پرس‌وجو: $2',
'viewsource'           => 'نمایش مبدأ',
'viewsourcefor'        => 'برای $1',
'protectedpagetext'    => 'این صفحه برای جلوگیری از ویرایش قفل شده‌است.',
'viewsourcetext'       => 'می‌توانید متن مبدأ این صفحه را مشاهده کنید یا از آن نسخه بردارید',
'protectedinterface'   => 'این صفحه ارائه‌دهندهٔ متنی برای رابط کاربر این نرم‌افزار است و به منظور پیشگیری از خرابکاری قفل شده‌است.',
'editinginterface'     => "'''هشدار:''' شما صفحه‌ای را ویرایش می‌کنید که شامل  متنی به‌کاررفته در رابط کاربر این نرم‌افزار است. تغییر این صفحه منجر به تغییر ظاهر رابط کاربر این نرم‌افزار برای دیگر کاربران خواهد شد.",
'sqlhidden'            => '(دستور SQL مخفی‌شده)',
'cascadeprotected'     => 'این صفحه در مقابل ویرایش محافظت شده‌است برای اینکه در {{PLURAL:$1|صفحهٔ|صفحه‌های}} محافظت‌شدهٔ زیر که گزینهٔ «آبشاری» در {{PLURAL:$1|آن|آنها}} انتخاب شده‌است، قرار گرفته‌است::
$2',
'namespaceprotected'   => "شما اجازهٔ ویرایش صفحات فضای نام '''$1''' را ندارید.",
'customcssjsprotected' => 'شما اجازهٔ ویرایش این صفحه را ندارید، چرا که حاوی تنظیمات شخصی یک کاربر دیگر است.',
'ns-specialprotected'  => 'صفحه‌های فضای نام {{ns:special}} غیر قابل ویرایش هستند.',

# Login and logout pages
'logouttitle'                => 'خروج کاربر از سیستم',
'logouttext'                 => 'اکنون از سیستم خارج شدید. شما می‌توانید به استفادهٔ گمنام از {{SITENAME}} ادامه دهید، یا می‌توانید با همین کاربر یا کاربر دیگری به سیستم وارد شوید. توجه کنید که تا زمانی که cache مرورگرتان را پاک کنید،
بعضی صفحات ممکن است به شکلی نمایش یابند که انگار هنوز وارد سیستم هستید.',
'welcomecreation'            => '<h2>$1، خوش آمدید!</h2><p>حساب شما
ایجاد شد.
فراموش نکنید که ترجیحات {{SITENAME}} خود را
تنظیم کنید.',
'loginpagetitle'             => 'ورود کاربر به سیستم',
'yourname'                   => 'نام کاربری شما',
'yourpassword'               => 'کلمهٔ عبور شما',
'yourpasswordagain'          => 'کلمهٔ عبور را دوباره وارد کنید',
'remembermypassword'         => 'کلمهٔ عبور را به یاد بسپار.',
'yourdomainname'             => 'دامنهٔ شما',
'externaldberror'            => 'خطایی در ارتباط با پایگاه داده رخ داده‌است یا این که شما اجازه به روز رسانی حساب بیرونی خود را ندارید.',
'loginproblem'               => '<b>ورود شما به سیستم با مشکلی مواجه شد.</b><br />دوباره تلاش کنید!',
'login'                      => 'ورود به سیستم',
'loginprompt'                => 'برای ورود به {{SITENAME}} باید کوکی‌ها را فعال کنید.',
'userlogin'                  => 'ورود به سیستم / ایجاد حساب کاربری',
'logout'                     => 'خروج از سیستم',
'userlogout'                 => 'خروج از سیستم',
'notloggedin'                => 'به سیستم وارد نشده‌اید',
'nologin'                    => 'نام کاربری ندارید؟ $1.',
'nologinlink'                => 'یک حساب جدید بسازید',
'createaccount'              => 'ایجاد حساب جدید',
'gotaccount'                 => 'حساب کاربری دارید؟ $1.',
'gotaccountlink'             => 'وارد شوید',
'createaccountmail'          => 'با پست الکترونیکی',
'badretype'                  => 'کلمه‌های عبوری که وارد کردید یکسان نیستند.',
'userexists'                 => 'نام کاربری‌ای که وارد کردید قبلاً استفاده شده است. لطفاً یک نام دیگر انتخاب کنید.',
'youremail'                  => 'پست الکترونیکی شما*',
'username'                   => 'نام کاربری:',
'uid'                        => 'شمارهٔ کاربری:',
'yourrealname'               => '*نام واقعی شما',
'yourlanguage'               => 'زبان شما',
'yournick'                   => 'لقب شما (برای امضاها)',
'badsig'                     => 'امضای خام غیرمجاز؛ لطفاً برچسب‌های HTML را بررسی کنید.',
'badsiglength'               => 'امضای شما بیش از اندازه طولانی است؛ امضاها باید کمتر از $1 نویسه طول داشته باشند.',
'email'                      => 'پست الکترونیک',
'prefs-help-realname'        => '*نام واقعی (اختیاری): اگر تصمیم به ذکر آن بگیرید هنگام ارجاع به آثارتان و انتساب آنها به شما از نام واقعی‌تان استفاده خواهد شد.',
'loginerror'                 => 'خطا در ورود به سیستم',
'prefs-help-email'           => '* نشانی پست الکترونیک (اختیاری) : تماس دیگر کاربران با شما را بوسیلهٔ نامهٔ الکترونیکی از طریق صفحهٔ کاربری یا صفحهٔ بحث کاربری، بدون نیاز به فاش کردن هویت‌‌ و نشانی واقعی پست الکترونیک‌تان ممکن می‌سازد.',
'nocookiesnew'               => 'حساب کاربری ایجاد شد، اما شما وارد سیستم نشدید. {{SITENAME}} برای ورود کاربران به سیستم از cookie استفاده می‌کند. شما cookieها را از کار انداخته‌اید. لطفاً cookieها را به کار بیندازید، و سپس با نام کاربری و کلمهٔ عبور جدیدتان به سیستم وارد شوید.',
'nocookieslogin'             => '{{SITENAME}} برای ورود کاربران به سیستم از cookie استفاده می‌کند. شما cookieها را از کار
انداخته‌اید. لطفاً cookieها را به کار بیندازید و دوباره تلاش کنید.',
'noname'                     => 'شما نام کاربری معتبری مشخص نکرده‌اید.',
'loginsuccesstitle'          => 'ورود موفقیت‌آمیز به سیستم',
'loginsuccess'               => 'شما اکنون با نام «$1» به {{SITENAME}} وارد شده‌اید.',
'nosuchuser'                 => 'کاربری با نام «$1» وجود ندارد.
املای نام را بررسی کنید، یا از فرم زیر برای ایجاد یک حساب کاربری جدید استفاده کنید.',
'nosuchusershort'            => "هیچ کاربری با نام ''$1'' وجود ندارد. املایتان را وارسی کنید.",
'nouserspecified'            => 'باید یک نام کاربری مشخص کنید.',
'wrongpassword'              => 'کلمهٔ عبوری که وارد کردید نادرست است. لطفاً دوباره تلاش کنید.',
'wrongpasswordempty'         => 'کلمهٔ عبوری که وارد کرده‌اید، خالی است. لطفاً دوباره تلاش کنید.',
'passwordtooshort'           => 'کلمهٔ عبوری که وارد کرده‌اید خیلی کوتاه است. کلمهٔ عبور باید حداقل $1 حرف داشته باشد.',
'mailmypassword'             => 'یک کلمهٔ عبور جدید به شما فرستاده شود',
'passwordremindertitle'      => 'یادآور کلمه رمز {{SITENAME}}',
'passwordremindertext'       => 'Someone (probably you, from IP address $1)
requested that we send you a new password for {{SITENAME}} ($4).
The password for user "$2" is now "$3".
You should log in and change your password now.

If someone else made this request or if you have remembered your password and
you no longer wish to change it, you may ignore this message and continue using
your old password.

------------------------------

یک نفر (احتمالاً خود شما) با نشانی آی‌پی $1 درخواست کرده‌است که ما کلمهٔ عبور جدیدی برای  حساب کاربری‌ {{SITENAME}}ی شما در {{SERVERNAME}} بفرستیم ($4).
کلمهٔ عبور کاربر \'\'$2\'\' همکنون \'\'$3\'\' است. 
حالا باید وارد سیستم شده و کلمهٔ عبور خود را تغییر دهید. 
اگر کس دیگری این درخواست را کرده‌است یا اینکه شما کلمهٔ عبور پیشین خود را به یاد آورده‌اید و دیگر علاقه‌ای به تغییر آن ندارید، به این پیغام اهمیت مدهید و همان کلمهٔ عبور پیشین را به کار برید.',
'noemail'                    => 'هیچ نشانی پست الکترونیکی‌ای برای کاربر «$1» ثبت نشده است.',
'passwordsent'               => 'یک کلمهٔ عبور جدید به نشانی الکترونیکی ثبت شده برای کاربر «$1» فرستاده شد.
لطفاً پس از دریافت آن دوباره به سیستم وارد شوید.',
'blocked-mailpassword'       => 'نشانی آی‌پی شما از ویرایش بازداشته شده‌است و از این رو به منظور جلوگیری از سوءاستفاده اجازهٔ بهره‌گیری از قابلیت بازیافت گذرواژه را ندارد.',
'eauthentsent'               => 'یک نامهٔ الکترونیکی تأییدیهٔ آدرس به آدرس مورنظر ارسال شد. قبل از اینکه نامهٔ دیگری قابل ارسال به این آدرس باشد، باید دستوراتی که در آن نامه آمده است را جهت تأیید این مساله که این آدرس متعلق به شماست، اجرا کنید.',
'throttled-mailpassword'     => 'یک یادآور گذرواژه در $1 ساعت گذشته برای شما فرستاده شده‌است. برای جلوگیری از سوءاستفاده هر  $1 ساعت تنها یک یادآوری فرستاده می‌شود.',
'mailerror'                  => 'خطا در فرستادن نامهٔ الکترونیکی : $1',
'acct_creation_throttle_hit' => 'شرمنده! شما در حال حاضر، $1 حساب کاربری ساخته‌اید. نمی‌توانید یکی دیگر بسازید.',
'emailauthenticated'         => 'نشانی پست الکترونیک شما در $1 تصدیق شد.',
'emailnotauthenticated'      => 'نشانی پست الکترونیکی شما <strong>هنوز تصدیق نشده است.</strong> هیچ نامهٔ الکترونیکی‌ای برای هر یک از ویژگی‌های زیر ارسال نخواهد شد.',
'noemailprefs'               => '<strong>برای راه‌اندازی این قابلیت‌ها یک نشانی پست الکترونیکی مشخص کنید.</strong>',
'emailconfirmlink'           => 'نشانی پست الکترونیکی خود را تأیید کنید',
'invalidemailaddress'        => 'نشانی واردشدهٔ پست الکترونیک قابل‌قبول نیست، چرا که دارای ساختار نامعتبری است. لطفاً نشانی‌آی با ساختار صحیح وارد کنید و یا بخش مربوط را خالی بگذارید.',
'accountcreated'             => 'حساب ایجاد شد.',
'accountcreatedtext'         => 'حساب کاربری $1 ایجاد شده‌است.',
'loginlanguagelabel'         => 'زبان: $1',

# Password reset dialog
'resetpass'               => 'صفرکردن گذرواژهٔ حساب کاربری',
'resetpass_announce'      => 'شما با کد موقتی پست‌شده وارد شده‌اید. برای انجام فرایند ورود به سیستم باید گذروازهٔ جدیدی وارد کنید:',
'resetpass_text'          => '<!-- اینجا متن اضافه کنید -->',
'resetpass_header'        => 'صفرکردن گذرواژه',
'resetpass_submit'        => 'تنظیم گذرواژه و ورود به سیستم',
'resetpass_success'       => 'گذرواژهٔ شما با موفقیت تغییر داده شد. در حال وارد کردن شما به سیستم....',
'resetpass_bad_temporary' => 'گذرواژهٔ موقت نامعتبر است. احتمالاً پیشتر گذرواژهٔ خود را با موفقیت تغییر داده‌اید یا گذرواژهٔ موقت جدیدی درخواسته‌اید.',
'resetpass_forbidden'     => 'در این ویکی نمی‌توان گذرواژه‌ها را تغییر دارد.',
'resetpass_missing'       => 'اطلاعاتی برای کارگزار فرستاده نشده‌است',

# Edit page toolbar
'bold_sample'     => 'متن پررنگ',
'bold_tip'        => 'متن پُررنگ',
'italic_sample'   => 'متن ایتالیک',
'italic_tip'      => 'متن ایتالیک',
'link_sample'     => 'عنوان پیوند',
'link_tip'        => 'پیوند داخلی',
'extlink_sample'  => 'http://www.example.com عنوان پیوند',
'extlink_tip'     => 'پیوند به بیرون (پیشوند http:// را فراموش نکنید)',
'headline_sample' => 'متن عنوان',
'headline_tip'    => 'عنوان سطح ۲',
'math_sample'     => 'درج فرمول در اینجا',
'math_tip'        => 'فرمول ریاضی (LaTeX)',
'nowiki_sample'   => 'اینجا متن قالب‌بندی‌نشده وارد شود',
'nowiki_tip'      => 'نادیده گرفتن قالب‌بندی ویکی',
'image_sample'    => 'مثال.jpg',
'image_tip'       => 'تصویر داخل متن',
'media_sample'    => 'مثال.ogg',
'media_tip'       => 'پیوند پروندهٔ رسانه',
'sig_tip'         => 'امضای شما و برچسب زمان',
'hr_tip'          => 'خط افقی (در کاربرد آن امساک کنید)',

# Edit pages
'summary'                   => 'خلاصه',
'subject'                   => 'موضوع/عنوان',
'minoredit'                 => 'این ویرایش جزئی است',
'watchthis'                 => 'تعقیب این مقاله',
'savearticle'               => 'صفحه ذخیره شود',
'preview'                   => 'پیش‌نمایش',
'showpreview'               => 'پیش‌نمایش',
'showlivepreview'           => 'پیش‌نمایش زنده',
'showdiff'                  => 'نمایش تغییرات',
'anoneditwarning'           => 'شما با نام کاربری وارد نشده‌اید. نشانی IP شما در تاریخچهٔ ویرایش‌های این صفحه ثبت خواهد شد.',
'missingsummary'            => "'''یادآوری:''' شما خلاصهٔ ویرایش ننوشته‌اید. اگر دوباره ''ذخیره'' را کلیک کنید ویرایشتان بدون خلاصه ذخیره خواهد شد.",
'missingcommenttext'        => 'لطفاً توضیحی در زیر بیفزایید.',
'missingcommentheader'      => "یادآوری: '''شما موضوع/عنوان این یادداشت را مشخص نکرده‌اید.''' اگر دوباره دکمهٔ ذخیره را فشار دهید ویرایش شما بدون آن ذخیره خواهد شد.",
'summary-preview'           => 'پیش‌نمایش خلاصه',
'subject-preview'           => 'پیش‌نمایش موضوع/عنوان',
'blockedtitle'              => 'کاربر بسته شد.',
'blockedtext'               => "'''نام کاربری یا نشانی IP شما بسته شده است.'''

این کار توسط $1 انجام شده‌است. دلیل داده‌شده این است:<br />''$2''<p>

* شروع قطع دسترسی: $8
* زمان پایان این قطع دسترسی: $6
* کاربری که دسترسی‌اش قطع شده: $7

شما می‌توانید با $1 یا یکی از [[{{MediaWiki:grouppage-sysop}}|مدیران]] تماس بگیرید و در این باره صحبت کنید.

توجه کنید که شما نمی‌توانید از امکان «فرستادن پست الکترونیکی به این کاربر» استفاده کنید مگر اینکه نشانی پست الکترونیکی معتبری در [[Special:Preferences|ترجیحات کاربری]]‌تان ثبت کرده باشید.

نشانی IP شما $3 و شماره قطع دسترسی شما $5 است. لطفاً این شماره‌ها را در کلیهٔ پرس‌وجوهایتان ذکر کنید.

==نکته برای کاربران AOL==
به خاطر اعمال تخریبی یک کاربر مشخص AOL، {{SITENAME}} معمولاً proxyهای AOL را می‌بندد. متأسفانه ممکن است تعداد زیادی از کاربران AOL از یک خادم proxy واحد استفاده کنند، و در نتیجه کاربران بی‌تقصیر AOL معمولاً ندانسته بسته می‌شوند. از دردسر ایجادشده عذر می‌خواهیم.

اگر این اتفاق برای شما افتاد، لطفاً به یکی از مدیران از یک نشانی پست الکترونیک AOL پیغام بفرستید. حتماً نشانی IP خود را مطابق آن چه بالاتر گفته شده در پیغامتان ذکر کنید.",
'autoblockedtext'           => "دسترسی نشانی اینترنتی (IP) شما قطع شده‌است، چرا که این نشانی اینترنتی توسط یک کاربر استفاده می‌شده که دسترسی او توسط $1 قطع گردیده‌است.
علت ذکر شده چنین است:

:''$2''

* شروع قطع دسترسی: $8
* پایان قطع دسترسی: $6

شما می‌توانید با $1 یا یکی دیگر از [[{{MediaWiki:grouppage-sysop}}|مدیران]] تماس بگیرید، تا در مورد این قطع دسترسی صحبت کنید.

توجه کنید که برای ارسال پست الکترونیکی در ویکی، باید پست الکترونیکی خود را از طریق صفحهٔ [[Special:Preferences|تنظیمات]] فعال کرده باشید، و نیز، باید امکان استفاده از این ویژگی برای شما قطع نباشد.

شماره قطع دسترسی شما $5 است. لطفاً این شماره را در هر درخواستی که در این باره مطرح می‌کنید قید کنید.",
'blockedoriginalsource'     => "متن مبدأ '''$1''' در زیر نمایش داده شده است:",
'blockededitsource'         => "متن '''ویرایش‌های شما''' در '''$1''' در زیر نشان داده شده‌است:",
'whitelistedittitle'        => 'برای ویرایش باید به سیستم وارد شوید.',
'whitelistedittext'         => 'برای ویرایش مقاله‌ها باید به سیستم شوید: $1.',
'whitelistreadtitle'        => 'برای خواندن باید به سیستم وارد شوید',
'whitelistreadtext'         => '
برای خواندن مقالات باید [[Special:Userlogin|به سیستم وارد شوید]].',
'whitelistacctitle'         => 'شما مجاز نیستید حساب درست کنید.',
'whitelistacctext'          => 'برای ایجاد حساب در این ویکی باید [[Special:Userlogin|به سیستم وارد شوید]] و اجازه
‌های مربوط به این کار را داشته باشید.',
'confirmedittitle'          => 'تأیید نشانی پست الکترونیکی، برای ویرایش، لازم است.',
'confirmedittext'           => 'شما باید، پیش از ویرایش صفحه‌ها، نشانی پست الکترونیکی خود را مشخص و تأیید کنید. لطفاً از طریق [[Special:Preferences|ترجیحات کاربر]] این کار را صورت دهید.',
'nosuchsectiontitle'        => 'چنین بخشی وجود ندارد',
'nosuchsectiontext'         => 'شما تلاش کرده‌اید یک بخش در صفحه را ویرایش کنید که وجود ندارد. از آن‌جایی که بخش $1 وجود ندارد، ذخیره ویرایش شما نیز ممکن نیست.',
'loginreqtitle'             => 'ورود به سیستم لازم است',
'loginreqlink'              => 'ورود به سیستم',
'loginreqpagetext'          => 'برای دیدن صفحات دیگر باید $1 کنید.',
'accmailtitle'              => 'کلمهٔ عبور فرستاده شد.',
'accmailtext'               => 'کلمه‌ٔ عبور «$1» به «$2» فرستاده شد.',
'newarticle'                => '(جدید)',
'newarticletext'            => 'شما پیوندی را دنبال کرده‌اید و به صفحه‌ای رسیده‌اید که هنوز وجود ندارد. برای ایجاد صفحه، در مستطیل زیر شروع به تایپ کنید (برای اطلاعات بیشتر به [[{{ns:project}}:راهنما|صفحهٔ راهنما]] مراجعه کنید). اگر اشتباهاً اینجا آمده‌اید، دکمهٔ «بازگشت» مرورگرتان را بزنید.',
'anontalkpagetext'          => "---- ''این صفحه‌ی بحث برای کاربر گمنامی است که هنوز حسابی درست نکرده است یا از آن استفاده نمی‌کند. بنابراین برای شناسایی‌اش مجبوریم از نشانی IP عددی استفاده کنیم. چنین نشانی‌های IPای ممکن است توسط چندین کاربر به شکل مشترک استفاده شود. اگر شما کاربر گمنامی هستید و تصور می‌کنید اظهار نظرات نامربوط به شما صورت گرفته است، لطفاً برای پیشگیری از اشتباه گرفته شدن با کاربران گمنام دیگر در آیند [[Special:Userlogin|حسابی ایجاد کنید یا به سیستم وارد شوید]].''",
'noarticletext'             => "'''این ویکی مقاله‌ای با این نام بخصوص ندارد.'''

* '''[{{fullurl:{{FULLPAGENAME}}|action=edit}} مقالهٔ {{PAGENAME}} را آغاز کنید]'''.
* [[Special:Search/{{PAGENAMEE}}|جستجوی {{PAGENAME}}]] در مقالات دیگر.
* [[Special:Whatlinkshere/{{FULLPAGENAMEE}}|جستجوی صفحاتی از ویکی‌پدیا که به این مقاله پیوند دارند]].

----
'''اگر این صفحه را لحظاتی پیش ایجاد کرده‌اید و کماکان ظاهر نشده‌است، ممکن است به دلیل تأخیر در به‌روز رسانی پایگاه داده باشد.''' [{{fullurl:{{FULLPAGENAME}}|action=purge}} پاکسازی] را امتحان کنید، در غیراینصورت لطفاً قبل از ایجاد دوبارهٔ صفحه کمی منتظر شوید.
* اگر در گذشته در زیر این عنوان مقاله‌ای نوشته‌ بودید، ممکن است حذف شده باشد. در [{{fullurl:Special:Log|type=delete&page={{FULLPAGENAMEE}}}} سیاههٔ حذف] به دنبال آن بگردید.",
'clearyourcache'            => "'''نکته:''' پس از ذخیره‌سازی ممکن است برای دیدن تغییرات نیاز باشد که حافظهٔ نهانی مرورگر خود را خالی کنید. '''موزیلا / فایرفاکس / Safari:'''  کلید '''Shift''' را نگه‌دارید و روی دکمهٔ '''Reload''' کلیک کنید، یا کلید‌های '''Ctrl-Shift-R''' را با هم فشار دهید (در رایانه‌های اپل مکینتاش کلید‌های '''Cmd-Shift-R''')؛ '''اینترنت اکسپلورر:''' کلید '''Ctrl''' نگه‌دارید و روی دکمهٔ '''Refresh''' کلیک‌ کنید، یا کلید‌های '''Ctrl-F5''' را با هم فشار دهید؛ '''Konqueror:''' روی دکمهٔ '''Reload''' کلیک کنید و یا کلید '''F5''' را فشار دهید؛ '''اُپرا:''' کاربران اُپرا ممکن است لازم باشد که بطور کامل حافظهٔ نهانی مرورگر را در منوی ''Tools&rarr;Preferences'' خالی کنند.",
'usercssjsyoucanpreview'    => "<strong>نکته:</strong> قبل از این که فایل CSS یا JS خود را ذخیره کنید، با استفاده از دکمه '''پیش‌نمایش''' می‌توان آن را آزمایش کنید.",
'usercsspreview'            => "'''فراموش مکنید که CSS کاربریتان فقط پیش‌نمایش یافته و هنوز ذخیره نشده‌است.'''",
'userjspreview'             => "'''فراموش مکنید که شما فقط دارید جاوااسکریپت کاربریتان را امتحان می‌کنید/پیش‌نمایشش را می‌بینید. هنوز ذخیره نشده‌است!'''",
'userinvalidcssjstitle'     => "'''هشدار:''' پوسته‌ای با نام ''$1'' وجود ندارد. توجه کنید که صفحه‌های &#8206;.css و &#8206;.js با حروف کوچک نوشته می‌شوند. نمونه:  کاربر:فو/monobook.css در مقابل کاربر:فو/Monobook.css",
'updated'                   => '(به‌روز شد)',
'note'                      => '<strong>نکته:</strong>',
'previewnote'               => 'توجه کنید که این فقط پیش‌نمایش است، و ذخیره نشده است!',
'previewconflict'           => 'این پیش‌نمایش منعکس‌کنندهٔ متن ناحیهٔ ویرایش متن بالایی است،
به شکلی که اگر بخواهید متن را ذخیره کنید نشان داده خواهد شد.',
'session_fail_preview'      => '<strong>شرمنده! به دلیل از دست رفتن اطلاعات نشست کاربری، نمی‌توانیم ویرایش شما را پردازش کنیم. لطفاً دوباره سعی کنید. در صورتی که باز هم با همین پیام مواجه شدید، از سیستم خارج شوید و مجدداً وارد شوید.</strong>',
'session_fail_preview_html' => "'''متاسفانه امکان ثبت ویرایش شما به خاطر از دست رفتن اطلاعات نشست کاربری وجود ندارد.''' با توجه به این که در این ویکی امکان درج HTML خام فعال است، پیش‌نمایش صفحه پنهان شده تا امکان حملات مبتنی بر جاوااسکریپت وجود نداشته باشد. '''اگر مطمئن هستید که این پیش‌نمایش یک ویرایش مجاز است، آن را تکرار کنید. اگر تکرار پیش‌نمایش نتیجه نداد، از سیستم خارج شوید و دوباره وارد شوید.",
'token_suffix_mismatch'     => "'''ویرایش شما ذخیره نشد، زیرا مرورگر شما نویسه‌های نقطه‌گذاری را از هم پاشیده‌است. 
ویرایش شما ذخیره نشد تا از خراب شدن متن صفحه جلوگیری شود. 
گاهی این اشکال زمانی پیش می‌آید که شما از یک برنامه تحت وب حدواسط (web-based proxy) استفاده کنید.'''",
'editing'                   => 'در حال ویرایش $1',
'editinguser'               => 'در حال ویرایش $1',
'editingsection'            => 'در حال ویرایش $1 (بخش)',
'editingcomment'            => 'در حال ویرایش $1 (یادداشت)',
'editconflict'              => 'تعارض ویرایشی: $1',
'explainconflict'           => 'از وقتی شما ویرایش این صفحه را آغاز کرده‌اید شخص دیگری آن را تغییر داده است.
ناحیهٔ متنی بالایی شامل متن صفحه به شکل فعلی آن است.
تغییرات شما در ناحیهٔ متنی پایینی نشان داده شده است.
شما باید تغییراتتان را با متن فعلی ترکیب کنید.
وقتی «ذخیرهٔ صفحه» را فشار دهید، <b>فقط</b> متن ناحیهٔ متنی بالایی ذخیره خواهد شد.<br />',
'yourtext'                  => 'متن شما',
'storedversion'             => 'نسخهٔ ضبط‌شده',
'nonunicodebrowser'         => "'''هشدار: مرورگر شما با استانداردهای یونیکد سازگار نیست.''' کاراکترهای غیر ASCII به صورت اعداد در مبنای شانزده به شما نشان داده می‌شوند.",
'editingold'                => '<strong>هشدار:
شما دارید نسخهٔ قدیمی‌ای از این صفحه را ویرایش می‌کنید.
اگر ذخیره‌اش کنید، هر تغییری که پس از این نسخه انجام شده از بین خواهد رفت.</strong>',
'yourdiff'                  => 'تفاوت‌ها',
'copyrightwarning'          => 'لطفاً توجه داشته باشید که فرض می‌شود کلیهٔ مشارکت‌های شما با {{SITENAME}} تحت «$2» منتشر می‌شوند (برای جزئیات بیشتر به $1 مراجعه کنید). اگر نمی‌خواهید نوشته‌هایتان بی‌رحمانه ویرایش شده و به دلخواه توزیع شود، اینجا نفرستیدشان.<br />
همینطور شما دارید به ما قول می‌دهید که خودتان این را نوشته‌اید، یا آن را از یک منبع آزاد با مالکیت عمومی یا مشابه آن برداشته‌اید. <strong>کارهای دارای حق انحصاری تکثیر (copyright) را بی‌اجازه نفرستید!</strong>',
'copyrightwarning2'         => 'لطفاً توجه داشته باشید که فرض می‌شود کلیهٔ مشارکت‌های شما با {{SITENAME}} تحت «اجازه‌نامهٔ مستندات آزاد گنو» منتشر می‌شوند (برای جزئیات بیشتر به $1 مراجعه کنید). اگر نمی‌خواهید نوشته‌هایتان بی‌رحمانه ویرایش شده و به دلخواه توزیع شود، اینجا نفرستیدشان.<br />
همینطور شما دارید به ما قول می‌دهید که خودتان این را نوشته‌اید، یا آن را از یک منبع آزاد با مالکیت عمومی یا مشابه آن برداشته‌اید. <strong>کارهای دارای حق انحصاری تکثیر (copyright) را بی‌اجازه نفرستید!</strong>',
'longpagewarning'           => '<strong>هشدار: این صفحه $1 کیلوبایت طول دارد؛
بعضی مرورگرها ممکن با ویرایش صفحات نزدیک به ۳۲ کیلوبایت یا طولانی‌تر از آن مشکلاتی داشته باشند.
لطفاً دربارهٔ شکستن این صفحه به قسمت‌های کوچکتر فکر کنید.</strong>',
'longpageerror'             => '<strong>خطا: متنی که ارسال کرده‌اید $1 کیلوبایت طول دارد. این مقدار از مقدار بیشینهٔ $2 کیلوبایت بیشتر است. نمی‌توان ذخیره‌اش کرد.</strong>',
'readonlywarning'           => '<strong>هشدار: پایگاه داده برای نگهداری قفل شده است،
بنابراین نمی‌توانید ویرایش‌هایتان را همین الآن ذخیره کنید.
اگر می‌خواهید متن را در یک پروندهٔ متنی ببرید و بچسبانید و برای آینده ذخیره‌اش کنید.</strong>',
'protectedpagewarning'      => 'هشدار: این صفحه قفل شده است تا فقط کاربران با امتیاز مدیر (یا بالاتر) بتوانند ویرایشش کنند.',
'semiprotectedpagewarning'  => "'''توجه:''' این صفحه قفل شده‌است تا تنها کاربران ثبت‌نام‌کرده قادر به ویرایش آن‌ باشند.",
'cascadeprotectedwarning'   => "'''هشدار:''' این صفحه به علت قرارگرفتن در {{PLURAL:$1|صفحهٔ|صفحه‌های}} آبشاری-محافظت‌شدهٔ زیر قفل شده‌است تا فقط مدیران بتوانند ویرایشش کنند.",
'templatesused'             => 'الگوهای استفاده شده در این صفحه:',
'templatesusedpreview'      => 'الگوهای استفاده شده در این پیش‌نمایش:',
'templatesusedsection'      => 'الگوهای استفاده‌شده در این بخش:',
'template-protected'        => '(حفاظت‌شده)',
'template-semiprotected'    => '(نیمه حفاظت‌شده)',
'edittools'                 => '<!-- متن این قسمت زیر صفحات ویرایش و بارگذاری نشان داده می‌شود -->',
'nocreatetitle'             => 'ایجاد صفحه محدود شده‌است.',
'nocreatetext'              => 'این وبگاه قابلیت ایجاد صفحه‌های جدید را محدود کرده‌است. می‌توانید بازگردید و صفحه‌ای موجود را ویرایش کنید یا اینکه  [[Special:Userlogin|به سیستم وارد شوید یا حساب کاربری ایجاد کنید]].',
'nocreate-loggedin'         => 'شما اجازهٔ ایجاد صفحه‌های جدید در این ویکی را ندارید.',
'permissionserrors'         => 'خطای سطح دسترسی',
'permissionserrorstext'     => 'شما اجازهٔ انجام این کار را به {{PLURAL:$1|دلیل|دلایل}} زیر ندارید:',
'recreate-deleted-warn'     => "'''هشدار: شما در حال ایجاد کردن دوبارهٔ صفحه‌ای هستید که قبلاً حذف شده‌است.''' در نظر داشته باشید که آیا ادامهٔ ویرایش این صفحه کار مناسبی هست یا نه. سیاههٔ حذف مربوط به این صفحه برای راحتی در ادامه آمده‌است:",

# "Undo" feature
'undo-success' => 'این ویرایش خنثی شده‌است. لطفاً پس از کسب اطمینان تغییرات نشان‌دا‌ده‌شده را ذخیره کنید.',
'undo-failure' => 'به علت تعارض با ویرایش‌های میانی نشد این ویرایش را خنثی کرد.',
'undo-summary' => 'خنثی‌سازی ویرایش $1  [[Special:Contributions/$2]] ([[User talk:$2]])',

# Account creation failure
'cantcreateaccounttitle' => 'نمی‌توان حساب باز کرد.',
'cantcreateaccounttext'  => 'امکان ایجاد حساب کاربری از این آی‌پی (<b>$1</b>) مسدود شده‌است. این احتمالاً به خاطر خرابکاری‌های پیاپی از آموزشگاه یا آی‌اس‌پی  شماست.',

# History pages
'revhistory'          => 'تاریخچهٔ تغییرات',
'viewpagelogs'        => 'نمایش سیاهه‌های مربوط به این صفحه',
'nohistory'           => 'این صفحه تاریخچهٔ ویرایش ندارد.',
'revnotfound'         => 'نسخه یافت نشد',
'revnotfoundtext'     => 'نسخهٔ قدیمی‌ای از صفحه که درخواسته بودید یافت نشد.
لطفاً URLی را که برای دسترسی به این صفحه استفاده کرده‌اید، بررسی کنید.',
'loadhist'            => 'در حال خواندن تاریخچهٔ صفحه',
'currentrev'          => 'نسخهٔ فعلی',
'revisionasof'        => 'نسخهٔ $1',
'revision-info'       => '<div id="viewingold-warning" style="background: #FFBDBD; border: 1px solid #BB7979; color: #000000; margin: 2em 0 .5em; padding: .5em 1em; vertical-align: middle; clear: both; font-size:small;">شما یک نسخه از تاریخچهٔ این صفحه را می‌بینید، که حاصل ویرایش $2 در تاریخ $1 است. این نسخه ممکن است تفاوت‌های اساسی با <a href="/wiki/{{FULLPAGENAME}}" title="{{FULLPAGENAME}}">نسخهٔ فعلی</a> داشته باشد.</div>
<div id="viewingold-plain" style="display:none;">Revision as of $1 by $2</div>',
'previousrevision'    => '→ نسخهٔ قدیمی‌تر',
'nextrevision'        => 'نسخهٔ جدیدتر←',
'currentrevisionlink' => 'نمایش نسخهٔ فعلی',
'cur'                 => 'فعلی',
'next'                => 'بعدی',
'last'                => 'قبلی',
'orig'                => 'اصلی',
'page_first'          => 'نخست',
'page_last'           => 'واپسین',
'histlegend'          => 'شرح: (فعلی) = تفاوت با نسخهٔ فعلی،
(قبلی) = تفاوت با نسخهٔ قبلی، جز = ویرایش جزئی',
'deletedrev'          => '[حذف‌شده]',
'histfirst'           => 'قدیمی‌ترین',
'histlast'            => 'جدیدترین',
'historysize'         => '($1 بایت)',
'historyempty'        => '(خالی)',

# Revision feed
'history-feed-title'          => 'تاریخچهٔ ویرایش‌ها',
'history-feed-description'    => 'تاریخچهٔ ویرایشهای صفحه در ویکی',
'history-feed-item-nocomment' => '$1 در $2', # user at time
'history-feed-empty'          => 'صفحهٔ درخواسته وجود ندارد. ممکن است که از ویکی حذف  یا اینکه نامش تغییر داده شده باشد. 
[[Special:Search|جستجوی]] صفحه‌های جدید مرتبطِ موجود در این ویکی را هم بیازمایید. شاید افاقه کرد.',

# Revision deletion
'rev-deleted-comment'         => '(توضیحات پاک شد)',
'rev-deleted-user'            => '(نام کاربری حذف شده‌است)',
'rev-deleted-event'           => '(مورد پاک شد)',
'rev-deleted-text-permission' => 'این ویرایش از این صفحه از تاریخچه عمومی این صفحه حذف شده‌است. اطلاعات مرتبط با آن را احتمالاً در [{{fullurl:Special:Log/delete|page={{FULLPAGENAMEE}}}} سیاههٔ حذف] می‌توانید ببینید.',
'rev-deleted-text-view'       => 'این ویرایش از این صفحه از تاریخچه عمومی این صفحه حذف شده‌است. شما به عنوان مدیر این وبگاه می‌توانید آن را ببینید. اطلاعات مرتبط با آن را احتمالاً در [{{fullurl:Special:Log/delete|page={{FULLPAGENAMEE}}}} سیاههٔ حذف] می‌توانید ببینید.',
'rev-delundel'                => 'نمایش/نهفتن',
'revisiondelete'              => 'حذف/احیای نسخه‌ها',
'revdelete-nooldid-title'     => 'هیچ نسخه‌ای انتخاب نشده‌است',
'revdelete-nooldid-text'      => 'نسخه یا نسخه‌هایی از صفحهٔ مورد نظر را که می‌خواهید تحت تاثیر قرار بگیرند انتخاب نکرده‌اید.',
'revdelete-selected'          => "{{PLURAL:$2|نسخهٔ|نسخه‌های}} انتخاب شده از '''$1:'''",
'logdelete-selected'          => "{{PLURAL:$2|مورد|موارد}} انتخاب شده از سیاهه‌های مرتبط با '''$1:'''",
'revdelete-text'              => 'نسخه‌ها و موارد حذف شده کماکان از طریق تارخچه و سیاهه‌ها قابل مشاهده هستند، اما بخش‌هایی از محتوای آن‌ها توسط عموم قابل مشاهده نخواهد بود. سایر مدیران این ویکی هنوز می‌توانند این محتوای پنهان را ببینند و حتی موارد حذف شده را احیا کنند، مگر آن که محدودیت‌های دیگری اعمال گردد.',
'revdelete-legend'            => 'تنظیم محدودیت‌های نسخه:',
'revdelete-hide-text'         => 'نهفتن متن نسخه',
'revdelete-hide-name'         => 'نهفتن عمل و هدف',
'revdelete-hide-comment'      => 'نهفتن توضیح ویرایش',
'revdelete-hide-user'         => 'نام کاربری/نشانی IP ویراستار مخفی شود',
'revdelete-hide-restricted'   => 'اعمال این تغییرات بر مدیران به همراه دیگران',
'revdelete-suppress'          => 'از دسترسی مدیران به داده نیز مانند سایر کاربران جلوگیری به عمل آید.',
'revdelete-hide-image'        => 'نهفتن محتویات پرونده',
'revdelete-unsuppress'        => 'خاتمهٔ محدودیت‌ها در مورد نسخه‌های انتخاب شده',
'revdelete-log'               => 'توضیح سیاهه:',
'revdelete-submit'            => 'اِعمال بر نسخهٔ انتخاب‌شده',
'revdelete-logentry'          => 'تغییر پیدایی نسخه در [[$1]]',
'logdelete-logentry'          => 'تغییر پیدایی مورد در [[$1]]',
'revdelete-logaction'         => '$1 نسخه به وضعیت $2 تغییر یافتند.',
'logdelete-logaction'         => '$1 {{PLURAL:$1|مورد|مورد}} به [[$3]] به وضعیت $2 تغییر یافتند.',
'revdelete-success'           => 'تغییر پیدایی نسخه با موفقیت انجام شد.',
'logdelete-success'           => 'تغییر پیدایی مورد با موفقیت انجام شد.',

# Oversight log
'oversightlog'    => 'سیاههٔ نظارت',
'overlogpagetext' => 'آن چه در زیر می‌آید فهرست آخرین موارد حذف و قطع دسترسی است که شامل اطلاعاتی است که مدیران قادر به مشاهدهٔ آن نیستند.',

# Diffs
'difference'                => '(تفاوت بین نسخه‌ها)',
'loadingrev'                => 'در حال خواندن نسخه برای تفاوت گرفتن',
'lineno'                    => 'سطر $1:',
'editcurrent'               => 'ویرایش نسخهٔ فعلی این صفحه',
'selectnewerversionfordiff' => 'نسخهٔ جدیدتری را برای مقایسه انتخاب کنید',
'selectolderversionfordiff' => 'نسخهٔ قدیمی‌تری را برای مقایسه انتخاب کنید',
'compareselectedversions'   => 'مقایسهٔ نسخه‌های انتخاب‌شده',
'editundo'                  => 'خنثی‌سازی',
'diff-multi'                => '({{PLURAL:$1||$1&nbsp;}}ویرایش میانی نشان داده نشده‌است.)',

# Search results
'searchresults'         => 'نتایج جستجو',
'searchresulttext'      => 'برای اطلاعات بیشتر دربارهٔ جستجوی {{SITENAME}}، به [[{{ns:project}}:جستجو کردن|جستجوی {{SITENAME}}]] مراجعه کنید.',
'searchsubtitle'        => '«[[:$1]]» را جُستید',
'searchsubtitleinvalid' => 'برای پرس‌وجوی «$1»',
'noexactmatch'          => 'صفحه‌ای با عنوان دقیق $1 وجود ندارد. شما می‌توانید این صفحه را [[:\$1|ایجاد کنید]].',
'titlematches'          => 'عنوان مقاله تطبیق می‌کند',
'notitlematches'        => 'عنوان هیچ مقاله‌ای نمی‌خورد',
'textmatches'           => 'متن مقاله تطبیق می‌کند',
'notextmatches'         => 'متن هیچ مقاله‌ای نمی‌خورد',
'prevn'                 => '$1تای قبلی',
'nextn'                 => '$1تای بعدی',
'viewprevnext'          => 'نمایش ($1) ($2) ($3).',
'showingresults'        => 'نمایش <b>$1</b> نتیجه در پایین، آغاز از #<b>$2</b>.',
'showingresultsnum'     => 'نمایش <b>$3</b> نتیجه در پایین، آغاز از #<b>$2</b>.',
'nonefound'             => "<strong>نکته</strong>
جستجوهای ناموفق معمولاً به علت جستن کلمه‌های متداولی چون ''از'' و ''را'' که فهرست نشده‌اند، رخ می‌دهد یا اینکه چندین گزارهٔ جستجو وارد می‌شود (فقط صفحه‌هایی که حاوی همهٔ این گزاره‌ها باشند در نتیجه نمایش داده می‌شوند.).",
'powersearch'           => 'جستجو',
'powersearchtext'       => '
جستجو در فضاهای نام :<br />
$1<br />
$2 تغییرمسیرها فهرست شوند &nbsp; جستجو برای $3 $9',
'searchdisabled'        => 'با عرض شرمندگی، جستجوی کل متن موقتاً از کار انداخته شده است. می‌توانید از جستجوی Google در پایین استفاده کنید. نتایج حاصل از جستجو با این روش ممکن است به‌روز نباشند.',

# Preferences page
'preferences'              => 'ترجیحات',
'mypreferences'            => 'ترجیحات من',
'prefs-edits'              => 'تعداد ویرایش‌ها',
'prefsnologin'             => 'به سیستم وارد نشده‌اید',
'prefsnologintext'         => 'برای تنظیم ترجیحات کاربر باید [[Special:Userlogin|به سیستم وارد شوید]].',
'prefsreset'               => 'ترجیحات از حافظه میزان شد.',
'qbsettings'               => 'تنظیمات نوار سریع',
'qbsettings-none'          => 'نباشد',
'qbsettings-fixedleft'     => 'ثابت چپ',
'qbsettings-fixedright'    => 'ثابت راست',
'qbsettings-floatingleft'  => 'شناور چپ',
'qbsettings-floatingright' => 'شناور راست',
'changepassword'           => 'تغییر کلمهٔ عبور',
'skin'                     => 'پوسته',
'math'                     => 'نمایش ریاضیات',
'dateformat'               => 'قالب تاریخ',
'datedefault'              => 'بدون ترجیح',
'datetime'                 => 'تاریخ و زمان',
'math_failure'             => 'شکست در تجزیه',
'math_unknown_error'       => 'خطای ناشناخته',
'math_unknown_function'    => 'تابع ناشناختهٔ',
'math_lexing_error'        => 'خطای lexing',
'math_syntax_error'        => 'خطای نحوی',
'math_image_error'         => 'تبدیل به PNG شکست خورد',
'math_bad_tmpdir'          => 'امکان ایجاد یا نوشتن اطلاعات در پوشه موقت (temp) ریاضی وجود ندارد.',
'math_bad_output'          => 'امکان ایجاد یا نوشتن اطلاعات در پوشه خروجی (output) ریاضی وجود ندارد.',
'math_notexvc'             => 'برنامهٔ اجرایی texvc موجود نیست. برای اطلاعات بیشتر به <span dir=ltr>math/README</span> مراجعه کنید.',
'prefs-personal'           => 'داده‌های کاربر',
'prefs-rc'                 => 'تغییرات اخیر',
'prefs-watchlist'          => 'فهرست تعقیبات',
'prefs-watchlist-days'     => 'تعداد روزهایی که باید در فهرست تعقیبات نمایش داده شود:',
'prefs-watchlist-edits'    => 'تعداد ویرایشهای نشان‌داده در فهرست تعقیبات گسترش‌یافته:',
'prefs-misc'               => 'تنظیمات متفرقه',
'saveprefs'                => 'ذخیرهٔ ترجیحات',
'resetprefs'               => 'صفر کردن ترجیحات',
'oldpassword'              => 'کلمهٔ عبور قدیمی',
'newpassword'              => 'کلمهٔ عبور جدید',
'retypenew'                => 'کلمهٔ عبور جدید را دوباره وارد کنید',
'textboxsize'              => 'ابعاد جعبهٔ متن',
'rows'                     => 'تعداد سطرها',
'columns'                  => 'تعداد ستون‌ها',
'searchresultshead'        => 'تنظیمات نتیجهٔ جستجو',
'resultsperpage'           => 'تعداد نتایج در هر صفحه',
'contextlines'             => 'تعداد سطرها در هر نتیجه',
'contextchars'             => 'تعداد نویسه‌های اطراف در سطر',
'stub-threshold'           => 'آستانهٔ ویرایش پیوندهای <a href="#" class="stub">ناقص</a>:',
'recentchangesdays'        => 'تعداد روزهای نمایش داده‌شده در تغییرات اخیر:',
'recentchangescount'       => 'تعداد عناوین در تغییرات اخیر',
'savedprefs'               => 'ترجیحات شما ذخیره شد.',
'timezonelegend'           => 'منطقهٔ زمانی',
'timezonetext'             => 'تفاوت تعداد ساعت زمان محلی‌تان با زمان خادم (وقت گرینیچ) را وارد کنید.',
'localtime'                => 'نمایش زمان محلی',
'timezoneoffset'           => 'تفاوت',
'servertime'               => 'زمان فعلی کارگزار',
'guesstimezone'            => 'از مرورگر گرفته شود',
'allowemail'               => 'امکان دریافت پست الکترونیکی از دیگر کاربران',
'defaultns'                => 'به طور پیش‌فرض در این فضاهای نام جستجو شود:',
'default'                  => 'پیش‌فرض',
'files'                    => 'پرونده‌ها',

# User rights
'userrights-lookup-user'      => 'مدیریت گروه‌های کاربری',
'userrights-user-editname'    => 'یک نام کاربری وارد کنید:',
'editusergroup'               => 'ویرایش گروه‌های کاربری',
'userrights-editusergroup'    => 'ویرایش گروه‌های کاربری',
'saveusergroups'              => 'ثبت گروه‌های کاربری',
'userrights-groupsmember'     => 'عضو:',
'userrights-groupsavailable'  => 'گروه‌های موجود:',
'userrights-groupshelp'       => 'گروه‌هایی را که می‌خواهید یک کاربر از آن حذف یا به آن اضافه شود انتخاب کنید. برای این که یک گروه را از حالت انتخاب شده در بیاورید دکمه CTRL را نگاه دارید و کلیک چپ کنید.',
'userrights-reason'           => 'علت تغییر:',
'userrights-available-none'   => 'شما نمی‌توانید عضویت در گروه‌ها را تغییر دهید.',
'userrights-available-add'    => 'شما می‌توانید کاربرانی را به گروه $1 اضافه کنید.',
'userrights-available-remove' => 'شما می‌توانید کاربرانی را از گروه $1 حذف کنید.',

# Groups
'group'               => 'گروه:',
'group-autoconfirmed' => 'کاربران تاییدشده',
'group-bot'           => 'ربات‌ها',
'group-sysop'         => 'مدیران',
'group-bureaucrat'    => 'دیوان‌سالاران',
'group-all'           => '(همه)',

'group-autoconfirmed-member' => 'کاربر تاییدشده',
'group-bot-member'           => 'ربات',
'group-sysop-member'         => 'مدیر',
'group-bureaucrat-member'    => 'دیوان‌سالار',

'grouppage-autoconfirmed' => '{{ns:project}}:کاربران تاییدشده',
'grouppage-bot'           => '{{ns:project}}:ربات‌ها',
'grouppage-sysop'         => '{{ns:project}}:مدیران',
'grouppage-bureaucrat'    => '{{ns:project}}:دیوان‌سالارها',

# User rights log
'rightslog'      => 'سیاههٔ اختیارات کاربر',
'rightslogtext'  => 'این سیاههٔ تغییرات اختیارات کاربر است.',
'rightslogentry' => 'عضویت $1 از گروه $2 به $3 تغییر داده شد.',
'rightsnone'     => '(هیچ)',

# Recent changes
'nchanges'                          => '$1 تغییر',
'recentchanges'                     => 'تغییرات اخیر',
'recentchangestext'                 => 'آخرین تغییرات ویکی را در این صفحه تعقیب کنید.',
'recentchanges-feed-description'    => 'ردیابی آخرین تغییرات این ویکی در این خورد.',
'rcnote'                            => 'در زیر آخرین <strong>$1</strong> تغییر در <strong>$2</strong> روز اخیر تا $3 آمده است.',
'rcnotefrom'                        => 'در زیر تغییرات از تاریخ <b>$2</b> آمده‌اند (تا <b>$1</b> مورد نشان داده می‌شود).',
'rclistfrom'                        => 'نمایش تغییرات جدید با شروع از $1',
'rcshowhideminor'                   => 'ویرایش‌های جزئی $1',
'rcshowhidebots'                    => 'ربات‌ها $1',
'rcshowhideliu'                     => 'کاربران ثبت‌نام‌کرده $1',
'rcshowhideanons'                   => 'کاربران ناشناس $1',
'rcshowhidepatr'                    => 'ویرایش‌های گشتی $1',
'rcshowhidemine'                    => 'ویرایش‌های من $1',
'rclinks'                           => 'نمایش آخرین $1 تغییر در $2 روز اخیر؛ $3',
'diff'                              => 'تفاوت',
'hist'                              => 'تاریخچه',
'hide'                              => 'پنهان‌سازی',
'show'                              => 'نمایش',
'minoreditletter'                   => 'جز',
'newpageletter'                     => 'جد',
'boteditletter'                     => 'ر',
'sectionlink'                       => '←',
'number_of_watching_users_pageview' => '[$1 کاربر تعقیب‌کننده]',
'rc_categories'                     => 'محدود به رده‌ها بشود (بین رده‌ها نویسهٔ | را قرار دهید)',
'rc_categories_any'                 => 'هر کدام',

# Recent changes linked
'recentchangeslinked'          => 'تغییرات مرتبط',
'recentchangeslinked-title'    => 'تغییرهای مرتبط با $1',
'recentchangeslinked-noresult' => 'در بازهٔ ‌زمانی داده‌شده تغییری در صفحه‌های پیوندداده رخ نداده‌است.',
'recentchangeslinked-summary'  => "این صفحه ویژه تغییرات اخیر در صفحه‌های پیوند داده شده به این صفحه را نشان می‌دهد. صفحه‌های که در فهرست تعقیبات شما باشند به صورت '''سیاه''' نشان داده می‌شوند.",

# Upload
'upload'                      => 'بارگذاری پرونده',
'uploadbtn'                   => 'بارگذاری پرونده',
'reupload'                    => 'بارگذاری دوباره',
'reuploaddesc'                => 'بازگشت به فرم بارگذاری',
'uploadnologin'               => 'به سیستم وارد نشده‌اید',
'uploadnologintext'           => 'برای بار کردن پرونده‌ها باید [[Special:Userlogin|وارد سیستم شوید]].',
'upload_directory_read_only'  => 'شاخهٔ بارگذاری ($1) از طرف کارگزار وب قابل نوشتن نیست.',
'uploaderror'                 => 'خطا در بار کردن',
'uploadtext'                  => "از فرم زیر برای بارگذاری کردن پرونده‌های جدید استفاده کنید. برای دیدن پرونده‌هایی که قبلاً بارگذاری شده‌اند به 
[[Special:Imagelist|فهرست پرونده‌ها]] بروید. بارگذاری و حذف پرونده‌ها هم‌چنین در [[Special:Log/upload|سیاههٔ بارگذاری‌ها]] ثبت می‌شود.

بعد از این که پرونده‌ای را بارگذاری کردید، به این سه شکل می‌توانید آن را در صفحه‌ها استفاده کنید:

*'''<nowiki>[[</nowiki>{{ns:image}}<nowiki>:File.jpg]]</nowiki>''',
*'''<nowiki>[[</nowiki>{{ns:image}}<nowiki>:File.png|alt text]]</nowiki>'''
*'''<nowiki>[[</nowiki>{{ns:media}}<nowiki>:File.ogg]]</nowiki>'''",
'uploadlog'                   => 'سیاهه‌ی بارکردن‌ها',
'uploadlogpage'               => 'سیاهه‌ی_بارکردن‌ها',
'uploadlogpagetext'           => 'فهرست زیر فهرستی از آخرین بارکردن‌های پرونده‌های است.
همه‌ی زمان‌های نشان‌داده‌شده زمان خادم هستند (وقت گرینیچ).',
'filename'                    => 'نام پرونده',
'filedesc'                    => 'خلاصه',
'fileuploadsummary'           => 'خلاصه:',
'filestatus'                  => 'وضعیت حق تکثیر',
'filesource'                  => 'منبع',
'uploadedfiles'               => 'پرونده‌های بارشده',
'ignorewarning'               => 'چشم‌پوشی از هشدار و ذخیرهٔ پرونده.',
'ignorewarnings'              => 'چشم‌پوشی از همهٔ هشدارها',
'minlength1'                  => 'اسم پرونده دست کم باید یک حرف باشد.',
'illegalfilename'             => 'نام پرونده «$1» نویسه‌هایی را شامل می‌شود که در نام صفحات مجاز نیستند. لطفاً نام پرونده را تغییر دهید و آن را دوباره بار کنید.',
'badfilename'                 => 'نام پرونده به «$1» تغییر کرد.',
'filetype-badmime'            => 'پرونده‌هایی که نوع MIME آن‌ها $1 باشد برای بارگزاری مجاز نیستند.',
'filetype-badtype'            => "'''\"&lrm;.\$1\"''' پسوند مجازی برای بارگذاری در ویکی‌پدیا نیست.

فهرست پسوندهای مجاز برای پرونده‌ها جهت بارگذاری در این ویکی به قرار زیر است:
:\$2",
'filetype-missing'            => 'این پرونده پسوند (مانند «<span dir=ltr>.jpg</span>») ندارد.',
'large-file'                  => 'توصیه می‌شود که پرونده‌ها بزرگتر از $1 نباشند: این پرونده $2 است.',
'largefileserver'             => 'این پرونده از اندازه‌ای که در پیکربندی خادم بعنوان سقف اندازهٔ پرونده درنظر گرفته‌ شده‌است، بزرگ‌تر است.',
'emptyfile'                   => 'پروندهٔ بارشده خالی بنظر می‌رسد. این مساله ممکن است به دلیل خطای تایپی در نام پرونده رخ داده باشد. لطفاً تأیید کنید که می‌خواهید این پرونده را با همین شرایط بار کنید.',
'fileexists'                  => 'در حال حاضر، پرونده‌ای با همین نام موجود است. اگر مطمئن نیستید که می‌خواهید آن پرونده را تغییر دهید، لطفاً $1 را بررسی کنید.',
'fileexists-extension'        => "پرونده‌ای با نام مشابه وجود دارد.<br />
نام پرونده‌ای که بارگزاری کردید این بود:'''<tt>$1</tt>'''<br />
نام پرونده‌ای که از قبل موجود است این است:'''<tt>$2</tt>'''<br />
لطفاً یک نام دیگر انتخاب کنید.",
'fileexists-thumb'            => "'''<center>تصویر از قبل موجود است</center>'''",
'fileexists-thumbnail-yes'    => 'به نظر می‌رسد که این پرونده، یک تصویر بندانگشتی (thumbnail) از تصویر بزرگتر اصلی باشد. لطفاً پروندهٔ با نام $1 را نگاه کنید. اگر پروندهٔ فعلی، تصویر کوچک‌شدهٔ آن پرونده است، نیازی به بارگذاری تصویر کوچکتر نیست.',
'file-thumbnail-no'           => 'نام پرونده با $1 آغاز می‌شود. به نظر می‌رسد که این پرونده، یک تصویر بندانگشتی (thumbnail) از تصویر بزرگتر اصلی باشد. اگر تصویر با اندازهٔ اصلی را دارید، آن را بارگذاری کنید. در غیر این صورت، نام پرونده را تغییر دهید.',
'fileexists-forbidden'        => 'در حال حاضر، پرونده‌ای به همین نام وجود دارد؛ لطفاً برگردید و پروندهٔ موردنظر خود را با نام دیگری بار کنید.
[[Image:$1|thumb|center|$1]]',
'fileexists-shared-forbidden' => 'در حال‌ حاضر، پرونده‌ای با همین نام در انبارهٔ مشترک پرونده‌ها وجود دارد؛ لطفاً برگردید و پروندهٔ موردنظر خود را با نام دیگری بار کنید.
[[Image:$1|thumb|center|$1]]',
'successfulupload'            => 'بار کردن با موفقیت انجام شد',
'uploadwarning'               => 'هشدار بار کردن',
'savefile'                    => 'ذخیره‌ی پرونده',
'uploadedimage'               => '«[[$1]]» بار شد',
'overwroteimage'              => 'نسخه جدیدی از  «[[$1]]» را بارگذاری کرد.',
'uploaddisabled'              => 'شرمنده، بار کردن از کار افتاده است.',
'uploaddisabledtext'          => 'امکان بارگذاری پرونده در این ویکی غیرفعال شده‌است.',
'uploadscripted'              => 'این صفحه حاوی اسکریپت یا کدی اچ‌تی‌ام‌ال است که ممکن است به‌نادرست توسط مرورگر وب تفسیر شود.',
'uploadcorrupt'               => 'این پرونده خراب است و یا پسوندی اشتباه دارد. لطفاً پرونده را بررسی نمایید و آن را دوباره بار کنید.',
'uploadvirus'                 => 'این پرونده ویروس دارد! جزئیات : $1',
'sourcefilename'              => 'نام پروندهٔ اصلی',
'destfilename'                => 'نام پروندهٔ مقصد',
'watchthisupload'             => 'تعقیب این صفحه',
'filewasdeleted'              => 'پرونده‌ای با همین نام پیشتر بارگذاری و پس از آن پاک شده‌است. بهتر است پیش از بارگذاری مجدد نگاهی به $1 بیندازید.',

'upload-proto-error'      => 'قرارداد نادرست',
'upload-proto-error-text' => 'بارگذاری از دوردست به نشانی‌هایی که با <code dir=ltr>http://</code> یا <code dir=ltr>ftp://</code> آغاز شوند نیاز دارد.',
'upload-file-error'       => 'خطای داخلی',
'upload-file-error-text'  => 'هنگام تلاش برای ایجاد یک پروندهٔ  موقت در کارگزار یک خطای داخلی رخ داد. لطفاً با مدیر سیستم تماس بگیرید.',
'upload-misc-error'       => 'خطایی نامعلوم در بارگذاری',
'upload-misc-error-text'  => 'هنگام بارگذاری، خطایی نامعلوم رخ داد. لطفاً اطمینان حاصل کنید که نشانی (URL) معتبر و قابل دسترسی است و بعد دوباره تلاش کنید. اگر مشکل همچنان برقرار بود با یکی از مدیران سیستم تماس بگیرید.',

# Some likely curl errors. More could be added from <http://curl.haxx.se/libcurl/c/libcurl-errors.html>
'upload-curl-error6'       => 'دسترسی به URL ممکن نشد.',
'upload-curl-error6-text'  => 'URL داده شده قابل دسترسی نیست. لطفاً درستی آن و اینکه وب‌گاه برقرار است را بازرسی کنید.',
'upload-curl-error28'      => 'زمان بارگذاری سر آمد.',
'upload-curl-error28-text' => 'این وب‌گاه بیش از اندازه در پاسخ تعلل کرد. لطفاً بررسی کنید که آیا وب‌گاه فعال و برخط است یا نه. سپس لختی درنگ کنید و دوباره تلاش نمایید. شاید بد نباشد که در زمان خلوت‌تری دوباره تلاش کنید.',

'license'            => 'اجازه‌نامه',
'nolicense'          => 'هیچیک انتخاب نشده‌است.',
'license-nopreview'  => '(پیش‌نمایش وجود ندارد)',
'upload_source_url'  => '(یک نشانی اینترنتی معتبر و قابل دسترسی برای عموم)',
'upload_source_file' => '(پرونده‌ای در رایانهٔ شما)',

# Image list
'imagelist'                 => 'فهرست تصاویر',
'imagelisttext'             => 'در زیر فهرست $1 تصویری که $2 مرتب شده است آمده است.',
'getimagelist'              => 'در حال اخذ فهرست تصاویر',
'ilsubmit'                  => 'جستجو',
'showlast'                  => 'نمایش آخرین $1 تصویر مرتب‌شده $2.',
'byname'                    => 'از روی نام',
'bydate'                    => 'از روی تاریخ',
'bysize'                    => 'از روی اندازه',
'imgdelete'                 => 'حذف',
'imgdesc'                   => 'توصیف',
'imgfile'                   => 'پرونده',
'filehist'                  => 'تاریخچه پرونده',
'filehist-help'             => 'روی تاریخ‌ها کلیک کنید تا نسخهٔ مربوط را ببینید.',
'filehist-deleteall'        => 'حذف همه',
'filehist-deleteone'        => 'حذف این مورد',
'filehist-revert'           => 'واگردانی',
'filehist-current'          => 'نسخهٔ فعلی',
'filehist-datetime'         => 'تاریخ',
'filehist-user'             => 'کاربر',
'filehist-dimensions'       => 'ابعاد',
'filehist-filesize'         => 'اندازه پرونده',
'filehist-comment'          => 'توضیح',
'imagelinks'                => 'پیوند‌های تصویر',
'linkstoimage'              => 'صفحه‌های زیر به این تصویر پیوند دارند:',
'nolinkstoimage'            => 'هیچ صفحه‌ای به این تصویر پیوند ندارد.',
'sharedupload'              => 'این پرونده یک بارگذاری اشتراکی است و ممکن است از طریق دیگر پروژه‌ها هم قابل دسترسی باشد.',
'shareduploadwiki'          => 'لطفاً برای اطلاعات بیشتر $1 را ببینید.',
'shareduploadwiki-linktext' => 'صفحهٔ توصیف پرونده',
'noimage'                   => 'هیچ پرونده‌ای با این نام موجود نیست می‌توانید $1',
'noimage-linktext'          => 'آن را بار کنید.',
'uploadnewversion-linktext' => 'بارکردن نسخهٔ جدیدی از پرونده',
'imagelist_date'            => 'تاریخ',
'imagelist_name'            => 'نام',
'imagelist_user'            => 'کاربر',
'imagelist_size'            => 'اندازه (بایت)',
'imagelist_description'     => 'توصیف',
'imagelist_search_for'      => 'جستجوی نام تصویر:',

# File reversion
'filerevert'                => 'واگردانی $1',
'filerevert-backlink'       => '→ $1',
'filerevert-legend'         => 'واگردانی پرونده',
'filerevert-intro'          => "شما در حال واگردانی '''[[Media:$1|$1]]''' به [نسخهٔ $4 مورخ $2، $3] هستید.",
'filerevert-comment'        => 'توضیح',
'filerevert-defaultcomment' => 'واگردانی به نسخهٔ $1، $2',
'filerevert-submit'         => 'برو',
'filerevert-success'        => "''[[Media:$1|$1]]''' به [نسخهٔ $4 مورخ $2، $3] واگردانده شد.",
'filerevert-badversion'     => 'نسخهٔ قدیمی‌تری از این پرونده وجود نداشت.',

# File deletion
'filedelete'             => 'حذف $1',
'filedelete-backlink'    => '→ $1',
'filedelete-legend'      => 'حذف پرونده',
'filedelete-intro'       => "شما در حال حذف کردن '''[[Media:$1|$1]]''' هستید.",
'filedelete-intro-old'   => '<span class="plainlinks">شما در حال حذف نسخه \'\'\'[[Media:$1|$1]]\'\'\' به تاریخ [$4 $3، $2] هستید.</span>',
'filedelete-comment'     => 'توضیح:',
'filedelete-submit'      => 'حذف',
'filedelete-success'     => "'''$1''' حذف شد.",
'filedelete-success-old' => '<span class="plainlinks">نسخه \'\'\'[[Media:$1|$1]]\'\'\' به تاریخ $3، $2 حذف شد.</span>',
'filedelete-nofile'      => "'''$1''' در این وبگاه وجود ندارد.",
'filedelete-nofile-old'  => "نسخه بایگانی شده‌ای از '''$1''' با مشخصات داده شده، وجود ندارد..",
'filedelete-iscurrent'   => 'شما می‌خواهید که آخرین نسخه از این پرونده را حذف کنید. لطفاً ابتدا پرونده را به یک نسخه قدیمی‌تر واگردانی کنید.',

# MIME search
'mimesearch'         => 'جستجوی MIMEی',
'mimesearch-summary' => 'با کمک این صفحه شما می‌توانید پرونده‌هایی که یک نوع MIME به خصوص دارند را پیدا کنید. باید اطلاعات MIME را به صورت contenttype/subtype وارد کنید، نظیر <tt>image/jpeg</tt>.',
'mimetype'           => 'نوع MIME:',
'download'           => 'بارگیری',

# Unwatched pages
'unwatchedpages' => 'صفحات تعقیب‌نشده',

# List redirects
'listredirects' => 'فهرست صفحه‌های تغییرمسیر',

# Unused templates
'unusedtemplates'     => 'الگوهای استفاده‌نشده',
'unusedtemplatestext' => 'این صفحه همهٔ صفحه‌هایی در فضای نام الگو را که در هیچ صفحه‌ای به کار نرفته‌اند، فهرست می‌کند. لطفاً پیش از پاک‌کردن این صفحه‌ها  پیوندهای دیگر به آنها را هم وارسی کنید.',
'unusedtemplateswlh'  => 'پیوندهای دیگر',

# Random redirect
'randomredirect'         => 'تغییرمسیر تصادفی',
'randomredirect-nopages' => 'هیج صفحهٔ تغییر مسیری در این فضای نام موجود نیست.',

# Statistics
'statistics'             => 'آمار',
'sitestats'              => 'آمار وبگاه',
'userstats'              => 'آمار کاربران',
'sitestatstext'          => "کلاً {{PLURAL:$1|'''$1'''|'''$1'''}} صفحه در پایگاه وجود دارد. این شامل صفحات «بحث»، صفحات دربارهٔ {{SITENAME}}، صفحات «ناقص» کوچک، تغییرمسیرها، و صفحه‌های دیگری می‌شود که احتمالاً مقاله به حساب نمی‌آیند. صرف نظر از این‌ها، <b>$2</b> صفحه هست که احتمالاً مقالهٔ معقول هستند.

'''$8''' پرونده بارگذاری شده‌اند.

در مجموع صفحه‌های {{SITENAME}} '''$3''' بار بازدید شده‌اند که شامل  '''$4''' ویرایش می‌شود. به این ترتیب هر صفحه به طور متوسط '''$5''' بار ویرایش شده و به ازای هر ویرایش '''$6''' بازدید صورت گرفته‌است.

طول [http://meta.wikimedia.org/wiki/Help:Job_queue صف کارها] $7 است.",
'userstatstext'          => "تعداد '''$1''' کاربر ثبت شده وجود دارد که از بین آن‌ها '''$2''' نفر ('''$4٪''') دارای دسترسی $5 هستند.",
'statistics-mostpopular' => 'صفحاتی که بیشترین تعداد بازدیدکننده را داشته‌اند',

'disambiguations'      => 'صفحه‌های ابهام‌زدایی',
'disambiguationspage'  => 'صفحات باید به طور دستی به این فهرست اضافه شوند تا در [[Special:Disambiguations]] مورد استفاده قرار بگیرند. صفحات این فهرست باید از نوع صفحات ابهام‌زدایی باشند. ربات‌ها از این فهرست برای اصلاح صفحات ابهام‌زدایی استفاده می‌کنند.',
'disambiguations-text' => "صفحه‌های زیر پیوندی به یک '''صفحهٔ ابهام‌زدایی''' هستند.  این صفحات باید در عوض به موضوعات مرتبط پیوند داده شوند.<br />یک صفحه هنگامی  
صفحهٔ ابهام‌زدایی در نظر گرفته می‌شود که در آن از الگویی که به [[MediaWiki:disambiguationspage]] پیوند دارد استفاده شده باشد.",

'doubleredirects'     => 'تغییرمسیرهای دوتایی',
'doubleredirectstext' => 'هر سطر دربردارندهٔ پیوندهایی به تغییر مسیر اول و دوم و همچنین خط نخست متن تغییر مسیر دوم است. معمولاً صفحهٔ مقصد واقعی که نخستین تغییرمسیر باید به آن باشد به این گونه مشخص می‌شود.',

'brokenredirects'        => 'تغییرمسیرهای خراب',
'brokenredirectstext'    => 'تغییرمسیرهای زیر به یک صفحهٔ ناموجود پیوند دارند.',
'brokenredirects-edit'   => '(ویرایش)',
'brokenredirects-delete' => '(حذف)',

'withoutinterwiki'        => 'صفحه‌های بدون پیوند میان‌ویکی',
'withoutinterwiki-header' => 'این صفحه‌ها پیوندی به صفحه‌ای به زبان دیگر نمی‌دارند:',

'fewestrevisions' => 'مقاله‌های دارای کمترین شمار ویرایش',

# Miscellaneous special pages
'nbytes'                  => '$1 بایت',
'ncategories'             => '$1 رده',
'nlinks'                  => '$1 پیوند',
'nmembers'                => '$1 عضو',
'nrevisions'              => '$1 ویرایش',
'nviews'                  => '$1 نمایش',
'specialpage-empty'       => 'این صفحه تُهی‌است.',
'lonelypages'             => 'صفحه‌های یتیم',
'lonelypagestext'         => 'به صفحه‌های زیر از هیچ صفحهٔ دیگری در این ویکی پیوند داده نشده‌است:',
'uncategorizedpages'      => 'صفحه‌های رده‌بندی نشده',
'uncategorizedcategories' => 'رده‌های رده‌بندی نشده',
'uncategorizedimages'     => 'تصویرهای رده‌بندی‌نشده',
'uncategorizedtemplates'  => 'الگوهای رده‌بندی نشده',
'unusedcategories'        => 'رده‌های بی‌استفاده',
'unusedimages'            => 'تصویرهای استفاده‌نشده',
'popularpages'            => 'صفحات محبوب',
'wantedcategories'        => 'رده‌های مورد نیاز',
'wantedpages'             => 'صفحات مورد نیاز',
'mostlinked'              => 'صفحه‌هایی که بیشتر از همه به آنها پیوند شده است',
'mostlinkedcategories'    => 'رده‌هایی که بیشتر از همه به آنها پیوند شده است',
'mostlinkedtemplates'     => 'الگوهایی که بیشتر از همه به آنها پیوند شده است',
'mostcategories'          => 'مقاله‌هایی که بیشترین تعداد رده را دارند',
'mostimages'              => 'تصاویری که بیشتر از همه به آنها پیوند شده است',
'mostrevisions'           => 'مقاله‌هایی که بیشتر از بقیه ویرایش شده‌اند',
'allpages'                => 'همهٔ صفحه‌ها',
'prefixindex'             => 'نمایهٔ پیشوندی',
'randompage'              => 'صفحهٔ تصادفی',
'randompage-nopages'      => 'هیچ صفحه‌ای در این فضای نام موجود نیست',
'shortpages'              => 'صفحات کوتاه',
'longpages'               => 'صفحه‌های بلند',
'deadendpages'            => 'صفحه‌های بن‌بست',
'deadendpagestext'        => 'صفحه‌های زیر به هیچ صفحهٔ دیگر در این ویکی پیوند ندارند.',
'protectedpages'          => 'صفحه‌های حفاظت‌شده',
'protectedpagestext'      => 'صفحه‌های زیر در برابر ویرایش یا انتقال حفاظت شده‌اند:',
'protectedpagesempty'     => 'در حال حاضر هیچ‌صفحه‌ای محافظت نشده‌است.',
'listusers'               => 'فهرست کاربران',
'specialpages'            => 'صفحات ویژه',
'spheading'               => 'صفحات ویژهٔ همهٔ کاربران',
'restrictedpheading'      => 'صفحات ویژهٔ محدودشده',
'rclsub'                  => '(به صفحات پیونددار از «$1»)',
'newpages'                => 'صفحات جدید',
'newpages-username'       => 'نام کاربری:',
'ancientpages'            => 'قدیمی‌ترین مقاله‌ها',
'intl'                    => 'پیوندهای بین‌زبانی',
'move'                    => 'انتقال',
'movethispage'            => 'انتقال این صفحه',
'unusedimagestext'        => '<p>لطفاً توجه کنید که وبگاه‌های دیگر از جمله {{SITENAME}}های بین‌المللی ممکن است با URL مستقیم به تصاویر پیوند داشته باشند، و نتیجتاً با وجود استفادهٔ فعال
اینجا فهرست شده باشند.',
'unusedcategoriestext'    => 'این صفحات رده وجود دارند ولی هیچ مقاله یا ردهٔ دیگری از آنها استفاده نمی‌کند.',

# Book sources
'booksources'               => 'منابع کتاب',
'booksources-search-legend' => 'جستجوی منابع کتاب',
'booksources-isbn'          => 'شابک:',
'booksources-go'            => 'برو',
'booksources-text'          => 'در زیر فهرستی از پیوندها به وبگاههای دیگر که کتاب‌های نو و دست‌دوم می‌فروشند آمده‌است. همچنین ممکن است اطلاعات بیشتری راجع به کتاب مورد نظر شما بدارند.',

'categoriespagetext' => 'رده‌های زیر در ویکی وجود دارند.',
'data'               => 'داده',
'userrights'         => 'مدیریت اختیارات کاربر',
'groups'             => 'گروههای کاربری',
'isbn'               => 'شابک',
'alphaindexline'     => '$1 تا $2',
'version'            => 'نسخه',

# Special:Log
'specialloguserlabel'  => 'کاربر:',
'speciallogtitlelabel' => 'عنوان:',
'log'                  => 'سیاهه‌ها',
'all-logs-page'        => 'تمام سياهه‌ها',
'log-search-legend'    => 'به دنبال سیاهه‌ها جستجو کن',
'log-search-submit'    => 'برو',
'alllogstext'          => 'نمایش یک‌جای بارکردن‌ها، حذف‌ها، حفاظت‌ها، بستن‌ها و سیاهه‌های مربوط به مدیران. می‌توانید با انتخاب نوع سیاهه، نام کاربری و صفحه‌های تغییریافته، نمایش را محدودتر سازید.',
'logempty'             => 'مورد منطبق با منظور شما در سیاهه یافت نشد.',
'log-title-wildcard'   => 'صفحاتی را جستجو کن که عنوانشان با این عبارت آغاز می‌شود',

# Special:Allpages
'nextpage'          => 'صفحهٔ بعد ($1)',
'prevpage'          => 'صفحهٔ قبلی ($1)',
'allpagesfrom'      => 'نمایش صفحه‌ها با شروع از:',
'allarticles'       => 'همهٔ مقاله‌ها',
'allinnamespace'    => 'همهٔ صفحه‌ها (فضای نام $1)',
'allnotinnamespace' => 'همهٔ صفحه‌ها (که در فضای نام $1 است)',
'allpagesprev'      => 'قبلی',
'allpagesnext'      => 'بعدی',
'allpagessubmit'    => 'برو',
'allpagesprefix'    => 'نمایش صفحه‌های دارای پیشوند:',
'allpagesbadtitle'  => 'عنوان صفحهٔ داده‌شده نامعتبر است یا اینکه دارای پیشوندی بین‌زبانی یا بین‌ویکی‌ای است. ممکن است نویسه‌هایی بدارد که نمی‌توان از آنها در عنوان صفحه‌ها استفاده کرد.',
'allpages-bad-ns'   => '{{SITENAME}} دارای فضای نام «$1» نیست.',

# Special:Listusers
'listusersfrom'      => 'نمایش کاربران با شروع از:',
'listusers-submit'   => 'نمایش',
'listusers-noresult' => 'هیچ کاربری یافت نشد.',

# E-mail user
'mailnologin'     => 'نشانی‌ای از فرستنده وجود ندارد.',
'mailnologintext' => 'برای فرستادن پست الکترونیکی به کاربران دیگر باید [[Special:Userlogin|به سیستم وارد شوید]]
و نشانی پست الکترونیکی معتبری در [[Special:Preferences|ترجیحات]]
خود داشته باشید.',
'emailuser'       => 'پست الکترونیکی به این کاربر',
'emailpage'       => 'پست الکترونیکی به کاربر',
'emailpagetext'   => 'اگر این کاربر نشانی پست الکترونیکی معتبری در ترجیحات کاربری‌اش وارد کرده
باشد، فرم زیر یک پیغام می‌فرستد.
نشانی پست الکترونیکی‌ای که در ترجیحات کاربریتان وارد کرده‌اید در نشانی فرستنده (From) نامه
خواهد آمد، تا گیرنده بتواند پاسخ دهد.',
'usermailererror' => 'پست الکترونیکی دچار خطا شد:',
'defemailsubject' => 'پست الکترونیکی {{SITENAME}}',
'noemailtitle'    => 'نشانی پست‌الکترونیک موجود نیست',
'noemailtext'     => 'این کاربر نشانی پست الکترونیکی معتبری مشخص نکرده است،
یا تصمیم گرفته از کاربران دیگر پست الکترونیکی دریافت نکند.',
'emailfrom'       => 'از',
'emailto'         => 'به',
'emailsubject'    => 'عنوان',
'emailmessage'    => 'پیغام',
'emailsend'       => 'فرستاده شود',
'emailccme'       => 'رونوشت پیغام را برایم بفرست.',
'emailccsubject'  => 'رونوشت پیغام شما به $1: $2',
'emailsent'       => 'پست الکترونیکی فرستاده شد',
'emailsenttext'   => 'پیغام پست الکترونیکی شما فرستاده شد.',

# Watchlist
'watchlist'            => 'فهرست تعقیبات من',
'mywatchlist'          => 'تعقیبات من',
'watchlistfor'         => "(برای '''$1''')",
'nowatchlist'          => 'در فهرست تعقیبات شما هیچ موردی نیست.',
'watchlistanontext'    => 'برای مشاهده و ویرایش فهرست تعقیبات خود از $1 استفاده کنید.',
'watchnologin'         => 'به سیستم وارد نشده‌اید',
'watchnologintext'     => 'برای تغییر فهرست تعقیباتتان باید [[Special:Userlogin|به سیستم وارد شوید]].',
'addedwatch'           => 'به فهرست تعقیبات اضافه شد',
'addedwatchtext'       => "صفحهٔ «$1» به [[Special:Watchlist|فهرست تعقیبات]] شما اضافه شد.
تغییرات این صفحه و صفحهٔ بحث متناظرش در آینده در اینجا فهرست خواهد شد. به‌علاوه، این صفحه، برای واضح‌تر دیده شدن در [[Special:Recentchanges|فهرست تغییرات اخیر]] به شکل <b>سیاه</b> خواهد آمد.

اگر بعداً می‌خواستید این صفحه از فهرست تعقیباتتان برداشته شود، روی «'''توقف تعقیب'''» در بالای صفحه کلیک کنید.",
'removedwatch'         => 'از فهرست تعقیبات برداشته شد',
'removedwatchtext'     => 'صفحهٔ «$1» از فهرست تعقیبات شما برداشته شد',
'watch'                => 'تعقیب',
'watchthispage'        => 'تعقیب این صفحه',
'unwatch'              => 'توقف تعقیب',
'unwatchthispage'      => 'توقف تعقیب',
'notanarticle'         => 'مقاله نیست',
'watchnochange'        => 'هیچ یک از موارد در حال تعقیب شما در دورهٔ زمانی نمایش‌یافته ویرایش نشده است.',
'watchlist-details'    => '($1 صفحه بدون احتساب صفحات بحث؛)',
'wlheader-enotif'      => '*اطلاع‌رسانی ایمیلی امکان‌پذیر است.',
'wlheader-showupdated' => "*صفحاتی که پس از آخرین سرزدنتان به آنها تغییر کرده‌اند '''پررنگ''' نشان داده شده‌اند.",
'watchmethod-recent'   => 'بررسی ویرایش‌های اخیر برای صفحه‌های مورد تعقیب',
'watchmethod-list'     => 'بررسی صفحه‌های مورد تعقیب برای ویرایش‌های اخیر',
'watchlistcontains'    => 'فهرست تعقیبات شما حاوی $1 صفحه است.',
'iteminvalidname'      => 'مشکل با مورد «$1»، نام نامعتبر است...',
'wlnote'               => 'در زیر آخرین $1 تغییر در $2 ساعت آخر آمده است.',
'wlshowlast'           => 'نمایش آخرین $1 ساعت $2 روز $3',
'watchlist-show-bots'  => 'نمایش ویرایش ربات‌ها',
'watchlist-hide-bots'  => 'پنهان کردن ویرایش ربات‌ها',
'watchlist-show-own'   => 'نمایش ویرایش‌های من',
'watchlist-hide-own'   => 'پنهان کردن ویرایش‌های من',
'watchlist-show-minor' => 'نمایش ویرایش‌های جزئی',
'watchlist-hide-minor' => 'پنهان کردن ویرایش‌های جزئی',

# Displayed when you click the "watch" button and it's in the process of watching
'watching'   => 'تعقیب...',
'unwatching' => 'توقف تعقیب...',

'enotif_mailer'                => 'پست الکترونیکی اطلاع‌رسانی {{SITENAME}}',
'enotif_reset'                 => 'علامت‌گذاری همهٔ صفحه‌ها به عنوان بازدید شده',
'enotif_newpagetext'           => 'این یک صفحهٔ تازه‌است.',
'enotif_impersonal_salutation' => 'کاربر {{SITENAME}}',
'changed'                      => 'تغییر یافته',
'created'                      => 'ایجاد شد',
'enotif_subject'               => 'صفحهٔ «$PAGETITLE» {{SITENAME}} به دست $PAGEEDITOR $CHANGEDORCREATED‌است.',
'enotif_lastvisited'           => 'برای دیدن همهٔ تغییرات از آخرین باری که سر زده‌اید $1 را ببینید.',
'enotif_lastdiff'              => 'برای نمایش این تغییر $1 را ببینید.',
'enotif_anon_editor'           => 'کاربر ناشناس $1',
'enotif_body'                  => '$WATCHINGUSERNAME گرامی،

صفحهٔ «$PAGETITLE» {{SITENAME}} در $PAGEEDITDATE به دست $PAGEEDITOR $CHANGEDORCREATED است. برای دیدن نسخهٔ کنونی به $PAGETITLE_URL بروید.

$NEWPAGE

توضیح ویراستار: $PAGESUMMARY $PAGEMINOREDIT

تماس با ویراستار:
نامه: $PAGEEDITOR_EMAIL
ویکی: $PAGEEDITOR_WIKI

تا هنگامی که به صفحه سر نزده‌اید، در صورت رخ‌دادنِ احتمالیِ تغییراتِ بیشتر، اعلانیه‌ای برای شما فرستاده نخواهد شد. شما همچنین می‌توانید در صفحهٔ تعقیبات خود پرجم‌های مربوط به آگاهی‌رسانی پستی را صفر کنید.

خاکسار شما،

سامانهٔ آگاهی‌رسانی  {{SITENAME}}.

--
برای تغییر تنظیمات فهرست تعقیباتتان به {{fullurl:{{ns:special}}:Watchlist/edit}} بروید.

بازخورد و کمک بیشتر:
{{fullurl:{{ns:help}}:Contents}}',

# Delete/protect/revert
'deletepage'                  => 'حذف صفحه',
'confirm'                     => 'تأیید',
'excontent'                   => "محتوای صفحه این بود: '$1'",
'excontentauthor'             => "محتویات صفحه این بود: '$1' (و تنها مشارکت‌کننده '$2' بود)",
'exbeforeblank'               => "محتوای صفحه قبل از خالی‌کردن '$1' بود.",
'exblank'                     => 'صفحه خالی بود',
'confirmdelete'               => 'تأیید حذف',
'deletesub'                   => '(در حال حذف «$1»)',
'historywarning'              => 'هشدار! صفحه‌ای که دارید حذف می‌کنید، تاریخچه‌ای دارد:',
'confirmdeletetext'           => 'شما در حال حذف‌کردن یک صفحه یا تصویر از پایگاه‌ داده همراه با تمام تاریخچهٔ آن هستید. لطفاً این عمل را تأیید کنید و اطمینان حاصل کنید که عواقب این کار را می‌دانید و این عمل را مطابق با [[{{MediaWiki:policy-url}}]] انجام می‌دهید.',
'actioncomplete'              => 'عمل انجام شد.',
'deletedtext'                 => '«$1» حذف شده است.
برای سابقهٔ حذف‌های اخیر به $2 مراجعه کنید.',
'deletedarticle'              => '«$1» حذف شد',
'dellogpage'                  => 'سیاههٔ_حذف',
'dellogpagetext'              => 'فهرست زیر فهرستی از آخرین حذف‌هاست.
همهٔ زمان‌های نشان‌داده‌شده زمان خادم (وقت گرینویچ) است.',
'deletionlog'                 => 'سیاههٔ حذف',
'reverted'                    => 'به نسخهٔ قدیمی‌تر واگردانده شد.',
'deletecomment'               => 'توضیح حذف',
'rollback'                    => 'واگردانی ویرایش‌ها',
'rollback_short'              => 'واگرد',
'rollbacklink'                => 'واگردانی',
'rollbackfailed'              => 'واگردانی نشد',
'cantrollback'                => 'نمی‌توان ویرایش را واگرداند. آخرین مشارکت‌کننده تنها مؤلف این مقاله است.',
'alreadyrolled'               => 'واگردانی آخرین ویرایش [[$1]] بوسیلهٔ [[User:$2|$2]] ([[User talk:$2|بحث]]) ممکن نیست؛ پیش از این شخص دیگری مقاله را ویرایش یا واگردانی کرده است.

آخرین ویرایش توسط [[User:$3|$3]] ([[User talk:$3|بحث]]).',
'editcomment'                 => 'توضیح ویرایش این بود: «<i>$1</i>».', # only shown if there is an edit comment
'revertpage'                  => 'ویرایش $2 واگردانده شد به آخرین تغییری که  $1 انجام داده بود',
'rollback-success'            => 'ویرایش‌های $1 واگردانی شد؛ صفحه به ویرایش $2 برگردانده شد.',
'sessionfailure'              => 'بنظر می‌رسد مشکلی در مورد نشست کاربری شما وجود دارد؛ عمل درخواست شده بعنوان اقدام پیشگیرانه در برابر ربوده‌شدن اطلاعات نشست کاربری، لغو شد. لطفاً دکمهٔ «بازگشت» را در مرورگر خود بفشارید و صفحه‌ای که از آن به اینجا رسیده‌اید را مجدداً فراخوانی کنید، سپس مجدداً سعی کنید.',
'protectlogpage'              => 'سیاههٔ_محافظت',
'protectlogtext'              => 'در زیر فهرست قفل کردن‌ها/ازقفل‌درآوردن‌های صفحات آمده است.
برای اطلاعات بیشتر به [[{{ns:project}}:سیاست حفاظت از صفحات]] مراجعه کنید.',
'protectedarticle'            => '[[$1]] محافظت شد',
'modifiedarticleprotection'   => 'وضعیت محافظت صفحهٔ [[$1]] تغییر داده شد',
'unprotectedarticle'          => '[[$1]] از محافظت به در آمد',
'protectsub'                  => '(محافظت از «$1»)',
'confirmprotect'              => 'تأیید حفاظت',
'protectcomment'              => 'دلیل محافظت',
'protectexpiry'               => 'زمان سرآمدن:',
'protect_expiry_invalid'      => 'زمان سرآمدن نامعتبر است.',
'protect_expiry_old'          => 'زمان سرآمدن در گذشته‌است.',
'unprotectsub'                => '(به‌درآوردن «$1» از محافظت)',
'protect-unchain'             => 'بازکردن اجازهٔ انتقال',
'protect-text'                => 'می‌توانید سطح حفاظت صفحهٔ [[$1]] را ببینید و آن را تغییر دهید. لطفاً اطمینان حاصل کنید که [[{{ns:project}}:سیاست حفاظت از صفحات|سیاست حفاظت از صفحات]] را رعایت می‌کنید.',
'protect-locked-blocked'      => 'شما در مدتی که دسترسی‌تان قطع است نمی‌توانید سطح حفاظت صفحات را تغییر دهید. تنظیمات فعلی صفحهٔ $1 به این قرار است:',
'protect-locked-dblock'       => 'به دلیل قفل شدن پایگاه داده، امکان تغییر سطح حفاظت صفحات وجود ندارد. تنظیمات فعلی صفحهٔ $1 به این قرار است:',
'protect-locked-access'       => 'حساب کاربری شما اجازهٔ تغییر سطح حفاظت صفحات را ندارد. تنظیمات فعلی صفحهٔ $1 به این قرار است:',
'protect-cascadeon'           => 'این صفحه  در حال حاضر محافظت شده‌است زیرا در {{PLURAL:$1|صفحهٔ|صفحه‌های}} زیر که گزینهٔ محافظت آبشاری {{PLURAL:$1|آن|آن‌ها}} فعال است، 
شما می‌توانید سطح محافظت این صفحه را تغییر بدهید اما این کار تاثیری بر محافظت آبشاری صفحه نخواهد گذاشت.',
'protect-default'             => '(پیش‌فرض)',
'protect-fallback'            => 'سطح دسترسی $1 لازم است.',
'protect-level-autoconfirmed' => 'بستن کاربران ثبت‌نام‌نکرده.',
'protect-level-sysop'         => 'فقط مدیران',
'protect-summary-cascade'     => 'آبشاری',
'protect-expiring'            => 'زمان سرآمدن $1 (UTC)',
'protect-cascade'             => 'محافظت آبشاری - از همهٔ صفحاتی که در این صفحه آمده‌اند محافظت می‌شود.',
'restriction-type'            => 'دسترسی',
'restriction-level'           => 'سطح محدودیت',
'minimum-size'                => 'حداقل اندازه',
'maximum-size'                => 'حداکثر اندازه',
'pagesize'                    => '(بایت)',

# Restrictions (nouns)
'restriction-edit' => 'ویرایش',
'restriction-move' => 'انتقال',

# Restriction levels
'restriction-level-sysop'         => 'کامل‌حفاظت‌شده',
'restriction-level-autoconfirmed' => 'نیمه‌حفاظت‌شده',
'restriction-level-all'           => 'هر سطحی',

# Undelete
'undelete'                     => 'احیای صفحهٔ حذف‌شده',
'undeletepage'                 => 'نمایش و احیای صفحه‌های حذف‌شده',
'viewdeletedpage'              => 'نمایش صفحات حذف‌شده',
'undeletepagetext'             => 'صفحات زیر حذف شده‌اند ولی هنوز در بایگانی هستند و می‌توانند احیا شوند.
این بایگانی ممکن است هر چند وقت تمیز شود.',
'undeleteextrahelp'            => "برای احیای تمام صفحه، همهٔ جعبه‌ها را تیک‌ناخورده رها کرده و دکمهٔ '''''احیا''''' را کلیک کنید. برای انجام احیایی منتخبانه، جعبه‌های متناظر با نسخه‌های موردِنظر برای احیا را تیک زده و دکمهٔ '''''احیا''''' را کلیک کنید. دکمهٔ '''''از نو''''' محتویات بخش «توضیح»  را پاک و تمام جعبه‌ها را تیک‌ناخورده می‌کند.",
'undeleterevisions'            => '$1 نسخهٔ بایگانی شده است',
'undeletehistory'              => 'اگر این صفحه را احیا کنید، همهٔ نسخه‌های آن در تاریخچه احیا خواهند شد.
اگر صفحهٔ جدیدی با نام یکسان از زمان حذف ایجاد شده باشد، نسخه‌های احیاشده در تاریخچهٔ قبلی خواهند آمد،
و نسخهٔ فعلی صفحهٔ زنده به طور خودکار جایگزین نخواهد شد.',
'undeleterevdel'               => 'احیا صفحات در حالتی که باعث حذف شدن بخشی از آخرین نسخهٔ صفحه بشود مقدور نیست. در این حالت شما باید چند نسخهٔ اخیر صفحه را نیز احیا کنید. نسخه‌هایی از پرونده‌ها که شما اجازه دیدنش را نداشته باشید قابل احیا نخواهند بود.',
'undeletehistorynoadmin'       => 'این مقاله حذف شده‌است. دلیل حذف این مقاله به همراه مشخصات کاربرانی که قبل از حذف این صفحه را ویرایش کرده‌اند، در خلاصهٔ زیر آمده‌است. متن واقعی این ویرایش‌های حذف شده فقط در دسترس مدیران است.',
'undelete-revision'            => 'حذف نسخهٔ $1 از $2 توسط $3:',
'undeleterevision-missing'     => 'نسخه نامعتبر یا مفقود است. ممکن است پیوندتان نادرست باشد یا اینکه نسخه از بایگانی حذف یا بازیابی شده باشد .',
'undeletebtn'                  => 'احیا شود!',
'undeletereset'                => 'از نو',
'undeletecomment'              => 'توضیح:',
'undeletedarticle'             => '«$1» احیا شد',
'undeletedrevisions'           => '$1 نسخه احیا شد',
'undeletedrevisions-files'     => '$1 نسخه و $2 پرونده احیا شد.',
'undeletedfiles'               => '$1 پرونده احیا شد.',
'cannotundelete'               => 'نشد احیا کرد. ممکن است کس دیگری پیشتر این صفحه را احیا کرده باشد.',
'undeletedpage'                => "<big> '''$1 احیا شد.'''</big>
برای دیدن سیاههٔ حذفها و احیاهای اخیر به  [[Special:Log/delete|سیاههٔ حذف]] رجوع کنید.",
'undelete-header'              => 'برای دیدن صفحه‌های حذف‌شدهٔ اخیر [[Special:Log/delete|سیاههٔ حذف]] را ببینید.',
'undelete-search-box'          => 'جستجوی صفحه‌های حذف‌شده.',
'undelete-search-prefix'       => 'نمایش صفحه‌ها با شروع از:',
'undelete-search-submit'       => 'برو',
'undelete-no-results'          => 'هیچ صفحهٔ منطبقی در بایگانی حذف‌شده‌ها یافت نشد.',
'undelete-filename-mismatch'   => 'امکان احیای نسخهٔ $1 وجود ندارد: نام پرونده مطابقت نمی‌کند.',
'undelete-bad-store-key'       => 'امکان احیای نسخهٔ $1 وجود ندارد: پرونده قبل از حذف از دست رفته بود.',
'undelete-cleanup-error'       => 'خطا در حذف تاریخچهٔ استفاده نشدهٔ $1',
'undelete-missing-filearchive' => 'امکان احیای تارخچهٔ شمارهٔ $1 وجود ندارد زیرا اطلاعات در پایگاه داده وجود ندارد.',
'undelete-error-short'         => 'خطا در احیای پرونده: $1',
'undelete-error-long'          => 'در زمان احیای پرونده خطا رخ داد:

$1',

# Namespace form on various pages
'namespace'      => 'فضای نام:',
'invert'         => 'انتخاب برعکس شود',
'blanknamespace' => '(اصلی)',

# Contributions
'contributions' => 'مشارکت‌ها',
'mycontris'     => 'مشارکت‌های من',
'contribsub2'   => 'برای $1 ($2)',
'nocontribs'    => 'هیچ تغییری با این مشخصات یافت نشد.',
'ucnote'        => 'در زیر آخرین <b>$1</b> تغییر این کاربر در <b>$2</b> روز اخیر می‌آید.',
'uclinks'       => 'نمایش آخرین $1 تغییر؛ نمایش $2 روز اخیر.',
'uctop'         => ' (بالا)',
'month'         => 'در این ماه (و قبل از آن)',
'year'          => 'در این سال (و قبل از آن)',

'sp-contributions-newest'      => 'جدیدترین',
'sp-contributions-oldest'      => 'قدیمی‌ترین',
'sp-contributions-newer'       => '$1‌تای جدیدتر',
'sp-contributions-older'       => '$1‌تای قدیمی‌تر',
'sp-contributions-newbies'     => 'فقط مشارکت‌های تازه‌واردان نمایش داده شود',
'sp-contributions-newbies-sub' => 'برای تازه‌کاران',
'sp-contributions-blocklog'    => 'سیاههٔ بسته‌شدن‌ها',
'sp-contributions-search'      => 'جستجوی مشارکت‌ها',
'sp-contributions-username'    => 'نشانی آی‌پی یا نام کاربری:',
'sp-contributions-submit'      => 'جستجو',

'sp-newimages-showfrom' => 'نشان‌دادن تصویرهای جدید از $1 به بعد',

# What links here
'whatlinkshere'        => 'پیوندهای به این صفحه',
'whatlinkshere-title'  => 'صفحه‌هایی که به $1 پیوند دارند',
'whatlinkshere-barrow' => '&gt;',
'notargettitle'        => 'مقصدی نیست',
'notargettext'         => 'شما صفحهٔ یا کاربر مقصدی برای انجام این عمل روی آن مشخص نکرده‌اید.',
'linklistsub'          => '(فهرست پیوندها)',
'linkshere'            => "صفحه‌های زیر به '''[[:$1]]''' پیوند دارند:",
'nolinkshere'          => "هیچ صفحه‌ای به '''[[:$1]]''' پیوند ندارد.",
'nolinkshere-ns'       => "هیچ صفحه‌ای از فضای نام انتخاب شده به '''[[:$1]]''' پیوند ندارد.",
'isredirect'           => 'صفحهٔ تغییر مسیر',
'istemplate'           => 'استفاده‌شده در صفحه',
'whatlinkshere-prev'   => '{{PLURAL:$1|قبلی|$1 مورد قبلی}}',
'whatlinkshere-next'   => '{{PLURAL:$1|بعدی|$1 مورد بعدی}}',
'whatlinkshere-links'  => '← پیوندها',

# Block/unblock
'blockip'                     => 'بستن کاربر',
'blockiptext'                 => 'از فرم زیر برای بستن دسترسی ویرایش یک نشانی IP یا نام کاربری مشخص استفاده کنید. این کار فقط فقط باید برای جلوگیری از خرابکاری انجام شود، و بر اساس [[{{ns:project}}:قطع دسترسی|سیاست قطع دسترسی]]. دلیل مشخص این کار را در زیر ذکر کنید (مثلاً با ذکر صفحه‌های به‌خصوصی که تخریب شده‌اند).',
'ipaddress'                   => 'نشانی IP/نام کاربر',
'ipadressorusername'          => 'نشانی IP یا نام کاربری',
'ipbexpiry'                   => 'خاتمه',
'ipbreason'                   => 'دلیل',
'ipbreasonotherlist'          => 'دیگر دلایل',
'ipbreason-dropdown'          => '**وارد کردن اطلاعات نادرست
**پاک کردن اطلاعات مفید از صفحات
**هرزنگاری از طریق درج مکرر پیوند به وب‌گاه‌ها
**درج چرندیات یا نوشته‌های بی‌معنا در صفحات
**تهدید یا ارعاب دیگر کاربرها
**سوء استفاده از چند حساب کاربری زاپاس
**نام کاربری نامناسب
**نقض مکرر حق تکثیر',
'ipbanononly'                 => 'فقط بستن کاربران گمنام',
'ipbcreateaccount'            => 'جلوگیری از ایجاد حساب',
'ipbemailban'                 => 'جلوگیری از ارسال پست الکترونیکی',
'ipbenableautoblock'          => 'نشانه‌های آی‌پی استفاده شده توسط کاربر بصورت خودکار بسته‌ شود.',
'ipbsubmit'                   => 'این کاربر بسته شود',
'ipbother'                    => 'زمانی دیگر',
'ipboptions'                  => '۲ ساعت:2 hours,۱ روز:1 day,۳ روز:3 days,۱ هفته:1 week,۲ هفته:2 weeks,۱ ماه:1 month,۳ ماه:3 months,۶ ماه:6 months,۱ سال:1 year,بی‌پایان:infinite',
'ipbotheroption'              => 'دیگر',
'ipbotherreason'              => 'دلایل دیگر/اضافی',
'ipbhidename'                 => 'نهفتن نام کاربری/آی‌پی از سیاههٔ بسته‌شدن‌ها، فهرست بسته‌شدگان کنونی و فهرست کاربران.',
'badipaddress'                => 'کاربری با این نام وجود ندارد.',
'blockipsuccesssub'           => 'بستن با موفقیت انجام شد',
'blockipsuccesstext'          => '«$1» بسته شده است.
<br />برای بررسی بسته‌شدن‌ها، به [[Special:Ipblocklist|فهرست نشانی‌های IP و نام‌های کاربری بسته‌شده]] مراجعه کنید.',
'ipb-edit-dropdown'           => 'دلایل قطع دسترسی',
'ipb-unblock-addr'            => 'بازکردن $1',
'ipb-unblock'                 => 'بازکردن نام کاربری یا نشانی آی‌پی',
'ipb-blocklist-addr'          => 'دیدن بست‌های موجود $1',
'ipb-blocklist'               => 'دیدنِ بَست‌های موجود',
'unblockip'                   => 'باز کردن کاربر',
'unblockiptext'               => 'برای باز گرداندن دسترسی نوشتن به یک نشانی IP یا نام کاربری بسته‌شده
از فرم زیر استفاده کنید.',
'ipusubmit'                   => 'باز کردن این نشانی',
'unblocked'                   => 'دسترسی [[User:$1|$1]] دوباره برقرار شد.',
'unblocked-id'                => 'قطع دسترسی شماره $1 خاتمه یافت',
'ipblocklist'                 => 'فهرست نشانی‌های IP و نام‌های کاربری بسته‌شده',
'ipblocklist-legend'          => 'جستجوی کاربر بسته شده',
'ipblocklist-username'        => 'نام کاربری یا نشانی IP',
'ipblocklist-submit'          => 'جستجو',
'blocklistline'               => '$1، $2 $3 را بست ($4)',
'infiniteblock'               => 'بی‌پایان',
'expiringblock'               => 'در $1 به پایان می‌رسد',
'anononlyblock'               => 'فقط کاربران گمنام',
'noautoblockblock'            => 'بستن خودکار غیرفعال است.',
'createaccountblock'          => 'امکان ایجاد حساب مسدود است.',
'emailblock'                  => 'پست الکتروینکی مسدود شد',
'ipblocklist-empty'           => 'فهرست بسته‌شدن‌ها خالی‌است.',
'ipblocklist-no-results'      => 'دسترسی حساب کاربری یا آدرس اینترنتی مورد نظر قطع نیست.',
'blocklink'                   => 'بسته شود',
'unblocklink'                 => 'باز شود',
'contribslink'                => 'مشارکت‌ها',
'autoblocker'                 => 'به طور خودکار بسته شد چون IP شما و «$1» یکی است. دلیل «$2».',
'blocklogpage'                => 'سیاههٔ_بسته‌شدن‌ها',
'blocklogentry'               => '«$1»  $2 بسته شد. $3',
'blocklogtext'                => 'این سیاهه‌ای از اعمال بستن و باز کردن کاربرها است. نشانی‌های IPی که به طور
خودکار بسته شده‌اند فهرست نشده‌اند. برای فهرست محرومیت‌ها و بسته‌شدن‌های عملیاتی در لحظهٔ حاضر،
به [[Special:Ipblocklist|فهرست IPهای بسته]] مراجعه کنید.',
'unblocklogentry'             => '«$1» باز شد',
'block-log-flags-anononly'    => 'فقط کاربران گمنام',
'block-log-flags-nocreate'    => 'قابلیت ایجاد حساب غیرفعال شد.',
'block-log-flags-noautoblock' => 'قطع دسترسی خودکار غیرفعال شد',
'block-log-flags-noemail'     => 'پست الکترونیکی مسدود شد',
'range_block_disabled'        => 'قابلیت بستن گستره‌ای مدیران سلب  شده‌است.',
'ipb_expiry_invalid'          => 'زمان خاتمه نامعتبر.',
'ipb_already_blocked'         => '«$1» همین الان هم بسته‌است.',
'ip_range_invalid'            => 'گسترهٔ آی‌پی (IP) نامعتبر است.',
'proxyblocker'                => 'پروکسی‌بَند',
'ipb_cant_unblock'            => 'خطا: آی‌دی بسته‌شدن $1 یافت نشد. ممکن است پیشتر باز شده باشد.',
'proxyblockreason'            => 'نشانیIP شما بسته شده است چون یک پیشکار (proxy) باز است. لطفاً با تأمین‌کنندهٔ اینترنت خود تماس بگیرید و آنها را از این مشکل امنیتی جدی آگاه کنید.',
'proxyblocksuccess'           => 'انجام شد.',
'sorbsreason'                 => 'نشانی اینترنتی (IP) شما توسط DNSBL به عنوان یک پروکسی باز گزارش شده‌است.',
'sorbs_create_account_reason' => 'نشانی اینترنتی (IP) شما توسط DNSBL به عنوان یک پروکسی باز گزارش شده‌است. شما اجازهٔ ساختن حساب کاربری ندارید.',

# Developer tools
'lockdb'              => 'قفل کردن پایگاه داده',
'unlockdb'            => 'از قفل در آوردن پایگاه داده',
'lockdbtext'          => 'قفل کردن پایگاه داده امکان ویرایش صفحات، تغییر تنظیمات، ویرایش تعقیبات، و سایر تغییراتی را که نیازمند تغییری در پایگاه داده است، از همهٔ کاربران سلب می‌کند. لطفاً تایید کنید که دقیقاً این کار را می‌خواهید انجام دهید، و در اولین فرصت پایگاه داده را از حالت قفل شده خارج خواهید کرد.',
'unlockdbtext'        => 'از قفل در آوردن پایگاه داده به تمامی کاربران اجازه می‌دهد که توانایی ویرایش صفحات، تغییر تنظیمات، تغییر تعقیبات و هر تغییر دیگری که نیازمند تغییر در پایگاه داده باشد را دوباره به دست بیاورند. لطفاً تایید کنید که همین کار را می‌خواهید انجام دهید.',
'lockconfirm'         => 'بله، من جداً می‌خواهم پایگاه داده را قفل کنم.',
'unlockconfirm'       => 'بله، من جداً می‌خواهم پایگاه داده را از قفل در آورم.',
'lockbtn'             => 'قفل کردن پایگاه داده',
'unlockbtn'           => 'از قفل درآوردن پایگاه داده',
'locknoconfirm'       => 'شما در جعبهٔ تأیید تیک نزدید',
'lockdbsuccesssub'    => 'قفل کردن پایگاه داده با موفقیت انجام شد',
'unlockdbsuccesssub'  => 'قفل پایگاه داده برداشته شد',
'lockdbsuccesstext'   => 'پایگاه داده قفل شد.
<br />فراموش نکنید که پس از اتمام نگهداری قفل را بردارید.',
'unlockdbsuccesstext' => 'پایگاه داده از قفل در آمد.',
'lockfilenotwritable' => 'قفل پایگاه داده نوشتنی نیست. برای این که بتوانید پایگاه داده را قفل یا باز کنید، باید این پرونده نوشتنی باشد.',
'databasenotlocked'   => 'پایگاه داده قفل نیست.',

# Move page
'movepage'                => 'انتقال صفحه',
'movepagetext'            => "با استفاده از فرم زیر نام صفحه تغییر خواهد کرد، و تمام تاریخچه‌اش به
نام جدید منتقل خواهد شد. عنوان قدیمی تبدیل به یک صفحهٔ تغییر مسیر به عنوان جدید خواهد شد. پیوندهای که به عنوان صفحهٔ قدیمی وجود دارند، تغییر نخواهند کرد؛ حتماً تغییر مسیرهای دوتایی یا خراب را بررسی کنید. '''شما''' مسئول اطمینان از این هستید که پیوندها هنوز به همان‌جایی که قرار است بروند.

توجه کنید که اگر از قبل صفحه‌ای در عنوان جدید وجود داشته باشد صفحه منتقل '''نخواهد شد'''، مگر
این که صفحه خالی یا تغییر مسیر باشد و تاریخچهٔ ویرایشی نداشته باشد. این یعنی اگر اشتباه کردید می‌توانید صفحه را به همان جایی که از آن منتقل شده بود برگردانید، و این که نمی‌توانید روی صفحات موجود بنویسید.

'''هشدار!'''
انتقال صفحات به نام جدید ممکن است تغییر اساسی و غیرمنتظره‌ای برای صفحات محبوب باشد؛ لطفاً مطمئن شوید که قبل از انتقال دادن صفحه، عواقب این کار را درک می‌کنید.",
'movepagetalktext'        => "صفحهٔ بحث مربوط، اگر وجود داشته باشد، بطور خودکار همراه با مقالهٔ اصلی منتقل خواهد شد '''مگر اینکه''' :
* در حال انتقال صفحه از این فضای نام به فضای نام دیگری باشید،
* یک صفحهٔ بحث غیرخالی تحت این نام جدید وجود داشته باشد، یا
* جعبهٔ زیر را تیک نزده باشید.

در این حالات، باید صفحه را بطور دستی انتقال داده و یا محتویات دو صفحه را با ویرایش ادغام کنید.",
'movearticle'             => 'انتقال صفحه',
'movenologin'             => 'به سیستم وارد نشده‌اید',
'movenologintext'         => 'برای انتقال صفحات باید کاربر ثبت‌شده بوده و
[[Special:Userlogin|به سیستم وارد شوید]].',
'movenotallowed'          => 'شما اجازهٔ انتقال دادن صفحات در این ویکی را ندارید.',
'newtitle'                => 'به عنوان جدید',
'move-watch'              => 'تعقیب این صفحه',
'movepagebtn'             => 'صفحه منتقل شود',
'pagemovedsub'            => 'انتقال با موفقیت انجام شد',
'movepage-moved'          => 'صفحه‌ٔ «$1» به «$2» منتقل شد.', # The two titles are passed in plain text as $3 and $4 to allow additional goodies in the message.
'articleexists'           => 'صفحه‌ای با این نام از قبل وجود دارد، یا نامی که انتخاب کرده‌اید معتبر نیست.
لطفاً نام دیگری انتخاب کنید.',
'talkexists'              => 'صفحه با موفقیت منتقل شد، ولی صفحهٔ بحث را، به این دلیل که صفحهٔ بحثی در عنوان جدید
وجود دارد، نمی‌توان منتقل کرد. لطفاً آنها را دستی ترکیب کنید.',
'movedto'                 => 'منتقل شد به',
'movetalk'                => 'صفحهٔ «بحث» هم، در صورت لزوم، منتقل شود.',
'talkpagemoved'           => 'صفحهٔ بحث متناظر نیز منتقل شد.',
'talkpagenotmoved'        => 'صفحهٔ بحث متناظر منتقل <strong>نشد</strong>.',
'1movedto2'               => '$1 به $2 منتقل شد',
'1movedto2_redir'         => '$1 به $2 که قبلاً صفحهٔ تغییر مسیر بود، منتقل شد',
'movelogpage'             => 'سیاههٔ انتقال',
'movelogpagetext'         => 'در زیر فهرستی از صفحات منتقل شده آمده است.',
'movereason'              => 'دلیل انتقال',
'revertmove'              => 'واگردانی',
'delete_and_move'         => 'حذف و انتقال',
'delete_and_move_text'    => '== نیاز به حذف ==

مقاله‌ٔ مقصد «[[$1]]» وجود دارد. آیا می‌خواهید آن را حذف کنید تا انتقال ممکن شود؟',
'delete_and_move_confirm' => 'بله، صفحه حذف شود',
'delete_and_move_reason'  => 'حذف برای ممکن‌شدن انتقال',
'selfmove'                => 'عناوین صفحهٔ مبداء و مقصد یکی است؛ انتقال صفحه به خودش ممکن نیست.',
'immobile_namespace'      => 'عنوان مقصد از نوع خاصی است؛ امکان انتقال صفحه‌ها به آن فضای نام وجود ندارد.',

# Export
'export'            => 'صدور صفحه‌ها',
'exporttext'        => 'شما می‌توانید متن و تاریخچهٔ ویرایش یک صفحهٔ مشخص یا مجموعه‌ای از صفحه‌ها را به شکل پوشیده در XML صادر کنید؛
این اطلاعات را می‌توان در ویکیِ دیگری که نرم‌افزار «مدیاویکی» را اجرا می‌کند وارد کرد، تبدیل کرد، یا برای سرگرمی شخصی نگه داشت.',
'exportcuronly'     => 'فقط نسخهٔ فعلی بیاید، نه کل تاریخچه',
'exportnohistory'   => "----
'''توجه:''' امکان صدور تارخچهٔ کامل صفحه‌ها از طریق این صفحه به دلایل اجرایی از کار انداخته شده‌است.",
'export-submit'     => 'صدور',
'export-addcattext' => 'افزودن صفحه‌ها از رده:',
'export-addcat'     => 'افزودن',
'export-download'   => 'پیشنهاد ذخیره به صورت پرونده',

# Namespace 8 related
'allmessages'               => 'همهٔ پیغام‌ها',
'allmessagesname'           => 'نام',
'allmessagesdefault'        => 'متن پیش‌فرض',
'allmessagescurrent'        => 'متن کنونی',
'allmessagestext'           => 'این فهرستی از همهٔ پیغام‌های موجود در فضای نام مدیاویکی: است',
'allmessagesnotsupportedDB' => "نمی‌توان از '''ویژه:همهٔ پیغام‌ها''' استفاده کرد چود '''\$wgUseDatabaseMessages''' خاموش شده است.",
'allmessagesfilter'         => 'صافی نام پیغام:',
'allmessagesmodified'       => 'تنها نمایش تغییریافته‌ها',

# Thumbnails
'thumbnail-more'           => 'بزرگ شود',
'missingimage'             => '<b>تصویر مفقود</b><br /><i>$1</i>',
'filemissing'              => 'پرونده وجود ندارد',
'thumbnail_error'          => 'خطا در ایجاد انگشت‌دانه: $1',
'djvu_page_error'          => 'صفحهٔ DjVu خارج از حدود مجاز',
'djvu_no_xml'              => 'امکان پیدا کردن پروندهٔ XML برای استفادهٔ DjVu وجود نداشت.',
'thumbnail_invalid_params' => 'پارامترهای غیر مجاز در تصویر انگشتدانه‌ای (thumbnail)',
'thumbnail_dest_directory' => 'اشکال در ایجاد پوشهٔ مقصد',

# Special:Import
'import'                     => 'واردکردن صفحه‌ها',
'importinterwiki'            => 'واردات تراویکیانه',
'import-interwiki-text'      => 'یک ویکی و یک نام صفحه را انتخاب کنید تا اطلاعات از آن وارد شود. تاریخ نسخه‌ها و نام ویرایش‌کنندگان ثابت خواهد ماند. اطلاعات مربوط به وارد کردن صفحه‌ها در [[Special:Log/import|سیاههٔ واردکردن‌ها]] درج خواهد شد.',
'import-interwiki-history'   => 'تمام نسخه‌های تاریخچهٔ این صفحه انتقال داده شود',
'import-interwiki-submit'    => 'وارد شود',
'import-interwiki-namespace' => 'صفحات به فضای نام انتقال داده شود',
'importtext'                 => 'لطفاً پرونده را از ویکی منبع صادر کنید )از طریق صفحهٔ Special:Export) و پس از ذخیره کردن آن روی رایانهٔ خودتان، آن را در این ویکی بارگذاری کنید.',
'importstart'                => 'در حال وارد کردن صفحات...',
'import-revision-count'      => '$1 ویرایش',
'importnopages'              => 'صفحه‌ای برای واردکردن نیست.',
'importfailed'               => 'وارد کردن صفحات شکست خورد: $1',
'importunknownsource'        => 'نوع مأخذ واردکردن نامعلوم',
'importcantopen'             => 'پروندهٔ ورود صفحات باز نشد',
'importbadinterwiki'         => 'پیوند میان‌ویکی نادرست',
'importnotext'               => 'صفحه خالی یا بدون متن',
'importsuccess'              => 'واردکردن با موفقیت انجام شد!',
'importhistoryconflict'      => 'نسخه‌های ناسازگار از تاریخچهٔ این صفحه وجود دارد. (احتمالاً قبلاً این صفحه وارد شده است)',
'importnosources'            => 'هیچ منبعی برای وارد کردن اطلاعات از ویکی دیگر تعریف نشده‌است',
'importnofile'               => 'هیچ پروندهٔ ورودی بارگذاری نشده‌است',
'importuploaderror'          => 'در بارگذاری پروندهٔ ورود، اشکال رخ داد. احتمال دارد که اندازهٔ پرونده بیشتر از حداکثر اندازهٔ مجاز باشد.',

# Import log
'importlogpage'                    => 'سیاههٔ واردکردن‌ها',
'importlogpagetext'                => 'وارد کردن صفحات به همراه تارخچهٔ ویرایش آن‌ها از ویکی‌های دیگر',
'import-logentry-upload'           => '[[$1]] از طریق بارگذاری پرونده، وارد شد.',
'import-logentry-upload-detail'    => '$1 نسخه',
'import-logentry-interwiki'        => '$1 تراویکی شد',
'import-logentry-interwiki-detail' => '$1 نسخه از $2',

# Tooltip help for the actions
'tooltip-pt-userpage'             => 'صفحهٔ کاربری من',
'tooltip-pt-anonuserpage'         => 'صفحهٔ کاربری آی‌پی‌ای که با آن ویرایش می‌کنید.',
'tooltip-pt-mytalk'               => 'صفحهٔ بحث من',
'tooltip-pt-anontalk'             => 'بحث پیرامون ویرایش‌های این آی‌پی',
'tooltip-pt-preferences'          => 'ترجیحات من',
'tooltip-pt-watchlist'            => 'فهرست صفحاتی که شما تغییرات آن‌ها را تعقیب می‌کنید',
'tooltip-pt-mycontris'            => 'فهرست مشارکت‌های من',
'tooltip-pt-login'                => 'توصیه می‌شود که به سیستم وارد شوید لیکن اجباری نیست.',
'tooltip-pt-anonlogin'            => 'هرآینه توصیه می‌شود که به سیستم وارد شوید لیکن اجباری نیست.',
'tooltip-pt-logout'               => 'خروج از سیستم',
'tooltip-ca-talk'                 => 'گفتگو پیرامون صفحهٔ محتوا',
'tooltip-ca-edit'                 => 'شما می‌توانید این صفحه را ویرایش کنید. لطفاً پیش از ذخیره از دکمهٔ پیش‌نمایش استفاده کنید.',
'tooltip-ca-addsection'           => 'توضیحی به این بحث اضافه کنید.',
'tooltip-ca-viewsource'           => 'این صفحه محافظت‌شده است. می‌توانید متن مبدأ آن را مشاهده کنید.',
'tooltip-ca-history'              => 'نسخه‌های پیشین این صفحه',
'tooltip-ca-protect'              => 'محافظت از این صفحه',
'tooltip-ca-delete'               => 'حذف این صفحه',
'tooltip-ca-undelete'             => 'بازگرداندن نسخه‌های صفحهٔ حذف‌شده',
'tooltip-ca-move'                 => 'انتقال این صفحه',
'tooltip-ca-watch'                => 'اضافه کردن این صفحه به فهرست تعقیبات شما',
'tooltip-ca-unwatch'              => 'حذف این صفحه از فهرست تعقیبات شما',
'tooltip-search'                  => 'جستجو در {{SITENAME}}',
'tooltip-p-logo'                  => 'صفحهٔ اصلی',
'tooltip-n-mainpage'              => 'بازدید از صفحهٔ اصلی',
'tooltip-n-portal'                => 'پیرامون پروژه، چه‌ها توانید کرد و کجا توانید یافت',
'tooltip-n-currentevents'         => 'یافتن اطلاعات پیشزمینه پیرامون وقایع کنونی',
'tooltip-n-recentchanges'         => 'فهرست تغییرات اخیر در ویکی.',
'tooltip-n-randompage'            => 'آوردن یک صفحهٔ تصادفی',
'tooltip-n-help'                  => 'مکانی برای دریافتن.',
'tooltip-n-sitesupport'           => 'حمایتمان کنید',
'tooltip-t-whatlinkshere'         => 'فهرست تمام صفحاتی که به این صفحه پیوند می‌دهند',
'tooltip-t-recentchangeslinked'   => 'تغییرات اخیر در صفحاتی که این صفحه به آن‌ها پیوند دارد',
'tooltip-feed-rss'                => 'خبرنامه RSS برای این صفحه',
'tooltip-feed-atom'               => 'خبرنامهٔ Atom برای این صفحه',
'tooltip-t-contributions'         => 'مشاهدهٔ فهرست مشارکت‌های این کاربر',
'tooltip-t-emailuser'             => 'ارسال پست الکترونیکی به ای کاربر',
'tooltip-t-upload'                => 'بارگذاری تصاویر و پرونده‌های دیگر',
'tooltip-t-specialpages'          => 'فهرست تمام صفحات ویژه',
'tooltip-t-print'                 => 'نسخهٔ قابل چاپ این صفحه',
'tooltip-t-permalink'             => 'پیوند دائمی به این نسخه از این صفحه',
'tooltip-ca-nstab-main'           => 'دیدن صفحهٔ محتویات',
'tooltip-ca-nstab-user'           => 'نمایش صفحهٔ کاربر',
'tooltip-ca-nstab-media'          => 'دیدن صفحهٔ مدیا',
'tooltip-ca-nstab-special'        => 'این یک صفحهٔ ویژه است، نمی‌توانید خود صفحه را ویرایش کنید',
'tooltip-ca-nstab-project'        => 'نمایش صفحهٔ پروژه',
'tooltip-ca-nstab-image'          => 'دیدن صفحهٔ تصویر',
'tooltip-ca-nstab-mediawiki'      => 'نمایش پیغام سیستم',
'tooltip-ca-nstab-template'       => 'نمایش الگو',
'tooltip-ca-nstab-help'           => 'دیدن صفحهٔ راهنما',
'tooltip-ca-nstab-category'       => 'دیدن صفحهٔ رده',
'tooltip-minoredit'               => 'یک علامت جزئی به این ویرایش اضافه کن',
'tooltip-save'                    => 'تغییرات خود را ذخیره کنید',
'tooltip-preview'                 => 'پیش‌نمایش تغییرات شما، لطفاً قبل از ذخیره‌سازی صفحه از این کلید استفاده کنید.',
'tooltip-diff'                    => 'نمایش تغییراتی که شما در متن داده‌اید.',
'tooltip-compareselectedversions' => 'دیدن تفاوت‌های موجود بین دو نسخهٔ انتخاب شده این صفحه.',
'tooltip-watch'                   => 'این صفحه را به فهرست تعقیبات خود بیافزایید.',
'tooltip-recreate'                => 'ایجاد دوبارهٔ صفحه صرف نظر از حذف شدن قبلی آن',
'tooltip-upload'                  => 'شروع بارگذاری',

# Stylesheets
'common.css'   => '/* دستورات این بخش همهٔ کاربران را تحت تاثیر قرار می‌دهند. */',
'monobook.css' => '/* دستورات این بخش کاربرانی را که از پوستهٔ مونوبوک استفاده کنند تحت تاثیر قرار می‌دهند. */',

# Scripts
'common.js'   => '/* جاوااسکریپت‌هایی که اینجا بیایند در هر بار بار کردن صفحه برای همهٔ کاربران بار خواهند شد. */',
'monobook.js' => '/* این قسمت را تغییر ندهید، به جای آن [[MediaWiki:Common.css]] را اصلاح کنید. */',

# Metadata
'nodublincore'      => 'فراداه Dublin Core RDF برای این کارگذار غیر فعال شده‌است.',
'nocreativecommons' => 'متاداده RDF کرییتیو کامنز برای این کارگزار از کار انداخته شده است.',
'notacceptable'     => 'کارگذار این ویکی از ارسال داده به شکلی که برنامهٔ شما بتواند نمایش بدهد، عاجز است.',

# Attribution
'anonymous'        => 'کاربر(ان) گمنام {{SITENAME}}',
'siteuser'         => '$1، کاربر {{SITENAME}}',
'lastmodifiedatby' => 'این صفحه آخرین بار در $2، $1 به دست $3 تغییر یافته‌است.', # $1 date, $2 time, $3 user
'and'              => 'و',
'othercontribs'    => 'بر اساس اثری از $1',
'others'           => 'دیگران',
'siteusers'        => '$1، کاربر(ان) {{SITENAME}}',
'creditspage'      => 'اعتبارات این صفحه',
'nocredits'        => 'اطلاعات سازندگان این صفحه موجود نیست.',

# Spam protection
'spamprotectiontitle'    => 'فیلتر هرزنگاری‌ها',
'spamprotectiontext'     => 'از ذخیره کردن صفحه توسط سامانه پالایش هرزنگاری‌ها جلوگیری شد. 
معمولاً این اتفاق زمانی می‌افتد که متن جدید صفحه، حاوی پیوندی به یک نشانی وب خارجی باشد.',
'spamprotectionmatch'    => 'متن زیر چیزی‌است که فیلتر هرزه‌نگاری ما را به کارانداخت: $1',
'subcategorycount'       => '$1 زیررده در این رده وجود دارد.',
'categoryarticlecount'   => '$1 مقاله در این رده وجود دارد.',
'category-media-count'   => '{{PLURAL:$1|یک|$1}} پرونده در این رده وجود دارد.',
'listingcontinuesabbrev' => '(ادامه)',
'spambot_username'       => 'هرزه‌تمیزکارِ مدیاویکی',
'spam_reverting'         => 'واگردانی به آخرین نسخه‌ای که پیوندی به $1 ندارد.',
'spam_blanking'          => 'تمام نسخه‌ها حاوی پیوند به $1 بود، در حال خالی کردن',

# Info page
'infosubtitle'   => 'اطلاعات در مورد صفحه',
'numedits'       => 'تعداد ویرایش‌ها (ی نوشتار): $1',
'numtalkedits'   => 'تعداد ویرایش‌ها (صفحهٔ بحث): $1',
'numwatchers'    => 'شمار تعقیب‌کنندگان: $1',
'numauthors'     => 'شمار نویسندگان متمایز (مقاله): $1',
'numtalkauthors' => 'تعداد مؤلفان مختلف (صفحهٔ بحث): $1',

# Math options
'mw_math_png'    => 'همیشه PNG کشیده شود',
'mw_math_simple' => 'اگر خیلی ساده بود HTML وگرنه PNG',
'mw_math_html'   => 'اگر ممکن بود HTML وگرنه PNG',
'mw_math_source' => 'در قالب TeX باقی بماند (برای مرورگرهای متنی)',
'mw_math_modern' => 'توصیه برای مرورگرهای امروزی',
'mw_math_mathml' => 'استفاده از MathML در صورت امکان (آزمایشی)',

# Patrolling
'markaspatrolleddiff'                 => 'به عنوان پاسبانی‌شده علامت بزن',
'markaspatrolledtext'                 => 'این مقاله را به عنوان پاسبانی‌شده علامت بزن',
'markedaspatrolled'                   => 'به عنوان پاسبانی‌شده علامت زده شد.',
'markedaspatrolledtext'               => 'نسخه‌های انتخاب شده به عنوان پاسبانی‌شده علامت زده‌شد.',
'rcpatroldisabled'                    => 'پاسبانی تغییرات اخیر غیر فعال است.',
'rcpatroldisabledtext'                => 'امکان پاسبانی تغییرات اخیر در حال حاضر غیر فعال است.',
'markedaspatrollederror'              => 'علامت پاسبانی زده نشد.',
'markedaspatrollederrortext'          => 'باید یک نسخه را مشخص کنید تا برچسب به عنوان پاسبانی‌شده علامت بخورد.',
'markedaspatrollederror-noautopatrol' => 'شما نمی‌توانید به تغییرات انجام شده توسط خودتان علامت پاسبانی‌شده بزنید.',

# Patrol log
'patrol-log-page' => 'سیاههٔ نگهبانی',
'patrol-log-line' => '$1 از $2 را به صورت پاسبانی‌شده علامت زد $3',
'patrol-log-auto' => '(خودکار)',
'patrol-log-diff' => 'نسخه $1',

# Image deletion
'deletedrevision'                 => '$1 نسخهٔ حذف شدهٔ قدیمی.',
'filedeleteerror-short'           => 'خطا در حذف پرونده: $1',
'filedeleteerror-long'            => 'در زمان حذف پرونده خطا رخ داد:

$1',
'filedelete-missing'              => 'پروندهٔ $1 قابل حذف نیست چون پرونده‌ای به این نام وجود ندارد.',
'filedelete-old-unregistered'     => 'نسخهٔ پروندهٔ $1 در پایگاه داده وجود ندارد.',
'filedelete-current-unregistered' => 'پرونده‌ای با نام $1 در پایگاه داده موجود نیست.',
'filedelete-archive-read-only'    => 'امکان نوشتن در پوشهٔ تاریخچهٔ $1 وجود ندارد.',

# Browsing diffs
'previousdiff' => '→ تفاوت قبلی',
'nextdiff'     => 'تفاوت بعدی ←',

# Media information
'mediawarning'         => "'''هشدار''': این پرونده ممکن است حاوی کدهای مخربی باشد که با اجرای آن رایانهٔ شما آسیب ببیند.",
'imagemaxsize'         => 'محدودکردن ابعاد تصویر نمایش‌داده‌شده در صفحهٔ توصیف تصویر، به ابعاد:',
'thumbsize'            => 'اندازهٔ Thumbnail:',
'widthheight'          => '$1 در $2',
'widthheightpage'      => '$1×$2، $3 صفحه',
'file-info'            => 'اندازهٔ پرونده: $1، نوع  MIME $2',
'file-info-size'       => '(<span dir=ltr>$1 X $2</span> پیکسل، اندازهٔ پرونده: $3، نوع MIME پرونده: $4)',
'file-nohires'         => '<small>تفکیک‌پذیری بالاتری در دسترس نیست.</small>',
'svg-long-desc'        => '(پرونده SVG، با ابعاد $1 × $2 پیکسل، اندازه پرونده: $3)',
'show-big-image'       => 'تصویر با تفکیک‌پذیری بالاتر',
'show-big-image-thumb' => '<small>اندازهٔ این پیش‌نمایش: &#8206;$1 × $2 پیکسل</small>',

# Special:Newimages
'newimages'    => 'گالری پرونده‌های جدید',
'showhidebots' => '(ویرایش رُبات‌ها $1)',
'noimages'     => 'چیزی برای دیدن نیست.',

# Bad image list
'bad_image_list' => 'اطلاعات را باید به این شکل وارد کنید:

فقط سطرهایی که با * شروع شوند در نظر گرفته می‌شوند. اولین پیوند در هر سطر، باید پیوندی به یک تصویر بد باشد. 
پیوندهایی بعدی در همان سطر، به عنوان موارد استثنا در نظر گرفته می‌شوند.',

# Metadata
'metadata'          => 'متاداده',
'metadata-help'     => 'این پرونده حاوی اطلاعات اضافه‌ای است که احتمالاً توسط دوربین دیجیتالی‌ یا پویشگری که در ایجاد یا دیجیتالی‌کردن آن به کار رفته‌است، افزوده شده‌است. اگر پرونده از وضعیت ابتدایی‌اش تغییر داده شده باشد آنگاه ممکن است شرح و تفصیلات موجود اطلاعات عکس را تماماً بازتاب ندهد.',
'metadata-expand'   => 'نمایش جزئیات تفصیلی',
'metadata-collapse' => 'نهفتن جزئیات تفصیلی',
'metadata-fields'   => 'فرداده EXIF نشان داده شده در این پیغام وقتی جدول فراداده‌های تصویر جمع شده باشد هم نمایش داده می‌شوند.
بقیهٔ موارد تنها زمانی نشان داده می‌شوند که جدول یادشده باز شود.
* make
* model
* datetimeoriginal
* exposuretime
* fnumber
* focallength',

# EXIF tags
'exif-imagewidth'                  => 'عرض',
'exif-imagelength'                 => 'طول',
'exif-bitspersample'               => 'نقطه در هر جزء',
'exif-compression'                 => 'شِمای فشرده‌سازی',
'exif-photometricinterpretation'   => 'ترکیب نقاط',
'exif-orientation'                 => 'جهت',
'exif-samplesperpixel'             => 'تعداد اجزا',
'exif-planarconfiguration'         => 'آرایش داده‌ها',
'exif-xresolution'                 => 'تفکیک‌پذیری افقی',
'exif-yresolution'                 => 'تفکیک‌پذیری عمودی',
'exif-resolutionunit'              => 'واحد تفکیک‌پذیری X و Y',
'exif-stripoffsets'                => 'جایگاه داده‌های تصویر',
'exif-jpeginterchangeformatlength' => 'بایت دادهٔ JPEG',
'exif-transferfunction'            => 'تابع تبدیل',
'exif-whitepoint'                  => 'رنگینگی نقطهٔ سفید',
'exif-datetime'                    => 'تاریخ و زمان تغییر پرونده',
'exif-imagedescription'            => 'عنوان تصویر',
'exif-make'                        => 'شرکت سازندهٔ دوربین',
'exif-model'                       => 'مدل دوربین',
'exif-software'                    => 'نرم‌افزار استفاده‌شده',
'exif-artist'                      => 'عکاس/هنرمند',
'exif-copyright'                   => 'دارندهٔ حق تکثیر',
'exif-exifversion'                 => 'نسخهٔ exif',
'exif-colorspace'                  => 'فضای رنگی',
'exif-componentsconfiguration'     => 'معنی هر یک از مؤلفه‌ها',
'exif-compressedbitsperpixel'      => 'حالت فشرده‌سازی تصویر',
'exif-pixelydimension'             => 'عرض تصویر معتبر',
'exif-pixelxdimension'             => 'طول تصویر معتبر',
'exif-makernote'                   => 'تذکرات شرکت سازنده',
'exif-usercomment'                 => 'توضیحات کاربر',
'exif-relatedsoundfile'            => 'پروندهٔ صوتی مربوط',
'exif-datetimeoriginal'            => 'تاریخ و زمان تولید داده‌ها',
'exif-datetimedigitized'           => 'تاریخ و زمان دیجیتالی شدن',
'exif-subsectime'                  => 'کسر ثانیهٔ تاریخ و زمان',
'exif-exposuretime'                => 'زمان نوردهی',
'exif-exposuretime-format'         => '$1 ثانیه ($2)',
'exif-fnumber'                     => 'ضریب F',
'exif-exposureprogram'             => 'برنامهٔ نوردهی',
'exif-spectralsensitivity'         => 'حساسیت طیفی',
'exif-isospeedratings'             => 'درجه‌بندی سرعت ایزو',
'exif-oecf'                        => 'عامل تبدیل نوری‌-الکترونیک',
'exif-shutterspeedvalue'           => 'سرعت شاتر',
'exif-aperturevalue'               => 'دیافراگم',
'exif-brightnessvalue'             => 'روشنی',
'exif-exposurebiasvalue'           => 'خطای نوردهی',
'exif-subjectdistance'             => 'فاصلهٔ سوژه',
'exif-meteringmode'                => 'حالت سنجش فاصله',
'exif-lightsource'                 => 'منبع نور',
'exif-flash'                       => 'فلاش',
'exif-focallength'                 => 'فاصلهٔ کانونی عدسی',
'exif-focallength-format'          => '$1 میلی‌متر',
'exif-flashenergy'                 => 'قدرت فلاش',
'exif-focalplanexresolution'       => 'تفکیک‌پذیری X صفحهٔ کانونی',
'exif-focalplaneyresolution'       => 'تفکیک‌پذیری Y صفحهٔ کانونی',
'exif-focalplaneresolutionunit'    => 'واحد تفکیک‌پذیری صفحهٔ کانونی',
'exif-subjectlocation'             => 'مکان سوژه',
'exif-exposureindex'               => 'شاخص نوردهی',
'exif-sensingmethod'               => 'روش حسگری',
'exif-filesource'                  => 'منبع پرونده',
'exif-scenetype'                   => 'نوع صحنه',
'exif-customrendered'              => 'ظهور عکس سفارشی',
'exif-exposuremode'                => 'حالت نوردهی',
'exif-whitebalance'                => 'تعادل رنگ سفید (white balance)',
'exif-digitalzoomratio'            => 'نسبت زوم دیجیتال',
'exif-focallengthin35mmfilm'       => 'فاصلهٔ کانونی برای فیلم ۳۵ میلی‌متری',
'exif-scenecapturetype'            => 'نوع ضبط صحنه',
'exif-contrast'                    => 'کنتراست',
'exif-saturation'                  => 'غلظت رنگ',
'exif-sharpness'                   => 'وضوح',
'exif-devicesettingdescription'    => 'شرح تنظیمات دستگاه',
'exif-subjectdistancerange'        => 'محدودهٔ فاصلهٔ سوژه',
'exif-imageuniqueid'               => 'شناسهٔ یکتای تصویر',
'exif-gpsversionid'                => 'نسخهٔ برچسب جی‌پی‌اس',
'exif-gpslatituderef'              => 'عرض جغرافیایی شمالی یا جنوبی',
'exif-gpslatitude'                 => 'عرض جغرافیایی',
'exif-gpslongituderef'             => 'طول جغرافیایی شرقی یا غربی',
'exif-gpslongitude'                => 'طول جغرافیایی',
'exif-gpsaltituderef'              => 'نقطهٔ مرجع ارتفاع',
'exif-gpsaltitude'                 => 'ارتفاع',
'exif-gpstimestamp'                => 'زمان جی‌پی‌اس (ساعت اتمی)',
'exif-gpssatellites'               => 'ماهواره‌های استفاده‌شده برای اندازه‌گیری',
'exif-gpsstatus'                   => 'وضعیت گیرنده',
'exif-gpsmeasuremode'              => 'حالت اندازه‌گیری',
'exif-gpsdop'                      => 'دقت اندازه‌گیری',
'exif-gpsspeedref'                 => 'یکای سرعت',
'exif-gpsspeed'                    => 'سرعت گیرندهٔ جی‌پی‌اس',
'exif-gpstrackref'                 => 'مرجع برای جهت حرکت',
'exif-gpstrack'                    => 'جهت حرکت',
'exif-gpsimgdirectionref'          => 'مرجع برای جهت تصویر',
'exif-gpsimgdirection'             => 'جهت تصویر',
'exif-gpsdestlatituderef'          => 'مرجع برای عرض جغرافیایی مقصد',
'exif-gpsdestlatitude'             => 'عرض جغرافیایی مقصد',
'exif-gpsdestlongituderef'         => 'مرجع برای طول جغرافیایی مقصد',
'exif-gpsdestlongitude'            => 'طول جغرافیایی مقصد',
'exif-gpsdestbearingref'           => 'مرجع برای جهت مقصد',
'exif-gpsdestbearing'              => 'جهت مقصد',
'exif-gpsdestdistanceref'          => 'مرجع برای فاصله تا مقصد',
'exif-gpsdestdistance'             => 'فاصله تا مقصد',
'exif-gpsareainformation'          => 'نام ناحیهٔ جی‌پی‌اس',
'exif-gpsdatestamp'                => 'تاریخ جی‌پی‌اس',
'exif-gpsdifferential'             => 'تصحیح جزئی جی‌پی‌اس',

# EXIF attributes
'exif-compression-1' => 'غیرفشرده',

'exif-unknowndate' => 'تاریخ نامعلوم',

'exif-orientation-1' => 'عادی', # 0th row: top; 0th column: left
'exif-orientation-2' => 'افقی پشت و روشده', # 0th row: top; 0th column: right
'exif-orientation-3' => '۱۸۰ درجه چرخیده', # 0th row: bottom; 0th column: right
'exif-orientation-4' => 'عمودی پشت و روشده', # 0th row: bottom; 0th column: left
'exif-orientation-5' => '۹۰° پادساعتگرد چرخیده و عمودی پشت و رو شده', # 0th row: left; 0th column: top
'exif-orientation-6' => '۹۰° ساعتگرد چرخیده', # 0th row: right; 0th column: top
'exif-orientation-7' => '۹۰° ساعتگرد چرخیده و عمودی پشت و رو شده', # 0th row: right; 0th column: bottom
'exif-orientation-8' => '۹۰° پادساعتگرد چرخیده', # 0th row: left; 0th column: bottom

'exif-planarconfiguration-2' => 'قالب دووجهی',

'exif-xyresolution-i' => '$1 نقطه در اینچ',
'exif-xyresolution-c' => '$1 نقطه در سانتی‌متر',

'exif-componentsconfiguration-0' => 'وجود ندارد',

'exif-exposureprogram-0' => 'تعریف‌نشده',
'exif-exposureprogram-1' => 'دستی',
'exif-exposureprogram-2' => 'برنامهٔ عادی',
'exif-exposureprogram-3' => 'اولویت دیافراگم',
'exif-exposureprogram-4' => 'اولویت شاتر',
'exif-exposureprogram-5' => 'برنامه خلاق (با گرایش به سمت عمق میدان)',
'exif-exposureprogram-6' => 'برنامه پرجنبش (با گرایش به سمت سرعت بیشتر شاتر)',
'exif-exposureprogram-7' => 'حالت پرتره (برای عکس‌های نزدیک که پس‌زمینه خارج از فاصلهٔ کانونی است)',
'exif-exposureprogram-8' => 'حالت منظره (برای عکس‌های منظره که تمرکز روی پس‌زمینه است)',

'exif-subjectdistance-value' => '$1 متر',

'exif-meteringmode-0'   => 'نامعلوم',
'exif-meteringmode-1'   => 'میانگین',
'exif-meteringmode-2'   => 'میانگین با مرکز سنگین',
'exif-meteringmode-3'   => 'تک‌نقطه‌ای',
'exif-meteringmode-4'   => 'چندنقطه‌ای',
'exif-meteringmode-5'   => 'طرح‌دار',
'exif-meteringmode-6'   => 'جزئی',
'exif-meteringmode-255' => 'غیره',

'exif-lightsource-0'   => 'نامعلوم',
'exif-lightsource-1'   => 'روشنایی روز',
'exif-lightsource-2'   => 'فلورسانت',
'exif-lightsource-3'   => 'تنگستن (نور بدون گرما)',
'exif-lightsource-4'   => 'فلاش',
'exif-lightsource-9'   => 'هوای خوب',
'exif-lightsource-10'  => 'آسمان ابری',
'exif-lightsource-11'  => 'سایه',
'exif-lightsource-17'  => 'نور استاندارد A',
'exif-lightsource-18'  => 'نور استاندارد B',
'exif-lightsource-19'  => 'نور استاندارد C',
'exif-lightsource-255' => 'سایر',

'exif-focalplaneresolutionunit-2' => 'اینچ',

'exif-sensingmethod-1' => 'تعریف نشده',
'exif-sensingmethod-2' => 'حسگر ناحیهٔ رنگی یک تراشه‌ای',
'exif-sensingmethod-3' => 'حسگر ناحیهٔ رنگی دو تراشه‌ای',
'exif-sensingmethod-4' => 'حسگر ناحیهٔ رنگی سه تراشه‌ای',
'exif-sensingmethod-5' => 'حسگر ناحیه‌ای ترتیبی رنگ‌ها',
'exif-sensingmethod-7' => 'حسگر سه‌خطی',
'exif-sensingmethod-8' => 'حسگر خطی ترتیبی رنگ‌ها',

'exif-scenetype-1' => 'تصویر مستقیماً عکاسی شده',

'exif-customrendered-0' => 'ظهور عادی',
'exif-customrendered-1' => 'ظهور سفارشی',

'exif-exposuremode-0' => 'نوردهی خودکار',
'exif-exposuremode-1' => 'نوردهی دستی',

'exif-whitebalance-0' => 'تنظیم خودکار تعادل رنگ سفید (white balance)',
'exif-whitebalance-1' => 'تنظیم دستی تعادل رنگ سفید (white balance)',

'exif-scenecapturetype-0' => 'استاندارد',
'exif-scenecapturetype-1' => 'چشم‌انداز',
'exif-scenecapturetype-2' => 'پرتره',
'exif-scenecapturetype-3' => 'شبانه',

'exif-gaincontrol-0' => 'هیچ',

'exif-contrast-0' => 'عادی',
'exif-contrast-1' => 'نرم',
'exif-contrast-2' => 'زبر',

'exif-saturation-0' => 'عادی',
'exif-saturation-1' => 'رنگ‌های رقیق شده',
'exif-saturation-2' => 'رنگ‌های تغلیظ شده',

'exif-sharpness-0' => 'عادی',
'exif-sharpness-1' => 'نرم',
'exif-sharpness-2' => 'زبر',

'exif-subjectdistancerange-0' => 'نامعلوم',
'exif-subjectdistancerange-1' => 'ماکرو',
'exif-subjectdistancerange-2' => 'نمای نزدیک',
'exif-subjectdistancerange-3' => 'نمای دور',

# Pseudotags used for GPSLatitudeRef and GPSDestLatitudeRef
'exif-gpslatitude-n' => 'عرض جغرافیایی شمالی',
'exif-gpslatitude-s' => 'عرض جغرافیایی جنوبی',

# Pseudotags used for GPSLongitudeRef and GPSDestLongitudeRef
'exif-gpslongitude-e' => 'طول جغرافیایی شرقی',
'exif-gpslongitude-w' => 'طول جغرافیایی غربی',

'exif-gpsstatus-a' => 'در حال اندازه‌گیری',

'exif-gpsmeasuremode-2' => 'اندازه‌گیری دوبعدی',
'exif-gpsmeasuremode-3' => 'اندازه‌گیری سه‌بعدی',

# Pseudotags used for GPSSpeedRef and GPSDestDistanceRef
'exif-gpsspeed-k' => 'کیلومتر بر ساعت',
'exif-gpsspeed-m' => 'مایل بر ساعت',
'exif-gpsspeed-n' => 'گره',

# Pseudotags used for GPSTrackRef, GPSImgDirectionRef and GPSDestBearingRef
'exif-gpsdirection-t' => 'جهت درست',
'exif-gpsdirection-m' => 'جهت مغناطیسی',

# External editor support
'edit-externally'      => 'ویرایش این پرونده با استفاده از ویرایشگر خارجی',
'edit-externally-help' => 'برای اطلاعات بیشتر [http://meta.wikimedia.org/wiki/Help:External_editors راهنمایی‌های تنظیمات] ویرایشگر خارجی را ببینید.',

# 'all' in various places, this might be different for inflected languages
'recentchangesall' => 'همه',
'imagelistall'     => 'همه',
'watchlistall2'    => 'همه',
'namespacesall'    => 'همه',
'monthsall'        => 'همهٔ ماه‌ها',

# E-mail address confirmation
'confirmemail'            => 'تأیید نشانی پست الکترونیکی',
'confirmemail_noemail'    => 'شما در صفحهٔ [[Special:Preferences|ترجیحات کاربری]] خود نشانی پست الکترونیک معتبری وارد نکرده‌اید.',
'confirmemail_text'       => 'این ویکی شما را ملزم به تأیید اعتبار پست الکترونیک خود، پیش از استفاده از خدمات پست الکترونیک اینجا می‌کند. دکمهٔ زیرین را فعال کنید تا نامهٔ تأییدی به نشانی شما فرستاده شود. این نامه دربردارندهٔ پیوندی خواهد بود که حاوی یک کد است. پیوند را در مرورگر خود بار کنید (اجرا) کنید تا اعتبار نشانی پست الکترونیک شما مسجل شود.',
'confirmemail_pending'    => '<div class="error">
یک کد تأییدی پیشتر برای شما به صورت الکترونیک فرستاده شده‌است. اگر همین اواخر حساب خود را باز کرده‌اید شاید بد نباشد که پیش از درخواست یک کد جدید چند دقیقه درنگ کنید تا شاید نامهٔ قبلی برسد.
</div>',
'confirmemail_send'       => 'پُست‌کردن یک کد تأیید',
'confirmemail_sent'       => 'نامهٔ الکترونیکی تأییدی فرستاده شد.',
'confirmemail_oncreate'   => 'یک کد تأییدی به نشانی پست الکترونیک شما فرستاده شد. برای واردشدن به سیستم نیازی به این کد نیست، ولی برای راه‌اندازی امکانات وابسته به پست الکترونیک در این ویکی به آن نیاز خواهید داشت.',
'confirmemail_sendfailed' => 'فرستادن پست الکترونیکی تأییدی ممکن نشد. وجود نویسه‌های نامعتبر در نشانی را وارسی کنید.

$1',
'confirmemail_invalid'    => 'کد تأیید نامعتبر است. ممکن است که منقضی شده باشد.',
'confirmemail_needlogin'  => 'برای تأیید نشانی پست الکترونیکتان نیاز به $1 دارید.',
'confirmemail_success'    => 'نشانی پست الکترونیکی شما تأیید شده‌است. همکنون می‌توانید به سیستم وارد شده و از ویکی لذت ببرید.',
'confirmemail_loggedin'   => 'نشانی پست الکترونیکی شما تأیید شد.',
'confirmemail_error'      => 'هنگام ذخیرهٔ تأیید شما به مشکلی برخورده شد.',
'confirmemail_subject'    => 'تأیید نشانی پست الکترونیک {{SITENAME}}',
'confirmemail_body'       => 'Someone, probably you from IP address $1, has registered an
account "$2" with this e-mail address on {{SITENAME}}.

To confirm that this account really does belong to you and activate
e-mail features on {{SITENAME}}, open this link in your browser:

$3

If this is *not* you, don\'t follow the link. This confirmation code
will expire at $4.

---------

یک نفر، احتمالاً خود شما، از نشانی آی‌پی $1 حساب کاربری‌ای با نام «$2» و این نشانی پست‌الکترونیکی در {{SITENAME}} ایجاد کرده‌است.

برای تأیید اینکه این حساب واقعاً متعلق به شماست و نیز برای فعال‌سازی امکانات ایمیلیِ {{SITENAME}} پیوند را در مرورگر اینترنت خود باز کنید:

$3

اگر این شما *نیستید* لطفاً پیوند را دنبال مکنید. این کدِ تأیید در تاریخ $4 منقضی خواهد شد.
</div>',

# Scary transclusion
'scarytranscludedisabled' => '[تراگنجانش بین‌ویکیانه فعال نیست]',
'scarytranscludefailed'   => 'فراخوانی الگو برای $1 میسر نشد.',
'scarytranscludetoolong'  => 'نشانی اینترنتی مورد نظر (URL) بیش از اندازه بلند بود',

# Trackbacks
'trackbackremove' => ' ([$1 حذف])',

# Delete conflict
'deletedwhileediting' => 'هشدار: این صفحه پس از اینکه شما آغاز به ویرایش‌اش کرده‌اید، حذف شده است.',
'confirmrecreate'     => "کاربر [[User:$1|$1]] ([[User talk:$1|بحث]]) این مقاله را پس از اینکه شما آغاز به ویرایش آن نموده‌اید به دلیل زیر حذف کرده است :
: ''$2''
لطفاً تأیید کنید که مجدداً می‌خواهید این مقاله را بسازید.",
'recreate'            => 'بازایجاد',

# HTML dump
'redirectingto' => 'در حال تغییر مسیر به [[$1]]...',

# action=purge
'confirm_purge'        => 'پاک کردن نسخهٔ حافظهٔ نهانی (Cache) این صفحه را تأیید می‌کنید؟

$1',
'confirm_purge_button' => 'تأیید',

# AJAX search
'searchcontaining' => "جستجوی مقاله‌هایی که ''$1'' می‌دارند.",
'searchnamed'      => "جستجوی مقاله‌هایی با نام ''$1''.",
'articletitles'    => "مقاله‌هایی که با ''$1'' آغاز می‌شوند.",
'hideresults'      => 'نهفتن نتایج',

# Multipage image navigation
'imgmultipageprev'   => '&rarr; صفحهٔ پیشین',
'imgmultipagenext'   => 'صفحهٔ بعد &larr;',
'imgmultigo'         => 'برو!',
'imgmultigotopre'    => 'رفتن به صفحه',
'imgmultiparseerror' => 'به نظر می‌رسد که پرونده تصویر خراب شده‌است، به همین‌خاطر {{SITENAME}} نمی‌تواند فهرستی از صفحه‌ها نمایش دهد.',

# Table pager
'ascending_abbrev'         => 'صعودی',
'descending_abbrev'        => 'نزولی',
'table_pager_next'         => 'صفحهٔ بعدی',
'table_pager_prev'         => 'صفحه قبل',
'table_pager_first'        => 'صفحهٔ نخست',
'table_pager_last'         => 'صفحهٔ آخر',
'table_pager_limit'        => 'نمایش $1 مورد در هر صفحه',
'table_pager_limit_submit' => 'برو',
'table_pager_empty'        => 'هیچ نتیجه',

# Auto-summaries
'autosumm-blank'   => 'خالی‌کردن صفحه',
'autosumm-replace' => "جایگزینی صفحه با '$1'",
'autoredircomment' => 'تغییر مسیر به [[$1]]',
'autosumm-new'     => 'صفحهٔ جدید: $1',

# Size units
'size-bytes'     => '$1 بایت',
'size-kilobytes' => '$1 کیلوبایت',
'size-megabytes' => '$1 مگابایت',
'size-gigabytes' => '$1 گیگابایت',

# Live preview
'livepreview-loading' => 'در حال بارشدن…',
'livepreview-ready'   => 'بارشدن… آماده!',
'livepreview-failed'  => 'پیش‌نمایش زنده به مشکل برخورد! لطفاً از پیش‌نمایش عادی استفاده کنید',
'livepreview-error'   => 'ارتباط به مشکل برخورد: $1 "$2" از پیش‌نمایش عادی استفاده کنید.',

# Friendlier slave lag warnings
'lag-warn-normal' => 'ممکن است تغییرات تازه‌تر از $1 ثانیه در این فهرست نشان داده نشوند.',
'lag-warn-high'   => 'ممکن است ، به خاطر پس‌افتادگی زیاد کارگزار دادگان، تغییرات تازه‌تر از $1 ثانیه، در این فهرست نشان داده نشده باشند.',

# Watchlist editor
'watchlistedit-numitems'       => 'فهرست تعقیبات شما شامل $1 صفحه به جز صفحه‌های بحث است.',
'watchlistedit-noitems'        => 'فهرست تعقیبات شما خالی است.',
'watchlistedit-clear-title'    => 'خالی کردن فهرست تعقیبات',
'watchlistedit-clear-legend'   => 'خالی کردن فهرست تعقیبات',
'watchlistedit-clear-confirm'  => 'شما در حال پاک کردن تمام عناوین از فهرست تعقیبات‌تان هستید. 
آیا مطمئنید که می‌خواهید این کار انجام بشود؟ 
توجه کنید که شما می‌توانید [[Special:Watchlist/edit|برخی عنوان‌ها را به دلخواه حذف کنید]].',
'watchlistedit-clear-submit'   => 'فهرست تعقیبات خالی شود',
'watchlistedit-clear-done'     => 'فهرست تعقیبات شما خالی شد و همهٔ عنوان‌ها حذف شدند.',
'watchlistedit-normal-title'   => 'ویرایش فهرست تعقیبات',
'watchlistedit-normal-legend'  => 'حذف عنوان‌ها از فهرست تعقیبات',
'watchlistedit-normal-explain' => 'عنوان‌های موجود در فهرست تعقیبات شما در پایین نمایش داده شده‌اند. 
برای حذف یک عنوان، جعبه کوچک کنار آن را تیک بزنید. 
شما می‌توانید [[Special:Watchlist/raw|فهرست خام تعقیبات را ویرایش کنید]] یا [[Special:Watchlist/clear|فهرست تعقیبات خود را کاملاً خالی کنید]].',
'watchlistedit-normal-submit'  => 'عنوان‌ها حذف شود',
'watchlistedit-normal-done'    => '$1 عنوان از فهرست تعقیبات شما حذف شد:',
'watchlistedit-raw-title'      => 'ویرایش فهرست خام تعقیبات',
'watchlistedit-raw-legend'     => 'ویرایش فهرست خام تعقیبات',
'watchlistedit-raw-explain'    => 'عنوان‌های موجود در فهرست تعقیبات شما در زیر نشان داده شده‌اند، و شما می‌توانید مواردی را حذف یا اضافه کنید. 
هر مورد در یک سطر جداگانه باید قرار بگیرد. در پایان، دکمهٔ «به روز رساندن تعقیبات» را بفشارید. 
توجه کنید که شما می‌توانید از [[Special:Watchlist/edit|ویرایشگر استاندارد فهرست تعقیبات]] هم استفاده کنید.',
'watchlistedit-raw-titles'     => 'عنوان‌ها:',
'watchlistedit-raw-submit'     => 'به روز رساندن تعقیبات',
'watchlistedit-raw-done'       => 'فهرست تعقیبات شما به روز شد.',
'watchlistedit-raw-added'      => '$1 عنوان به فهرست تعقیبات اضافه شد:',
'watchlistedit-raw-removed'    => '$1 عنوان حذف شد:',

# Watchlist editing tools
'watchlisttools-view'  => 'فهرست تعقیبات',
'watchlisttools-edit'  => 'مشاهده و ویرایش فهرست تعقیبات',
'watchlisttools-raw'   => 'ویرایش فهرست خام تعقیبات',
'watchlisttools-clear' => 'پاک کردن فهرست تعقیبات',

);
